/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.StateIntf;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.state.AnyValue;
import oracle.dms.instrument.state.DoubleValue;
import oracle.dms.instrument.state.IntegerValue;
import oracle.dms.instrument.state.LongValue;
import oracle.dms.instrument.state.ObjectValue;
import oracle.dms.instrument.state.Value;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;

public class State
extends Sensor
implements StateIntf {
    private int _updateCount;
    private double _min;
    private double _max;
    private Value _value;
    private String _units;
    private static final byte ANY = 0;
    public static final byte DOUBLE = 1;
    public static final byte LONG = 2;
    public static final byte INTEGER = 3;
    public static final byte OBJECT = 5;
    private static final byte _minType = 1;
    private static final byte _maxType = 5;
    private byte _type = 0;
    private boolean _initialized = false;
    private static final String JDBC_STATEMENT = "JDBC_Statement";

    private State(boolean sanitizedName, Noun parent, String name, byte valueType, String units, String desc) {
        super(sanitizedName, parent, name, desc);
        this._units = DMSUtil.sanitize(units, 99, true, false);
        this._type = valueType;
        switch (valueType) {
            case 3: {
                this._value = new IntegerValue();
                break;
            }
            case 2: {
                this._value = new LongValue();
                break;
            }
            case 1: {
                this._value = new DoubleValue();
                break;
            }
            case 5: {
                this._value = new ObjectValue();
                break;
            }
            case 0: {
                this._value = new AnyValue();
                this._type = 0;
            }
        }
        if (this._type != 0) {
            this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, this._type, 0);
        }
        this.setUpdateTime(0L);
        this.traceAction(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State makeState(Noun parent, String name, byte valueType, String units, String desc) {
        State st = null;
        String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
        if (valueType < 1 || valueType > 5) {
            valueType = 0;
        }
        Noun noun = parent;
        synchronized (noun) {
            st = (State)parent.getSensor(sanitizedName);
            if (st == null) {
                st = new State(false, parent, sanitizedName, valueType, units, desc);
            }
        }
        return st;
    }

    private static State getState(String pathname, byte valueType, String units, String desc) {
        State st = (State)Sensor.lookupCache(pathname);
        if (st != null) {
            return st;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        st = State.makeState(parent, name, valueType, units, desc);
        st.addToCache(pathname);
        return st;
    }

    public static State create(Noun parent, String name, byte valueType, String units, String desc) {
        if (name == null || name.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR3", new Object[]{"State.create(NSiSS)", name, units, desc}));
        }
        if (valueType < 1 || valueType > 5) {
            throw new InstrumentationException(DMSNLSupport.getMessage("WRONG_TYPE", null));
        }
        return State.makeState(parent, name, valueType, units, desc);
    }

    public static State create(String pathname, byte valueType, String units, String desc) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR3", new Object[]{"State.create(SiSS)", pathname, units, desc}));
        }
        if (valueType < 1 || valueType > 5) {
            throw new InstrumentationException(DMSNLSupport.getMessage("WRONG_TYPE", null));
        }
        return State.getState(pathname, valueType, units, desc);
    }

    public static State create(String pathname, String units, String desc, int init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSi)", pathname, units, desc}));
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)3, new Integer(init));
        }
        return st;
    }

    public static State create(String pathname, String units, String desc, long init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSl)", pathname, units, desc}));
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)2, new Long(init));
        }
        return st;
    }

    public static State create(String pathname, String units, String desc, double init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSd)", pathname, units, desc}));
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)1, new Double(init));
        }
        return st;
    }

    public static State create(String pathname, String units, String desc, Object init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSO)", pathname, units, desc}));
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)5, init);
        }
        return st;
    }

    public static State create(Noun parent, String name, String units, String desc, int init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSi)", parent, name, units, desc}));
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)3, new Integer(init));
        }
        return st;
    }

    public static State create(Noun parent, String name, String units, String desc, long init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSl)", parent, name, units, desc}));
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)2, new Long(init));
        }
        return st;
    }

    public static State create(Noun parent, String name, String units, String desc, double init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSd)", parent, name, units, desc}));
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)1, new Double(init));
        }
        return st;
    }

    public static State create(Noun parent, String name, String units, String desc, Object init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSO)", parent, name, units, desc}));
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)5, init);
        }
        return st;
    }

    public State(Noun parent, String name, String units, String desc, int init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)3, new Integer(init));
    }

    public State(Noun parent, String name, String units, String desc, long init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)2, new Long(init));
    }

    public State(Noun parent, String name, String units, String desc, double init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)1, new Double(init));
    }

    public State(Noun parent, String name, String units, String desc, Object init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)5, init);
    }

    private void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized(true);
        if (this._metrics[0] != null) {
            return;
        }
        switch (this._type) {
            case 1: 
            case 2: 
            case 3: {
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, this._type, 0);
                break;
            }
            case 5: {
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 4, 0);
            }
        }
    }

    private void initialize(byte valueType, Object init) {
        if (this.isInitialized() || this._type != 0) {
            return;
        }
        this.setInitialized(true);
        this.setUpdateTime();
        this._value = new AnyValue();
        switch (valueType) {
            case 3: {
                this._value.update((Integer)init);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 3, 0);
                break;
            }
            case 2: {
                this._value.update((Long)init);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 2, 0);
                break;
            }
            case 1: {
                this._value.update((Double)init);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 1, 0);
                break;
            }
            default: {
                if (init instanceof String && JDBC_STATEMENT.equals(this.getParent().getType()) && init.equals("null")) {
                    init = "";
                }
                this._value.update(init);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 4, 0);
            }
        }
        this.traceAction(8);
    }

    private void traceAction(int action) {
        if (this.isTraceable()) {
            if (!this._initialized && this._type == 0) {
                return;
            }
            Tracer tr = ExecutionContext.get().getTracer();
            if (tr != null) {
                Object obj;
                String strVal = null;
                strVal = this._value != null ? ((obj = this._value.getValue()) == null ? "" : obj.toString()) : "";
                tr.append(this, action, strVal);
            }
        }
    }

    public synchronized void deriveMetric(int metric) {
        if (!this.isAlive()) {
            return;
        }
        this._value.deriveMetric(metric);
        boolean derived = false;
        if ((metric & 2) > 0 && this._metrics[1] == null) {
            this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
            derived = true;
        }
        byte valueType = this._type;
        switch (this._type) {
            case 0: {
                Object val = this._value.getValue();
                if (!(val instanceof Number)) break;
                valueType = 1;
            }
            case 1: 
            case 2: 
            case 3: {
                if ((metric & 8) > 0 && this._metrics[3] == null) {
                    this._metrics[3] = new Metric(this._name + ".maxValue", this._description, this._units, this, false, valueType, 3);
                    derived = true;
                }
                if ((metric & 4) <= 0 || this._metrics[2] != null) break;
                this._metrics[2] = new Metric(this._name + ".minValue", this._description, this._units, this, false, valueType, 2);
                derived = true;
            }
        }
        if (derived && this.isInitialized()) {
            this.setUpdateTime();
        }
    }

    public static void update(String name, int newval) {
        ((State)Sensor.get(name)).update(newval);
    }

    public static void update(String name, long newval) {
        ((State)Sensor.get(name)).update(newval);
    }

    public static void update(String name, double newval) {
        ((State)Sensor.get(name)).update(newval);
    }

    public static void update(String name, Object newval) {
        ((State)Sensor.get(name)).update(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int newval) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long newval) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(double newval) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object newval) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    private void updateAdmin(long time) {
        if (!this.isInitialized() && this._type != 0) {
            this.initialize();
        }
        this.setUpdateTime(time);
        ++this._updateCount;
        this.traceAction(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(int inc) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(inc);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
        Bucket.drop((Sensor)this, inc, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long inc) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(inc);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
        Bucket.drop((Sensor)this, inc, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double inc) {
        long time = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(inc);
            this.updateAdmin(time);
        }
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
        Bucket.drop((Sensor)this, inc, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric m) {
        if (m == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("DOESNT_BELONG", new Object[]{"State.getValue(Metric)", m, this}));
        }
        if (!m.isAlive()) {
            return new ErrorObject();
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException(DMSNLSupport.getMessage("DOESNT_BELONG", new Object[]{"State.getValue(Metric)", m, this}));
        }
        State state = this;
        synchronized (state) {
            if (!this.isAlive()) {
                return new ErrorObject();
            }
            switch (index) {
                case 1: {
                    return new Integer(this._updateCount);
                }
                case 2: {
                    return this._value.getMin();
                }
                case 3: {
                    return this._value.getMax();
                }
                case 0: {
                    return this._value.getValue();
                }
            }
        }
        throw new InstrumentationException(DMSNLSupport.getMessage("DOESNT_BELONG", new Object[]{"State.getValue(Metric)", m, this}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long timeStamp = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._updateCount = 0;
            this._value.reset();
            this.setUpdateTime(timeStamp);
            this.setResetTime(timeStamp);
            this.setInitialized(false);
        }
    }

    State getCousin(Noun pre) {
        State retval = null;
        Noun cousinNoun = this.getParent().getCousin(pre);
        if (cousinNoun != null) {
            retval = State.create(cousinNoun, this._name, this._units, "cousin", this._value);
        }
        return retval;
    }

    public void setCopy(boolean copy) {
        this._value.setCopy(copy);
    }

    public byte getValueType() {
        return this._type;
    }

    synchronized void setInitialized(boolean init) {
        this._initialized = init;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public String getValueTypeString() {
        switch (this._type) {
            case 1: {
                return new String("State.DOUBLE");
            }
            case 3: {
                return new String("State.INTEGER");
            }
            case 2: {
                return new String("State.LONG");
            }
            case 5: {
                return new String("State.OBJECT");
            }
        }
        return new String("State.ANY");
    }
}

