/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.clock.ClockManager;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.State;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;

public class RollupSensor
extends Sensor {
    private static final byte STATE = 0;
    private static final byte EVENT = 1;
    private static final byte PHASE_EVENT = 2;
    private static final String STATE_NAME = "State";
    private static final String EVENT_NAME = "Event";
    private static final String PHASE_EVENT_NAME = "PhaseEvent";
    private static final int MAX_COUNT = 6;
    private static int[] s_max = new int[3];
    private byte m_type;
    private byte m_state_type;
    private String m_units = null;
    private int m_count;
    private int m_derived = 0;
    private double m_avg = 0.0;
    private Number m_sum;
    private Number m_max;
    private Number m_min;
    private long m_time = 0L;
    private int m_active = 0;

    private RollupSensor() {
    }

    private RollupSensor(Noun parent, Sensor sensor, byte type) {
        super(parent, sensor.getName(), "rollup sensor for " + sensor.getName());
        this.m_type = type;
        this.m_count = sensor.getDescriptor().getMetricCount();
        switch (type) {
            case 0: {
                this.createStateMetrics((State)sensor);
                break;
            }
            case 1: {
                this.createEventMetrics((Event)sensor);
                break;
            }
            case 2: {
                this.createPhaseEventMetrics((PhaseEvent)sensor);
            }
        }
    }

    private void createStateMetrics(State state) {
        Object mdesc = null;
        Metric met = state.getMetric(1);
        if (met == null) {
            return;
        }
        this.m_units = met.getUnits();
        this.m_state_type = state.getValueType();
        this._metrics[4] = new Metric(this._name + ".sum", this._description, this.m_units, this, false, this.m_state_type, 4);
        this._metrics[5] = new Metric(this._name + ".avg", this._description, this.m_units, this, false, 1, 5);
        met = state.getMetric(8);
        if (met != null) {
            this._metrics[3] = new Metric(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, 3);
            this.m_derived |= 8;
        }
        if ((met = state.getMetric(4)) != null) {
            this._metrics[2] = new Metric(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, 2);
            this.m_derived |= 4;
        }
    }

    private void createEventMetrics(Event event) {
        this._metrics[4] = new Metric(this._name + ".sum", this._description, "ops", this, false, 3, 4);
        this._metrics[5] = new Metric(this._name + ".avg", this._description, "ops", this, false, 1, 5);
    }

    private void createPhaseEventMetrics(PhaseEvent pe) {
        this.m_units = ClockManager.getUnits(DMSConsole.UNITS);
        Metric met = null;
        this._metrics[0] = new Metric(this._name + ".time", this._description, this.m_units, this, false, 2, 0);
        met = pe.getMetric(4);
        if (met != null) {
            this._metrics[2] = new Metric(this._name + ".minTime", this._description, this.m_units, this, false, 2, 2);
            this.m_derived |= 4;
        }
        if ((met = pe.getMetric(8)) != null) {
            this._metrics[3] = new Metric(this._name + ".maxTime", this._description, this.m_units, this, false, 2, 3);
            this.m_derived |= 8;
        }
        if ((met = pe.getMetric(2)) != null) {
            this._metrics[1] = new Metric(this._name + ".completed", this._description, "ops", this, false, 3, 1);
            this.m_derived |= 2;
        }
        if ((met = pe.getMetric(32)) != null && this._metrics[1] != null) {
            this._metrics[5] = new Metric(this._name + ".avg", this._description, this.m_units, this, false, 1, 5);
            this.m_derived |= 0x20;
        }
        if ((met = pe.getMetric(64)) != null) {
            this._metrics[6] = new Metric(this._name + ".active", this._description, "threads", this, false, 3, 6);
            this.m_derived |= 0x40;
        }
    }

    protected static RollupSensor create(Noun parent, Sensor sensor) {
        String stype = null;
        byte type = 0;
        if (sensor == null || (stype = sensor.getDescriptor().getType()) == null) {
            return null;
        }
        if (stype.equals(EVENT_NAME)) {
            type = 1;
        } else if (stype.equals(PHASE_EVENT_NAME)) {
            type = 2;
        } else if (stype.equals(STATE_NAME)) {
            type = 0;
            if (((State)sensor).getValueType() == 5) {
                return null;
            }
        } else {
            return null;
        }
        return new RollupSensor(parent, sensor, type);
    }

    protected void update(Noun[] nouns, String noun_type) {
        switch (this.m_type) {
            case 0: {
                this.updateState(nouns, noun_type);
                break;
            }
            case 1: {
                this.updateEvent(nouns, noun_type);
                break;
            }
            case 2: {
                this.updatePhaseEvent(nouns, noun_type);
            }
        }
    }

    private void updateState(Noun[] nouns, String type) {
        Metric met = null;
        Number val = null;
        int count = 0;
        double total = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double minval = 0.0;
        double maxval = 0.0;
        for (int i = 0; i < nouns.length; ++i) {
            if (type.equals(nouns[i].getType())) {
                ++count;
                State state = (State)nouns[i].getSensor(this._name);
                if (state == null) continue;
                met = state.getMetric(1);
                val = (Number)state.getValue(met);
                total += val.doubleValue();
                met = state.getMetric(4);
                if (met != null && (minval = (val = (Number)state.getValue(met)).doubleValue()) < min) {
                    min = minval;
                }
                if ((met = state.getMetric(8)) != null && (maxval = (val = (Number)state.getValue(met)).doubleValue()) > max) {
                    max = maxval;
                }
            }
            switch (this.m_state_type) {
                case 3: {
                    this.m_sum = new Integer((int)total);
                    if (this._metrics[2] != null) {
                        this.m_min = new Integer((int)min);
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = new Integer((int)max);
                    break;
                }
                case 2: {
                    this.m_sum = new Long((long)total);
                    if (this._metrics[2] != null) {
                        this.m_min = new Long((long)min);
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = new Long((long)max);
                    break;
                }
                case 1: {
                    this.m_sum = new Double(total);
                    if (this._metrics[2] != null) {
                        this.m_min = new Double(min);
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = new Double(max);
                }
            }
            this.m_avg = total / (double)count;
        }
    }

    private void updateEvent(Noun[] nouns, String type) {
        Event e = null;
        int total = 0;
        int count = 0;
        Integer val = null;
        for (int i = 0; i < nouns.length; ++i) {
            e = (Event)nouns[i].getSensor(this._name);
            if (e == null) continue;
            val = (Integer)e.getValue();
            total += val.intValue();
            ++count;
        }
        this.m_sum = new Integer(total);
        this.m_avg = (double)total / (double)count;
    }

    private void updatePhaseEvent(Noun[] nouns, String type) {
        PhaseEvent pe = null;
        long totalTime = 0L;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        int totalActive = 0;
        int totalCompleted = 0;
        Number val = null;
        long time = 0L;
        for (int i = 0; i < nouns.length; ++i) {
            pe = (PhaseEvent)nouns[i].getSensor(this._name);
            if (pe == null) continue;
            val = (Long)pe.getValue(1);
            totalTime += val.longValue();
            val = (Integer)pe.getValue(2);
            if (val != null) {
                totalCompleted += val.intValue();
            }
            if ((val = (Integer)pe.getValue(64)) != null) {
                totalActive += val.intValue();
            }
            if ((val = (Long)pe.getValue(4)) != null && (time = val.longValue()) < minTime) {
                minTime = time;
            }
            if ((val = (Long)pe.getValue(8)) == null || (time = val.longValue()) <= maxTime) continue;
            maxTime = time;
        }
        this.m_time = totalTime;
        this.m_sum = new Integer(totalCompleted);
        this.m_active = totalActive;
        this.m_min = new Long(minTime);
        this.m_max = new Long(maxTime);
        if (totalCompleted > 0 && (this.m_derived & 0x20) == 32) {
            this.m_avg = (double)totalTime / (double)totalCompleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric metric) {
        if (metric == null) {
            throw new InstrumentationException("metric is null!" + this);
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte index = metric.getIndex();
        if (this._metrics[index] != metric) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to this RollupSensor" + this);
        }
        RollupSensor rollupSensor = this;
        synchronized (rollupSensor) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 4: {
                    return this.m_sum;
                }
                case 0: {
                    return new Long(this.m_time);
                }
                case 1: {
                    return this.m_sum;
                }
                case 2: {
                    return this.m_min;
                }
                case 3: {
                    return this.m_max;
                }
                case 6: {
                    return new Integer(this.m_active);
                }
                case 5: {
                    return new Double(this.m_avg);
                }
            }
        }
        return null;
    }

    public void deriveMetric(int met) {
        int toDerive = (met | this.m_derived) ^ this.m_derived;
        if (toDerive == 0) {
            return;
        }
        if (this.m_type == 1) {
            return;
        }
        if (this.m_type == 0) {
            if ((toDerive & 4) != 0) {
                this._metrics[2] = new Metric(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, 2);
                this.m_derived |= 4;
            }
            if ((toDerive & 8) != 0) {
                this._metrics[3] = new Metric(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, 3);
                this.m_derived |= 8;
            }
        }
        if (this.m_type == 2) {
            if ((toDerive & 4) != 0) {
                this._metrics[2] = new Metric(this._name + ".minTime", this._description, this.m_units, this, false, 2, 2);
                this.m_derived |= 4;
            }
            if ((toDerive & 8) != 0) {
                this._metrics[3] = new Metric(this._name + ".maxTime", this._description, this.m_units, this, false, 2, 3);
                this.m_derived |= 8;
            }
            if ((toDerive & 2) != 0) {
                this._metrics[1] = new Metric(this._name + ".completed", this._description, "ops", this, false, 3, 1);
                this.m_derived |= 2;
            }
            if ((toDerive & 0x20) != 0 && this._metrics[1] != null) {
                this._metrics[5] = new Metric(this._name + ".avg", this._description, this.m_units, this, false, 1, 5);
                this.m_derived |= 0x20;
            }
            if ((toDerive & 0x40) != 0) {
                this._metrics[6] = new Metric(this._name + ".active", this._description, "threads", this, false, 3, 6);
                this.m_derived |= 0x40;
            }
        }
    }

    protected void updateMetrics(Sensor sensor) {
        if (this.m_type != 0 && this.m_type != 2) {
            return;
        }
        SensorDescriptor desc = sensor.getDescriptor();
        int count = desc.getMetricCount();
        SensorDescriptor my_desc = this.getDescriptor();
        int my_count = my_desc.getMetricCount();
        String[] mnames = null;
        int toDerive = 0;
        if (this.m_type == 0) {
            if (my_count == count + 1) {
                return;
            }
            mnames = desc.getMetricNames();
            for (int i = 0; i < mnames.length; ++i) {
                if (mnames[i].endsWith("minValue")) {
                    toDerive |= 4;
                }
                if (!mnames[i].endsWith("maxValue")) continue;
                toDerive |= 8;
            }
            this.deriveMetric(toDerive);
            return;
        }
        if (my_count == count || my_count == 6) {
            return;
        }
        mnames = desc.getMetricNames();
        for (int i = 0; i < mnames.length; ++i) {
            if (mnames[i].endsWith("minTime")) {
                toDerive |= 4;
            }
            if (mnames[i].endsWith("maxTime")) {
                toDerive |= 8;
            }
            if (mnames[i].endsWith("completed")) {
                toDerive |= 2;
            }
            if (mnames[i].endsWith("active")) {
                toDerive |= 0x40;
            }
            if (!mnames[i].endsWith("avg")) continue;
            toDerive |= 0x20;
        }
        this.deriveMetric(toDerive);
    }

    public void reset() {
    }

    static {
        RollupSensor.s_max[0] = 3;
        RollupSensor.s_max[1] = 1;
        RollupSensor.s_max[2] = 7;
    }
}

