/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.TransTrace;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class PhaseEvent
extends Sensor
implements PhaseEventIntf {
    private long _duration = 0L;
    private long _exclTime = 0L;
    private int _active = 0;
    private int _maxActive = 0;
    private int _updateCount = 0;
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;
    private static Clock _clock = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhaseEvent create(Noun parent, String name, String desc) {
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("PhaseEvent.create(): bad parameters");
        }
        PhaseEvent pe = (PhaseEvent)parent.getSensor(name);
        if (pe != null) {
            return pe;
        }
        String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
        Noun noun = parent;
        synchronized (noun) {
            pe = (PhaseEvent)parent.getSensor(sanitizedName);
            if (pe != null) {
                return pe;
            }
            return new PhaseEvent(false, parent, sanitizedName, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhaseEvent create(String pathname, String desc) {
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("PhaseEvent.create(): bad parameters");
        }
        PhaseEvent pe = (PhaseEvent)Sensor.lookupCache(pathname);
        if (pe != null) {
            return pe;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            pe = (PhaseEvent)parent.getSensor(sanitizedName);
            if (pe != null) {
                pe.addToCache(pathname);
                return pe;
            }
            return new PhaseEvent(false, parent, sanitizedName, desc);
        }
    }

    public static PhaseEvent create(String pathname, String desc, int derived) {
        PhaseEvent pe = PhaseEvent.create(pathname, desc);
        pe.deriveMetric(derived);
        return pe;
    }

    public PhaseEvent(Noun parent, String name, String desc) {
        this(true, parent, name, desc);
    }

    private PhaseEvent(boolean sanitizeName, Noun parent, String name, String desc) {
        super(sanitizeName, parent, name, desc);
        this._metrics[0] = new Metric(this._name + ".time", this._description, ClockManager.getUnits(DMSConsole.UNITS), this, false, 2, 0);
        this.setUpdateTime(0L);
        if (_clock == null) {
            _clock = DMSConsole.getClock();
        }
    }

    public synchronized void deriveMetric(int metric) {
        if (!this._alive) {
            return;
        }
        String units = ClockManager.getUnits(DMSConsole.UNITS);
        boolean derived = false;
        if ((metric & 2) > 0 && this._metrics[1] == null) {
            this._metrics[1] = new Metric(this._name + ".completed", this._description, "ops", this, false, 3, 1);
            derived = true;
        }
        if ((metric & 8) > 0 && this._metrics[3] == null) {
            this._metrics[3] = new Metric(this._name + ".maxTime", this._description, units, this, false, 2, 3);
            derived = true;
        }
        if ((metric & 4) > 0 && this._metrics[2] == null) {
            this._metrics[2] = new Metric(this._name + ".minTime", this._description, units, this, false, 2, 2);
            derived = true;
        }
        if ((metric & 0x20) > 0 && this._metrics[5] == null) {
            this._metrics[5] = new Metric(this._name + ".avg", this._description, units, this, false, 1, 5);
            derived = true;
        }
        if ((metric & 0x40) > 0 && this._metrics[6] == null) {
            this._metrics[6] = new Metric(this._name + ".active", this._description, "threads", this, false, 3, 6);
            derived = true;
        }
        if ((metric & 0x80) > 0 && this._metrics[7] == null) {
            this._metrics[7] = new Metric(this._name + ".maxActive", this._description, "threads", this, false, 3, 7);
            derived = true;
        }
        if (TransTrace._isEnabled() && (metric & 0x100) > 0 && this._metrics[8] == null) {
            this._metrics[8] = new Metric(this._name + ".exclTime", this._description, "msecs", this, false, 2, 8);
            derived = true;
        }
        if (derived) {
            this.setUpdateTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric m) {
        if (m == null) {
            throw new InstrumentationException("Metric: " + m + " does not belong to PhaseEvent " + this);
        }
        if (!m.isAlive()) {
            return new ErrorObject();
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("Metric: " + m + " does not belong to PhaseEvent " + this);
        }
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 1: {
                    return new Integer(this._updateCount);
                }
                case 2: {
                    if (this._min == Long.MAX_VALUE) {
                        return new Long(0L);
                    }
                    return new Long(_clock.convertTime(this._min, DMSConsole.UNITS));
                }
                case 3: {
                    if (this._max == Long.MIN_VALUE) {
                        return new Long(0L);
                    }
                    return new Long(_clock.convertTime(this._max, DMSConsole.UNITS));
                }
                case 0: {
                    return new Long(_clock.convertTime(this._duration, DMSConsole.UNITS));
                }
                case 5: {
                    long duration = _clock.convertTime(this._duration, DMSConsole.UNITS);
                    return new Double(this._updateCount != 0 && duration != 0L ? (double)duration / (double)this._updateCount : 0.0);
                }
                case 6: {
                    return new Integer(this._active);
                }
                case 7: {
                    return new Integer(this._maxActive);
                }
                case 8: {
                    this._exclTime = this._duration;
                    return new Long(this._exclTime);
                }
            }
        }
        throw new InstrumentationException("Metric: " + m + " does not belong to PhaseEvent " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start() {
        Tracer tr;
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 1);
        }
        if (this.isLoggable()) {
            this.logActivation("Start");
        }
        long time = _clock.getTime();
        long convertedTime = _clock.convertTime(time, 1000L);
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            ++this._active;
            if (this._active > this._maxActive) {
                this._maxActive = this._active;
            }
            if (this._lastUpdate < convertedTime) {
                this._lastUpdate = convertedTime;
            }
        }
        return time;
    }

    public static long start(String pathname) {
        return ((PhaseEvent)Sensor.get(pathname)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long startToken) {
        Tracer tr;
        long convertedTime = _clock.convertTime(startToken, 1000L);
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            ++this._active;
            if (this._active > this._maxActive) {
                this._maxActive = this._active;
            }
            if (this._lastUpdate < convertedTime) {
                this._lastUpdate = convertedTime;
            }
        }
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 1);
        }
        if (this.isLoggable()) {
            this.logActivation("Start");
        }
    }

    public static void stop(String name, long token) {
        ((PhaseEvent)Sensor.get(name)).stop(token);
    }

    public void stop(long token) {
        this.stop2(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop2(long token) {
        Tracer tr;
        long stopToken = _clock.getTime();
        long thisDuration = stopToken - token;
        if (thisDuration < 0L) {
            thisDuration = 0L;
            stopToken = token;
        }
        long convertedTime = _clock.convertTime(stopToken, 1000L);
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration += thisDuration;
            if (this._max < thisDuration) {
                this._max = thisDuration;
            }
            if (this._min > thisDuration) {
                this._min = thisDuration;
            }
            --this._active;
            ++this._updateCount;
            if (this._lastUpdate < convertedTime) {
                this._lastUpdate = convertedTime;
            }
        }
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 2);
        }
        if (this.isLoggable()) {
            StringBuffer sb = new StringBuffer("Stop: [");
            sb.append(token);
            sb.append(", ");
            sb.append(stopToken);
            sb.append(", ");
            sb.append(this._updateCount);
            sb.append(" ops, ");
            sb.append(this._duration);
            sb.append(" " + _clock.getUnits() + "]");
            this.logActivation(sb.toString());
        }
        Bucket.drop((Sensor)this, thisDuration, convertedTime);
        return stopToken;
    }

    public long stopElapsed(long token) {
        long tokenStop = this.stop2(token);
        return tokenStop - token;
    }

    public static void stop(String pathname, long startToken, long stopToken) {
        ((PhaseEvent)Sensor.get(pathname)).stop(startToken, stopToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long startToken, long stopToken) {
        Tracer tr;
        long convertedTime;
        long thisDuration = stopToken - startToken;
        if (thisDuration < 0L) {
            thisDuration = 0L;
            convertedTime = _clock.convertTime(startToken, 1000L);
        } else {
            convertedTime = _clock.convertTime(stopToken, 1000L);
        }
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration += thisDuration;
            if (this._max < thisDuration) {
                this._max = thisDuration;
            }
            if (this._min > thisDuration) {
                this._min = thisDuration;
            }
            --this._active;
            ++this._updateCount;
            if (this._lastUpdate < convertedTime) {
                this._lastUpdate = convertedTime;
            }
        }
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 2);
        }
        if (this.isLoggable()) {
            StringBuffer sb = new StringBuffer("Stop: [");
            sb.append(startToken);
            sb.append(", ");
            sb.append(stopToken);
            sb.append(", ");
            sb.append(this._updateCount);
            sb.append(" ops, ");
            sb.append(this._duration);
            sb.append(" msecs]");
            this.logActivation(sb.toString());
        }
        Bucket.drop((Sensor)this, thisDuration, convertedTime);
    }

    public static void abort(String name, long token) {
        ((PhaseEvent)Sensor.get(name)).abort(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(long token) {
        Tracer tr;
        long timeStamp = System.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            --this._active;
            this.setUpdateTime(timeStamp);
        }
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 3);
        }
        if (this.isLoggable()) {
            this.logActivation("Abort");
        }
    }

    public static long getToken() {
        return _clock.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long timeStamp = System.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration = 0L;
            this._updateCount = 0;
            this._min = Long.MAX_VALUE;
            this._max = Long.MIN_VALUE;
            this._maxActive = this._active;
            this.setUpdateTime(timeStamp);
            this.setResetTime(timeStamp);
        }
    }

    PhaseEvent getCousin(Noun pre) {
        PhaseEvent retval = null;
        Noun cousinNoun = this.getParent().getCousin(pre);
        if (cousinNoun != null) {
            retval = PhaseEvent.create(cousinNoun, this._name, "cousin");
            int derivedBits = 0;
            derivedBits |= 1;
            derivedBits |= 2;
            if (this._metrics[3] != null) {
                derivedBits |= 8;
            }
            if (this._metrics[2] != null) {
                derivedBits |= 4;
            }
            if (this._metrics[8] != null) {
                derivedBits |= 0x100;
            }
            retval.deriveMetric(derivedBits);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExclTime(long time) {
        long timeStamp = System.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._exclTime += time;
            this.setUpdateTime(timeStamp);
        }
    }

    public boolean isInitialized() {
        return this._updateCount > 0 || this._active > 0;
    }

    static synchronized void shutdown() {
        _clock = null;
    }
}

