/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.File;
import oracle.dms.instrument.DMSFileUtil;
import oracle.dms.instrument.DumpFilenameFilter;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.State;

class NounDumperThread
extends Thread {
    static final String DMSDUMP_PREFIX = "dmsDump_";
    static final String DMSDUMP_SUFFIX = ".xml";
    private Noun _noun = null;
    private long _interval = 0L;
    private String _dest = null;
    private int _maxDumps = 0;
    private NounDumpListener _lsnr = null;
    private PhaseEvent _dumpPhase = null;
    private State _prevDumpState = null;
    private State _nextDumpState = null;
    private State _destState = null;
    private State _intervalState = null;
    private State _maxDumpsState = null;

    NounDumperThread(Noun n, int interval, String dest, int max, NounDumpListener lsnr) {
        this._noun = n;
        this._interval = interval * 1000;
        this._dest = dest;
        this._maxDumps = max;
        this._lsnr = lsnr;
        Noun diNoun = Noun.create("/DMS-Internal/transtrace/DumpInfo", "dms_dumpInfo");
        this._dumpPhase = PhaseEvent.create(diNoun, "dump", "metric data was dumped to file");
        this._dumpPhase.deriveMetric(46);
        this._prevDumpState = State.create(diNoun, "lastDumpTime", "", "timestamp of previous dump", (Object)"no dump yet");
        this._nextDumpState = State.create(diNoun, "nextDumpTime", "", "timestamp of next dump", (Object)"n/a");
        this._destState = State.create(diNoun, "location", "", "dump location", (Object)this._dest);
        this._intervalState = State.create(diNoun, "sleepInterval", "secs", "sleep interval between dumps", this._interval / 1000L);
        this._maxDumpsState = State.create(diNoun, "maxDumps", "files", "maximum number of dumps", this._maxDumps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this._noun.isAlive()) {
                long tstamp = this.doSleep();
                long tok = this._dumpPhase.start();
                this.evictOldDumps();
                try {
                    String fname = this.dumpFileName(tstamp);
                    if (this._lsnr != null) {
                        try {
                            this._lsnr.preNounDump(this._noun);
                        }
                        catch (Exception e) {
                            System.err.println("NounDumper: listener preDump -- " + e);
                            e.printStackTrace();
                        }
                    }
                    this._noun.dump(fname, "pdml", false);
                    if (this._lsnr == null) continue;
                    try {
                        this._lsnr.postNounDump(this._noun);
                    }
                    catch (Exception e) {
                        System.err.println("NounDumper: listener postDump -- " + e);
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("NounDumper: Exception caught -- " + e);
                    e.printStackTrace();
                }
                finally {
                    this._dumpPhase.stop(tok);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void evictOldDumps() {
        try {
            String fname;
            int i;
            File dir = new File(this._dest);
            if (!DMSFileUtil.isDirectory(dir)) {
                return;
            }
            String[] fileNameList = DMSFileUtil.list(dir, new DumpFilenameFilter());
            if (fileNameList.length < this._maxDumps) {
                return;
            }
            long[] tstampList = new long[fileNameList.length];
            for (i = 0; i < fileNameList.length; ++i) {
                int j;
                fname = fileNameList[i];
                String tstampStr = fname.substring(DMSDUMP_PREFIX.length(), fname.length() - DMSDUMP_SUFFIX.length());
                Long tstampL = new Long(tstampStr);
                long tstamp = tstampL;
                for (j = 0; j < i && tstamp <= tstampList[j]; ++j) {
                }
                for (int k = i; k > j; --k) {
                    tstampList[k] = tstampList[k - 1];
                }
                tstampList[j] = tstamp;
            }
            for (i = this._maxDumps - 1; i < fileNameList.length; ++i) {
                fname = this.dumpFileName(tstampList[i]);
                File f = new File(fname);
                f.delete();
            }
        }
        catch (Exception e) {
            System.err.println("DMS Dump: exception during eviction: " + e);
            e.printStackTrace();
        }
    }

    private String dumpFileName(long tstamp) {
        StringBuffer fnameBuf = new StringBuffer();
        fnameBuf.append(this._dest);
        fnameBuf.append(File.separator);
        fnameBuf.append(DMSDUMP_PREFIX);
        fnameBuf.append(tstamp);
        fnameBuf.append(DMSDUMP_SUFFIX);
        return fnameBuf.toString();
    }

    private long doSleep() throws InterruptedException {
        long now = System.currentTimeMillis();
        long wakeUp = (now + this._interval) / this._interval * this._interval;
        long wakeUpSecs = wakeUp / 1000L;
        long sleepTime = wakeUp - now;
        this._nextDumpState.update(new Long(wakeUpSecs));
        Thread.currentThread();
        Thread.sleep(sleepTime);
        this._prevDumpState.update(new Long(wakeUpSecs));
        return wakeUpSecs;
    }
}

