/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashMap;
import java.util.Map;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.ExecutionContextForJDBC;
import oracle.dms.instrument.Tracer;

public class ExecutionContext {
    public static final String ATT_ACTION = "Action";
    public static final String ATT_MODULE = "Module";
    public static final String ATT_CLIENTID = "ClientID";
    public static final String ATT_ECIDUID = "ECID_UID";
    public static final String ATT_URI = "URI";
    public static final String ATT_TCONTEXT = "Oracle-TraceContext";
    public static final String ATT_TTRIGGER = "Oracle-TraceTrigger";
    private int m_ECIDSequenceNumber = 0;
    private Tracer m_defaultTracer;
    private Tracer m_tracer;
    private Map m_attMap = new HashMap();
    private ExecutionContextForJDBC m_jdbcCtx = null;
    private static ThreadLocal tlocal = new ThreadLocal();
    private static boolean s_snoAutoIncrement = false;

    private ExecutionContext() {
    }

    public static ExecutionContext get() {
        ExecutionContext ectx = (ExecutionContext)tlocal.get();
        if (ectx == null) {
            ectx = new ExecutionContext();
            tlocal.set(ectx);
        }
        return ectx;
    }

    public void setECID(LogMessage.InstanceId newECID) {
        if (newECID == null) {
            this.m_attMap.put(ATT_ECIDUID, LogManager.getLogManager().getUniqueId());
            this.m_ECIDSequenceNumber = 0;
            if (this.m_jdbcCtx != null) {
                this.m_jdbcCtx.invalidate();
            }
        } else {
            String uid = newECID.getUniqueId();
            if (uid != null) {
                this.m_attMap.put(ATT_ECIDUID, uid);
                this.m_ECIDSequenceNumber = newECID.getSequenceNumber();
                if (this.m_jdbcCtx != null) {
                    this.m_jdbcCtx.invalidate();
                }
            }
        }
    }

    public void incrementECIDSequenceNumber() {
        ++this.m_ECIDSequenceNumber;
    }

    public void setECIDSequenceNumber(int sno) {
        this.m_ECIDSequenceNumber = sno;
    }

    public int getECIDSequenceNumber() {
        if (ExecutionContext.isSequenceNumberAutoIncrementEnabled()) {
            this.incrementECIDSequenceNumber();
        }
        return this.m_ECIDSequenceNumber;
    }

    public void reset() {
        this.m_tracer = this.m_defaultTracer;
        if (this.m_tracer != null) {
            this.m_tracer.reset();
        }
        this.getAttributeMap().clear();
        this.m_ECIDSequenceNumber = 0;
        if (this.m_jdbcCtx != null) {
            this.m_jdbcCtx.invalidate();
        }
    }

    public LogMessage.InstanceId getECID() {
        String uid = (String)this.m_attMap.get(ATT_ECIDUID);
        if (uid == null) {
            this.setECID(null);
            uid = (String)this.m_attMap.get(ATT_ECIDUID);
        }
        return new LogMessage.InstanceId(uid, this.getECIDSequenceNumber());
    }

    public Tracer getTracer() {
        if (this.m_tracer == null) {
            if (this.m_defaultTracer == null) {
                this.m_defaultTracer = new Tracer();
            }
            this.m_tracer = this.m_defaultTracer;
        }
        return this.m_tracer;
    }

    public void setTracer(Tracer t) {
        this.m_tracer = t;
    }

    public String getECIDasString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.m_attMap.get(ATT_ECIDUID));
        ret.append(',');
        ret.append(this.getECIDSequenceNumber());
        return ret.toString();
    }

    public Map getAttributeMap() {
        return this.m_attMap;
    }

    public void setAttributeMap(Map map) {
        if (map != null) {
            this.m_attMap = map;
        }
    }

    public void setAttribute(String att, Object val) {
        this.m_attMap.put(att, val);
        if (this.m_jdbcCtx != null) {
            this.m_jdbcCtx.invalidate();
        }
    }

    public static LogMessage.InstanceId parseECID(String str) {
        LogMessage.InstanceId retval = null;
        if (str != null && !str.equals("")) {
            String uid = str;
            int sno = 0;
            int length = str.length();
            int index = str.indexOf(44);
            if (index > 0) {
                uid = str.substring(0, index);
                ++index;
                while (index < length && str.charAt(index) == ' ') {
                    ++index;
                }
                if (index < length) {
                    try {
                        sno = Integer.parseInt(str.substring(index));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            retval = new LogMessage.InstanceId(uid, sno);
        }
        return retval;
    }

    public static void setSequenceNumberAutoIncrementEnabled(boolean val) {
        s_snoAutoIncrement = val;
    }

    private static boolean isSequenceNumberAutoIncrementEnabled() {
        return s_snoAutoIncrement;
    }

    ExecutionContextForJDBC getJdbcCtx() {
        if (this.m_jdbcCtx == null) {
            this.m_jdbcCtx = new ExecutionContextForJDBC();
        }
        return this.m_jdbcCtx;
    }

    static synchronized void shutdown() {
        tlocal = new ThreadLocal();
        s_snoAutoIncrement = false;
    }
}

