/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class Event
extends Sensor
implements EventIntf {
    private int _count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event create(String pathname, String desc) {
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("Event.create(): bad parameters");
        }
        Event ev = (Event)Sensor.lookupCache(pathname);
        if (ev != null) {
            return ev;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            ev = (Event)parent.getSensor(sanitizedName);
            if (ev != null) {
                ev.addToCache(pathname);
                return ev;
            }
            return new Event(false, parent, sanitizedName, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event create(Noun parent, String name, String desc) {
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("Event.create(): bad parameters");
        }
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            Event e = (Event)parent.getSensor(sanitizedName);
            if (e != null) {
                return e;
            }
            return new Event(false, parent, sanitizedName, desc);
        }
    }

    public Event(Noun parent, String name, String desc) {
        this(true, parent, name, desc);
    }

    private Event(boolean sanitizeName, Noun parent, String name, String desc) {
        super(sanitizeName, parent, name, desc);
        this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
        this.setUpdateTime(0L);
    }

    public static void occurred(String pathname) {
        ((Event)Sensor.get(pathname)).occurred();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void occurred() {
        Tracer tr;
        int count;
        Event event = this;
        synchronized (event) {
            count = ++this._count;
        }
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 0);
        }
        if (this.isLoggable()) {
            this.logActivation("" + count);
        }
        Bucket.drop((Sensor)this, 1, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void occurred(Object[] inserts) {
        Tracer tr;
        int count;
        Event event = this;
        synchronized (event) {
            count = ++this._count;
        }
        if (this.isTraceable() && (tr = ExecutionContext.get().getTracer()) != null) {
            tr.append((Sensor)this, 0);
        }
        if (this.isLoggable()) {
            this.logActivation("" + count, inserts);
        }
        Bucket.drop((Sensor)this, 1, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric m) {
        if (m == null) {
            m = this.getMetric(2);
        }
        if (!m.isAlive()) {
            return new ErrorObject();
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("Metric: " + m + " does not belong to Event " + this);
        }
        Event event = this;
        synchronized (event) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 1: {
                    return new Integer(this._count);
                }
            }
        }
        throw new InstrumentationException("Metric: " + m + " does not belong to Event " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long timeStamp = System.currentTimeMillis();
        Event event = this;
        synchronized (event) {
            this._count = 0;
            this.setResetTime(timeStamp);
        }
    }

    public void deriveMetric(int metric) {
    }

    Event getCousin(Noun pre) {
        Event retval = null;
        Noun cousinNoun = this.getParent().getCousin(pre);
        if (cousinNoun != null) {
            retval = Event.create(cousinNoun, this._name, "cousin");
        }
        return retval;
    }

    public boolean isInitialized() {
        return this._count > 0;
    }
}

