/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Properties;
import java.util.Stack;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.ExecutionContext;

public class CorrelationContext {
    private String upstreamId;
    private String currentId;
    private String downstreamId;
    private LogMessage.InstanceId execCtxId;
    private LogMessage.InstanceId errorInstId;
    private Properties properties;
    private static ThreadLocal threadStack = new ThreadLocal();

    private CorrelationContext() {
    }

    public static void enter(String fromCtx, String toCtx, LogMessage.InstanceId execCtxId) {
        ExecutionContext.get().setECID(execCtxId);
        CorrelationContext ctx = new CorrelationContext();
        ctx.upstreamId = fromCtx;
        ctx.currentId = toCtx;
        ctx.downstreamId = null;
        ctx.execCtxId = execCtxId;
        CorrelationContext.push(ctx);
    }

    public static void enter(String toCtx) {
        int seqNo;
        String uniqueId;
        ExecutionContext.get().incrementECIDSequenceNumber();
        CorrelationContext currCtx = CorrelationContext.getTop();
        LogMessage.InstanceId execCtxId = null;
        String fromCtx = null;
        if (currCtx != null) {
            execCtxId = currCtx.execCtxId;
            fromCtx = currCtx.currentId;
        }
        if (execCtxId != null) {
            uniqueId = execCtxId.getUniqueId();
            seqNo = execCtxId.getSequenceNumber() + 1;
        } else {
            uniqueId = LogManager.getLogManager().getUniqueId();
            seqNo = 0;
        }
        CorrelationContext.enter(fromCtx, toCtx, new LogMessage.InstanceId(uniqueId, seqNo));
    }

    public static void exit() {
        CorrelationContext exitCtx = CorrelationContext.pop();
        if (exitCtx == null) {
            return;
        }
        LogMessage.InstanceId errInstId = exitCtx.errorInstId;
        if (errInstId != null) {
            CorrelationContext.setError(exitCtx.currentId, new LogMessage.InstanceId(errInstId.getUniqueId(), errInstId.getSequenceNumber() + 1));
        }
    }

    public static void setError(String fromComponent, LogMessage.InstanceId errorInstanceId) {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            ctx.downstreamId = fromComponent;
            ctx.errorInstId = errorInstanceId;
        }
    }

    public static void setError() {
        String uniqueId = LogManager.getLogManager().getUniqueId();
        CorrelationContext.setError(null, new LogMessage.InstanceId(uniqueId, 0));
    }

    public static void clearError() {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            ctx.errorInstId = null;
            ctx.downstreamId = null;
        }
    }

    public static LogMessage.InstanceId getExecContextId() {
        return ExecutionContext.get().getECID();
    }

    public static LogMessage.InstanceId getErrorInstanceId() {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            return ctx.errorInstId;
        }
        return null;
    }

    public static String getUpstreamId() {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            return ctx.upstreamId;
        }
        return null;
    }

    public static String getDownstreamId() {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            return ctx.downstreamId;
        }
        return null;
    }

    public static void setProperty(String propertyName, String value) {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            if (ctx.properties == null) {
                ctx.properties = new Properties();
            }
            ctx.properties.setProperty(propertyName, value);
        }
    }

    public static String getProperty(String propertyName) {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null && ctx.properties != null) {
            return ctx.properties.getProperty(propertyName);
        }
        return null;
    }

    public static Properties getProperties() {
        CorrelationContext ctx = CorrelationContext.getTop();
        if (ctx != null) {
            return ctx.properties;
        }
        return null;
    }

    public static LogMessage.InstanceId parseExecContextId(String strCtx) {
        return ExecutionContext.parseECID(strCtx);
    }

    private static CorrelationContext getTop() {
        Stack stack = (Stack)threadStack.get();
        if (stack != null && !stack.empty()) {
            return (CorrelationContext)stack.peek();
        }
        return null;
    }

    private static void push(CorrelationContext ctx) {
        Stack<CorrelationContext> stack = (Stack<CorrelationContext>)threadStack.get();
        if (stack == null) {
            stack = new Stack<CorrelationContext>();
            threadStack.set(stack);
        }
        stack.push(ctx);
    }

    private static CorrelationContext pop() {
        Stack stack = (Stack)threadStack.get();
        if (stack != null && !stack.empty()) {
            return (CorrelationContext)stack.pop();
        }
        return null;
    }

    static synchronized void shutdown() {
        threadStack = new ThreadLocal();
    }
}

