/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.ArrayList;
import oracle.dms.context.ExecutionContext;
import oracle.dms.instrument.BucketSensor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket {
    static void drop(Sensor sensor, long amount, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(sensor);
        if (bucketNouns == null) {
            return;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, sensor);
            if (bucketSensor == null) continue;
            bucketSensor.update(amount, updateTime);
        }
    }

    static void drop(Sensor sensor, int amount, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(sensor);
        if (bucketNouns == null) {
            return;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, sensor);
            if (bucketSensor == null) continue;
            bucketSensor.update(amount, updateTime);
        }
    }

    static void drop(Sensor sensor, double amount, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(sensor);
        if (bucketNouns == null) {
            return;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, sensor);
            if (bucketSensor == null) continue;
            bucketSensor.update(amount, updateTime);
        }
    }

    private static ArrayList<Noun> getBucketNouns(Sensor sensor) {
        Noun parent = sensor.getParent();
        ArrayList<String> bucketKeys = parent.getBucketKeys();
        if (bucketKeys == null) {
            return null;
        }
        ExecutionContext ctx = ExecutionContext.get();
        if (ctx == null) {
            return null;
        }
        ArrayList<Noun> bucketNouns = new ArrayList<Noun>();
        for (String key : bucketKeys) {
            Noun bucketNoun;
            String value = ctx.getValue(key);
            if (value == null || (bucketNoun = Bucket.getBucketNoun(parent, key, value)) == null) continue;
            bucketNouns.add(bucketNoun);
        }
        return bucketNouns;
    }

    private static BucketSensor getBucketSensor(Noun bucket, Sensor sens) {
        Sensor sensor = bucket.getSensor(sens.getName());
        if (sensor != null) {
            return (BucketSensor)sensor;
        }
        return BucketSensor.create(bucket, sens);
    }

    static Noun getBucketNoun(Noun noun, String key, String value) {
        String name;
        if (noun == null || key == null || value == null) {
            return null;
        }
        Noun parent = noun.getParent();
        Noun bucket = parent.getChild(name = noun.getName() + "_B" + key + "_" + value);
        if (bucket != null) {
            return bucket;
        }
        String type = noun.getType() + "_bucketBy_" + key;
        bucket = Noun.create(parent, name, type);
        Bucket.createBucketSensors(noun, bucket);
        return bucket;
    }

    static void createBucketSensors(Noun original, Noun bucket) {
        Sensor[] sensors;
        for (Sensor sensor : sensors = original.getSensors()) {
            BucketSensor.create(bucket, sensor);
        }
    }
}

