/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.impl.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import oracle.dms.http.Request;
import oracle.dms.reporter.TableBaseReporter;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.util.QueryOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableReporter
extends TableBaseReporter {
    TableSource m_source = null;
    Collection<Table> m_tables = null;

    TableReporter(TableSource source, Request request) {
        super(request);
        if (source == null) {
            throw new IllegalArgumentException("source=" + source);
        }
        this.m_source = source;
    }

    @Override
    public final void printResponse(PrintWriter out) {
        HashSet<String> badTables = new HashSet<String>();
        String[] tableNames = this.m_request.getTables();
        this.m_tables = this.getTables(tableNames, badTables);
        this.printHeading(out);
        if (this.m_tables != null) {
            for (Table table : this.m_tables) {
                this.printTable(table, out);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, this.getClass().getName(), "printResponse", "no tables to be printed");
        }
        this.printBadParams(null, badTables, out);
        this.printEnding(out);
        badTables.clear();
    }

    @Override
    public void clear() {
        super.clear();
        if (this.m_tables != null) {
            for (Table table : this.m_tables) {
                table.close();
            }
            this.m_tables.clear();
        }
    }

    Collection<Table> getTables(String[] tables, Collection<String> badTables) {
        if (tables == null || tables.length == 0) {
            tables = this.m_source.getTableNames(this.m_options);
        }
        QueryOptions options = (QueryOptions)this.m_options.clone();
        options.setQueryType(QueryOptions.QueryType.ALL);
        Table[] tableObjs = this.m_source.getTables(tables, options);
        HashSet<Table> retval = new HashSet<Table>();
        for (int i = tables.length - 1; i >= 0; --i) {
            if (tableObjs[i] == null) {
                if (badTables == null) continue;
                badTables.add(tables[i]);
                continue;
            }
            retval.add(tableObjs[i]);
        }
        return retval;
    }

    @Override
    protected void setQueryOptions() {
        String[] nullVariables;
        String[] variables;
        String historicalTime;
        String[] tnIds;
        String cacheString;
        super.setQueryOptions();
        int interval = 0;
        String intervalString = this.m_request.getParameter("interval");
        if (intervalString != null && intervalString.trim().length() > 0) {
            try {
                interval = Integer.parseInt(intervalString.trim());
                if (interval >= 1000) {
                    this.m_options.setInterval(interval);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ("all".equalsIgnoreCase(cacheString = this.m_request.getParameter("cache")) || "refreshall".equalsIgnoreCase(cacheString) || "false".equalsIgnoreCase(cacheString) || "refreshvalues".equalsIgnoreCase(cacheString)) {
            this.m_options.setUseCache(QueryOptions.UseCache.REFRESH_ALL);
        } else {
            this.m_options.setUseCache(QueryOptions.UseCache.CACHE_COPY);
        }
        String preFetchString = this.m_request.getParameter("prefetch");
        if ("false".equalsIgnoreCase(preFetchString)) {
            this.m_options.setPrefetching(false);
        }
        if ((tnIds = this.m_request.getParameterValues("toponodeid")) != null && tnIds.length > 0) {
            for (String tnId : tnIds) {
                if (tnId == null || tnId.trim().length() == 0) continue;
                this.m_options.addTopoNodeID(tnId);
            }
        }
        if ((historicalTime = this.m_request.getParameter("historical")) != null && historicalTime.trim().length() > 0) {
            this._setHistoricTime(historicalTime.trim());
        }
        if ((variables = this.m_request.getParameterValues("variable")) != null && variables.length > 0) {
            for (String variable : variables) {
                String[] tokens;
                if (variable == null || variable.trim().length() == 0 || (tokens = variable.split(" ", 2)) == null | tokens.length < 2) continue;
                this.m_options.setValue(tokens[0], (Serializable)((Object)tokens[1]));
            }
        }
        if ((nullVariables = this.m_request.getParameterValues("variablenull")) != null && nullVariables.length > 0) {
            for (String nullVariable : nullVariables) {
                if (nullVariable == null || nullVariable.trim().length() == 0) continue;
                this.m_options.setValue(nullVariable, null);
            }
        }
    }

    private void _setHistoricTime(String historicString) {
        long endTime;
        long startTime;
        String[] times = historicString.split(":");
        if (times == null || times.length != 2) {
            return;
        }
        try {
            startTime = Long.parseLong(times[0].trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            endTime = Long.parseLong(times[1].trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        this.m_options.setHistoricalTime(startTime, endTime);
    }

    abstract void printTable(Table var1, PrintWriter var2);

    abstract void printHeading(PrintWriter var1);

    abstract void printEnding(PrintWriter var1);
}

