/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.impl.reporter;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.impl.reporter.MetricTableReporter;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.QueryOptions;

class MetricListReporter
extends MetricTableReporter {
    MetricListReporter(TableSource tableSource, Request request, boolean doTreelet) {
        super(tableSource, request, doTreelet);
    }

    void printHeading(PrintWriter out) {
        MetricListReporter.printHTMLStart(out);
        out.println("</head><body bgcolor=\"#ffffff\">");
        this.m_options.setUseCache(QueryOptions.UseCache.REFRESH_ALL);
        Object[] tables = this.m_source.getTableNames(this.m_options);
        if (tables != null) {
            Arrays.sort(tables);
        }
        this.printMetricList((String[])tables, out);
    }

    void printMetricList(String[] tables, PrintWriter out) {
        this.printMetricTable(tables, out);
        out.print("<hr style=\"color:#cccc99\">");
        out.print(new Date());
        out.println("</body></html>");
    }

    private void printMetricTable(String[] tables, PrintWriter out) {
        MetricListReporter.printBanner("<font size=+2>" + DMSNLSupport.getString("TV_TABLES", "Metric Tables") + "</font>", out);
        if (!this.m_isCollector) {
            this.printTextFormat(null, "metricTableFrame", out);
            out.print("<p>");
        }
        if (tables != null) {
            for (String table : tables) {
                out.print("<a");
                this.printTableSort(table, out);
                out.print(" target=");
                out.print("metricTableFrame");
                out.print('>');
                out.print(table);
                out.print("</a><br>\n");
            }
            out.print("<p>");
        }
    }

    void printEnding(PrintWriter out) {
    }

    void printTable(Table table, PrintWriter out) {
    }
}

