/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.dms.http.DmsHttplet;
import oracle.dms.http.Httpd;
import oracle.dms.http.Request;
import oracle.dms.impl.util.ByteBuf;
import oracle.dms.util.DMSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends Request {
    static final float HTTP_VER_1_1 = 1.1f;
    static final float HTTP_VER_1_0 = 1.0f;
    static final float HTTP_VER_0_9 = 0.9f;
    static final int HTTP_CODE_GET = 1;
    static final int HTTP_CODE_POST = 2;
    static final int HTTP_CODE_HEAD = 3;
    static final int BAD_CONTENT_LENGTH = Integer.MAX_VALUE;
    private int m_method = -1;
    private float m_httpVersion = 1.0f;
    private HashMap<String, String> m_headerTable = new HashMap();
    private HashMap<String, ArrayList<String>> m_paramTable = new HashMap();
    private InputStream m_input = null;
    private int m_contentLength = Integer.MAX_VALUE;
    private Httpd m_parent = null;
    private String m_requestURI = null;
    private ByteBuf m_postData = null;

    public HttpRequest(InputStream in, Httpd parent) {
        if (in == null || parent == null) {
            throw new IllegalArgumentException(this.toString() + ".init(): instrm=" + in + " parent=" + parent);
        }
        this.m_input = new BufferedInputStream(in);
        this.m_parent = parent;
    }

    void close() {
        this.m_headerTable.clear();
        this.m_paramTable.clear();
        if (this.m_tables != null) {
            Arrays.fill(this.m_tables, null);
        }
    }

    float getHttpVersion() {
        return this.m_httpVersion;
    }

    int getHttpMethod() {
        return this.m_method;
    }

    @Override
    public String getMethod() {
        switch (this.m_method) {
            case 1: {
                return "GET";
            }
            case 2: {
                return "POST";
            }
            case 3: {
                return "HEAD";
            }
        }
        return "";
    }

    @Override
    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        return this.m_headerTable.get(name.toLowerCase());
    }

    @Override
    public String getParameter(String name) {
        ArrayList<String> valueVec = this.getParameters(name);
        if (valueVec == null) {
            return null;
        }
        return valueVec.get(0);
    }

    ArrayList<String> getParameters(String name) {
        if (name == null) {
            return null;
        }
        return this.m_paramTable.get(name.toLowerCase());
    }

    @Override
    public String[] getParameterValues(String name) {
        ArrayList<String> values = this.getParameters(name);
        if (values == null) {
            return null;
        }
        String[] ret = new String[values.size()];
        values.toArray(ret);
        return ret;
    }

    @Override
    public String getRequestedSessionId() {
        return null;
    }

    @Override
    public String getRequestURI() {
        if (this.m_requestURI != null) {
            return this.m_requestURI;
        }
        return Httpd.DEFAULT_PATH;
    }

    @Override
    public String getServerName() {
        String host = Httpd.getHttpdHost();
        if (host != null) {
            return host;
        }
        return DMSUtil.getLocalHostname();
    }

    @Override
    public int getServerPort() {
        return this.m_parent.getHttpdPort();
    }

    InputStream getInputStream() {
        return this.m_input;
    }

    int getContentLength() {
        if (this.m_contentLength != Integer.MAX_VALUE) {
            return this.m_contentLength;
        }
        try {
            String contentLength = this.getHeader("content-length");
            if (contentLength != null) {
                this.m_contentLength = Integer.parseInt(contentLength);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.m_contentLength;
    }

    void decreContentLength() {
        --this.m_contentLength;
    }

    public ByteBuf getPostData() {
        return this.m_postData;
    }

    void setPostData(ByteBuf data) {
        this.m_postData = data;
    }

    int read() throws IOException {
        return this.m_input.read();
    }

    DmsHttplet getHttplet() {
        String path = this.getRequestURI();
        return this.m_parent.getHttplet(path);
    }

    void setMethod(int method) {
        this.m_method = method;
    }

    void setVersion(float version) {
        this.m_httpVersion = version;
    }

    void setHeader(String paramName, String paramVal) {
        if (paramName == null || paramVal == null) {
            return;
        }
        this.m_headerTable.put(paramName, paramVal);
    }

    void setParameterValues(String paramName, ArrayList<String> paramVals) {
        if (paramName == null || paramVals == null) {
            return;
        }
        this.m_paramTable.put(paramName, paramVals);
    }

    void setRequestURI(String uri) {
        if (uri != null && uri.trim().length() > 0) {
            this.m_requestURI = uri;
        }
    }
}

