/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.dms.http.Base64Encoder;
import oracle.dms.http.Httpd;
import oracle.dms.spy.Authorizer;
import oracle.dms.util.DMSProperties;

public class HttpAuthorizer
implements Authorizer {
    private Set<String> m_userpasswds = Collections.synchronizedSet(new HashSet());
    private Set<InetAddress> m_hosts = Collections.synchronizedSet(new HashSet());
    private boolean m_bindLocalHost = false;

    public HttpAuthorizer() {
        String host;
        String prop = DMSProperties.getProperty("oracle.dms.basic.userpasswds");
        if (prop != null) {
            StringTokenizer upTok = new StringTokenizer(prop, ",;");
            while (upTok.hasMoreTokens()) {
                this.addUserPasswd(upTok.nextToken());
            }
        }
        if ((host = Httpd.getHttpdHost()) != null) {
            this.addHost(host);
            this.m_bindLocalHost = true;
            return;
        }
        String hosts = DMSProperties.getProperty("oracle.dms.http.granted.hosts");
        if (hosts != null) {
            StringTokenizer upTok = new StringTokenizer(hosts, ",;");
            while (upTok.hasMoreTokens()) {
                this.addHost(upTok.nextToken());
            }
        }
    }

    public boolean authenticate(InetAddress host, String encodedUserPasswd) {
        if (this.m_hosts.size() == 0 && this.m_userpasswds.size() == 0) {
            return true;
        }
        return host != null && this.m_hosts.contains(host) || encodedUserPasswd != null && this.m_userpasswds.contains(encodedUserPasswd);
    }

    public boolean needPasswd() {
        return !this.m_userpasswds.isEmpty();
    }

    public void addHost(final String host) {
        if (host == null || this.m_bindLocalHost) {
            return;
        }
        InetAddress[] addrs = null;
        try {
            addrs = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>(){

                @Override
                public InetAddress[] run() throws UnknownHostException {
                    return InetAddress.getAllByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, this.toString(), "addHost", "host=" + host, e);
            }
            return;
        }
        catch (SecurityException e) {
            if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, this.toString(), "addHost", "host=" + host, e);
            }
            return;
        }
        for (int i = 0; i < addrs.length; ++i) {
            this.m_hosts.add(addrs[i]);
        }
    }

    public boolean removeHost(final String host) {
        if (host == null || this.m_bindLocalHost) {
            return false;
        }
        InetAddress[] addrs = null;
        try {
            addrs = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>(){

                @Override
                public InetAddress[] run() throws UnknownHostException {
                    return InetAddress.getAllByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, this.toString(), "removeHost", "host=" + host, e);
            }
            return false;
        }
        catch (SecurityException e) {
            if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, this.toString(), "removeHost", "host=" + host, e);
            }
            return false;
        }
        boolean retval = false;
        for (int i = 0; i < addrs.length; ++i) {
            retval |= this.m_hosts.remove(addrs[i]);
        }
        return retval;
    }

    public void addHost(InetAddress host) {
        if (host == null || this.m_bindLocalHost) {
            return;
        }
        this.m_hosts.add(host);
    }

    public boolean removeHost(InetAddress host) {
        if (host == null || this.m_bindLocalHost) {
            return false;
        }
        return this.m_hosts.remove(host);
    }

    public void addUserPasswd(String username, String password) {
        if (username == null || username.trim().length() == 0) {
            return;
        }
        String userPasswd = username + ':';
        if (password != null) {
            userPasswd = userPasswd + password;
        }
        this.m_userpasswds.add(Base64Encoder.encode(userPasswd));
    }

    public boolean removeUserPasswd(String username, String password) {
        if (username == null || username.trim().length() == 0) {
            return false;
        }
        String userPasswd = username + ':';
        if (password != null) {
            userPasswd = userPasswd + password;
        }
        return this.m_userpasswds.remove(Base64Encoder.encode(userPasswd));
    }

    public void addUserPasswd(String userPasswd) {
        if (userPasswd == null || userPasswd.length() <= 1 || userPasswd.indexOf(58) <= 0) {
            return;
        }
        this.m_userpasswds.add(Base64Encoder.encode(userPasswd));
    }

    public boolean removeUserPasswd(String userPasswd) {
        if (userPasswd == null || userPasswd.length() <= 1 || userPasswd.indexOf(58) <= 0) {
            return false;
        }
        return this.m_userpasswds.remove(Base64Encoder.encode(userPasswd));
    }
}

