/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.ExecutionContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECForJDBC
implements ExecutionContextListener {
    public static final String E2E_CONTEXT = "E2E_CONTEXT";
    public static final String CLIENT_CONTEXT = "CLIENTIDCONTEXT";
    private IdentityHashMap<String, Map<String, String>> m_jdbcMap = null;
    private IdentityHashMap<String, String> m_e2eMap = null;
    private static final Map<String, String> EMPTY_MAP = new IdentityHashMap<String, String>();
    private IdentityHashMap<String, String> m_map = new IdentityHashMap();
    private ExecutionContext m_ctx = null;
    private static Logger s_logger = DMSContextManager.getLogger();
    private boolean m_first = true;
    public static final String SPC = "wlmPC";
    public static final String WRC = "wlmWRC";
    public static final String URI = "uri";
    public static final String SQLTRACE = "sqltrace";
    public static final String TRACE = "dmsTrace";
    public static final String ACTION = "Action";
    public static final String MODULE = "Module";
    public static final String CLIENTID = "client_identifier";
    public static final String ECID = "ECID_UID";
    private static HashSet<String> s_e2eKey = new HashSet();
    private HashSet<String> m_changedKeys = new HashSet();
    public static final String DB_RID = "dbRID";

    private ECForJDBC() {
    }

    ECForJDBC(ExecutionContext ctx) {
        this.m_ctx = ctx;
    }

    public static IdentityHashMap getContextMap() {
        ECForJDBC jctx = ECForJDBC.get();
        if (jctx == null) {
            return null;
        }
        return jctx.getDiffMap();
    }

    private static ECForJDBC get() {
        ExecutionContext ctx = ExecutionContext.get();
        if (ctx == null) {
            return null;
        }
        return ctx.getECForJDBC();
    }

    public static boolean updateSqlText() {
        ExecutionContext ctx = ExecutionContext.get();
        if (ctx == null) {
            return false;
        }
        return ctx.updateSqlText();
    }

    private IdentityHashMap getDiffMap() {
        if (this.m_first) {
            this.m_map.put("ECID", this.m_ctx.getECID());
        } else {
            this.m_map.clear();
        }
        this.m_map.put(DB_RID, this.getRID());
        HashSet<String> keySet = this.getKeys();
        for (String key : keySet) {
            this.m_map.put(key, this.m_ctx.getValue(key));
        }
        keySet.clear();
        this.m_first = false;
        return this.m_map;
    }

    private HashSet<String> getKeys() {
        if (this.m_first) {
            for (String key : s_e2eKey) {
                if (!this.m_ctx.hasKey(key)) continue;
                this.m_changedKeys.add(key);
            }
        }
        return this.m_changedKeys;
    }

    @Override
    public void keyTouched(String key) {
        s_logger.log(Level.FINEST, "CTX_00006", key);
        this.m_changedKeys.add(key.intern());
    }

    private String getRID() {
        if (this.m_ctx == null) {
            return null;
        }
        String rid = this.m_ctx.getChildRIDasString();
        this.m_ctx.setLocalValue(DB_RID, rid);
        return rid;
    }

    public static void finished() {
        ExecutionContext ctx = null;
        ECForJDBC jctx = null;
        ctx = ExecutionContext.get();
        if (ctx == null || (jctx = ctx.getECForJDBC()) == null) {
            return;
        }
        ctx.setLocalValue(DB_RID, null);
    }

    public static Map<String, Map<String, String>> getMap() {
        ECForJDBC jctx = ECForJDBC.get();
        if (jctx == null) {
            return null;
        }
        return jctx.getJdbcMap();
    }

    private Map<String, Map<String, String>> getJdbcMap() {
        if (this.m_jdbcMap == null) {
            this.createMap();
        }
        if (this.m_jdbcMap == null) {
            return null;
        }
        this.addChangedKeys();
        return this.m_jdbcMap;
    }

    private void addChangedKeys() {
        this.m_e2eMap.put(DB_RID, this.getRID());
        HashSet<String> propKeys = this.m_ctx.getPropagateKeys();
        for (String key : this.m_changedKeys) {
            if (!propKeys.contains(key)) continue;
            String value = this.m_ctx.getValue(key);
            if (value != null) {
                this.m_e2eMap.put(key, value.intern());
                continue;
            }
            if (this.m_e2eMap.get(key) == null) continue;
            this.m_e2eMap.remove(key);
        }
        this.m_changedKeys.clear();
    }

    private void addAllKeys() {
        HashSet<String> propKeys = this.m_ctx.getPropagateKeys();
        if (propKeys == null) {
            return;
        }
        for (String key : propKeys) {
            String value = this.m_ctx.getValue(key);
            if (value == null) continue;
            this.m_e2eMap.put(key, value.intern());
        }
    }

    private void createMap() {
        IdentityHashMap jdbcMap = null;
        IdentityHashMap<String, String> e2eMap = null;
        jdbcMap = new IdentityHashMap();
        if (jdbcMap != null) {
            e2eMap = new IdentityHashMap<String, String>();
            if (e2eMap == null) {
                return;
            }
        } else {
            return;
        }
        e2eMap.put(ECID, this.m_ctx.getECID());
        jdbcMap.put(E2E_CONTEXT, e2eMap);
        this.m_jdbcMap = jdbcMap;
        this.m_e2eMap = e2eMap;
        this.addAllKeys();
        this.m_jdbcMap = jdbcMap;
        this.m_e2eMap = e2eMap;
    }

    public static String getAsString() {
        ECForJDBC jctx = ECForJDBC.get();
        return jctx.toString();
    }

    public String toString() {
        if (this.m_jdbcMap == null) {
            return null;
        }
        String retVal = new String();
        for (String mapkey : this.m_jdbcMap.keySet()) {
            retVal = retVal + mapkey;
            retVal = retVal + ": ";
            Map<String, String> map = this.m_jdbcMap.get(mapkey);
            if (map != null) {
                for (String key : map.keySet()) {
                    String value = map.get(key);
                    if (value == null) continue;
                    String add = new String(key + "," + value + "~");
                    retVal = retVal + add;
                }
            }
            retVal = retVal + "\n";
        }
        return retVal;
    }

    static {
        s_e2eKey.add(URI);
        s_e2eKey.add(SPC);
        s_e2eKey.add(WRC);
        s_e2eKey.add(SQLTRACE);
        s_e2eKey.add(TRACE);
        s_e2eKey.add(ACTION);
        s_e2eKey.add(MODULE);
        s_e2eKey.add(CLIENTID);
    }
}

