/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.LogManager;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.RID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFamily {
    public static final int ROOT = 0;
    private String m_ecid = null;
    private boolean m_new = true;
    private HashMap<String, ExecutionContext> m_ctxMap = new HashMap();
    private HashMap<ExecutionContext, Thread> m_activeCtxMap = new HashMap();
    private int m_newKids = 0;
    private long m_lastNewKidTime = 0L;
    private int m_active = 0;
    private int m_stashed = 0;
    private long m_lastStashTime = 0L;
    private long m_stopUseTime = 0L;
    private Level m_level = null;
    private HashSet<String> m_logKeys = null;
    private HashSet<String> m_propagateKeys = null;
    private static Logger s_logger = DMSContextManager.getLogger();

    private ContextFamily() {
    }

    static ContextFamily create() {
        ContextFamily ctf = new ContextFamily();
        String ecid = ContextFamily.createECID();
        if (ctf == null || ecid == null) {
            s_logger.log(Level.WARNING, "CTX-00011");
            return null;
        }
        if (ctf != null) {
            ctf.setECID(ecid);
            boolean set = DMSContextManager.registerFamily(ctf);
            if (!set) {
                s_logger.log(Level.WARNING, "CTX-00012", ecid);
                return null;
            }
            ctf.addContext(new RID());
        }
        return ctf;
    }

    static ContextFamily create(String ecid, RID rid) {
        if (ecid == null || rid == null) {
            return null;
        }
        ContextFamily ctf = new ContextFamily();
        ctf.setECID(ecid);
        boolean set = DMSContextManager.registerFamily(ctf);
        if (!set) {
            s_logger.log(Level.WARNING, "CTX-00012", ecid);
            return null;
        }
        ctf.addContext(rid);
        return ctf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContext(RID rid) {
        ExecutionContext ctx = ExecutionContext.create(this, rid);
        if (ctx == null) {
            s_logger.log(Level.WARNING, "CTX-00013");
        }
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            this.m_ctxMap.put(rid.toString(), ctx);
        }
        this.resetStopUseTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContext(ExecutionContext ctx) {
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            this.m_ctxMap.put(ctx.getRID().toString(), ctx);
        }
        this.incrNewKids();
    }

    private synchronized void setECID(String ecid) {
        this.m_ecid = ecid;
    }

    public synchronized String getECID() {
        return this.m_ecid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionContext getExecutionContext(RID rid) {
        ExecutionContext ctx = null;
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            ctx = this.m_ctxMap.get(rid.toString());
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionContext getExecutionContext(String ridStr) {
        if (ridStr == null) {
            return null;
        }
        ExecutionContext ctx = null;
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            ctx = this.m_ctxMap.get(ridStr);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActive(ExecutionContext ctx) {
        if (ctx == null) {
            return;
        }
        String ecid = ctx.getECID();
        if (!ecid.equals(this.getECID())) {
            return;
        }
        HashMap<ExecutionContext, Thread> hashMap = this.m_activeCtxMap;
        synchronized (hashMap) {
            this.m_activeCtxMap.put(ctx, Thread.currentThread());
            ++this.m_active;
        }
        if (this.getStopUseTime() != 0L) {
            this.resetStopUseTime();
            DMSContextManager.registerFamily(this);
        }
        this.m_new = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void eliminate(ExecutionContext ctx) {
        if (ctx == null || ctx.isActive()) {
            return;
        }
        this.decrNewKids();
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            this.m_ctxMap.remove(ctx.getRID().toString());
        }
    }

    synchronized void incrNewKids() {
        ++this.m_newKids;
        this.m_lastNewKidTime = System.currentTimeMillis();
    }

    synchronized void decrNewKids() {
        --this.m_newKids;
    }

    private synchronized void resetStopUseTime() {
        this.m_stopUseTime = 0L;
    }

    private synchronized long getStopUseTime() {
        return this.m_stopUseTime;
    }

    private synchronized void setStopUseTime(long time) {
        this.m_stopUseTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delActive(ExecutionContext ctx) {
        if (ctx == null) {
            return;
        }
        Thread t = null;
        HashMap<ExecutionContext, Thread> hashMap = this.m_activeCtxMap;
        synchronized (hashMap) {
            t = this.m_activeCtxMap.remove(ctx);
            if (t != null) {
                --this.m_active;
            }
        }
        if (this.m_active == 0 && this.isExpired()) {
            DMSContextManager.deregisterFamily(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getActive() {
        ArrayList<ExecutionContext> deadCtxList = new ArrayList<ExecutionContext>();
        int totalSize = 0;
        HashMap<ExecutionContext, Thread> hashMap = this.m_activeCtxMap;
        synchronized (hashMap) {
            Set<ExecutionContext> keys = this.m_activeCtxMap.keySet();
            for (ExecutionContext ctx : keys) {
                Thread t = this.m_activeCtxMap.get(ctx);
                Thread.State state = t.getState();
                if (state != Thread.State.TERMINATED) continue;
                deadCtxList.add(ctx);
            }
            totalSize = this.m_activeCtxMap.size();
        }
        int active = totalSize - deadCtxList.size();
        for (ExecutionContext ctx : deadCtxList) {
            ctx.deactivate();
        }
        return active;
    }

    synchronized int getNewKids() {
        return this.m_newKids;
    }

    private synchronized long getLastNewKidTime() {
        return this.m_lastNewKidTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCount() {
        int size = 0;
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            size = this.m_ctxMap.size();
        }
        return size;
    }

    synchronized void incrementStashed() {
        ++this.m_stashed;
        this.m_lastStashTime = System.currentTimeMillis();
    }

    synchronized void decrementStashed() {
        --this.m_stashed;
    }

    private synchronized int getStashedCount() {
        return this.m_stashed;
    }

    private synchronized long getLastStashedTime() {
        return this.m_lastStashTime;
    }

    private static String createECID() {
        return LogManager.getLogManager().getUniqueId();
    }

    boolean isExpired() {
        int count;
        if (this.m_new) {
            return false;
        }
        long now = System.currentTimeMillis();
        long minLife = DMSContextManager.getMinLife();
        long stop = this.getStopUseTime();
        if (stop > 0L) {
            return now - stop > minLife;
        }
        if (this.getActive() > 0) {
            return false;
        }
        int newKids = this.getNewKids();
        int stashedCount = this.getStashedCount();
        if (stashedCount == 0 && newKids == 0) {
            this.setStopUseTime(now);
            return minLife <= 0L;
        }
        long maxSaveTime = DMSContextManager.getMaxStashMillis();
        if (stashedCount > 0 && now - this.getLastStashedTime() <= maxSaveTime) {
            return false;
        }
        boolean waitOneRound = false;
        if (newKids > 0 && this.getStopUseTime() == 0L) {
            waitOneRound = true;
        }
        if (stashedCount > 0 && (count = DMSContextManager.removeFromStash(this.getECID(), stashedCount)) != stashedCount) {
            return false;
        }
        this.setStopUseTime(now);
        return minLife <= 0L && !waitOneRound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, ExecutionContext> getContexts() {
        HashMap<String, ExecutionContext> map = new HashMap<String, ExecutionContext>();
        Collection<ExecutionContext> values = null;
        HashMap<String, ExecutionContext> hashMap = this.m_ctxMap;
        synchronized (hashMap) {
            values = this.m_ctxMap.values();
        }
        for (ExecutionContext ctx : values) {
            String RID2 = ctx.getRIDasString();
            map.put(RID2, ctx);
        }
        return map;
    }

    synchronized void setLogLevel(Level level) {
        if (this.m_level == null && level != null) {
            DMSContextManager.incrementLevels();
        }
        if (this.m_level != null && level == null) {
            DMSContextManager.decrementLevels();
        }
        this.m_level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Level getLogLevel() {
        ContextFamily contextFamily = this;
        synchronized (contextFamily) {
            return this.m_level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLogKey(String key) {
        if (key == null) {
            return;
        }
        if (DMSContextManager.s_logKeys.contains(key)) {
            return;
        }
        ContextFamily contextFamily = this;
        synchronized (contextFamily) {
            if (this.m_logKeys == null) {
                this.m_logKeys = new HashSet();
            }
            this.m_logKeys.add(key);
        }
    }

    HashSet<String> getLogKeys() {
        return this.m_logKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPropagateKey(String key) {
        if (key == null) {
            return;
        }
        if (DMSContextManager.s_propagateKeys.contains(key)) {
            return;
        }
        ContextFamily contextFamily = this;
        synchronized (contextFamily) {
            if (this.m_propagateKeys == null) {
                this.m_propagateKeys = new HashSet();
            }
            this.m_propagateKeys.add(key.intern());
        }
    }

    HashSet<String> getPropagateKeys() {
        return this.m_propagateKeys;
    }
}

