/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import java.util.HashMap;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockState;

public class ClockManager {
    public static boolean DEBUG = false;
    private static HashMap _clocks = new HashMap();
    private static Clock _primary = null;
    public static final String DEFAULT = "default";
    public static final String LOGICAL = "logical";
    public static final String HIGHRES = "highres";
    private static HashMap _clockmap = new HashMap();
    public static final long TICKS = 1L;
    public static final long MSECS = 1000L;
    public static final long USECS = 1000000L;
    public static final long NSECS = 1000000000L;
    private static HashMap _unitmap;

    public static synchronized void shutdown() {
        _clocks.clear();
        _primary = null;
        ClockState.shutdown();
    }

    public static Clock getClock() {
        if (_primary == null) {
            Clock clock;
            _primary = clock = ClockManager.createClock(DEFAULT);
        }
        return _primary;
    }

    public static Clock createClock(String cname) {
        Clock clock;
        if (DEBUG) {
            System.out.println("Checking if clock (" + cname + ") is loaded");
        }
        String clazzname = null;
        if (cname.equalsIgnoreCase(HIGHRES) && !ClockManager.validHighRes()) {
            cname = DEFAULT;
        }
        if ((clock = (Clock)_clocks.get(cname)) != null) {
            return clock;
        }
        clazzname = (String)_clockmap.get(cname);
        if (DEBUG) {
            System.out.println("The class name for (" + cname + ") is " + clazzname);
        }
        if (clazzname == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzname);
            if (DEBUG) {
                System.out.println("Called Class.forName(\"" + clazzname + "\")");
            }
            clock = (Clock)clazz.newInstance();
            if (DEBUG) {
                System.out.println("Created a new instance of " + clazzname);
            }
            _clocks.put(cname.toLowerCase(), clock);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Can't find or load class " + clazzname);
            return null;
        }
        return clock;
    }

    public static long getFrequency(String units) {
        Long Lunits;
        if (units != null && (Lunits = (Long)_unitmap.get(units.toLowerCase())) != null) {
            return Lunits;
        }
        return ClockManager.getClock().getReportedFrequency();
    }

    public static String getUnits(long freq) {
        String units = (String)_unitmap.get(new Long(freq));
        if (units != null) {
            return units;
        }
        return ClockManager.getClock().getUnits();
    }

    public static Clock setClock(String cname) {
        Clock clock = ClockManager.createClock(cname);
        if (clock != null) {
            _primary = clock;
        } else {
            clock = ClockManager.getClock();
        }
        return clock;
    }

    private static boolean validHighRes() {
        try {
            System.loadLibrary("dms2");
            if (DEBUG) {
                System.err.println("Loaded dms2 lib");
            }
            return true;
        }
        catch (Throwable e) {
            try {
                System.loadLibrary("yod");
                if (DEBUG) {
                    System.err.println("Loaded yod lib");
                }
                return true;
            }
            catch (Throwable ee) {
                if (DEBUG) {
                    System.err.println("Couldn't load lib for high resolution clock, using default clock instead.");
                }
                return false;
            }
        }
    }

    static {
        _clockmap.put(DEFAULT, "oracle.dms.clock.SimpleClock");
        _clockmap.put(LOGICAL, "oracle.dms.clock.LogicalClock");
        _clockmap.put(HIGHRES, "oracle.dms.clock.HighResolutionClock");
        _unitmap = new HashMap();
        _unitmap.put("ticks", new Long(1L));
        _unitmap.put("msecs", new Long(1000L));
        _unitmap.put("usecs", new Long(1000000L));
        _unitmap.put("nsecs", new Long(1000000000L));
        _unitmap.put(new Long(1L), "ticks");
        _unitmap.put(new Long(1000L), "msecs");
        _unitmap.put(new Long(1000000L), "usecs");
        _unitmap.put(new Long(1000000000L), "nsecs");
    }
}

