/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.management;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.impl.incident.IncidentImpl;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentCreationEvent;
import oracle.dfw.incident.IncidentDump;
import oracle.dfw.incident.IncidentException;
import oracle.dfw.management.IncidentFilePurger;
import oracle.dfw.management.IncidentManagementException;
import oracle.dfw.management.IncidentSummary;
import oracle.dfw.management.PurgeIncidentFileAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncidentManager
implements DiagnosticsListener {
    private Map<String, IncidentSummary> m_incidentSummaries = Collections.synchronizedMap(new HashMap());
    private String m_oracleInstancePath;
    private String m_incidentRootPath;
    private Logger m_logger;
    private IncidentFilePurger m_incidentFilePurger;
    private DiagnosticsConfiguration m_config;
    private static final String INCIDENT_FILENAME = "incident.xml";
    private static final String IGNORE_DIR = "package";
    private static final String INCIDENT_SUB_PATH = "diagnostics" + File.separatorChar + "incidents";
    private static final String INCIDENT_FILE = "incident.xml";

    public IncidentManager(String oracleInstancePath, DiagnosticsConfiguration config) throws IncidentManagementException {
        if (oracleInstancePath == null || oracleInstancePath.length() == 0 || config == null) {
            throw new IllegalArgumentException("Invalid arguments oracleInstancePath=" + oracleInstancePath + " config=" + config);
        }
        this.m_logger = LoggerFactory.getFrameworkLogger();
        this.m_config = config;
        String incidentRootPath = oracleInstancePath + File.separatorChar + INCIDENT_SUB_PATH;
        File checkPath = new File(incidentRootPath);
        try {
            if (!checkPath.exists() && !checkPath.mkdirs()) {
                this.m_logger.log(Level.WARNING, "MAS-40359", incidentRootPath);
                throw new IncidentManagementException("40359", incidentRootPath);
            }
            this.m_incidentRootPath = incidentRootPath;
        }
        catch (SecurityException e) {
            this.m_logger.log(Level.WARNING, "MAS-40359", incidentRootPath);
            throw new IncidentManagementException("40359", incidentRootPath, e);
        }
        this.m_oracleInstancePath = oracleInstancePath;
        DiagnosticsEventManager.registerListener(this);
    }

    public void setIncidentFilePurger(IncidentFilePurger incidentFilePurger) {
        this.m_incidentFilePurger = incidentFilePurger;
    }

    public Collection<IncidentSummary> getIncidentSummaries() {
        this.loadIncidentSummaries();
        ArrayList<IncidentSummary> result = new ArrayList<IncidentSummary>();
        result.addAll(this.m_incidentSummaries.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Incident getIncident(String incidentId) throws IncidentException, IncidentManagementException {
        if (incidentId == null) {
            return null;
        }
        IncidentSummary summary = null;
        for (IncidentSummary summaryIncident : this.getIncidentSummaries()) {
            if (!summaryIncident.getIncidentId().equals(incidentId)) continue;
            summary = summaryIncident;
            break;
        }
        if (summary == null) {
            return null;
        }
        String fullPath = this.m_incidentRootPath + File.separatorChar + incidentId + File.separatorChar + "incident.xml";
        FileReader reader = null;
        IncidentImpl incident = null;
        try {
            reader = new FileReader(fullPath);
            incident = new IncidentImpl(reader);
        }
        catch (IOException e) {
            this.m_logger.log(Level.WARNING, "MAS-40374", fullPath);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return incident;
    }

    public boolean purgeIncident(String incidentId) throws IncidentManagementException, IncidentException {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, "Received request to purge incident " + incidentId);
        }
        if (this.m_incidentFilePurger == null) {
            throw new IncidentManagementException("40382", incidentId);
        }
        IncidentImpl purgeIncident = (IncidentImpl)this.getIncident(incidentId);
        if (purgeIncident == null) {
            throw new IncidentManagementException("40386", incidentId);
        }
        boolean deleteLocalIncidentFiles = true;
        List<PurgeIncidentFileAction> dumps = this.buildDumpFilePurgeList(purgeIncident);
        if (dumps != null && dumps.size() > 0) {
            try {
                this.m_incidentFilePurger.purgeIncidentFiles(dumps);
                for (PurgeIncidentFileAction fileAction : dumps) {
                    if (fileAction.getStatus() != null && fileAction.getStatus().equals((Object)PurgeIncidentFileAction.FileStatus.FILE_PURGED)) {
                        for (IncidentDump incidentDump : fileAction.getIncidentDumps()) {
                            purgeIncident.removeIncidentDump(incidentDump);
                        }
                        continue;
                    }
                    deleteLocalIncidentFiles = false;
                }
            }
            catch (IncidentManagementException e) {
                deleteLocalIncidentFiles = false;
                this.m_logger.log(Level.INFO, "MAS-40383", e);
            }
        }
        boolean incidentDeleted = false;
        if (deleteLocalIncidentFiles) {
            boolean errorDeletingFile = false;
            String incidentDirPath = this.m_incidentRootPath + File.separatorChar + incidentId;
            File incidentDir = new File(incidentDirPath);
            if (incidentDir.isDirectory()) {
                File[] incidentFiles;
                for (File incidentFile : incidentFiles = incidentDir.listFiles()) {
                    if (incidentFile.isFile()) {
                        if (incidentFile.delete()) continue;
                        errorDeletingFile = true;
                        break;
                    }
                    errorDeletingFile = true;
                    break;
                }
                if (!errorDeletingFile) {
                    incidentDir.delete();
                    incidentDeleted = true;
                }
            }
        }
        if (!incidentDeleted) {
            purgeIncident.setStatus(Incident.IncidentStatus.PURGE);
            this.persistIncident(purgeIncident);
            this.m_logger.log(Level.INFO, "MAS-40385", incidentId);
        } else {
            this.m_incidentSummaries.remove(incidentId);
            this.m_logger.log(Level.INFO, "MAS-40384", incidentId);
        }
        return incidentDeleted;
    }

    private List<PurgeIncidentFileAction> buildDumpFilePurgeList(Incident incident) {
        HashMap filesByInstance = new HashMap();
        for (IncidentDump dump : incident.getIncidentDumps()) {
            PurgeIncidentFileAction action;
            HashMap<String, PurgeIncidentFileAction> files = (HashMap<String, PurgeIncidentFileAction>)filesByInstance.get(dump.getOracleInstanceId());
            if (files == null) {
                action = new PurgeIncidentFileAction(incident.getIncidentId(), dump.getDumpPath(), dump.getOracleInstanceId());
                action.addIncidentDump(dump);
                files = new HashMap<String, PurgeIncidentFileAction>();
                files.put(dump.getDumpPath(), action);
                filesByInstance.put(dump.getOracleInstanceId(), files);
                continue;
            }
            if (!files.containsKey(dump.getDumpPath())) {
                action = new PurgeIncidentFileAction(incident.getIncidentId(), dump.getDumpPath(), dump.getOracleInstanceId());
                action.addIncidentDump(dump);
                files.put(dump.getDumpPath(), action);
                continue;
            }
            action = (PurgeIncidentFileAction)files.get(dump.getDumpPath());
            action.addIncidentDump(dump);
        }
        ArrayList<PurgeIncidentFileAction> filesToPurge = new ArrayList<PurgeIncidentFileAction>();
        for (HashMap instanceFiles : filesByInstance.values()) {
            filesToPurge.addAll(instanceFiles.values());
        }
        return filesToPurge;
    }

    private void persistIncident(Incident incident) throws IncidentManagementException {
        String xml;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, "Persisting incident " + incident.getIncidentId());
        }
        if ((xml = incident.toXML()) == null) {
            throw new IncidentManagementException("40364");
        }
        String incidentDirectory = this.m_incidentRootPath + File.separatorChar + incident.getIncidentId();
        File incidentFile = new File(incidentDirectory);
        String filePath = incidentDirectory + File.separatorChar + "incident.xml";
        try {
            PrintWriter pw = new PrintWriter(filePath);
            pw.print(xml);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "MAS-40366", filePath);
            throw new IncidentManagementException("40366", filePath, e);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, "Persisted incident " + incident.getIncidentId() + " to file " + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIncidentSummaries() {
        Map<String, IncidentSummary> map = this.m_incidentSummaries;
        synchronized (map) {
            File rootIncidentDir = new File(this.m_incidentRootPath);
            File[] subDirs = rootIncidentDir.listFiles();
            int len = subDirs.length;
            for (int i = 0; i < len; ++i) {
                File[] incidentFiles;
                if (!subDirs[i].isDirectory() || subDirs[i].getName().equalsIgnoreCase(IGNORE_DIR) || this.m_incidentSummaries.containsKey(subDirs[i].getName()) || (incidentFiles = subDirs[i].listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().compareTo("incident.xml") == 0;
                    }
                })) == null || incidentFiles.length != 1) continue;
                FileReader reader = null;
                try {
                    reader = new FileReader(incidentFiles[0]);
                    IncidentImpl incident = new IncidentImpl(reader);
                    this.m_incidentSummaries.put(incident.getIncidentId(), new IncidentSummary(incident));
                    continue;
                }
                catch (Exception e) {
                    this.m_logger.log(Level.WARNING, "MAS-40374", incidentFiles[0].getPath());
                    continue;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof IncidentCreationEvent) {
            Incident incident = ((IncidentCreationEvent)event).getIncident();
            this.m_incidentSummaries.put(incident.getIncidentId(), new IncidentSummary(incident));
        } else if (event instanceof DiagnosticsConfigurationChangedEvent) {
            // empty if block
        }
    }

    @Override
    public Class<DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{IncidentCreationEvent.class, DiagnosticsConfigurationChangedEvent.class};
    }
}

