/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.util.List;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.IncidentDump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Incident {
    public String getIncidentId();

    public long getTimeOfIncident();

    public List<DiagnosticsCategory> getProblemImpacts();

    public String getExecutionContextId();

    public IncidentSource getIncidentSource();

    public ErrorMessage getErrorMessage();

    public String getDescription();

    public String getProblemKey();

    public IncidentStatus getStatus();

    public List<IncidentDump> getIncidentDumps();

    public String toXML();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncidentStatus {
        CREATED,
        FLOOD_CONTROLLED,
        PURGE;


        public static IncidentStatus getIncidentStatus(String status) {
            try {
                return IncidentStatus.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncidentSource {
        SYSTEM,
        MANUAL;


        public static IncidentSource getIncidentSource(String source) {
            try {
                return IncidentSource.valueOf(source.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

