/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import oracle.as.management.translation.NLSupport;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextDump
extends ComponentDiagnosticDump {
    private String m_description;
    private static final String ECID_ARG = "ecid";
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();

    public ExecutionContextDump() {
        NLSupport nls = NLSupport.getNLSupport(DFW_MESSAGES, this.getClass().getClassLoader());
        this.m_description = nls.getTranslation("DFW_ECIDCTX_DESCRIPTION");
        this.defineArgument(ECID_ARG, ArgumentType.STRING, false, nls.getTranslation("DFW_ECIDCTX_ECID_ARG"));
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException {
        DumpWriter dw = new DumpWriter(context);
        String ecid = context.getArguments().getString(ECID_ARG);
        if (ecid != null && ecid.length() > 0) {
            this.dumpExecutionContext(ecid, dw);
        } else {
            String[] ecids = DMSContextManager.getEcids();
            if (ecids != null) {
                for (String e : ecids) {
                    this.dumpExecutionContext(e, dw);
                }
            }
        }
        return dw.getDumpResult();
    }

    @Override
    public String getName() {
        return "ecidctx";
    }

    @Override
    public String getOwner() {
        return "mas";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.PERFORMANCE);
    }

    @Override
    public String getDumpDescription() {
        return this.m_description;
    }

    private void dumpExecutionContext(String ecid, DumpWriter dw) {
        HashMap<String, ExecutionContext> map = DMSContextManager.getContexts(ecid);
        if (map != null) {
            for (Map.Entry<String, ExecutionContext> entry : map.entrySet()) {
                dw.dumpln(entry.getValue().dump(0));
                dw.dumpln();
            }
        }
    }
}

