/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.config;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.config.DiagnosticsConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DiagnosticsConfiguration {
    private boolean m_incidentPurgeEnabled = false;
    private int m_incidentPurgeFrequency = 24;
    private int m_incidentPurgeAge = 30;
    private boolean m_logDetectionEnabled = true;
    private boolean m_floodControlEnabled = false;
    private int m_floodControlIncidentCount = 3;
    private int m_floodControlIncidentTimePeriod = 15;
    private DocumentBuilderFactory m_schemaFactory = DocumentBuilderFactory.newInstance();
    private static final String SCHEMA_FILE = "/oracle/dfw/config/diagnostic_config.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public DiagnosticsConfiguration() throws DiagnosticsConfigurationException {
        this.m_schemaFactory.setNamespaceAware(true);
        this.m_schemaFactory.setValidating(true);
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        URL defaultSchema = this.getClass().getResource(SCHEMA_FILE);
        if (defaultSchema == null) {
            throw new DiagnosticsConfigurationException("40387", SCHEMA_FILE);
        }
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
    }

    public synchronized void parseDiagnosticsConfiguration(InputStream confStream) throws DiagnosticsConfigurationException {
        Document document = null;
        try {
            DocumentBuilder parser = this.m_schemaFactory.newDocumentBuilder();
            document = parser.parse(confStream);
        }
        catch (Exception e) {
            throw new DiagnosticsConfigurationException("40388", e);
        }
        if (document == null) {
            throw new DiagnosticsConfigurationException("40388");
        }
        Element config = document.getDocumentElement();
        if (config == null) {
            throw new DiagnosticsConfigurationException("40388");
        }
        NodeList nodes = config.getElementsByTagName("incidentCleanup");
        Element incidentCleanup = (Element)nodes.item(0);
        this.m_incidentPurgeEnabled = Boolean.parseBoolean(incidentCleanup.getAttribute("incidentPurgeEnabled"));
        this.m_incidentPurgeFrequency = Integer.parseInt(incidentCleanup.getAttribute("incidentPurgeFrequency"));
        this.m_incidentPurgeAge = Integer.parseInt(incidentCleanup.getAttribute("incidentPurgeAge"));
        nodes = config.getElementsByTagName("incidentCreation");
        Element incidentCreation = (Element)nodes.item(0);
        this.m_logDetectionEnabled = Boolean.parseBoolean(incidentCreation.getAttribute("logDetectionEnabled"));
        this.m_floodControlEnabled = Boolean.parseBoolean(incidentCreation.getAttribute("floodControlEnabled"));
        this.m_floodControlIncidentCount = Integer.parseInt(incidentCreation.getAttribute("floodControlIncidentCount"));
        this.m_floodControlIncidentTimePeriod = Integer.parseInt(incidentCreation.getAttribute("floodControlIncidentTimePeriod"));
        DiagnosticsEventManager.notifyListeners(new DiagnosticsConfigurationChangedEvent(this));
    }

    public boolean isIncidentPurgeEnabled() {
        return this.m_incidentPurgeEnabled;
    }

    public int getIncidentPurgeFrequency() {
        return this.m_incidentPurgeFrequency;
    }

    public int getIncidentPurgeAge() {
        return this.m_incidentPurgeAge;
    }

    public boolean isLogDetectionEnabled() {
        return this.m_logDetectionEnabled;
    }

    public boolean isFloodControlEnabled() {
        return this.m_floodControlEnabled;
    }

    public int getFloodControlIncidentCount() {
        return this.m_floodControlIncidentCount;
    }

    public int getFloodControlIncidentTimePeriod() {
        return this.m_floodControlIncidentTimePeriod;
    }
}

