/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.query;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.core.ojdl.query.Condition;
import oracle.core.ojdl.reader.LogRecord;

public class OrCondition
extends Condition {
    private Condition m_c1;
    private Condition m_c2;
    private static String[] s_itemNames = new String[]{"type", "condition_1", "condition_2"};

    public OrCondition(Condition c1, Condition c2) {
        this.m_c1 = c1;
        this.m_c2 = c2;
    }

    public Condition[] getConditions() {
        return new Condition[]{this.m_c1, this.m_c2};
    }

    void toSql(StringBuffer buf) {
        buf.append("(");
        this.m_c1.toSql(buf);
        buf.append(" or ");
        this.m_c2.toSql(buf);
        buf.append(")");
    }

    boolean eval(LogRecord rec) {
        return this.m_c1.eval(rec) || this.m_c2.eval(rec);
    }

    public static CompositeType toCompositeType() throws OpenDataException {
        return Condition.toCompositeType();
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (!OrCondition.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException();
        }
        CompositeData cd1 = this.m_c1.toCompositeData(ct);
        CompositeData cd2 = this.m_c2.toCompositeData(ct);
        CompositeType effectiveType = new CompositeType(OrCondition.toCompositeType().getTypeName(), OrCondition.toCompositeType().getDescription(), s_itemNames, s_itemNames, new OpenType[]{SimpleType.STRING, cd1.getCompositeType(), cd2.getCompositeType()});
        return new CompositeDataSupport(effectiveType, s_itemNames, new Object[]{"OrCondition", cd1, cd2});
    }

    public static Condition from(CompositeData cd) throws OpenDataException {
        if (!"OrCondition".equals(cd.get("type"))) {
            throw new IllegalArgumentException();
        }
        CompositeData cd1 = (CompositeData)cd.get("condition_1");
        CompositeData cd2 = (CompositeData)cd.get("condition_2");
        return new OrCondition(Condition.from(cd1), Condition.from(cd2));
    }
}

