/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.XMLFormatter;
import oracle.core.ojdl.logging.MessageIdKeyResourceBundle;
import oracle.core.ojdl.logging.MessageIdResourceBundle;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.dms.context.ExecutionContext;

public class ODLFormatter
extends Formatter {
    public static final String ODL_XML = "ODL-XML";
    public static final String ODL10_XML = "ODL10-XML";
    public static final String ODL_TEXT = "ODL-Text";
    private LogFormatter m_logFormatter;
    private String[] m_supplAttributes = null;
    private boolean m_useDefaultAttributes = true;
    private Level m_useSrcClassAndMethodLevel = Level.FINE;
    private boolean m_includeMsgArgs = true;
    private Locale m_locale = null;
    private WeakHashMap m_bundles = new WeakHashMap();
    private static final Object MSG_ID_KEY_BUNDLE = new Object();
    private static final Object MSG_ID_SUFFIX_BUNDLE = new Object();
    private static final Object UNMARKED_BUNDLE = new Object();
    private static final String MSG_ID_SUFFIX_MARKER = "oracle.core.ojdl.logging.MessageIdSuffixResourceBundle";
    private static final String MSG_ID_KEY_MARKER = "oracle.core.ojdl.logging.MessageIdKeyResourceBundle";
    private static final String MARKER_FIELD = "ORACLE_LOGGING_MSG_ID_KEY_BUNDLE";
    private static final String MSG_ID_SUFFIX = ".MSGID";

    public ODLFormatter() {
        this(new ODL11Formatter());
    }

    public ODLFormatter(String format) {
        if (format.equalsIgnoreCase(ODL_XML)) {
            this.m_logFormatter = new ODL11Formatter();
        } else if (format.equalsIgnoreCase(ODL10_XML)) {
            this.m_logFormatter = new XMLFormatter();
        } else if (format.equalsIgnoreCase(ODL_TEXT)) {
            this.m_logFormatter = new ODLTextFormatter();
            this.setUseDefaultAttributes(false);
        } else {
            throw new IllegalArgumentException("format: " + format);
        }
    }

    ODLFormatter(LogFormatter logFormatter) {
        this.m_logFormatter = logFormatter;
    }

    public String format(LogRecord rec) {
        return this.m_logFormatter.format(this.toLogMessage(rec));
    }

    public String getHead(Handler h) {
        String header = this.m_logFormatter.header();
        return header != null ? header : "";
    }

    public String getTail(Handler h) {
        String tail = this.m_logFormatter.tail();
        return tail != null ? tail : "";
    }

    LogMessage toLogMessage(LogRecord rec) {
        Level level;
        Throwable t;
        String msgText;
        boolean isContextLogger;
        ExecutionContext ctx;
        String moduleId;
        String componentId;
        String orgId;
        int i;
        String name = rec.getLoggerName();
        if (name == null) {
            name = "";
        }
        if ((i = name.indexOf(46)) >= 0) {
            orgId = name.substring(0, i);
            int j = name.indexOf(46, i + 1);
            if (j >= 0) {
                componentId = name.substring(i + 1, j);
                moduleId = name.substring(j + 1);
            } else {
                componentId = name.substring(i + 1);
                moduleId = null;
            }
        } else {
            orgId = null;
            componentId = name;
            moduleId = null;
        }
        String upstreamId = null;
        String dwstreamId = null;
        LogMessage.InstanceId ecid = null;
        String userId = null;
        Map<String, String> supplAttrs = null;
        String appName = System.getProperty("application.name");
        if (appName != null) {
            supplAttrs = new HashMap<String, String>();
            supplAttrs.put("APP", appName);
        }
        ExecutionContext executionContext = ctx = (isContextLogger = "oracle.dms.context".equals(name)) ? null : ExecutionContext.get();
        if (ctx != null) {
            String uid = ctx.getECID();
            if (uid != null) {
                ecid = new LogMessage.InstanceId(uid, ctx.getRIDasString());
            }
            if (this.m_supplAttributes != null) {
                for (int k = 0; k < this.m_supplAttributes.length; ++k) {
                    String attrName = this.m_supplAttributes[k];
                    String attrValue = ctx.getValue(attrName);
                    if (attrValue == null) continue;
                    if (supplAttrs == null) {
                        supplAttrs = new HashMap();
                    }
                    supplAttrs.put(attrName, attrValue);
                }
            }
        }
        ResourceBundle bundle = rec.getResourceBundle();
        String s = rec.getMessage();
        String supplDet = null;
        String msgId = null;
        String detailLoc = null;
        String problemKey = null;
        String errorId = null;
        if (rec instanceof ODLLogRecord) {
            ODLLogRecord orec = (ODLLogRecord)rec;
            msgId = orec.getMessageId();
            Map map = orec.getSupplAttributes();
            if (map != null) {
                if (supplAttrs == null) {
                    supplAttrs = map;
                } else {
                    supplAttrs.putAll(map);
                }
            }
            supplDet = orec.getSupplDetail();
            detailLoc = orec.getDetailLocation();
            problemKey = orec.getProblemKey();
            errorId = orec.getErrorInstanceId();
        }
        if (bundle != null) {
            try {
                if (this.m_locale != null && !Locale.getDefault().equals(this.m_locale)) {
                    try {
                        bundle = this.getResourceBundle(rec.getResourceBundleName(), this.m_locale);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                msgText = bundle.getString(s);
                if (msgId == null) {
                    msgId = this.getMessageId(bundle, s);
                }
            }
            catch (Exception e) {
                msgText = s;
            }
        } else {
            msgText = s;
        }
        Object[] args = rec.getParameters();
        LogMessage.MessageArgument[] msgArgs = null;
        if (args != null && args.length > 0) {
            if (msgText != null && msgText.indexOf("{") >= 0) {
                try {
                    msgText = MessageFormat.format(msgText, args);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.m_includeMsgArgs && msgId != null) {
                msgArgs = new LogMessage.MessageArgument[args.length];
                for (int k = 0; k < args.length; ++k) {
                    String v = args[k] != null ? args[k].toString() : null;
                    msgArgs[k] = new LogMessage.MessageArgument(null, v);
                }
            }
        }
        if ((t = rec.getThrown()) != null) {
            supplDet = this.writeStackTrace(t);
        }
        if ((level = rec.getLevel()).intValue() <= this.m_useSrcClassAndMethodLevel.intValue()) {
            String srcMethod;
            String srcClass = rec.getSourceClassName();
            if (srcClass != null) {
                if (supplAttrs == null) {
                    supplAttrs = new HashMap();
                }
                supplAttrs.put("SRC_CLASS", srcClass);
            }
            if ((srcMethod = rec.getSourceMethodName()) != null) {
                if (supplAttrs == null) {
                    supplAttrs = new HashMap();
                }
                supplAttrs.put("SRC_METHOD", srcMethod);
            }
        }
        MessageType msgType = MessageType.UNKNOWN;
        int[] arbLevel = new int[]{16};
        if (level != null) {
            msgType = ODLLevel.getMsgTypeAndLevel(rec.getLevel(), arbLevel);
        }
        LogMessage.InstanceId eid = null;
        if (errorId != null) {
            eid = new LogMessage.InstanceId(errorId, null);
        }
        LogMessage msg = new LogMessage(null, componentId, msgId, null, msgType, null, arbLevel[0], moduleId, null, userId, upstreamId, dwstreamId, ecid, eid, msgText, msgArgs, detailLoc, supplDet);
        msg.setTimestamp(rec.getMillis());
        msg.setThreadId(String.valueOf(rec.getThreadID()));
        if (supplAttrs != null) {
            msg.setSupplAttrs(supplAttrs);
        }
        if (problemKey != null) {
            msg.setProblemKey(problemKey);
        }
        if (!this.m_useDefaultAttributes) {
            msg.setHostId(null);
            msg.setHostNwAddr(null);
            msg.setUserId(userId);
        }
        return msg;
    }

    public void setSupplementalAttributes(String[] attrNames) {
        if (attrNames != null) {
            for (int i = 0; i < attrNames.length; ++i) {
                attrNames[i] = attrNames[i].intern();
            }
        }
        this.m_supplAttributes = attrNames;
    }

    public String[] getSupplementalAttributes() {
        return this.m_supplAttributes;
    }

    public void setUseSourceClassAndMethod(boolean useSrcClassAndMethod) {
        this.setUseSourceClassAndMethod(useSrcClassAndMethod ? Level.OFF : Level.ALL);
    }

    public boolean getUseSourceClassAndMethod() {
        return this.m_useSrcClassAndMethodLevel == Level.OFF;
    }

    public void setUseSourceClassAndMethod(Level level) {
        this.m_useSrcClassAndMethodLevel = level;
    }

    public Level getUseSourceClassAndMethodLevel() {
        return this.m_useSrcClassAndMethodLevel;
    }

    public void setUseDefaultAttributes(boolean useDefaultAttributes) {
        this.m_useDefaultAttributes = useDefaultAttributes;
    }

    public boolean getUseDefaultAttributes() {
        return this.m_useDefaultAttributes;
    }

    public void setIncludeMessageArguments(boolean includeMessageArguments) {
        this.m_includeMsgArgs = includeMessageArguments;
    }

    public boolean getIncludeMessageArguments() {
        return this.m_includeMsgArgs;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    private final String writeStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessageId(ResourceBundle bundle, String key) {
        Object bt;
        if (bundle instanceof MessageIdKeyResourceBundle) {
            return key;
        }
        if (bundle instanceof MessageIdResourceBundle) {
            try {
                return ((MessageIdResourceBundle)((Object)bundle)).getMessageId(key);
            }
            catch (Exception e1) {
                return null;
            }
        }
        WeakHashMap weakHashMap = this.m_bundles;
        synchronized (weakHashMap) {
            bt = this.m_bundles.get(bundle);
            if (bt == null) {
                try {
                    bundle.getString(MSG_ID_KEY_MARKER);
                    bt = MSG_ID_KEY_BUNDLE;
                }
                catch (Exception e1) {
                    try {
                        bundle.getString(MSG_ID_SUFFIX_MARKER);
                        bt = MSG_ID_SUFFIX_BUNDLE;
                    }
                    catch (Exception e2) {
                        Class<?> cl = bundle.getClass();
                        try {
                            cl.getDeclaredField(MARKER_FIELD);
                            bt = MSG_ID_KEY_BUNDLE;
                        }
                        catch (NoSuchFieldException e3) {
                            bt = UNMARKED_BUNDLE;
                        }
                    }
                    this.m_bundles.put(bundle, bt);
                }
            }
        }
        if (bt == MSG_ID_KEY_BUNDLE) {
            return key;
        }
        if (bt == MSG_ID_SUFFIX_BUNDLE) {
            try {
                return bundle.getString(key + MSG_ID_SUFFIX);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private ResourceBundle getResourceBundle(String resourceBundleName, Locale locale) throws MissingResourceException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(resourceBundleName, locale, cl);
    }
}

