/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LogWriterException;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.ODL11Formatter;

public abstract class BufferedLogWriter
extends LogWriter {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final String BUFFER_SIZE_PROP = "BufferSize";
    private static final String FLUSH_INTERVAL_PROP = "FlushInterval";
    private LogFormatter m_formatter;
    private int m_bufferSize;
    private int m_bufferPos;
    private byte[] m_buffer;
    private long m_flushInterval = 5000L;
    private Thread m_flusher;
    private String m_encoding;
    private long m_msgLogged;
    private long m_numBytes;
    private long m_writes;
    private long m_numFlushes;
    private long m_numBytesFlushed;
    private Object m_lock = new Object();
    private volatile boolean m_stopFlusher = false;

    protected BufferedLogWriter() {
        this(LogManager.getLogManager().getEncoding());
    }

    protected BufferedLogWriter(String encoding) {
        this(new ODL11Formatter(), encoding);
    }

    protected BufferedLogWriter(LogFormatter formatter, String encoding) {
        this.m_formatter = formatter;
        this.m_encoding = encoding;
        int bufferSize = BufferedLogWriter.getIntConfiguration(BUFFER_SIZE_PROP);
        this.m_bufferSize = bufferSize >= 0 ? bufferSize : 32768;
        this.m_buffer = new byte[this.m_bufferSize];
        this.m_bufferPos = 0;
        int flushInt = BufferedLogWriter.getIntConfiguration(FLUSH_INTERVAL_PROP);
        if (flushInt >= 0) {
            this.m_flushInterval = flushInt;
        }
        if (this.m_flushInterval > 0L) {
            this.m_flusher = new Flusher();
            this.m_flusher.setName("LogFlusher");
            this.m_flusher.setDaemon(true);
            this.m_flusher.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.isOpened()) {
                this.handleException(new LoggingException("Attempt to close an already closed LogWriter"));
                return;
            }
            this.flush();
            this.m_buffer = null;
            this.m_formatter = null;
            this.debug("Messages logged = " + this.m_msgLogged);
            this.debug("Bytes written = " + this.m_numBytes);
            this.debug("Writes = " + this.m_writes);
            this.debug("Flusher: " + this.m_numFlushes + ", " + this.m_numBytesFlushed);
        }
        if (this.m_flusher != null) {
            this.stopFlusher();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.isOpened()) {
                this.handleException(new LoggingException("Attempt to flush a closed LogWriter"));
                return;
            }
            if (this.m_bufferPos > 0) {
                this.writeBytes(this.m_buffer, 0, this.m_bufferPos);
                this.m_bufferPos = 0;
                ++this.m_writes;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogMessage message) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.isOpened()) {
                this.handleException(new LoggingException("Attempt to write to a closed LogWriter"));
                return;
            }
            if (message.getTimestamp() == 0L) {
                message.setTimestamp(System.currentTimeMillis());
            }
            this.writeToBuffer(this.m_formatter.format(message));
            ++this.m_msgLogged;
        }
    }

    private boolean isOpened() {
        return this.m_formatter != null;
    }

    protected abstract void writeBytes(byte[] var1, int var2, int var3);

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String encoding) throws LogWriterException {
        if (this.m_numBytes > 0L) {
            return;
        }
        String enc = LogManager.checkEncoding(encoding);
        if (enc == null) {
            throw new LogWriterException("Invalid encoding: " + encoding);
        }
        this.m_encoding = enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.isOpened()) {
                this.handleException(new LoggingException("Attempt to operate on a closed LogWriter"));
                return;
            }
            if (size < 0) {
                return;
            }
            this.flush();
            this.m_bufferSize = size;
            this.m_buffer = new byte[this.m_bufferSize];
        }
    }

    public int getBufferSize() {
        return this.m_buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushInterval(long interval) {
        boolean stopFlusherThread = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.isOpened()) {
                this.handleException(new LoggingException("Attempt to operate on a closed LogWriter"));
                return;
            }
            if (interval <= 0L) {
                this.m_flushInterval = 0L;
                stopFlusherThread = true;
            } else {
                this.m_flushInterval = interval;
                if (this.m_flusher == null) {
                    this.m_flusher = new Flusher();
                    this.m_flusher.setName("LogFlusher");
                    this.m_flusher.setDaemon(true);
                    this.m_stopFlusher = false;
                    this.m_flusher.start();
                }
            }
        }
        if (stopFlusherThread) {
            this.stopFlusher();
        }
    }

    public long getFlushInterval() {
        return this.m_flushInterval;
    }

    private void writeToBuffer(String data) {
        byte[] bytes;
        String enc = this.getEncoding();
        try {
            bytes = enc == null ? data.getBytes() : data.getBytes(enc);
        }
        catch (Exception e) {
            this.handleException(new LoggingException("Invalid encoding: " + enc));
            bytes = new byte[]{};
        }
        if (this.m_bufferPos + bytes.length > this.m_buffer.length) {
            this.flush();
        }
        if (bytes.length > this.m_buffer.length) {
            this.writeBytes(bytes, 0, bytes.length);
            ++this.m_writes;
        } else {
            System.arraycopy(bytes, 0, this.m_buffer, this.m_bufferPos, bytes.length);
            this.m_bufferPos += bytes.length;
        }
        this.m_numBytes += (long)bytes.length;
    }

    private void handleException(Exception exn) {
        this.getExceptionHandler().onException(exn);
    }

    void debug(String str) {
        LogManager.getLogManager().debug(str);
    }

    private static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int getIntConfiguration(String propertyName) {
        LogManager manager = LogManager.getLogManager();
        String strVal = manager.getProperty(propertyName, null);
        if (strVal != null) {
            return BufferedLogWriter.parseInt(strVal);
        }
        return -1;
    }

    private void stopFlusher() {
        if (this.m_flusher == null) {
            return;
        }
        this.m_stopFlusher = true;
        this.m_flusher.interrupt();
        try {
            this.m_flusher.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_flusher = null;
    }

    LogFormatter getFormatter() {
        return this.m_formatter;
    }

    private final class Flusher
    extends Thread {
        private Flusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!BufferedLogWriter.this.m_stopFlusher || !BufferedLogWriter.this.m_flusher.isInterrupted()) {
                try {
                    Thread.sleep(BufferedLogWriter.this.m_flushInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (BufferedLogWriter.this.m_stopFlusher) break;
                Object object = BufferedLogWriter.this.m_lock;
                synchronized (object) {
                    if (!BufferedLogWriter.this.isOpened()) {
                        break;
                    }
                    BufferedLogWriter.this.m_numFlushes++;
                    BufferedLogWriter.this.m_numBytesFlushed += BufferedLogWriter.this.m_bufferPos;
                    BufferedLogWriter.this.flush();
                }
            }
        }
    }
}

