/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.Message;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.DispatchScheduler;

public class AQjmsSimpleScheduler
implements DispatchScheduler {
    long m_minSleepTime;
    long m_maxSleepTime;
    long m_duration = 0L;
    String m_id;

    public AQjmsSimpleScheduler() {
        this(null, AQjmsConstants.getMinSleepTime(), AQjmsConstants.getMaxSleepTime());
    }

    public AQjmsSimpleScheduler(String id) {
        this(id, AQjmsConstants.getMinSleepTime(), AQjmsConstants.getMaxSleepTime());
    }

    public AQjmsSimpleScheduler(String id, long minSleepTime, long maxSleepTime) {
        this.m_id = id;
        this.m_minSleepTime = minSleepTime;
        this.m_maxSleepTime = maxSleepTime;
    }

    @Override
    public void feedException(int exceptionType, Exception exp) {
        this.m_duration = AQjmsConstants.getListenerRetry();
        if (this.m_duration > this.m_maxSleepTime) {
            this.m_duration = this.m_maxSleepTime;
        }
    }

    @Override
    public void feedData(Message msg) {
        if (msg == null) {
            this.doubleDuration();
            AQjmsOracleDebug.trace(3, "AQjmsSimpleScheduler.feedData", "Got a null message, the sleep time is doubled to " + this.m_duration);
        } else {
            this.m_duration = 0L;
            AQjmsOracleDebug.trace(3, "AQjmsSimpleScheduler.feedData", "Got a non null message, the sleep time is reset to 0");
        }
    }

    @Override
    public long getNextSleepTime() {
        long realDuration = this.m_duration < this.m_minSleepTime ? 0L : (this.m_duration > this.m_maxSleepTime ? this.m_maxSleepTime : this.m_duration);
        return realDuration;
    }

    private void doubleDuration() {
        this.m_duration = this.m_duration == 0L ? this.m_minSleepTime : (this.m_duration *= 2L);
        if (this.m_duration > this.m_maxSleepTime) {
            this.m_duration = this.m_maxSleepTime;
        }
    }
}

