/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import oracle.AQ.AQOracleAgent;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQFactory;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSFactory;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsArrayErrorInfo;
import oracle.jms.AQjmsArrayErrors;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsCompletionListenerWorker;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsInterOp;
import oracle.jms.AQjmsJsonMessage;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsMessageProperty;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsRecipients;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTempLobTruncateException;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsUtil;
import oracle.jms.JsonMessage;
import oracle.sql.ANYDATA;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.ORAData;

public class AQjmsProducer
extends AQjmsObject
implements MessageProducer {
    AQjmsSession jms_sess;
    AQjmsDestination prod_dest;
    int type;
    boolean msgid_enabled;
    boolean timestamp_enabled;
    int m_priority;
    long m_timetolive;
    int del_mode;
    private String transfxm;
    private String connection_id;
    private int deliveryDelay = 0;
    AQjmsCompletionListenerWorker completionLsnrWorker;

    AQjmsProducer(AQjmsSession session, AQjmsDestination destination, int type) throws JMSException {
        super("Producer", session);
        this.jms_sess = session;
        this.prod_dest = destination;
        this.type = type;
        this.del_mode = 2;
        this.m_priority = this.jms_sess.getCompliant() ? 4 : 1;
        this.m_timetolive = -1L;
        this.timestamp_enabled = true;
        this.msgid_enabled = true;
        this.transfxm = null;
        this.connection_id = this.jms_sess.jms_conn.getConnectionID();
        session.attach(this);
    }

    private native void ocienq(String var1, Message var2, int var3, boolean var4, int var5, int var6, int var7, long var8, AQjmsAgent[] var10, long[] var11, long var12, String var14) throws Exception;

    private native void ocienq2(String var1, Message var2, int var3, boolean var4, int var5, int var6, int var7, long var8, AQjmsAgent[] var10, long[] var11, long var12, String var14, String var15, String var16, byte[] var17) throws Exception;

    public synchronized void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed("setDisableMessageID");
        this.msgid_enabled = value;
    }

    public synchronized boolean getDisableMessageID() throws JMSException {
        this.checkClosed("getDisableMessageID");
        return this.msgid_enabled;
    }

    public synchronized void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed("setDisableMessageTimestamp");
        this.timestamp_enabled = value;
    }

    public synchronized boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed("getDisableMessageTimestamp");
        return this.timestamp_enabled;
    }

    public synchronized void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed("setDeliveryMode");
        if (deliveryMode != 2 && deliveryMode != 1) {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
        this.del_mode = deliveryMode;
    }

    public synchronized int getDeliveryMode() throws JMSException {
        this.checkClosed("getDeliveryMode");
        return this.del_mode;
    }

    public long getDeliveryDelay() throws JMSException {
        return this.deliveryDelay * 1000;
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.deliveryDelay = (int)Math.ceil((double)deliveryDelay / 1000.0);
    }

    private int getDelay() {
        return this.deliveryDelay;
    }

    public synchronized void setPriority(int priority) throws JMSException {
        this.checkClosed("setPriority");
        this.m_priority = priority;
    }

    public synchronized int getPriority() throws JMSException {
        this.checkClosed("getPriority");
        return this.m_priority;
    }

    public synchronized void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed("setTimeToLive");
        this.m_timetolive = timeToLive;
    }

    public synchronized long getTimeToLive() throws JMSException {
        this.checkClosed("getTimeToLive");
        return this.m_timetolive;
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkClosed("getQueue");
        if (this.type == 10) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "TopicPublisher");
        return null;
    }

    public synchronized void setTransformation(String transformation) {
        this.transfxm = transformation;
    }

    public synchronized String getTransformation() {
        return this.transfxm;
    }

    public synchronized void send(Message message) throws JMSException {
        this.send(message, null);
    }

    public synchronized void send(Message message, CompletionListener completionListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "entry");
        this.checkClosed("send");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("send is called without a valid Queue");
        }
        if (this.prod_dest.isQueue()) {
            this.send(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, completionListener);
        } else {
            this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null, completionListener);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "exit");
    }

    public synchronized void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive, null);
    }

    public synchronized void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "entry");
        this.checkClosed("send(msg,mode,prio,ttl)");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("send is called without a valid Queue");
        }
        if (this.prod_dest.isQueue()) {
            this.send(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false, completionListener);
        } else {
            this.publish(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false, null, completionListener);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "exit");
    }

    public synchronized void send(Queue queue, Message message) throws JMSException {
        this.send(queue, message, null);
    }

    public synchronized void send(Queue queue, Message message, CompletionListener completionListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "entry");
        this.checkClosed("send(q,msg)");
        boolean immediate_visibility = false;
        this.send(queue, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, immediate_visibility, completionListener);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public synchronized void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(queue, message, deliveryMode, priority, timeToLive, null);
    }

    public synchronized void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "entry");
        this.checkClosed("send(q,msg,mode,prio,ttl)");
        boolean immediate_visibility = false;
        this.send(queue, message, deliveryMode, priority, timeToLive, null, null, immediate_visibility, completionListener);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "exit");
    }

    public synchronized void bufferSend(Queue queue, Message message, int priority, long timeToLive) throws JMSException {
        if (((AQjmsDestination)queue).isSharded()) {
            AQjmsError.throwEx(244, "bufferSend");
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "entry");
        this.checkClosed("send(q,msg,prio,ttl)");
        boolean immediate_visibility = true;
        this.send((Destination)queue, message, 1, priority, timeToLive, null, null, immediate_visibility);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "exit");
    }

    synchronized void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility, CompletionListener completionListener) throws JMSException {
        AQjmsDestination dest_queue = null;
        boolean retry = false;
        String adtType = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "entry");
        this.checkClosed("send(q,msg,mode,prio,ttl,dev..)");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        try {
            if (completionListener != null && this.completionLsnrWorker == null) {
                this.completionLsnrWorker = new AQjmsCompletionListenerWorker(this);
                this.completionLsnrWorker.launch();
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.send", e);
        }
        if (queue == null) {
            if (this.prod_dest == null || this.prod_dest.getQueueName() == null) {
                AQjmsError.throwInvalidDestEx(143);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "prod_dest: " + this.prod_dest.getCompleteName());
                dest_queue = this.prod_dest;
            }
        } else if (queue.getQueueName() != null) {
            if (queue instanceof AQjmsDestination) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "queue: " + ((AQjmsDestination)queue).getCompleteName());
                dest_queue = (AQjmsDestination)queue;
            } else {
                AQjmsError.throwInvalidDestEx(125);
            }
        } else {
            AQjmsError.throwInvalidDestEx(143);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "dest_queue: " + dest_queue.getCompleteName());
        adtType = this.getAdtType(dest_queue);
        do {
            retry = false;
            try {
                if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.isXMLType(message)) {
                    if (!(!dest_queue.isSharded() && !dest_queue.isMigrating() || message instanceof AQjmsAdtMessage || message instanceof AQjmsJsonMessage || adtType != null && adtType.equalsIgnoreCase("SYS.ANYDATA"))) {
                        this.jdbcEnqueueSh(dest_queue, message, deliveryMode, priority, timeToLive, immediate_visibility, null);
                    } else {
                        this.jdbcEnqueue(dest_queue, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, null);
                    }
                } else {
                    this.enqueue(dest_queue, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, null);
                }
                if (completionListener == null) continue;
                this.completionLsnrWorker.add(this, completionListener, message);
            }
            catch (JMSException exNow) {
                Object exM = exNow.getMessage();
                String exErrCode = exNow.getErrorCode();
                int exErrCodeInt = 0;
                try {
                    exErrCodeInt = Integer.parseInt(exErrCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exErrCodeInt == 25609) {
                    dest_queue.getProperty().setMigrating(false);
                    retry = true;
                    if (this.jms_sess != null && this.jms_sess.jdbcConnInfo != null) {
                        AQjmsOracleDebug.trace(0, "AQjmsProducer.send-main", "CANCEL_MIGRATION occurred and enqueue request is routed for JDBC Connection Info: " + this.jms_sess.jdbcConnInfo.toString());
                        continue;
                    }
                    AQjmsOracleDebug.trace(0, "AQjmsProducer.send-main", "CANCEL_MIGRATION occurred and enqueue request is routed");
                    continue;
                }
                retry = false;
                if (this.jms_sess != null && this.jms_sess.jdbcConnInfo != null) {
                    exM = (String)exM + ". JDBC Connection Info: " + this.jms_sess.jdbcConnInfo.toString();
                }
                AQjmsOracleDebug.trace(2, "AQjmsProducer.send-main", "Exception Recieved: " + (String)exM + " ErrorCode " + exErrCode);
                AQjmsException newJmsExcp = new AQjmsException((String)exM, exErrCodeInt, exNow);
                throw newJmsExcp;
            }
        } while (retry);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "exit");
    }

    private boolean isXMLType(Message message) throws JMSException {
        if (!(message instanceof AQjmsAdtMessage)) {
            return false;
        }
        return ((AQjmsAdtMessage)message).getAdtPayload().getClass().getName().equals("oracle.xdb.XMLType");
    }

    private String getAdtType(AQjmsDestination dest) throws JMSException {
        if (this.transfxm == null) {
            return dest.getAdtType();
        }
        return AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), dest, this.transfxm).getSourceType();
    }

    private boolean useTempLobs(boolean immediateVisible) {
        return this.jms_sess.toUseTempLobs() || this.transfxm != null || immediateVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void jdbcEnqueue(AQjmsDestination dest, Message message, int deliveryMode, int priority, long timeToLive, Integer sequenceDeviation, byte[] relativeMsgId, boolean immediateVisible, AQjmsAgent[] recipientList) throws JMSException {
        AQjmsMessage ojmsMessage;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.jdbcEnqueue", "entry");
        String enqueueState = "START";
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (dest == null) {
            AQjmsError.throwEx(127);
        }
        if ((ojmsMessage = (AQjmsMessage)AQjmsProducer.convertForeignMessage(this.jms_sess, message)).getInputStream() != null && !dest.isSharded()) {
            AQjmsError.throwInvalidDestEx(245);
        }
        byte[] msgId = null;
        try {
            String adtType = this.getAdtType(dest);
            if (ojmsMessage.isHeaderOnly()) {
                ojmsMessage = (AQjmsMessage)AQjmsProducer.convertHeaderMessage(ojmsMessage, adtType);
                ojmsMessage.setStringProperty2("JMS_OracleHeaderOnly", "yes");
            }
            this.checkMessageType(adtType, ojmsMessage, false);
            if (!(ojmsMessage instanceof AQjmsAdtMessage) && !(ojmsMessage instanceof AQjmsJsonMessage)) {
                ojmsMessage.setStringProperty2("JMS_OracleDeliveryMode", "" + deliveryMode);
            }
            if (dest.isTopic() && !(ojmsMessage instanceof AQjmsAdtMessage) && !(ojmsMessage instanceof AQjmsJsonMessage)) {
                ojmsMessage.setStringProperty2("JMS_OracleConnectionID", this.connection_id);
            }
            long msgTimestamp = System.currentTimeMillis();
            ojmsMessage.setJMSTimestamp(msgTimestamp);
            if (!this.lock("jdbcEnqueue", -1L)) {
                AQjmsError.throwEx(122);
            }
            oracle.jdbc.OracleConnection dbConn = (oracle.jdbc.OracleConnection)this.jms_sess.getDBConnection();
            if (!(ojmsMessage instanceof AQjmsAdtMessage) && !(ojmsMessage instanceof AQjmsJsonMessage)) {
                AQjmsConnection jmsConn;
                AQjmsMessageHeaderExt headerExt = ojmsMessage.getMessageHeaderExt();
                if (headerExt.getReplyto() == null) {
                    AQjmsAgent dummy_agt = new AQjmsAgent(" ", null, 0);
                    headerExt.setReplyto(dummy_agt);
                }
                headerExt.setUserid((jmsConn = this.jms_sess.getJmsConnection()) == null ? null : jmsConn.getUserName());
                AQjmsPropertyList propList = AQjmsMessage.convertHashtableToPropertyList(ojmsMessage.getPropertiesHashtable());
                headerExt.setProperties(propList);
            }
            String destName = dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "destination Name: " + destName);
            AQMessageProperties msgprop = AQFactory.createAQMessageProperties();
            msgprop.setDelay(this.getDelay());
            if (ojmsMessage.getDelay() != 0) {
                msgprop.setDelay(ojmsMessage.getDelay());
            }
            msgprop.setExceptionQueue(ojmsMessage.getExceptionQueue());
            if (ojmsMessage.isJMSBody() && this.jms_sess.getCompliant()) {
                priority = AQjmsMessage.toJMSPriority(priority);
            }
            msgprop.setPriority(priority);
            msgprop.setCorrelation(ojmsMessage.getJMSCorrelationID());
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set correlation: " + ojmsMessage.getJMSCorrelationID());
            AQjmsAgent sender = ojmsMessage.getSenderID();
            if (sender != null) {
                AQAgent aqSender = AQFactory.createAQAgent();
                aqSender.setName(sender.getName());
                aqSender.setAddress(sender.getAddress());
                aqSender.setProtocol(sender.getProtocol());
                msgprop.setSender(aqSender);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set sender_name: " + sender.getName() + "\nset sender_addr: " + sender.getAddress() + "\nset sender_protocol: " + sender.getProtocol());
            }
            if (recipientList != null && recipientList.length > 0) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "recipient list specified");
                AQAgent[] aqRecpList = new AQAgent[recipientList.length];
                for (int i = 0; i < recipientList.length; ++i) {
                    aqRecpList[i] = AQFactory.createAQAgent();
                    aqRecpList[i].setAddress(recipientList[i].getAddress());
                    aqRecpList[i].setName(recipientList[i].getName());
                    aqRecpList[i].setProtocol(recipientList[i].getProtocol());
                }
                msgprop.setRecipientList(aqRecpList);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "recipient list not specified");
            }
            int ttlInSecond = 0;
            ttlInSecond = timeToLive == 0L || timeToLive == -1L ? -1 : (int)timeToLive / 1000;
            msgprop.setExpiration(ttlInSecond);
            AQEnqueueOptions enqopt = new AQEnqueueOptions();
            enqopt.setRetrieveMessageId(true);
            int visib = 0;
            visib = immediateVisible ? 1 : 2;
            enqopt.setVisibility(AQjmsConstants.toEnqueueVisibilityEnum(visib));
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "visibility: " + visib);
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "JMS delivery mode: " + deliveryMode);
            int aqDeliveryMode = this.deliveryModeFromJMSToAQ(deliveryMode);
            if (!immediateVisible) {
                aqDeliveryMode = 1;
            }
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "AQ delivery mode: " + aqDeliveryMode);
            enqopt.setDeliveryMode(AQjmsConstants.toEnqueueDeliveryModeEnum(aqDeliveryMode));
            if (this.transfxm != null) {
                enqopt.setTransformation(this.transfxm);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set transformation: " + this.transfxm);
            }
            if (sequenceDeviation != null) {
                int sd = sequenceDeviation;
                enqopt.setSequenceDeviation(AQjmsConstants.toSequenceDeviationEnum(sd));
                if (relativeMsgId != null) {
                    enqopt.setRelativeMessageId(relativeMsgId);
                }
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set seq_deviation: " + sequenceDeviation + "\nset relative_msgid: " + String.valueOf(relativeMsgId));
            }
            Object aqPayload = null;
            if (ojmsMessage instanceof AQjmsAdtMessage) {
                Object ojmsPayload = ((AQjmsAdtMessage)ojmsMessage).getAdtPayload();
                if (ojmsPayload == null) {
                    AQjmsError.throwEx(104);
                }
                if (ojmsPayload instanceof OracleData) {
                    aqPayload = ((OracleData)ojmsPayload).toJDBCObject((Connection)dbConn);
                } else if (ojmsPayload instanceof CustomDatum) {
                    aqPayload = ((CustomDatum)ojmsPayload).toDatum((OracleConnection)dbConn);
                } else if (ojmsPayload instanceof ORAData) {
                    aqPayload = ((ORAData)ojmsPayload).toDatum((Connection)dbConn);
                } else {
                    AQjmsError.throwEx(129);
                }
            } else if (adtType != null && adtType.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                aqPayload = ojmsMessage.getGenMessageCont(this.jms_sess, this.useTempLobs(immediateVisible), false).toJDBCObject((Connection)dbConn);
            } else if (!dest.isJson()) {
                aqPayload = ojmsMessage.getMessageCont(this.jms_sess, this.useTempLobs(immediateVisible), false).toJDBCObject((Connection)dbConn);
            }
            ojmsMessage.validateUserProperties();
            AQMessage aqMsg = AQFactory.createAQMessage((AQMessageProperties)msgprop);
            if (adtType != null) {
                if (adtType.equalsIgnoreCase("SYS.ANYDATA") || aqPayload instanceof OracleOpaque) {
                    aqMsg.setPayload(ANYDATA.convertDatum((Datum)((Datum)aqPayload)));
                } else {
                    aqMsg.setPayload((Struct)((OracleStruct)aqPayload));
                }
            }
            if (dest.isJson()) {
                aqMsg.setPayload(((JsonMessage)((Object)ojmsMessage)).getJsonPayload());
            }
            dbConn.enqueue(destName, enqopt, aqMsg);
            enqueueState = "MESSAGE_INSERTED";
            msgId = aqMsg.getMessageId();
            if (ojmsMessage.getWriteLobLater()) {
                ojmsMessage.writeLob(this.jms_sess, dest, aqMsg.getMessageId(), adtType.equalsIgnoreCase("SYS.ANYDATA"));
            }
            enqueueState = "LOB_WRITTEN";
            ojmsMessage.setJMSMessageID(aqMsg.getMessageId());
            ojmsMessage.setJMSDestination((Destination)dest);
            ojmsMessage.setJMSXMaxRetries(dest.getMaxRetries());
            ojmsMessage.setJMSDeliveryMode(deliveryMode);
            if (timeToLive == 0L || timeToLive == -1L) {
                ojmsMessage.setJMSExpiration(0L);
            } else {
                ojmsMessage.setJMSExpiration(msgTimestamp + timeToLive);
            }
            ojmsMessage.setJMSPriority(priority);
            if (message != ojmsMessage) {
                AQjmsProducer.copyAQjmsMessageSendHeaders(ojmsMessage, message);
            }
            enqueueState = "SEND_COMPLETED";
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (SQLException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.jdbcEnqueue", ex);
            if (ex.getErrorCode() != 24033) {
                throw new AQjmsException(ex);
            }
        }
        finally {
            if (enqueueState.equals("MESSAGE_INSERTED")) {
                try {
                    if (!this.jms_sess.isInTransactionRechecked()) {
                        this.jms_sess.forceRollback();
                    } else if (!this.purgeEmptyMessage(dest.getCompleteName(), msgId)) {
                        this.jms_sess.setConsistency(false);
                    }
                }
                catch (Throwable ex) {}
            }
            try {
                ojmsMessage.messageSendCallback(false);
            }
            catch (AQjmsTempLobTruncateException te) {
                if (te.isBlob()) {
                    this.jms_sess.cachedTempBlob = null;
                } else {
                    this.jms_sess.cachedTempClob = null;
                }
            }
            catch (Throwable throwable) {}
            try {
                this.unlock("jdbcEnqueue");
            }
            catch (Throwable throwable) {}
            AQjmsOracleDebug.trace(3, "AQjmsProducer.jdbcEnqueue", "exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void jdbcEnqueueSh(AQjmsDestination dest, Message message, int deliveryMode, int priority, long timeToLive, boolean immediateVisible, AQjmsAgent[] recipientList) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.jdbcEnqueueSh", "entry");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (dest == null) {
            AQjmsError.throwEx(127);
        }
        AQjmsMessage ojmsMessage = (AQjmsMessage)AQjmsProducer.convertForeignMessage(this.jms_sess, message);
        byte[] msgId = null;
        InputStream inputStream = null;
        PushbackInputStream pushbackInputStream = null;
        try {
            JMSMessage jmsMsg;
            JMSEnqueueOptions jmsEnqOpt;
            AQMessageProperties msgprop;
            String destName;
            oracle.jdbc.internal.OracleConnection dbConn;
            long msgTimestamp;
            block45: {
                if (dest.isTopic() && !(ojmsMessage instanceof AQjmsAdtMessage) && !(ojmsMessage instanceof AQjmsJsonMessage)) {
                    ojmsMessage.setStringProperty2("JMS_OracleConnectionID", this.connection_id);
                }
                msgTimestamp = System.currentTimeMillis();
                ojmsMessage.setJMSTimestamp(msgTimestamp);
                if (!this.lock("jdbcEnqueueSh", -1L)) {
                    AQjmsError.throwEx(122);
                }
                dbConn = (oracle.jdbc.internal.OracleConnection)this.jms_sess.getDBConnection();
                if (!(ojmsMessage instanceof AQjmsAdtMessage) && !(ojmsMessage instanceof AQjmsJsonMessage)) {
                    AQjmsConnection jmsConn;
                    AQjmsMessageHeaderExt headerExt = ojmsMessage.getMessageHeaderExt();
                    if (headerExt.getReplyto() == null) {
                        AQjmsAgent dummy_agt = new AQjmsAgent(" ", null, 0);
                        headerExt.setReplyto(dummy_agt);
                    }
                    headerExt.setUserid((jmsConn = this.jms_sess.getJmsConnection()) == null ? null : jmsConn.getUserName());
                }
                destName = dest.getCompleteName();
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "destination Name: " + destName);
                msgprop = AQFactory.createAQMessageProperties();
                msgprop.setDelay(this.getDelay());
                if (ojmsMessage.getDelay() != 0) {
                    msgprop.setDelay(ojmsMessage.getDelay());
                }
                msgprop.setExceptionQueue(ojmsMessage.getExceptionQueue());
                msgprop.setPriority(priority);
                msgprop.setCorrelation(ojmsMessage.getJMSCorrelationID());
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "set correlation: " + ojmsMessage.getJMSCorrelationID());
                AQjmsAgent sender = ojmsMessage.getSenderID();
                if (sender != null) {
                    AQAgent aqSender = AQFactory.createAQAgent();
                    aqSender.setName(sender.getName());
                    aqSender.setAddress(sender.getAddress());
                    aqSender.setProtocol(sender.getProtocol());
                    msgprop.setSender(aqSender);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "set sender_name: " + sender.getName() + "\nset sender_addr: " + sender.getAddress() + "\nset sender_protocol: " + sender.getProtocol());
                }
                if (recipientList != null && recipientList.length > 0) {
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "recipient list specified");
                    AQAgent[] aqRecpList = new AQAgent[recipientList.length];
                    for (int i = 0; i < recipientList.length; ++i) {
                        aqRecpList[i] = AQFactory.createAQAgent();
                        aqRecpList[i].setAddress(recipientList[i].getAddress());
                        aqRecpList[i].setName(recipientList[i].getName());
                        aqRecpList[i].setProtocol(recipientList[i].getProtocol());
                    }
                    msgprop.setRecipientList(aqRecpList);
                } else {
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "recipient list not specified");
                }
                int ttlInSecond = 0;
                ttlInSecond = timeToLive == 0L || timeToLive == -1L ? -1 : (int)timeToLive / 1000;
                msgprop.setExpiration(ttlInSecond);
                jmsEnqOpt = new JMSEnqueueOptions();
                jmsEnqOpt.setRetrieveMessageId(true);
                int visib = 0;
                visib = immediateVisible ? 1 : 2;
                jmsEnqOpt.setVisibility(AQjmsConstants.toJmsEnqueueVisibilityEnum(visib));
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "visibility: " + visib);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "JMS delivery mode: " + deliveryMode);
                int aqDeliveryMode = this.deliveryModeFromJMSToAQ(deliveryMode);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "AQ delivery mode: " + aqDeliveryMode);
                jmsEnqOpt.setDeliveryMode(AQjmsConstants.toJmsEnqueueDeliveryModeEnum(aqDeliveryMode));
                JMSMessageProperties jmsProps = JMSFactory.createJMSMessageProperties();
                String userProps = ojmsMessage.getUserProperties();
                jmsProps.setUserProperties(userProps);
                String headerProps = ojmsMessage.getJmsHeaders(deliveryMode);
                jmsProps.setHeaderProperties(headerProps);
                JMSMessageProperties.JMSMessageType msgType = this.getTypeEnumOfJMSMessage(ojmsMessage);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "JMSMessageType: " + String.valueOf(msgType));
                jmsProps.setJMSMessageType(msgType);
                jmsMsg = JMSFactory.createJMSMessage((JMSMessageProperties)jmsProps);
                if (ojmsMessage != null && ojmsMessage.getInputStream() != null) {
                    if (deliveryMode == 1) {
                        AQjmsError.throwEx(247);
                    }
                    if (ojmsMessage.getBytesCont() != null) {
                        if (ojmsMessage instanceof BytesMessage && ojmsMessage.getBytesCont().length > 0) {
                            AQjmsError.throwEx(251);
                        }
                        if (ojmsMessage instanceof StreamMessage && ojmsMessage.getBytesCont().length > 4) {
                            AQjmsError.throwEx(251);
                        }
                    }
                    inputStream = ojmsMessage.getInputStream();
                    try {
                        pushbackInputStream = new PushbackInputStream(inputStream, 1);
                        int firstByte = pushbackInputStream.read();
                        if (firstByte == -1) {
                            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "Streaming Enqueue with empty inputstream");
                            if (ojmsMessage instanceof StreamMessage && ojmsMessage.getBytesCont().length == 4) {
                                jmsMsg.setPayload(ojmsMessage.getBytesCont());
                            }
                            break block45;
                        }
                        pushbackInputStream.unread(firstByte);
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "Streaming Enqueue");
                        jmsMsg.setPayload((InputStream)pushbackInputStream);
                    }
                    catch (IOException ioException) {
                        AQjmsError.throwEx(157, (Throwable)ioException);
                    }
                } else {
                    jmsMsg.setPayload(ojmsMessage.getBytesCont());
                }
            }
            dbConn.jmsEnqueue(destName, jmsEnqOpt, jmsMsg, msgprop);
            msgId = jmsMsg.getMessageId();
            ojmsMessage.setJMSMessageID(msgId);
            ojmsMessage.setJMSDestination((Destination)dest);
            ojmsMessage.setJMSXMaxRetries(dest.getMaxRetries());
            ojmsMessage.setJMSDeliveryMode(deliveryMode);
            if (timeToLive == 0L || timeToLive == -1L) {
                ojmsMessage.setJMSExpiration(0L);
            } else {
                ojmsMessage.setJMSExpiration(msgTimestamp + timeToLive);
            }
            ojmsMessage.setJMSPriority(priority);
            if (message != ojmsMessage) {
                AQjmsProducer.copyAQjmsMessageSendHeaders(ojmsMessage, message);
            }
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (SQLException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.jdbcEnqueueSh", ex);
            if (ex.getErrorCode() != 24033) {
                throw new AQjmsException(ex);
            }
        }
        finally {
            try {
                this.unlock("jdbcEnqueueSh");
            }
            catch (Throwable throwable) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (pushbackInputStream != null) {
                    pushbackInputStream.close();
                }
            }
            catch (IOException iOException) {}
            AQjmsOracleDebug.trace(3, "AQjmsProducer.jdbcEnqueueSh", "exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void enqueue(AQjmsDestination msg_dest, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility, AQjmsAgent[] recipient_list) throws JMSException {
        Connection db_conn = null;
        AQjmsConnection jms_conn = null;
        AQjmsMessageHeaderExt header_ext = null;
        AQjmsPropertyList prop_list = null;
        String q_name = "";
        OracleCallableStatement enq_stmt = null;
        AQjmsAgent sender = null;
        byte[] msg_id = null;
        long expire = 0L;
        long ttl_secs = 0L;
        Map<String, Class<?>> map = null;
        OracleArray recp_array = null;
        Object co_payload = null;
        String userid = null;
        String exceptionQ = null;
        int msg_delay = 0;
        AQjmsAgent dummy_agt = null;
        AQjmsSignature signature = null;
        int index = 0;
        boolean gen_pload = false;
        boolean is_anydata_dest = false;
        Message orig_msg = null;
        boolean use_templobs = false;
        String adt_type = null;
        boolean writeLobLater = true;
        String enqueueState = "START";
        Date curr_date = new Date();
        AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "entry");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (!this.lock("enqueue", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            boolean usingOCI;
            orig_msg = message;
            message = AQjmsProducer.convertForeignMessage(this.jms_sess, message);
            adt_type = this.getAdtType(msg_dest);
            boolean isSharded = msg_dest.isSharded();
            boolean isMigrating = msg_dest.isMigrating();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "isSharded: " + isSharded);
            if (!isSharded && !isMigrating) {
                if (message instanceof AQjmsMessage && ((AQjmsMessage)message).getInputStream() != null) {
                    AQjmsError.throwInvalidDestEx(245);
                }
                if (((AQjmsMessage)(message = AQjmsProducer.convertHeaderMessage(message, adt_type))).isJMSBody() && this.jms_sess.getCompliant()) {
                    priority = AQjmsMessage.toJMSPriority(priority);
                }
                if (((AQjmsMessage)message).isHeaderOnly()) {
                    ((AQjmsMessage)message).setStringProperty2("JMS_OracleHeaderOnly", "yes");
                }
                if (!(message instanceof AQjmsAdtMessage)) {
                    ((AQjmsMessage)message).setStringProperty2("JMS_OracleDeliveryMode", "" + deliveryMode);
                }
            }
            if (msg_dest.isTopic() && !(message instanceof AQjmsAdtMessage)) {
                ((AQjmsMessage)message).setStringProperty2("JMS_OracleConnectionID", this.connection_id);
            }
            message.setJMSTimestamp(curr_date.getTime());
            if (msg_dest == null) {
                AQjmsError.throwEx(127);
            }
            jms_conn = this.jms_sess.getJmsConnection();
            if (!isSharded && !isMigrating) {
                is_anydata_dest = adt_type.equalsIgnoreCase("SYS.ANYDATA");
                use_templobs = this.useTempLobs(immediate_visibility);
            }
            boolean bl = usingOCI = this.jms_sess.hasOciAQContext() && !(message instanceof AQjmsAdtMessage) && !is_anydata_dest;
            if (!isSharded && !isMigrating) {
                this.checkMessageType(adt_type, message, usingOCI);
            }
            q_name = msg_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "q_name: " + q_name);
            ttl_secs = timeToLive == 0L || timeToLive == -1L ? -1L : timeToLive / 1000L;
            db_conn = this.jms_sess.getDBConnection();
            map = db_conn.getTypeMap();
            if (!(message instanceof AQjmsAdtMessage)) {
                header_ext = ((AQjmsMessage)message).getMessageHeaderExt();
                if (header_ext.getReplyto() == null) {
                    dummy_agt = new AQjmsAgent(" ", null, 0);
                    header_ext.setReplyto(dummy_agt);
                }
                userid = jms_conn.getUserName();
                header_ext.setUserid(userid);
                if (!isSharded && !isMigrating) {
                    prop_list = AQjmsMessage.convertHashtableToPropertyList(((AQjmsMessage)message).getPropertiesHashtable());
                    header_ext.setProperties(prop_list);
                }
            }
            msg_delay = ((AQjmsMessage)message).getDelay() == 0 ? this.getDelay() : ((AQjmsMessage)message).getDelay();
            exceptionQ = ((AQjmsMessage)message).getExceptionQueue();
            signature = ((AQjmsMessage)message).getSignature();
            gen_pload = "SYS.AQ$_JMS_MESSAGE".equalsIgnoreCase(adt_type);
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "JMS delivery mode: " + deliveryMode);
            int aqDeliveryMode = this.deliveryModeFromJMSToAQ(deliveryMode);
            int visib = immediate_visibility ? 1 : 2;
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "AQ delivery mode: " + aqDeliveryMode);
            if (!isSharded && !isMigrating) {
                if (visib != 1) {
                    aqDeliveryMode = 1;
                }
                ((AQjmsMessage)message).validateUserProperties();
            }
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "visibility: " + visib);
            if (usingOCI) {
                long[] hdls = this.jms_sess.getOCIHandles();
                int m_type = this.getTypeCodeOfJMSMessage(message);
                if ((isSharded || isMigrating) && m_type == 100) {
                    gen_pload = true;
                }
                AQjmsOracleDebug.println("Context: " + this.jms_sess.oci_aq_cntxt);
                if (msg_dest.isSharded() || msg_dest.isMigrating()) {
                    String userProperties = ((AQjmsMessage)message).getUserProperties();
                    String jmsHeaders = ((AQjmsMessage)message).getJmsHeaders(deliveryMode);
                    byte[] bytesPayload = ((AQjmsMessage)message).getBytesCont();
                    this.ocienq2(q_name, message, m_type, gen_pload, priority, visib, aqDeliveryMode, ttl_secs, recipient_list, hdls, this.jms_sess.oci_aq_cntxt, this.transfxm, jmsHeaders, userProperties, bytesPayload);
                    ((AQjmsMessage)message).setWriteLobLater(false);
                } else {
                    this.ocienq(q_name, message, m_type, gen_pload, priority, visib, aqDeliveryMode, ttl_secs, recipient_list, hdls, this.jms_sess.oci_aq_cntxt, this.transfxm);
                }
                enqueueState = "MESSAGE_INSERTED";
                msg_id = ((AQjmsMessage)message).getJMSMessageIDAsBytes();
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message id: " + message.getJMSMessageID());
            } else {
                try {
                    map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
                }
                catch (ClassNotFoundException ce) {
                    AQjmsError.throwEx("Unable to put the oracle.AQ.AQOracleAgent class into sql map", (Throwable)ce);
                }
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message type: " + message.getClass().getName());
                int enquStmtType = 0;
                if (message instanceof AQjmsAdtMessage) {
                    co_payload = ((AQjmsAdtMessage)message).getAdtPayload();
                    if (co_payload == null) {
                        AQjmsError.throwEx(104);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "co_payload: " + co_payload.getClass().getName());
                    if (recipient_list != null && recipient_list.length > 0) {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list specified");
                        enq_stmt = this.jms_sess.getAdtStmt();
                        enquStmtType = 2;
                    } else {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list not specified");
                        enq_stmt = this.jms_sess.getAdtNoRecplStmt();
                        enquStmtType = 3;
                    }
                } else if (message instanceof AQjmsMessage) {
                    enq_stmt = this.jms_sess.getEnqueueStmt(message);
                    enquStmtType = 1;
                } else {
                    AQjmsError.throwEx(129);
                }
                enq_stmt.setString(this.getIndex(enquStmtType, "queue_name"), q_name);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set queue_name: " + q_name);
                sender = ((AQjmsMessage)message).getSenderID();
                if (sender != null) {
                    enq_stmt.setString(this.getIndex(enquStmtType, "sender_name"), sender.getName());
                    enq_stmt.setString(this.getIndex(enquStmtType, "sender_addr"), sender.getAddress());
                    enq_stmt.setInt(this.getIndex(enquStmtType, "sender_protocol"), sender.getProtocol());
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set sender_name: " + sender.getName() + "\nset sender_addr: " + sender.getAddress() + "\nset sender_protocol: " + sender.getProtocol());
                } else {
                    enq_stmt.setString(this.getIndex(enquStmtType, "sender_name"), null);
                    enq_stmt.setString(this.getIndex(enquStmtType, "sender_addr"), null);
                    enq_stmt.setInt(this.getIndex(enquStmtType, "sender_protocol"), 0);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set sender_name: null\nset sender_addr: null\nset sender_protocol: null");
                }
                enq_stmt.setNull(this.getIndex(enquStmtType, "original_msgid"), -2);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set original_msgid: null");
                enq_stmt.setString(this.getIndex(enquStmtType, "correlation"), message.getJMSCorrelationID());
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set correlation: " + message.getJMSCorrelationID());
                enq_stmt.setObject(this.getIndex(enquStmtType, "visibility"), (Object)visib, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set visibility: " + visib);
                enq_stmt.setObject(this.getIndex(enquStmtType, "priority"), (Object)priority, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set priority: " + priority);
                enq_stmt.setObject(this.getIndex(enquStmtType, "delay"), (Object)msg_delay, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set delay: " + msg_delay);
                enq_stmt.setLong(this.getIndex(enquStmtType, "expiration"), ttl_secs);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set expiration: " + ttl_secs);
                if (seq_deviation != null) {
                    if (seq_deviation == 2 || seq_deviation == 3) {
                        enq_stmt.setObject(this.getIndex(enquStmtType, "sequence_deviation"), (Object)seq_deviation, 4);
                        if (relative_msg_id != null) {
                            enq_stmt.setObject(this.getIndex(enquStmtType, "relative_msgid"), (Object)relative_msg_id, -2);
                        } else {
                            enq_stmt.setNull(this.getIndex(enquStmtType, "relative_msgid"), -2);
                        }
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set seq_deviation: " + seq_deviation + "\nset relative_msgid: " + String.valueOf(relative_msg_id));
                    } else {
                        AQjmsError.throwEx(154);
                    }
                } else {
                    enq_stmt.setNull(this.getIndex(enquStmtType, "sequence_deviation"), 2);
                    enq_stmt.setNull(this.getIndex(enquStmtType, "relative_msgid"), -2);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set seq_deviation: null\nset relative_msgid: null");
                }
                enq_stmt.setString(this.getIndex(enquStmtType, "exception_queue"), exceptionQ);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set exception_queue: " + exceptionQ);
                enq_stmt.setObject(this.getIndex(enquStmtType, "payload_type"), (Object)1, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set payload_type: 1");
                enq_stmt.registerOutParameter(this.getIndex(enquStmtType, "msgid"), -2);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "register out parameter msgid.");
                index = this.getIndex(enquStmtType, "recipients");
                if (index != -1) {
                    if (recipient_list != null && recipient_list.length > 0) {
                        recp_array = this.createRecpArrayfromAgentList(recipient_list);
                        enq_stmt.setObject(index, (Object)recp_array, 2003);
                    } else {
                        enq_stmt.setNull(index, 2003, "SYS.AQ$_RECIPIENTS");
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set recipients: " + String.valueOf(recipient_list));
                }
                if ((index = this.getIndex(enquStmtType, "object_user_data")) != -1) {
                    if (co_payload instanceof CustomDatum) {
                        enq_stmt.setCustomDatum(index, (CustomDatum)co_payload);
                    } else if (co_payload instanceof OracleData) {
                        enq_stmt.setObject(index, (Object)((OracleData)co_payload));
                    } else if (co_payload instanceof ORAData) {
                        enq_stmt.setObject(index, (Object)((ORAData)co_payload));
                    } else {
                        AQjmsError.throwEx(129);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set object_user_data: " + String.valueOf(co_payload));
                }
                if ((index = this.getIndex(enquStmtType, "jms_message")) != -1) {
                    enq_stmt.setObject(index, (Object)((AQjmsMessage)message).getMessageCont(this.jms_sess, use_templobs, false));
                    writeLobLater = ((AQjmsMessage)message).getWriteLobLater();
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set jms_message: " + String.valueOf(message));
                }
                if ((index = this.getIndex(enquStmtType, "signature")) != -1) {
                    if (signature != null) {
                        enq_stmt.setObject(index, (Object)signature);
                    } else {
                        enq_stmt.setNull(index, 2002, "SYS.AQ$_SIG_PROP");
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set signature: " + String.valueOf(signature));
                }
                if ((index = this.getIndex(enquStmtType, "transformation")) != -1) {
                    enq_stmt.setString(index, this.transfxm);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set transformation: " + this.transfxm);
                }
                if ((index = this.getIndex(enquStmtType, "gen_payload")) != -1) {
                    if (gen_pload) {
                        enq_stmt.setInt(index, 1);
                    } else {
                        enq_stmt.setInt(index, 0);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set gen_payload: " + gen_pload);
                }
                if ((index = this.getIndex(enquStmtType, "create_new_lob")) != -1) {
                    int create_empty_lob = writeLobLater ? 1 : 0;
                    enq_stmt.setObject(index, (Object)create_empty_lob, 4);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set create_new_lob: " + create_empty_lob);
                }
                if ((index = this.getIndex(enquStmtType, "delivery_mode")) != -1) {
                    enq_stmt.setInt(index, aqDeliveryMode);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set AQ delivery_mode: " + aqDeliveryMode);
                }
                long starttime = System.currentTimeMillis();
                enq_stmt.execute();
                long endtime = System.currentTimeMillis();
                enqueueState = "MESSAGE_INSERTED";
                AQjmsOracleDebug.trace(1, "AQjmsProducer.enqueue", "execute Query " + (endtime - starttime) + " msecs");
                msg_id = enq_stmt.getBytes(this.getIndex(enquStmtType, "msgid"));
                ((AQjmsMessage)message).setJMSMessageID(msg_id);
            }
            if (((AQjmsMessage)message).getWriteLobLater()) {
                ((AQjmsMessage)message).writeLob(this.jms_sess, msg_dest, msg_id, is_anydata_dest);
            }
            enqueueState = "LOB_WRITTEN";
            msg_id = ((AQjmsMessage)message).getJMSMessageIDAsBytes();
            message.setJMSDestination((Destination)msg_dest);
            ((AQjmsMessage)message).setJMSXMaxRetries(msg_dest.getMaxRetries());
            ((AQjmsMessage)message).setJMSDeliveryMode(deliveryMode);
            if (timeToLive == 0L || timeToLive == -1L) {
                message.setJMSExpiration(0L);
            } else {
                expire = curr_date.getTime() + ttl_secs * 1000L;
                message.setJMSExpiration(expire);
            }
            message.setJMSPriority(priority);
            ((AQjmsMessage)message).setDelay(msg_delay);
            ((AQjmsMessage)message).setExceptionQueue(exceptionQ);
            if (orig_msg != message) {
                AQjmsProducer.copyAQjmsMessageSendHeaders(message, orig_msg);
            }
            enqueueState = "SEND_COMPLETED";
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (SQLException ex) {
            try {
                if (enq_stmt != null) {
                    this.jms_sess.destroyStmt(enq_stmt);
                }
            }
            catch (Exception ex2) {
                AQjmsOracleDebug.traceEx(5, "AQjmsProducer.enqueue-ex2", ex2);
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex", ex);
            if (ex.getErrorCode() != 24033) {
                throw new AQjmsException(ex);
            }
        }
        catch (JMSException jmse) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex", jmse);
            throw jmse;
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex", e);
            AQjmsError.throwEx(122, (Throwable)e);
        }
        finally {
            if (enqueueState.equals("MESSAGE_INSERTED")) {
                try {
                    if (!this.jms_sess.isInTransactionRechecked()) {
                        this.jms_sess.forceRollback();
                    } else if (!this.purgeEmptyMessage(msg_dest.getCompleteName(), msg_id)) {
                        this.jms_sess.setConsistency(false);
                    }
                }
                catch (Throwable ex) {}
            }
            try {
                ((AQjmsMessage)message).messageSendCallback(false);
            }
            catch (AQjmsTempLobTruncateException te) {
                if (te.isBlob()) {
                    this.jms_sess.cachedTempBlob = null;
                } else {
                    this.jms_sess.cachedTempClob = null;
                }
            }
            catch (Throwable te) {}
            try {
                this.unlock("enqueue");
            }
            catch (Throwable te) {}
            AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "exit");
        }
    }

    private boolean purgeEmptyMessage(String queueName, byte[] msgId) {
        AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "enter");
        boolean success = true;
        try {
            Connection db_conn = this.jms_sess.getDBConnection();
            String purgeStmtString = "begin dbms_aqjms.aq$_purge_message(queue_name => ?, msgid => ?); end; ";
            AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "the purge statement:\n" + purgeStmtString);
            CallableStatement stmt = db_conn.prepareCall(purgeStmtString);
            stmt.setString(1, queueName);
            stmt.setBytes(2, msgId);
            stmt.execute();
            AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "purging the empty message is successful");
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(1, "AQjmsProducer.purgeEmptyMessage encountered exception", e);
            success = false;
        }
        AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "exit: success=" + success);
        return success;
    }

    private int deliveryModeFromJMSToAQ(int jmsMode) {
        if (jmsMode == 2) {
            return 1;
        }
        return 2;
    }

    private int getIndex(int enquStmtType, String paraName) throws JMSException {
        int index = AQjmsInterOp.getEnqueueStmtIndex(this.jms_sess.getDBVersion(), enquStmtType, paraName);
        if (index != -1) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.getIndex", "parameter: " + paraName + ", index: " + index);
        }
        return index;
    }

    public synchronized Topic getTopic() throws JMSException {
        this.checkClosed("getTopic");
        if (this.type == 20) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized void publish(Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "entry");
        this.checkClosed("publish");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "exit");
    }

    public synchronized void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "entry");
        this.checkClosed("publish(msg,mode,prio,ttl)");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false, null, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "exit");
    }

    public synchronized void publish(Topic topic, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "exit");
    }

    public synchronized void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "entry");
        this.publish(topic, message, deliveryMode, priority, timeToLive, null, null, false, null, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "exit");
    }

    public synchronized void bufferPublish(Topic topic, Message message, int priority, long timeToLive) throws JMSException {
        if (((AQjmsDestination)topic).isSharded()) {
            AQjmsError.throwEx(244, "bufferPublish");
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferPublish", "entry");
        this.publish(topic, message, 1, priority, timeToLive, null, null, true, null, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferPublish", "exit");
    }

    synchronized void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility, AQjmsAgent[] recipientList, CompletionListener completionListener) throws JMSException {
        AQjmsDestination dest_topic = null;
        boolean retry = false;
        String adtType = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "entry");
        this.checkClosed("publish(t,msg,mode,prio,ttl,seq..)");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        try {
            if (completionListener != null && this.completionLsnrWorker == null) {
                this.completionLsnrWorker = new AQjmsCompletionListenerWorker(this);
                this.completionLsnrWorker.launch();
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.publish", e);
        }
        if (topic == null) {
            if (this.prod_dest == null || this.prod_dest.getTopicName() == null) {
                AQjmsError.throwInvalidDestEx(166);
            } else {
                dest_topic = this.prod_dest;
            }
        } else if (topic instanceof AQjmsDestination) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.publish", "topic: " + ((AQjmsDestination)topic).getCompleteName());
            dest_topic = (AQjmsDestination)topic;
        } else {
            AQjmsError.throwInvalidDestEx(166);
        }
        adtType = this.getAdtType(dest_topic);
        do {
            retry = false;
            try {
                if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.isXMLType(message)) {
                    if (!(!dest_topic.isSharded() && !dest_topic.isMigrating() || message instanceof AQjmsAdtMessage || message instanceof AQjmsJsonMessage || adtType != null && adtType.equalsIgnoreCase("SYS.ANYDATA"))) {
                        this.jdbcEnqueueSh(dest_topic, message, deliveryMode, priority, timeToLive, immediate_visibility, recipientList);
                    } else {
                        this.jdbcEnqueue(dest_topic, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, recipientList);
                    }
                } else {
                    this.enqueue(dest_topic, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, recipientList);
                }
                if (completionListener == null) continue;
                this.completionLsnrWorker.add(this, completionListener, message);
            }
            catch (JMSException ex) {
                Object exM = ex.getMessage();
                String exErrCode = ex.getErrorCode();
                int exErrCodeInt = 0;
                try {
                    exErrCodeInt = Integer.parseInt(exErrCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exErrCodeInt == 25609) {
                    dest_topic.getProperty().setMigrating(false);
                    retry = true;
                    if (this.jms_sess != null && this.jms_sess.jdbcConnInfo != null) {
                        AQjmsOracleDebug.trace(0, "AQjmsProducer.publish-5", "CANCEL_MIGRATION occurred and enqueue request is routed for JDBC Connection Info: " + this.jms_sess.jdbcConnInfo.toString());
                        continue;
                    }
                    AQjmsOracleDebug.trace(0, "AQjmsProducer.publish-5", "CANCEL_MIGRATION occurred and enqueue request is routed");
                    continue;
                }
                retry = false;
                if (this.jms_sess != null && this.jms_sess.jdbcConnInfo != null) {
                    exM = (String)exM + ". JDBC Connection Info: " + this.jms_sess.jdbcConnInfo.toString();
                }
                AQjmsOracleDebug.trace(2, "AQjmsProducer.publish-5", "Exception Recieved: " + (String)exM + " ErrorCode " + exErrCode);
                AQjmsException newJmsExcp = new AQjmsException((String)exM, exErrCodeInt, ex);
                throw newJmsExcp;
            }
        } while (retry);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] recipientList) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "entry");
        this.checkClosed("publish(msg,rcplist)");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, recipientList, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] recipientList) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, recipientList, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] recipientList, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "entry");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false, recipientList, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] recipientList, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "entry");
        this.publish(topic, message, deliveryMode, priority, timeToLive, null, null, false, recipientList, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "exit");
    }

    private OracleArray createRecpArrayfromAgentList(AQjmsAgent[] recp_list) throws JMSException {
        Connection db_conn = null;
        Object[] obj_array = null;
        OracleArray recp_array = null;
        int num_recps = 0;
        AQOracleAgent ora_agt = null;
        AQjmsAgent agt = null;
        int i = 0;
        int j = 0;
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "entry");
        if (recp_list == null || recp_list.length == 0) {
            AQjmsError.throwEx(145);
        }
        num_recps = recp_list.length;
        obj_array = new Object[num_recps];
        try {
            for (i = 0; i < num_recps; ++i) {
                agt = recp_list[i];
                if (agt == null) {
                    j = i + 1;
                    AQjmsError.throwEx(201);
                }
                ora_agt = new AQOracleAgent(agt.getName(), agt.getAddress(), agt.getProtocol());
                AQjmsOracleDebug.trace(5, "AQjmsProducer", "recp[" + i + "]: " + agt.getName() + "::" + agt.getAddress() + "::" + agt.getProtocol());
                obj_array[i] = ora_agt;
            }
        }
        catch (SQLException sqlex) {
            throw new AQjmsException(sqlex);
        }
        try {
            db_conn = this.jms_sess.getDBConnection();
        }
        catch (Exception ex) {
            AQjmsError.throwEx(112, (Throwable)ex);
        }
        try {
            recp_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_RECIPIENTS", (Object)obj_array);
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.createRecpArrayfromAgentList", sqlex);
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "exit");
        return recp_array;
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.localClose", "ENTRY");
        this.jms_sess = null;
        if (this.completionLsnrWorker != null) {
            this.completionLsnrWorker.close();
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.localClose", "EXIT");
    }

    boolean isProducerClosed() {
        if (this.jms_sess == null) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.isProducerClosed", "Producer closed");
            return true;
        }
        return false;
    }

    void checkMessageType(String adtType, Message message, boolean usingOCI) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "adt type: " + adtType);
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "message_class: " + message.getClass().getName());
        boolean gen_pload = false;
        boolean use_gen_pload = false;
        if (adtType != null) {
            gen_pload = adtType.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE");
            boolean bl = use_gen_pload = gen_pload && (usingOCI || this.jms_sess.hasGenMsgSupport());
        }
        if (message instanceof AQjmsTextMessage) {
            if (!(adtType.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || adtType.equalsIgnoreCase("SYS.ANYDATA") || use_gen_pload)) {
                AQjmsError.throwEx(108, "TextMessage", adtType);
            }
        } else if (message instanceof AQjmsBytesMessage) {
            if (!(adtType.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || adtType.equalsIgnoreCase("SYS.ANYDATA") || use_gen_pload)) {
                AQjmsError.throwEx(108, "BytesMessage", adtType);
            }
        } else if (message instanceof AQjmsStreamMessage) {
            if (!(adtType.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE") || adtType.equalsIgnoreCase("SYS.ANYDATA") || use_gen_pload)) {
                AQjmsError.throwEx(108, "StreamMessage", adtType);
            }
        } else if (message instanceof AQjmsMapMessage) {
            if (!(adtType.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || adtType.equalsIgnoreCase("SYS.ANYDATA") || use_gen_pload)) {
                AQjmsError.throwEx(108, "MapMessage", adtType);
            }
        } else if (message instanceof AQjmsObjectMessage) {
            if (!(adtType.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || adtType.equalsIgnoreCase("SYS.ANYDATA") || use_gen_pload)) {
                AQjmsError.throwEx(108, "ObjectMessage", adtType);
            }
        } else if (message instanceof AQjmsAdtMessage) {
            if (adtType.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || adtType.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || adtType.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || adtType.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || adtType.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || adtType.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsError.throwEx(108, "AdtMessage", adtType);
            }
        } else if (message instanceof AQjmsJsonMessage) {
            if (adtType != null) {
                AQjmsError.throwEx(108, "JsonMessage", adtType);
            }
        } else {
            AQjmsError.throwEx(108, message.getClass().getName(), adtType);
        }
    }

    private static Message convertHeaderMessage(Message msg, String adt_type) throws JMSException {
        if (msg instanceof AQjmsMessage && ((AQjmsMessage)msg).isHeaderOnly()) {
            if (adt_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                return new AQjmsTextMessage((AQjmsMessage)msg);
            }
            if (adt_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || adt_type.equalsIgnoreCase("SYS.ANYDATA") || adt_type.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                return new AQjmsBytesMessage((AQjmsMessage)msg);
            }
            if (adt_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                return new AQjmsStreamMessage((AQjmsMessage)msg);
            }
            if (adt_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                return new AQjmsMapMessage((AQjmsMessage)msg);
            }
            if (adt_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                return new AQjmsObjectMessage((AQjmsMessage)msg);
            }
        }
        return msg;
    }

    private static Message convertForeignMessage(AQjmsSession s, Message msg) throws JMSException {
        Object body;
        if (msg == null || msg instanceof AQjmsMessage) {
            return msg;
        }
        Object ret = null;
        ret = msg instanceof BytesMessage ? s.createBytesMessage() : (msg instanceof MapMessage ? s.createMapMessage() : (msg instanceof ObjectMessage ? s.createObjectMessage() : (msg instanceof StreamMessage ? s.createStreamMessage() : (msg instanceof TextMessage ? s.createTextMessage() : s.createMessage()))));
        AQjmsProducer.copyForeignClientHeaders(msg, (Message)ret);
        Enumeration pe = msg.getPropertyNames();
        while (pe != null && pe.hasMoreElements()) {
            Object myprop;
            String k = (String)pe.nextElement();
            if (k == null || (myprop = msg.getObjectProperty(k)) == null) continue;
            if (!AQjmsMessage.isSystemProperty(k)) {
                ret.setObjectProperty(k, myprop);
                continue;
            }
            if (!AQjmsMessage.isSettableSystemProperty(k)) continue;
            ret.setObjectProperty(k, myprop);
        }
        if (msg instanceof BytesMessage) {
            ((BytesMessage)msg).reset();
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = ((BytesMessage)msg).readBytes(buf)) != -1) {
                ret.writeBytes(buf, 0, len);
            }
        } else if (msg instanceof MapMessage) {
            Enumeration e = ((MapMessage)msg).getMapNames();
            while (e != null && e.hasMoreElements()) {
                String k = (String)e.nextElement();
                ((MapMessage)ret).setObject(k, ((MapMessage)msg).getObject(k));
            }
        } else if (msg instanceof ObjectMessage) {
            body = ((ObjectMessage)msg).getObject();
            if (body != null) {
                ((ObjectMessage)ret).setObject((Serializable)body);
            }
        } else if (msg instanceof StreamMessage) {
            ((StreamMessage)msg).reset();
            try {
                Object item = null;
                while ((item = ((StreamMessage)msg).readObject()) != null) {
                    ((StreamMessage)ret).writeObject(item);
                }
            }
            catch (MessageEOFException item) {}
        } else if (msg instanceof TextMessage && (body = ((TextMessage)msg).getText()) != null) {
            ((TextMessage)ret).setText((String)body);
        }
        return ret;
    }

    private static void copyAQjmsMessageSendHeaders(Message aqJmsSourceMessage, Message foreignDestinationMessage) throws JMSException {
        try {
            foreignDestinationMessage.setJMSDestination(aqJmsSourceMessage.getJMSDestination());
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(5, "Foreign message does not accept an AQ destination as the JMSDestination header -> ignored", e);
        }
        foreignDestinationMessage.setJMSDeliveryMode(aqJmsSourceMessage.getJMSDeliveryMode());
        foreignDestinationMessage.setJMSExpiration(aqJmsSourceMessage.getJMSExpiration());
        foreignDestinationMessage.setJMSPriority(aqJmsSourceMessage.getJMSPriority());
        foreignDestinationMessage.setJMSMessageID(aqJmsSourceMessage.getJMSMessageID());
        foreignDestinationMessage.setJMSTimestamp(aqJmsSourceMessage.getJMSTimestamp());
        ((AQjmsMessage)foreignDestinationMessage).setJMSXMaxRetries(((AQjmsDestination)aqJmsSourceMessage.getJMSDestination()).getMaxRetries());
    }

    private static void copyForeignClientHeaders(Message foreignSourceMessage, Message aqDestinationMessage) throws JMSException {
        aqDestinationMessage.setJMSCorrelationID(foreignSourceMessage.getJMSCorrelationID());
        try {
            Destination replyDestination = foreignSourceMessage.getJMSReplyTo();
            if (replyDestination instanceof AQjmsDestination || replyDestination instanceof AQjmsAgent) {
                aqDestinationMessage.setJMSReplyTo(replyDestination);
            } else if (replyDestination != null) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.copyForeignClientHeaders", "Skip copying foreign JMSReplyTo header " + String.valueOf(replyDestination));
            }
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(5, "Error copying foreign JMSReplyTo header -> ignored", e);
        }
        aqDestinationMessage.setJMSType(foreignSourceMessage.getJMSType());
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed("getDestination");
        return this.prod_dest;
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, null);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "entry");
        this.checkClosed("send(dest,msg)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (this.prod_dest != null) {
            throw new UnsupportedOperationException("MessageProducer was assigned a destination at creation time");
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, completionListener);
        } else {
            this.publish((Topic)destination, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null, completionListener);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "entry");
        this.checkClosed("send(dest,msg,mode,prio,ttl)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, deliveryMode, priority, timeToLive, null, null, false, completionListener);
        } else {
            this.publish((Topic)destination, message, deliveryMode, priority, timeToLive, null, null, false, null, completionListener);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "exit");
    }

    public synchronized void bufferSend(Destination destination, Message message, int priority, long timeToLive) throws JMSException {
        if (((AQjmsDestination)destination).isSharded()) {
            AQjmsError.throwEx(244, "bufferSend");
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "entry");
        this.checkClosed("bufferSend(dest,msg,prio,ttl)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Destination)((Queue)destination), message, 1, priority, timeToLive, null, null, true);
        } else {
            this.publish((Topic)destination, message, 1, priority, timeToLive, null, null, true, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "exit");
    }

    synchronized void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-5", "entry");
        this.checkClosed("send(dest,msg,mode,prio,ttl, seq_deviation, relative_msg_id, visib)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, null);
        } else {
            this.publish((Topic)destination, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-5", "exit");
    }

    public void bulkSend(Message[] messages) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-1", "entry");
        this.checkClosed("bulkSend");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("bulkSend is called without a valid Destination");
        }
        if (this.prod_dest.isQueue()) {
            this.bulkSend(this.prod_dest, messages, null, null, null, null, null);
        } else {
            this.bulkPublish(this.prod_dest, messages, null, null, null, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-1", "exit");
    }

    public void bulkSend(Message[] messages, int[] deliveryModes, int[] priorities, long[] timesToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-2", "entry");
        this.checkClosed("bulkSend(msg,mode,prio,ttl)");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("bulkSend is called without a valid Destination");
        }
        if (this.prod_dest.isQueue()) {
            this.bulkSend(this.prod_dest, messages, deliveryModes, priorities, timesToLive, null, null);
        } else {
            this.bulkPublish(this.prod_dest, messages, deliveryModes, priorities, timesToLive, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-2", "exit");
    }

    public void bulkSend(Destination destination, Message[] messages) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-3", "entry");
        this.checkClosed("bulkSend(dest,msg)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.bulkSend((Queue)destination, messages, null, null, null, null, null);
        } else {
            this.bulkPublish((Topic)destination, messages, null, null, null, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public void bulkSend(Destination destination, Message[] messages, int[] deliveryModes, int[] priorities, long[] timesToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-4", "entry");
        this.checkClosed("bulkSend(dest,msg,mode,prio,ttl)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.bulkSend((Queue)destination, messages, deliveryModes, priorities, timesToLive, null, null);
        } else {
            this.bulkPublish((Topic)destination, messages, deliveryModes, priorities, timesToLive, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-4", "exit");
    }

    synchronized void bulkSend(Queue queue, Message[] messages, int[] deliveryModes, int[] priorities, long[] timesToLive, Integer seq_deviation, byte[] relative_msg_id) throws JMSException {
        AQjmsDestination dest_queue = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "entry");
        if (messages == null) {
            AQjmsError.throwEx(133);
        }
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i] != null) continue;
            AQjmsError.throwEx(133);
        }
        if (queue == null) {
            if (this.prod_dest == null || this.prod_dest.getQueueName() == null) {
                AQjmsError.throwInvalidDestEx(143);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "prod_dest: " + this.prod_dest.getCompleteName());
                dest_queue = this.prod_dest;
            }
        } else if (queue.getQueueName() != null) {
            if (queue instanceof AQjmsDestination) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "queue: " + ((AQjmsDestination)queue).getCompleteName());
                dest_queue = (AQjmsDestination)queue;
            } else {
                AQjmsError.throwInvalidDestEx(125);
            }
        } else {
            AQjmsError.throwInvalidDestEx(143);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "dest_queue: " + dest_queue.getCompleteName());
        this.bulkEnqueue(dest_queue, messages, deliveryModes, priorities, timesToLive, seq_deviation, relative_msg_id, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "exit");
    }

    private AQjmsMessageHeaderExt getHeaderWithProperties(Message message, AQjmsConnection jms_conn) throws JMSException {
        AQjmsMessageHeaderExt header_ext = null;
        AQjmsPropertyList prop_list = null;
        AQjmsAgent dummy_agt = null;
        String userid = null;
        try {
            if (!(message instanceof AQjmsAdtMessage)) {
                header_ext = ((AQjmsMessage)message).getMessageHeaderExt();
                if (header_ext.getReplyto() == null) {
                    dummy_agt = new AQjmsAgent(" ", null, 0);
                    header_ext.setReplyto(dummy_agt);
                }
                userid = jms_conn.getUserName();
                header_ext.setUserid(userid);
                prop_list = AQjmsMessage.convertHashtableToPropertyList(((AQjmsMessage)message).getPropertiesHashtable());
                header_ext.setProperties(prop_list);
            }
        }
        catch (SQLException sqlex) {
            throw new AQjmsException(sqlex);
        }
        return header_ext;
    }

    private OracleArray convertToORADATAArray(Message[] messages, AQjmsDestination msg_dest, AQjmsConnection jms_conn, Connection db_conn) throws JMSException, SQLException {
        OracleArray msg_array = null;
        AQjmsGenMessage_C[] gen_array = null;
        AQjmsTextMessage_C[] text_array = null;
        AQjmsBytesMessage_C[] bytes_array = null;
        AQjmsStreamMessage_C[] stream_array = null;
        AQjmsMapMessage_C[] map_array = null;
        AQjmsObjectMessage_C[] object_array = null;
        String dest_type = null;
        AQjmsMessageHeaderExt header_ext = null;
        dest_type = this.getAdtType(msg_dest);
        if (dest_type.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            gen_array = new AQjmsGenMessage_C[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                if (messages[i] instanceof AQjmsTextMessage) {
                    gen_array[i] = ((AQjmsTextMessage)messages[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messages[i] instanceof AQjmsBytesMessage) {
                    gen_array[i] = ((AQjmsBytesMessage)messages[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messages[i] instanceof AQjmsStreamMessage) {
                    gen_array[i] = ((AQjmsStreamMessage)messages[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messages[i] instanceof AQjmsMapMessage) {
                    gen_array[i] = ((AQjmsMapMessage)messages[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messages[i] instanceof AQjmsObjectMessage) {
                    gen_array[i] = ((AQjmsObjectMessage)messages[i]).getGenMessageCont(this.jms_sess, true, true);
                }
                header_ext = this.getHeaderWithProperties(messages[i], jms_conn);
                if (header_ext == null) continue;
                gen_array[i].setHeader(header_ext);
            }
            msg_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_MESSAGES", (Object)gen_array);
        } else if (dest_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            text_array = new AQjmsTextMessage_C[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                if (!(messages[i] instanceof AQjmsTextMessage)) continue;
                text_array[i] = (AQjmsTextMessage_C)((AQjmsTextMessage)messages[i]).getMessageCont(this.jms_sess, true, true);
                header_ext = this.getHeaderWithProperties(messages[i], jms_conn);
                if (header_ext == null) continue;
                text_array[i].setHeader(header_ext);
            }
            msg_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_TEXT_MESSAGES", (Object)text_array);
        } else if (dest_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            bytes_array = new AQjmsBytesMessage_C[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                if (!(messages[i] instanceof AQjmsBytesMessage)) continue;
                bytes_array[i] = (AQjmsBytesMessage_C)((AQjmsBytesMessage)messages[i]).getMessageCont(this.jms_sess, true, true);
                header_ext = this.getHeaderWithProperties(messages[i], jms_conn);
                if (header_ext == null) continue;
                bytes_array[i].setHeader(header_ext);
            }
            msg_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_BYTES_MESSAGES", (Object)bytes_array);
        } else if (dest_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            stream_array = new AQjmsStreamMessage_C[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                if (!(messages[i] instanceof AQjmsStreamMessage)) continue;
                stream_array[i] = (AQjmsStreamMessage_C)((AQjmsStreamMessage)messages[i]).getMessageCont(this.jms_sess, true, true);
                header_ext = this.getHeaderWithProperties(messages[i], jms_conn);
                if (header_ext == null) continue;
                stream_array[i].setHeader(header_ext);
            }
            msg_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_STREAM_MESSAGES", (Object)stream_array);
        } else if (dest_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            map_array = new AQjmsMapMessage_C[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                if (!(messages[i] instanceof AQjmsMapMessage)) continue;
                map_array[i] = (AQjmsMapMessage_C)((AQjmsMapMessage)messages[i]).getMessageCont(this.jms_sess, true, true);
                header_ext = this.getHeaderWithProperties(messages[i], jms_conn);
                if (header_ext == null) continue;
                map_array[i].setHeader(header_ext);
            }
            msg_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_MAP_MESSAGES", (Object)map_array);
        } else if (dest_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            object_array = new AQjmsObjectMessage_C[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                if (!(messages[i] instanceof AQjmsObjectMessage)) continue;
                object_array[i] = (AQjmsObjectMessage_C)((AQjmsObjectMessage)messages[i]).getMessageCont(this.jms_sess, true, true);
                header_ext = this.getHeaderWithProperties(messages[i], jms_conn);
                if (header_ext == null) continue;
                object_array[i].setHeader(header_ext);
            }
            msg_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_OBJECT_MESSAGES", (Object)object_array);
        } else {
            AQjmsError.throwEx(127);
        }
        return msg_array;
    }

    private OracleArray convertToMessagePropertyArray(AQjmsDestination msg_dest, Message[] messages, int[] priorities, long[] timesToLive, AQjmsAgent[][] recipient_list_array, Connection db_conn) throws SQLException, JMSException {
        AQjmsMessageProperty[] msgprops = null;
        OracleArray msgprops_array = null;
        AQjmsRecipients recipients = null;
        Integer priority = null;
        Integer expiration = null;
        Integer delay = null;
        msgprops = new AQjmsMessageProperty[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            msgprops[i] = new AQjmsMessageProperty();
            if (!msg_dest.isSharded() && ((AQjmsMessage)messages[i]).isJMSBody() && this.jms_sess.getCompliant()) {
                priority = new Integer(AQjmsMessage.toJMSPriority(priorities[i]));
                msgprops[i].setPriority(priority);
            } else {
                priority = new Integer(priorities[i]);
                msgprops[i].setPriority(priority);
            }
            if (timesToLive[i] == 0L || timesToLive[i] == -1L) {
                expiration = new Integer(-1);
                msgprops[i].setExpiration(expiration);
            } else {
                expiration = new Integer((int)(timesToLive[i] / 1000L));
                msgprops[i].setExpiration(expiration);
            }
            msgprops[i].setDelay(this.getDelay());
            delay = new Integer(((AQjmsMessage)messages[i]).getDelay());
            if (delay != 0) {
                msgprops[i].setDelay(delay);
            }
            msgprops[i].setExceptionQueue(((AQjmsMessage)messages[i]).getExceptionQueue());
            msgprops[i].setSignature(((AQjmsMessage)messages[i]).getSignature());
            if (recipient_list_array != null && recipient_list_array[i] != null && recipient_list_array[i].length > 0) {
                recipients = new AQjmsRecipients(recipient_list_array[i]);
                msgprops[i].setRecipientList(recipients);
            }
            msgprops[i].setSenderId(((AQjmsMessage)messages[i]).getSenderID());
            msgprops[i].setCorrelation(((AQjmsMessage)messages[i]).getJMSCorrelationID());
        }
        msgprops_array = (OracleArray)((oracle.jdbc.OracleConnection)db_conn).createOracleArray("SYS.AQ$_JMS_MESSAGE_PROPERTIES", (Object)msgprops);
        return msgprops_array;
    }

    synchronized void bulkPublish(Topic topic, Message[] messages, int[] deliveryModes, int[] priorities, long[] timesToLive, Integer seq_deviation, byte[] relative_msg_id, AQjmsAgent[][] recipient_list_array) throws JMSException {
        AQjmsDestination dest_topic = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkPublish-5", "entry");
        this.checkClosed("bulkPublish(t,msg,mode,prio,ttl,seq..)");
        if (messages == null) {
            AQjmsError.throwEx(133);
        }
        if (topic == null) {
            if (this.prod_dest == null || this.prod_dest.getTopicName() == null) {
                AQjmsError.throwInvalidDestEx(166);
            } else {
                dest_topic = this.prod_dest;
            }
        } else if (topic instanceof AQjmsDestination) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.publish", "topic: " + ((AQjmsDestination)topic).getCompleteName());
            dest_topic = (AQjmsDestination)topic;
        } else {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (dest_topic.isSharded() && (this.jms_sess.is21compatible() || AQjmsConstants.USE_JDBC_ARRAY)) {
            this.bulkEnqueueSh(dest_topic, messages, deliveryModes, priorities, timesToLive, recipient_list_array);
        } else {
            this.bulkEnqueue(dest_topic, messages, deliveryModes, priorities, timesToLive, seq_deviation, relative_msg_id, recipient_list_array);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void bulkEnqueueSh(AQjmsDestination msg_dest, Message[] messages, int[] deliveryModes, int[] priorities, long[] timesToLive, AQjmsAgent[][] recipient_list_array) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkEnqueueSh", "entry");
        AQjmsMessage[] ojmsMessages = new AQjmsMessage[messages.length];
        JMSMessage[] jmsMsgs = new JMSMessage[messages.length];
        AQMessageProperties[] msgpropArr = new AQMessageProperties[messages.length];
        Message message = null;
        AQjmsMessage ojmsMessage = null;
        JMSMessage jmsMsg = null;
        AQMessageProperties msgprop = null;
        AQjmsMessageHeaderExt headerExt = null;
        JMSEnqueueOptions jmsEnqOpt = null;
        int idx = 0;
        long msgTimestamp = System.currentTimeMillis();
        String destName = msg_dest.getCompleteName();
        boolean receiptFlg = recipient_list_array != null && recipient_list_array.length > 0;
        boolean ttlFlag = timesToLive != null && timesToLive.length > 0;
        boolean prtFlag = priorities != null && priorities.length > 0;
        String userName = null;
        byte[] msgId = null;
        int deliveryModeThis = 2;
        try {
            AQjmsConnection jmsConn;
            if (!this.lock("bulkEnqueueSh", -1L)) {
                AQjmsError.throwEx(122);
            }
            if ((jmsConn = this.jms_sess.getJmsConnection()) != null) {
                userName = jmsConn.getUserName();
            }
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.bulkEnqueueSh", ex);
        }
        finally {
            try {
                this.unlock("bulkEnqueueSh");
            }
            catch (Throwable ex) {}
        }
        try {
            for (idx = 0; idx < messages.length; ++idx) {
                ojmsMessage = (AQjmsMessage)AQjmsProducer.convertForeignMessage(this.jms_sess, messages[idx]);
                if (msg_dest.isTopic() && !(ojmsMessage instanceof AQjmsAdtMessage)) {
                    ojmsMessage.setStringProperty2("JMS_OracleConnectionID", this.connection_id);
                }
                ojmsMessage.setJMSTimestamp(msgTimestamp);
                msgprop = AQFactory.createAQMessageProperties();
                msgprop.setDelay(this.getDelay());
                if (ojmsMessage.getDelay() != 0) {
                    msgprop.setDelay(ojmsMessage.getDelay());
                }
                msgprop.setExceptionQueue(ojmsMessage.getExceptionQueue());
                if (prtFlag && priorities.length > idx) {
                    msgprop.setPriority(priorities[idx]);
                }
                msgprop.setCorrelation(ojmsMessage.getJMSCorrelationID());
                AQjmsAgent sender = ojmsMessage.getSenderID();
                if (sender != null) {
                    AQAgent aqSender = AQFactory.createAQAgent();
                    aqSender.setName(sender.getName());
                    aqSender.setAddress(sender.getAddress());
                    aqSender.setProtocol(sender.getProtocol());
                    msgprop.setSender(aqSender);
                }
                if (receiptFlg && recipient_list_array.length > idx && recipient_list_array[idx] != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "recipient list specified");
                    AQAgent[] aqRecpList = new AQAgent[recipient_list_array[idx].length];
                    for (int i = 0; i < recipient_list_array[idx].length; ++i) {
                        aqRecpList[i] = AQFactory.createAQAgent();
                        aqRecpList[i].setAddress(recipient_list_array[idx][i].getAddress());
                        aqRecpList[i].setName(recipient_list_array[idx][i].getName());
                        aqRecpList[i].setProtocol(recipient_list_array[idx][i].getProtocol());
                    }
                    msgprop.setRecipientList(aqRecpList);
                }
                int ttlInSecond = 0;
                ttlInSecond = !ttlFlag || timesToLive.length < idx || timesToLive[idx] == 0L || timesToLive[idx] == -1L ? -1 : (int)timesToLive[idx] / 1000;
                msgprop.setExpiration(ttlInSecond);
                JMSMessageProperties jmsProps = JMSFactory.createJMSMessageProperties();
                String userProps = ojmsMessage.getUserProperties();
                jmsProps.setUserProperties(userProps);
                deliveryModeThis = deliveryModes == null || deliveryModes.length < idx ? 2 : deliveryModes[idx];
                if (!(ojmsMessage instanceof AQjmsAdtMessage)) {
                    headerExt = ojmsMessage.getMessageHeaderExt();
                    if (headerExt.getReplyto() == null) {
                        AQjmsAgent dummy_agt = new AQjmsAgent(" ", null, 0);
                        headerExt.setReplyto(dummy_agt);
                    }
                    headerExt.setUserid(userName);
                }
                String headerProps = ojmsMessage.getJmsHeaders(deliveryModeThis);
                jmsProps.setHeaderProperties(headerProps);
                JMSMessageProperties.JMSMessageType msgType = this.getTypeEnumOfJMSMessage(ojmsMessage);
                jmsProps.setJMSMessageType(msgType);
                jmsMsg = JMSFactory.createJMSMessage((JMSMessageProperties)jmsProps);
                jmsMsg.setPayload(ojmsMessage.getBytesCont());
                msgpropArr[idx] = msgprop;
                ojmsMessages[idx] = ojmsMessage;
                jmsMsgs[idx] = jmsMsg;
            }
            jmsEnqOpt = new JMSEnqueueOptions();
            jmsEnqOpt.setRetrieveMessageId(true);
            int visib = 2;
            jmsEnqOpt.setVisibility(AQjmsConstants.toJmsEnqueueVisibilityEnum(visib));
            int aqDeliveryMode = this.deliveryModeFromJMSToAQ(2);
            if (deliveryModes != null && deliveryModes.length > 0) {
                aqDeliveryMode = this.deliveryModeFromJMSToAQ(deliveryModes[0]);
            }
            jmsEnqOpt.setDeliveryMode(AQjmsConstants.toJmsEnqueueDeliveryModeEnum(aqDeliveryMode));
            try {
                if (!this.lock("bulkEnqueueSh", -1L)) {
                    AQjmsError.throwEx(122);
                }
                oracle.jdbc.internal.OracleConnection dbConn = (oracle.jdbc.internal.OracleConnection)this.jms_sess.getDBConnection();
                dbConn.jmsEnqueue(destName, jmsEnqOpt, jmsMsgs, msgpropArr);
            }
            catch (SQLException enqExcp) {
                AQjmsOracleDebug.traceEx(3, "AQjmsProducer.bulkEnqueueSh", enqExcp);
                if (enqExcp.getErrorCode() != 24033) {
                    throw new AQjmsException(enqExcp);
                }
            }
            finally {
                try {
                    this.unlock("bulkEnqueueSh");
                }
                catch (Throwable throwable) {}
            }
            for (idx = 0; idx < jmsMsgs.length; ++idx) {
                jmsMsg = jmsMsgs[idx];
                ojmsMessage = ojmsMessages[idx];
                message = messages[idx];
                msgId = jmsMsg.getMessageId();
                ojmsMessage.setJMSMessageID(msgId);
                ojmsMessage.setJMSDestination((Destination)msg_dest);
                ojmsMessage.setJMSXMaxRetries(msg_dest.getMaxRetries());
                if (deliveryModes != null && deliveryModes.length > 0) {
                    ojmsMessage.setJMSDeliveryMode(deliveryModes[idx]);
                }
                if (!ttlFlag || timesToLive.length < idx || timesToLive[idx] == 0L || timesToLive[idx] == -1L) {
                    ojmsMessage.setJMSExpiration(0L);
                } else {
                    ojmsMessage.setJMSExpiration(msgTimestamp + timesToLive[idx]);
                }
                if (prtFlag && priorities.length > idx) {
                    ojmsMessage.setJMSPriority(priorities[idx]);
                }
                if (message == ojmsMessage) continue;
                AQjmsProducer.copyAQjmsMessageSendHeaders(ojmsMessage, message);
            }
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (JMSException jmsEx) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.bulkEnqueueSh", jmsEx);
            throw jmsEx;
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.bulkEnqueueSh", e);
            throw new AQjmsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void bulkEnqueue(AQjmsDestination msg_dest, Message[] messages, int[] deliveryModes, int[] priorities, long[] timesToLive, Integer seq_deviation, byte[] relative_msg_id, AQjmsAgent[][] recipient_list_array) throws JMSException {
        Connection db_conn = null;
        AQjmsConnection jms_conn = null;
        String q_name = "";
        OracleCallableStatement enq_stmt = null;
        Map<String, Class<?>> map = null;
        boolean gen_pload = false;
        boolean is_anydata_dest = false;
        Message[] orig_msgs = null;
        OracleArray messages_array = null;
        OracleArray msgprops_array = null;
        OracleArray msgids_array = null;
        byte[][] msgids = null;
        AQjmsArrayErrors errors_c = null;
        AQjmsArrayErrorInfo[] errors = null;
        AQjmsException jms_ex = null;
        String adt_type = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkEnqueue", "entry");
        if (msg_dest.isSharded()) {
            msg_dest.setAdtType("SYS.AQ$_JMS_MESSAGE");
        }
        try {
            int i;
            if (msg_dest == null) {
                AQjmsError.throwEx(127);
            }
            Date curr_date = new Date();
            if (!this.lock("bulkEnqueue", -1L)) {
                AQjmsError.throwEx(122);
            }
            jms_conn = this.jms_sess.getJmsConnection();
            adt_type = this.getAdtType(msg_dest);
            is_anydata_dest = adt_type.equalsIgnoreCase("SYS.ANYDATA");
            boolean usingOCI = false;
            q_name = msg_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.bulkEnqueue", "q_name: " + q_name);
            try {
                db_conn = this.jms_sess.getDBConnection();
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            gen_pload = "SYS.AQ$_JMS_MESSAGE".equalsIgnoreCase(adt_type);
            if (messages == null) {
                AQjmsError.throwEx(133);
            }
            if (deliveryModes == null) {
                deliveryModes = new int[messages.length];
                for (int i2 = 0; i2 < messages.length; ++i2) {
                    deliveryModes[i2] = this.del_mode;
                }
            }
            if (priorities == null) {
                priorities = new int[messages.length];
                for (int i3 = 0; i3 < messages.length; ++i3) {
                    priorities[i3] = this.m_priority;
                }
            }
            if (timesToLive == null) {
                timesToLive = new long[messages.length];
                for (int i4 = 0; i4 < messages.length; ++i4) {
                    timesToLive[i4] = this.m_timetolive;
                }
            }
            orig_msgs = new Message[messages.length];
            for (i = 0; i < messages.length; ++i) {
                if (messages[i] == null) {
                    AQjmsError.throwEx(133);
                }
                orig_msgs[i] = messages[i];
                messages[i] = AQjmsProducer.convertForeignMessage(this.jms_sess, messages[i]);
                messages[i] = AQjmsProducer.convertHeaderMessage(messages[i], adt_type);
                this.checkMessageType(adt_type, messages[i], usingOCI);
            }
            messages_array = this.convertToORADATAArray(messages, msg_dest, jms_conn, db_conn);
            msgprops_array = this.convertToMessagePropertyArray(msg_dest, messages, priorities, timesToLive, recipient_list_array, db_conn);
            for (i = 0; i < messages.length; ++i) {
                if (((AQjmsMessage)messages[i]).isHeaderOnly()) {
                    ((AQjmsMessage)messages[i]).setStringProperty2("JMS_OracleHeaderOnly", "yes");
                }
                if (!(messages[i] instanceof AQjmsAdtMessage)) {
                    ((AQjmsMessage)messages[i]).setStringProperty2("JMS_OracleDeliveryMode", "" + deliveryModes[i]);
                }
                messages[i].setJMSTimestamp(curr_date.getTime());
                if (msg_dest.isTopic() && !(messages[i] instanceof AQjmsAdtMessage)) {
                    ((AQjmsMessage)messages[i]).setStringProperty2("JMS_OracleConnectionID", this.connection_id);
                }
                ((AQjmsMessage)messages[i]).validateUserProperties();
            }
            if (usingOCI) {
            } else {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
                map.put("SYS.AQ$_SIG_PROP", Class.forName("oracle.jms.AQjmsSignature"));
                map.put("SYS.AQ$_RECIPIENTS", Class.forName("oracle.jms.AQjmsRecipients"));
                map.put("SYS.AQ$_MESSAGE_PROPERTY", Class.forName("oracle.jms.AQjmsMessageProperty"));
                map.put("SYS.AQ$_JMS_ARRAY_ERROR_INFO", Class.forName("oracle.jms.AQjmsArrayErrorInfo"));
                enq_stmt = this.jms_sess.getArrayEnqueueStmt(adt_type);
                enq_stmt.setString(1, q_name);
                enq_stmt.setObject(2, (Object)messages_array, 2003);
                enq_stmt.setObject(3, (Object)messages.length, 4);
                enq_stmt.setObject(4, (Object)msgprops_array, 2003);
                enq_stmt.setObject(5, (Object)2, 4);
                if (seq_deviation != null) {
                    if (seq_deviation == 2 || seq_deviation == 3) {
                        enq_stmt.setObject(7, (Object)seq_deviation, 4);
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.bulkEnqueue", "seq_dev: " + seq_deviation);
                        if (relative_msg_id != null) {
                            enq_stmt.setObject(6, (Object)relative_msg_id, -2);
                        } else {
                            enq_stmt.setNull(6, -2);
                        }
                    } else {
                        AQjmsError.throwEx(154);
                    }
                } else {
                    enq_stmt.setNull(7, 4);
                    enq_stmt.setNull(6, -2);
                }
                enq_stmt.setString(8, this.transfxm);
                enq_stmt.registerOutParameter(9, 2003, "SYS.AQ$_JMS_ARRAY_MSGIDS");
                enq_stmt.registerOutParameter(10, 2003, "SYS.AQ$_JMS_ARRAY_ERRORS");
                enq_stmt.registerOutParameter(11, 4);
                enq_stmt.execute();
                msgids_array = (OracleArray)enq_stmt.getArray(9);
                errors_c = (AQjmsArrayErrors)enq_stmt.getObject(10, AQjmsArrayErrors.getOracleDataFactory());
                if (errors_c != null) {
                    errors = errors_c.getArray();
                }
                msgids = (byte[][])msgids_array.getArray();
                for (i = 0; i < messages.length; ++i) {
                    if (errors == null) {
                        ((AQjmsMessage)messages[i]).setJMSMessageID(msgids[i]);
                    } else if (errors[i] == null) {
                        ((AQjmsMessage)messages[i]).setJMSMessageID(msgids[i]);
                    } else {
                        jms_ex = jms_ex == null ? new AQjmsException("Array enqueue error at position " + errors[i].getErrorPosition() + " with message " + errors[i].getErrorMsg(), 207) : new AQjmsException("Array enqueue error at position " + errors[i].getErrorPosition() + " with message " + errors[i].getErrorMsg(), 207, (Throwable)((Object)jms_ex));
                    }
                    if (errors != null && jms_ex != null) {
                        throw jms_ex;
                    }
                    messages[i].setJMSDestination((Destination)msg_dest);
                    ((AQjmsMessage)messages[i]).setJMSXMaxRetries(msg_dest.getMaxRetries());
                    messages[i].setJMSDeliveryMode(deliveryModes[i]);
                    if (timesToLive[i] == 0L || timesToLive[i] == -1L) {
                        messages[i].setJMSExpiration(0L);
                    } else {
                        messages[i].setJMSExpiration(curr_date.getTime() + timesToLive[i]);
                    }
                    messages[i].setJMSPriority(priorities[i]);
                    if (orig_msgs[i] == messages[i]) continue;
                    AQjmsProducer.copyAQjmsMessageSendHeaders(messages[i], orig_msgs[i]);
                }
                if (!this.jms_sess.isInTransactionRechecked()) {
                    this.jms_sess.forceCommit();
                }
            }
        }
        catch (JMSException jmsExp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.bulkEnqueue", jmsExp);
            throw jmsExp;
        }
        catch (SQLException ex) {
            try {
                if (enq_stmt != null) {
                    this.jms_sess.destroyStmt(enq_stmt);
                }
            }
            catch (Exception ex2) {
                AQjmsOracleDebug.traceEx(5, "AQjmsProducer.enqueue-ex2", ex2);
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex3", ex);
            if (ex.getErrorCode() != 24033) {
                throw new AQjmsException(ex);
            }
        }
        catch (ClassNotFoundException ex2) {
            AQjmsError.throwEx(146, (Throwable)ex2);
        }
        catch (Exception ex3) {
            AQjmsError.throwEx(204, (Throwable)ex3);
        }
        finally {
            try {
                for (int i = 0; i < messages.length; ++i) {
                    ((AQjmsMessage)messages[i]).messageSendCallback(true);
                }
            }
            catch (Throwable i) {}
            try {
                this.unlock("bulkEnqueue");
            }
            catch (Throwable i) {}
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkEnqueue", "exit");
    }

    private int getTypeCodeOfJMSMessage(Message message) throws JMSException {
        int mType = 0;
        if (message instanceof AQjmsTextMessage) {
            mType = 0;
        } else if (message instanceof AQjmsBytesMessage) {
            mType = 1;
        } else if (message instanceof AQjmsStreamMessage) {
            mType = 2;
        } else if (message instanceof AQjmsMapMessage) {
            mType = 3;
        } else if (message instanceof AQjmsObjectMessage) {
            mType = 4;
        } else if (message instanceof AQjmsMessage) {
            mType = 100;
        } else {
            AQjmsError.throwEx(122, "wrong msg type");
        }
        return mType;
    }

    private JMSMessageProperties.JMSMessageType getTypeEnumOfJMSMessage(Message message) throws JMSException {
        if (message instanceof AQjmsTextMessage) {
            return JMSMessageProperties.JMSMessageType.TEXT_MESSAGE;
        }
        if (message instanceof AQjmsBytesMessage) {
            return JMSMessageProperties.JMSMessageType.BYTES_MESSAGE;
        }
        if (message instanceof AQjmsStreamMessage) {
            return JMSMessageProperties.JMSMessageType.STREAM_MESSAGE;
        }
        if (message instanceof AQjmsMapMessage) {
            return JMSMessageProperties.JMSMessageType.MAP_MESSAGE;
        }
        if (message instanceof AQjmsObjectMessage) {
            return JMSMessageProperties.JMSMessageType.OBJECT_MESSAGE;
        }
        if (message instanceof AQjmsMessage) {
            return JMSMessageProperties.JMSMessageType.MESSAGE;
        }
        AQjmsError.throwEx(122, "wrong msg type");
        return JMSMessageProperties.JMSMessageType.MESSAGE;
    }
}

