/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAConnection;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsJMSConsumer;
import oracle.jms.AQjmsJMSProducer;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;

public class AQjmsJMSContext
implements JMSContext,
AutoCloseable {
    private final AQjmsConnection connection;
    private final int sessionMode;
    private boolean autoStart = true;
    private static AtomicLong sessionCount = new AtomicLong(0L);
    private volatile Session session;
    private MessageProducer innerProducer;
    private boolean xa;
    private boolean closed;

    AQjmsJMSContext(AQjmsConnection connection, int sessionMode) throws JMSException {
        this.connection = connection;
        this.sessionMode = sessionMode;
        this.createSession();
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.constructor", "SessionCount: " + String.valueOf(sessionCount));
    }

    public void acknowledge() {
        try {
            ((AQjmsSession)this.session).acknowledge();
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(5, "AQjmsJMSContext.acknowledge() failed ", e);
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    @Override
    public void close() {
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.close", "entry");
        try {
            if (!this.closed && this.session != null) {
                this.session.close();
                sessionCount.decrementAndGet();
            }
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.close", "sessionCount : " + String.valueOf(sessionCount));
        if (sessionCount.get() == 0L) {
            try {
                AQjmsOracleDebug.trace(5, "AQjmsJMSContext.close", "close connection");
                this.connection.close();
            }
            catch (JMSException e) {
                throw AQjmsUtil.convertToRuntimeException(e);
            }
        }
        this.closed = true;
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.close", "exit");
    }

    public void commit() {
        try {
            if (this.session != null) {
                this.session.commit();
            }
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        try {
            return this.session.createBrowser(queue);
        }
        catch (JMSException e) {
            if (e instanceof InvalidDestinationException) {
                throw new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        try {
            return this.session.createBrowser(queue, messageSelector);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public BytesMessage createBytesMessage() {
        try {
            return this.session.createBytesMessage();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createConsumer(destination));
            return consumer;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String selector) {
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createConsumer(destination, selector));
            return consumer;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String selector, boolean noLocal) {
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createConsumer(destination, selector, noLocal));
            return consumer;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSContext createContext(int sessionMode) {
        try {
            AQjmsOracleDebug.trace(5, "AQjmsJMSContext.createContext", "entry");
            if (!this.closed && this.connection != null) {
                return new AQjmsJMSContext(this.connection, sessionMode);
            }
            AQjmsError.throwIllegalStateEx(114, null);
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(1, "AQjmsJMSContext.createContext", e);
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        return null;
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createDurableConsumer(topic, name));
            return consumer;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) {
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createDurableConsumer(topic, name, selector, noLocal));
            return consumer;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public MapMessage createMapMessage() {
        try {
            return this.session.createMapMessage();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public Message createMessage() {
        try {
            return this.session.createMessage();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage() {
        try {
            return this.session.createObjectMessage();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        try {
            return this.session.createObjectMessage(object);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSProducer createProducer() {
        try {
            return new AQjmsJMSProducer(this.session, this.getInternalProducer(), this);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    private synchronized MessageProducer getInternalProducer() throws JMSException {
        if (this.innerProducer == null) {
            this.innerProducer = this.session.createProducer(null);
        }
        return this.innerProducer;
    }

    public Queue createQueue(String queueName) {
        try {
            return this.session.createQueue(queueName);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedConsumer(Topic arg0, String arg1) {
        return null;
    }

    public JMSConsumer createSharedConsumer(Topic arg0, String arg1, String arg2) {
        return null;
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.createSharedDurableConsumer", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.createSharedDurableConsumer", "name : " + name);
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createSharedDurableConsumer(topic, name));
            return consumer;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String selector) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.createSharedDurableConsumer", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.createSharedDurableConsumer", "name : " + name);
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.createSharedDurableConsumer", "selector : " + selector);
        try {
            AQjmsJMSConsumer consumer = new AQjmsJMSConsumer(this, this.session.createSharedDurableConsumer(topic, name, selector));
            return consumer;
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(5, "AQjmsJMSContext.createSharedDurableConsumer() failed ", e);
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public StreamMessage createStreamMessage() {
        try {
            return this.session.createStreamMessage();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        try {
            return this.session.createTemporaryQueue();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.session.createTemporaryTopic();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public TextMessage createTextMessage() {
        try {
            return this.session.createTextMessage();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public TextMessage createTextMessage(String text) {
        try {
            return this.session.createTextMessage(text);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public Topic createTopic(String topicName) {
        try {
            return this.session.createTopic(topicName);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public boolean getTransacted() {
        try {
            return this.session.getTransacted();
        }
        catch (JMSException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void recover() {
        try {
            this.session.recover();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void rollback() {
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException e) {
            if (e instanceof IllegalStateException) {
                throw new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public void unsubscribe(String subscriberName) {
        try {
            this.session.unsubscribe(subscriberName);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    private void createSession() {
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.checkSession", "entry");
        try {
            this.session = this.xa ? ((XAConnection)this.connection).createXASession() : this.connection.createSession(this.sessionMode);
            sessionCount.getAndIncrement();
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsJMSContext.checkSession", e);
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSContext.checkSession", "exit");
    }
}

