/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Date;

public class AQjmsDestinationStats {
    private final String queueName;
    private final String ownerName;
    private final long enqueueCount;
    private final long dequeueCount;
    private final long expCount;
    private final long statTimeInMillis;
    private final Date statDate;
    private final long queueDepth;
    private final int type;
    private final int mode;
    public static final int APPROX_CACHE = 1;
    public static final int APPROX_NOCACHE = 2;
    public static final int EXACT = 3;
    public static final int APPROX_NOCACHE_EXCLUDE_ROLLBACK = 4;
    public static final int EXACT_FULL = 5;
    static final int DEFAULT_MODE = 3;

    AQjmsDestinationStats(String _queueName, String _ownerName, int _type, long _enqCnt, long _deqCnt, int _mode) {
        this.queueName = _queueName;
        this.ownerName = _ownerName;
        this.type = _type;
        this.enqueueCount = _enqCnt;
        this.dequeueCount = _deqCnt;
        this.queueDepth = this.enqueueCount - this.dequeueCount;
        this.statTimeInMillis = System.currentTimeMillis();
        this.statDate = new Date();
        this.mode = _mode;
        this.expCount = 0L;
    }

    AQjmsDestinationStats(String _queueName, String _ownerName, int _type, long _enqCnt, long _deqCnt, long _expCnt, int _mode) {
        this.queueName = _queueName;
        this.ownerName = _ownerName;
        this.type = _type;
        this.enqueueCount = _enqCnt;
        this.dequeueCount = _deqCnt;
        this.expCount = _expCnt;
        this.queueDepth = this.enqueueCount - this.dequeueCount - this.expCount;
        this.statTimeInMillis = System.currentTimeMillis();
        this.statDate = new Date();
        this.mode = _mode;
    }

    AQjmsDestinationStats(String _queueName, String _ownerName, int _type, long _depth, int _mode) {
        this.queueName = _queueName;
        this.ownerName = _ownerName;
        this.type = _type;
        this.enqueueCount = 0L;
        this.dequeueCount = 0L;
        this.queueDepth = _depth;
        this.statTimeInMillis = System.currentTimeMillis();
        this.statDate = new Date();
        this.mode = _mode;
        this.expCount = 0L;
    }

    public long getDepth() {
        return this.queueDepth;
    }

    public long getEnqueueCount() {
        return this.enqueueCount;
    }

    public long getDequeueCount() {
        return this.dequeueCount;
    }

    public long getExpiredCount() {
        return this.expCount;
    }

    public long getStatsTimeMills() {
        return this.statTimeInMillis;
    }

    public Date getStatsDate() {
        return this.statDate;
    }

    public boolean isQueue() {
        return this.type == 10;
    }

    public boolean isTopic() {
        return this.type == 20;
    }
}

