/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.ArrayList;
import javax.jms.JMSException;
import oracle.jdbc.internal.JMSConsumerExceptionEvent;
import oracle.jdbc.internal.JMSConsumerExceptionListener;
import oracle.jms.AQjmsConsumerClosedException;
import oracle.jms.AQjmsDestinationClosedException;
import oracle.jms.AQjmsNtfRegistration;
import oracle.jms.AQjmsServerNotReachableException;
import oracle.jms.AQjmsSession;

public class AQjmsConsumerExceptionListener
implements JMSConsumerExceptionListener {
    int state;
    AQjmsNtfRegistration ntfReg;
    AQjmsSession session;

    public AQjmsConsumerExceptionListener(AQjmsNtfRegistration _ntfReg, AQjmsSession _session) {
        this.ntfReg = _ntfReg;
        this.session = _session;
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConsumerException(JMSConsumerExceptionEvent evnt) {
        if (this.state == 0) {
            return;
        }
        switch (evnt.getType()) {
            case 1: {
                AQjmsSession aQjmsSession = this.session;
                synchronized (aQjmsSession) {
                    this.raiseServerNotReachableException(this.session, evnt);
                    break;
                }
            }
            case 2: {
                this.raiseConsumerClosedException(this.session, evnt.getCause());
                break;
            }
            case 3: {
                this.raiseDestinationClosedException(this.session, evnt.getCause());
            }
        }
    }

    boolean isActive() {
        return this.state != 0;
    }

    void disable() {
        this.state = 1;
    }

    void raiseConsumerClosedException(AQjmsSession session, String cause) {
        if (this.state != 2) {
            return;
        }
        this.disable();
        AQjmsConsumerClosedException cce = new AQjmsConsumerClosedException(cause, 24035);
        session.getExceptionListener().onException((JMSException)cce);
    }

    void raiseDestinationClosedException(AQjmsSession session, String cause) {
        if (this.state != 2) {
            return;
        }
        this.disable();
        AQjmsDestinationClosedException dce = new AQjmsDestinationClosedException(cause, 24010);
        session.getExceptionListener().onException((JMSException)dce);
    }

    private void raiseServerNotReachableException(AQjmsSession session, JMSConsumerExceptionEvent evnt) {
        this.state = 0;
        ArrayList<AQjmsConsumerExceptionListener> excpListenerList = session.getConsumerExcpLsnrList();
        for (AQjmsConsumerExceptionListener excpListener : excpListenerList) {
            if (!excpListener.isActive()) continue;
            return;
        }
        AQjmsServerNotReachableException excp = new AQjmsServerNotReachableException(evnt.getCause(), 1034);
        session.getConsumerExcpLsnrList().clear();
        session.getExceptionListener().onException((JMSException)excp);
    }
}

