/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsTopicConnectionFactory;
import oracle.jms.AQjmsUtil;
import oracle.jms.AQjmsXAConnection;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.WebLogicHelper;

public class AQjmsXATopicConnectionFactory
extends AQjmsTopicConnectionFactory
implements XATopicConnectionFactory {
    private XADataSource m_xaDS = null;
    private AQjmsXAResourceFactory m_xaresFactory = null;

    AQjmsXATopicConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        super(string, string2, n, string3);
    }

    AQjmsXATopicConnectionFactory(String string, Properties properties) throws JMSException {
        super(string, properties);
    }

    AQjmsXATopicConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory aQjmsXAResourceFactory) throws JMSException {
        super(dataSource);
        this.m_xaresFactory = aQjmsXAResourceFactory;
    }

    AQjmsXATopicConnectionFactory(DataSource dataSource, String string, Properties properties) throws JMSException {
        super(dataSource, string, properties);
    }

    AQjmsXATopicConnectionFactory(String string, AQjmsXAResourceFactory aQjmsXAResourceFactory) throws JMSException {
        super(string);
        this.m_xaresFactory = aQjmsXAResourceFactory;
    }

    AQjmsXATopicConnectionFactory(XADataSource xADataSource) throws JMSException {
        this.m_xaDS = xADataSource;
    }

    AQjmsXATopicConnectionFactory(String string) throws JMSException {
        this.m_xaDS = (XADataSource)AQjmsUtil.lookupObject(string, XADataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory - constructor", "XADataSource name: " + string);
    }

    public AQjmsXATopicConnectionFactory() {
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        AQjmsXAConnection aQjmsXAConnection = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection", "enter");
        aQjmsXAConnection = this.createAllXAConnection(20);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection", "XATopicConnection created successfully");
        return aQjmsXAConnection;
    }

    public XATopicConnection createXATopicConnection(String string, String string2) throws JMSException {
        AQjmsXAConnection aQjmsXAConnection = null;
        Object var4_4 = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection w/username/password", "enter");
        aQjmsXAConnection = this.createAllXAConnection(20, string, string2);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXATopicConnection w/username/password", "XATopicConnection created successfully");
        return aQjmsXAConnection;
    }

    public XAConnection createXAConnection() throws JMSException {
        AQjmsXAConnection aQjmsXAConnection = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection", "enter");
        aQjmsXAConnection = this.createAllXAConnection(30);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection", "XAConnection created successfully");
        return aQjmsXAConnection;
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        AQjmsXAConnection aQjmsXAConnection = null;
        Object var4_4 = null;
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection w/username/password", "enter");
        aQjmsXAConnection = this.createAllXAConnection(30, string, string2);
        AQjmsOracleDebug.trace(5, "AQjmsXATopicConnectionFactory.createXAConnection w/username/password", "XAConnection created successfully");
        return aQjmsXAConnection;
    }

    private AQjmsXAConnection createAllXAConnection(int n) throws JMSException {
        AQjmsXAConnection aQjmsXAConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsXAConnection = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, n);
        } else {
            aQjmsXAConnection = this.jdbc_conn_str != null ? new AQjmsXAConnection(this.jdbc_conn_str, this.jdbc_info, n) : (this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, null, null, n) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, n) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, n)));
        }
        aQjmsXAConnection.setCompliant(this.compliant);
        return aQjmsXAConnection;
    }

    private AQjmsXAConnection createAllXAConnection(int n, String string, String string2) throws JMSException {
        AQjmsXAConnection aQjmsXAConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsXAConnection = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, string, string2, n);
        } else {
            Properties properties = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (string != null || string2 != null) {
                        properties = (Properties)this.jdbc_info.clone();
                        properties.put("user", string);
                        properties.put("password", string2);
                    } else {
                        properties = this.jdbc_info;
                    }
                    aQjmsXAConnection = new AQjmsXAConnection(this.jdbc_conn_str, properties, n);
                } else {
                    aQjmsXAConnection = new AQjmsXAConnection(this.jdbc_conn_str, string, string2, n);
                }
            } else {
                aQjmsXAConnection = this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, string, string2, n) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, string, string2, n) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, n));
            }
        }
        aQjmsXAConnection.setCompliant(this.compliant);
        return aQjmsXAConnection;
    }
}

