/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDBConnMgr;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.AQjmsXASession;

public class AQjmsXAConnection
extends AQjmsConnection
implements XAConnection,
XAQueueConnection,
XATopicConnection {
    private XADataSource m_xaDS;
    private AQjmsXAResourceFactory m_xaresFactory;

    AQjmsXAConnection(String string, String string2, int n, String string3, String string4, String string5, int n2) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(string, string2, n, string3, string4, string5, true);
        this.initialize(n2);
    }

    AQjmsXAConnection(String string, Properties properties, int n) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(string, properties, true);
        this.initialize(n);
    }

    AQjmsXAConnection(String string, String string2, String string3, int n) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(string, string2, string3, true);
        this.initialize(n);
    }

    AQjmsXAConnection(DataSource dataSource, AQjmsXAResourceFactory aQjmsXAResourceFactory, String string, String string2, int n) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(dataSource, string, string2);
        this.m_xaresFactory = aQjmsXAResourceFactory;
        this.initialize(n);
    }

    AQjmsXAConnection(XADataSource xADataSource, String string, String string2, int n) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(xADataSource, string, string2);
        this.initialize(n);
    }

    public synchronized XASession createXASession() throws JMSException {
        AQjmsXASession aQjmsXASession = null;
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXASession", "enter");
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(false);
        try {
            Connection connection = aQjmsGeneralDBConnection.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(connection);
            }
            aQjmsXASession = new AQjmsXASession(this, 30, aQjmsGeneralDBConnection, this.m_xaresFactory);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAConnection.createXASession", jMSException);
            throw jMSException;
        }
        finally {
            if (aQjmsXASession == null) {
                try {
                    if (aQjmsGeneralDBConnection != null) {
                        aQjmsGeneralDBConnection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXASession", "exit");
        return aQjmsXASession;
    }

    public synchronized XAQueueSession createXAQueueSession() throws JMSException {
        AQjmsXASession aQjmsXASession = null;
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXAQueueSession", "enter");
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.conn_type != 10) {
            AQjmsError.throwEx(107, this.conn_type == 20 ? "XATopicConnection" : "XAConnection");
        }
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(false);
        try {
            Connection connection = aQjmsGeneralDBConnection.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(connection);
            }
            aQjmsXASession = new AQjmsXASession(this, 10, aQjmsGeneralDBConnection, this.m_xaresFactory);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAConnection.createXAQueueSession", jMSException);
            throw jMSException;
        }
        finally {
            if (aQjmsXASession == null) {
                try {
                    if (aQjmsGeneralDBConnection != null) {
                        aQjmsGeneralDBConnection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXAQueueSession", "exit");
        return aQjmsXASession;
    }

    public synchronized XATopicSession createXATopicSession() throws JMSException {
        AQjmsXASession aQjmsXASession = null;
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXATopicSession", "enter");
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.conn_type != 20) {
            AQjmsError.throwEx(107, this.conn_type == 10 ? "XAQueueConnection" : "XAConnection");
        }
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(false);
        try {
            Connection connection = aQjmsGeneralDBConnection.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(connection);
            }
            aQjmsXASession = new AQjmsXASession(this, 20, aQjmsGeneralDBConnection, this.m_xaresFactory);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAConnection.createXATopicSession", jMSException);
            throw jMSException;
        }
        finally {
            if (aQjmsXASession == null) {
                try {
                    if (aQjmsGeneralDBConnection != null) {
                        aQjmsGeneralDBConnection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXATopicSession", "exit");
        return aQjmsXASession;
    }
}

