/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsSubscriberFactory
implements ObjectFactory {
    private String ag_name = null;
    private String address = null;
    private int protocol = 0;
    private String certificate = null;
    private String rule = null;
    private String transformation = null;
    private String sub_owner = null;
    static final String ALIAS_TYPE = "alias";
    static final String AGENT_TYPE = "agent";
    static final String AQSUB_TYPE = "aq_subscriber";
    static final String JMSUB_TYPE = "jms_subscriber";
    static final String RULE_ATTR = "rule";
    static final String TRANS_ATTR = "transformation";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws JMSException {
        Reference reference = (Reference)object;
        AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "entry");
        if (reference == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!reference.getClassName().equals("oracle.jms.AQjmsConsumer") && !reference.getClassName().equals("oracle.jms.AQjmsAgent")) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "unable to manufacture object of class: " + reference.getClassName());
            return null;
        }
        try {
            Object object2;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = ((DirContext)context).search(name, "(objectclass=*)", searchControls);
            if (namingEnumeration == null) {
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "failed to search attributes of subscriber " + name.get(0));
                return null;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            String string = (String)attributes.get("orclDBAQObjType").get();
            AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "obj_typ " + string);
            while (string.toLowerCase().equals(ALIAS_TYPE)) {
                object2 = (String)attributes.get("orclDBAQPointerAttr").get();
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "obj_dn " + (String)object2);
                InitialDirContext initialDirContext = new InitialDirContext(hashtable);
                namingEnumeration = initialDirContext.search((String)object2, "(objectclass=*)", searchControls);
                if (namingEnumeration == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "failed to search attributes of object " + (String)object2);
                    return null;
                }
                searchResult = namingEnumeration.next();
                attributes = searchResult.getAttributes();
                string = (String)attributes.get("orclDBAQObjType").get();
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "obj_typ2 " + string);
            }
            if (string.toLowerCase().equals(AGENT_TYPE) || string.toLowerCase().equals(AQSUB_TYPE) || string.toLowerCase().equals(JMSUB_TYPE)) {
                object2 = (String)attributes.get("cn").get();
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "cn " + (String)object2);
                int n = string.toLowerCase().equals(JMSUB_TYPE) ? ((String)object2).indexOf(46) + 1 : 0;
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "idx3 " + n);
                int n2 = ((String)object2).indexOf(58);
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "idx1 " + n2);
                int n3 = n2 == -1 ? -1 : ((String)object2).indexOf(58, n2 + 1);
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "idx2 " + n3);
                if (n3 == -1 || n == -1) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "attribute cn is of bad format " + (String)object2);
                    return null;
                }
                if (n2 > 0) {
                    this.ag_name = ((String)object2).substring(n, n2);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "ag_name " + this.ag_name);
                if (n3 - n2 > 1) {
                    this.address = ((String)object2).substring(n2 + 1, n3);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "address " + this.address);
                if (n3 < ((String)object2).length() - 1) {
                    String string2 = ((String)object2).substring(n3 + 1, ((String)object2).length());
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "pro " + string2);
                    this.protocol = Integer.valueOf(string2);
                }
            }
            if (string.toLowerCase().equals(AGENT_TYPE)) {
                object2 = attributes.get("orclDBAQPointerAttr");
                if (object2 == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "certificate = null ");
                } else {
                    this.certificate = (String)object2.get();
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "certificate " + this.certificate);
                }
                AQjmsAgent aQjmsAgent = new AQjmsAgent(this.ag_name, this.address, this.protocol);
                AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "Agents exit");
                return aQjmsAgent;
            }
            if (string.toLowerCase().equals(AQSUB_TYPE)) {
                object2 = attributes.get("orclDBAQGeneric");
                for (int i = 0; i < object2.size(); ++i) {
                    String string3 = (String)object2.get(i);
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "val " + string3);
                    if (string3.toLowerCase().startsWith(RULE_ATTR)) {
                        this.rule = string3.substring(RULE_ATTR.length() + 1);
                        AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "rule " + this.rule);
                        continue;
                    }
                    if (!string3.toLowerCase().startsWith(TRANS_ATTR)) continue;
                    this.transformation = string3.substring(TRANS_ATTR.length() + 1);
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "transformation " + this.transformation);
                }
                AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", " Subscriber exit");
                return null;
            }
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSubscriberFactory.getObjectInstance", namingException);
            AQjmsError.throwEx(205, (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSubscriberFactory.getObjectInstance", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "exit");
        return null;
    }
}

