/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.DispatchScheduler;

public class AQjmsStatScheduler
implements DispatchScheduler {
    long m_minSleepTime;
    long m_maxSleepTime;
    long m_duration = 0L;
    long m_lastEnqueueTime = -1L;
    String m_id;

    public AQjmsStatScheduler() {
        this(null, AQjmsConstants.getMinSleepTime(), AQjmsConstants.getMaxSleepTime());
    }

    public AQjmsStatScheduler(String string) {
        this(string, AQjmsConstants.getMinSleepTime(), AQjmsConstants.getMaxSleepTime());
    }

    public AQjmsStatScheduler(String string, long l, long l2) {
        this.m_id = string;
        this.m_minSleepTime = l;
        this.m_maxSleepTime = l2;
    }

    @Override
    public void feedException(int n, Exception exception) {
        this.m_duration = AQjmsConstants.getListenerRetry();
        if (this.m_duration > this.m_maxSleepTime) {
            this.m_duration = this.m_maxSleepTime;
        }
    }

    @Override
    public void feedData(Message message) {
        if (message == null) {
            this.m_duration = this.m_duration == 0L ? this.m_minSleepTime : (this.m_duration *= 2L);
            AQjmsOracleDebug.trace(3, "AQjmsStatScheduler.feedData", "Got a null message, the sleep time is doubled to " + this.m_duration);
        } else {
            long l = 0L;
            try {
                l = message.getJMSTimestamp();
            }
            catch (JMSException jMSException) {
                AQjmsOracleDebug.traceEx(3, "SimpleScheduler.feeData: getJMSTimestamp method failed", jMSException);
                return;
            }
            if (this.m_duration != 0L && this.m_lastEnqueueTime != -1L) {
                this.m_duration = l - this.m_lastEnqueueTime;
                AQjmsOracleDebug.trace(3, "AQjmsStatScheduler.feedData", "Got a non null message, the previous enqueue time is " + this.m_lastEnqueueTime + "\nthis enqueue time is " + l + ". the sleep time set to " + this.m_duration);
            } else {
                this.m_duration = 0L;
            }
            this.m_lastEnqueueTime = l;
        }
        if (this.m_duration > this.m_maxSleepTime) {
            this.m_duration = this.m_maxSleepTime;
        }
        if (this.m_duration < 0L) {
            this.m_duration = 0L;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSimpleScheduler.feedData", "The sleep time is normalized to " + this.m_duration);
    }

    @Override
    public long getNextSleepTime() {
        long l = this.m_duration < this.m_minSleepTime ? 0L : (this.m_duration > this.m_maxSleepTime ? this.m_maxSleepTime : this.m_duration);
        return l;
    }
}

