/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import oracle.jdbc.util.RepConversion;

class AQjmsMessageID {
    private byte[] systemMsgID = null;
    private String userSetID = null;
    private boolean hasUserSetID = false;

    AQjmsMessageID() {
    }

    synchronized String getJMSMessageID() {
        if (this.hasUserSetID) {
            return this.userSetID;
        }
        if (this.systemMsgID != null) {
            return "ID:" + RepConversion.bArray2String((byte[])this.systemMsgID);
        }
        return null;
    }

    synchronized String getPartialJMSMessageID() {
        if (this.hasUserSetID) {
            return this.userSetID;
        }
        if (this.systemMsgID != null) {
            return RepConversion.bArray2String((byte[])this.systemMsgID);
        }
        return null;
    }

    synchronized byte[] getJMSMessageIDAsBytes() {
        if (this.systemMsgID != null) {
            byte[] byArray = new byte[this.systemMsgID.length];
            System.arraycopy(this.systemMsgID, 0, byArray, 0, this.systemMsgID.length);
            return byArray;
        }
        return null;
    }

    synchronized void setJMSMessageID(byte[] byArray) {
        this.systemMsgID = byArray;
        this.userSetID = null;
        this.hasUserSetID = false;
    }

    synchronized void setJMSMessageID(String string) {
        this.userSetID = string;
        this.hasUserSetID = true;
    }
}

