/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import oracle.jdbc.OracleConnection;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsJDBCConnInfo;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;

class AQjmsExceptionListener
extends Thread
implements ExceptionListener {
    public static final long DEFAULT_PING_PERIOD = 120000L;
    private static final String PING_QUERY = "SELECT banner FROM v$version where 1<>1";
    private PreparedStatement m_pstmt;
    private ExceptionListener m_el;
    private long m_period = 120000L;
    private boolean m_stop = false;
    private boolean m_suspended = true;
    private boolean m_registered = false;
    private Connection m_dbConn;
    private AQjmsGeneralDBConnection m_genConn;
    private Object expLock = new Object();
    private JMSException expFromMessageListener;
    private AQjmsJDBCConnInfo jdbcInfo = null;
    private AQjmsConnection parentJmsConn = null;
    private Set<String> queueSet = new HashSet<String>();

    AQjmsExceptionListener(AQjmsGeneralDBConnection aQjmsGeneralDBConnection) throws JMSException {
        this.m_genConn = aQjmsGeneralDBConnection;
        this.m_dbConn = aQjmsGeneralDBConnection.getDBConnection();
        this.jdbcInfo = AQjmsUtil.getJDBCConnInfo((OracleConnection)this.m_dbConn);
        try {
            this.m_pstmt = this.m_dbConn.prepareStatement(PING_QUERY);
            this.m_pstmt.setQueryTimeout(1);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener constructor", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", "Setup Exception Listener DB Connection: " + this.jdbcInfo + "Time Now " + new Date());
    }

    synchronized void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener == null) {
            this.m_registered = false;
        } else {
            this.m_registered = true;
            if (!this.isAlive()) {
                this.start();
            }
        }
        this.m_el = exceptionListener;
    }

    ExceptionListener getExceptionListener() {
        return this.m_el;
    }

    void setParentJmsConn(AQjmsConnection aQjmsConnection) {
        this.parentJmsConn = aQjmsConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        ExceptionListener exceptionListener;
        block16: {
            try {
                if (this.parentJmsConn == null || this.parentJmsConn.queueSet == null) break block16;
                this.queueSet.clear();
                exceptionListener = this.parentJmsConn.queueSet;
                synchronized (exceptionListener) {
                    this.queueSet.addAll(this.parentJmsConn.queueSet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ": calling onException for : " + this.jdbcInfo + "Queue List: " + this.queueSet + "Time Now " + new Date());
        exceptionListener = null;
        Object object = this;
        synchronized (object) {
            exceptionListener = this.m_el;
        }
        if (exceptionListener != null) {
            try {
                object = jMSException.getLinkedException();
                if (object != null && ((Throwable)object).getMessage() == null) {
                    String string = object.getClass().getName();
                    String string2 = "Exception from " + string;
                    AQjmsException aQjmsException = new AQjmsException(string2, (Throwable)object);
                    jMSException.setLinkedException((Exception)((Object)aQjmsException));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!this.m_stop) {
                    exceptionListener.onException(jMSException);
                }
                AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ": invoked onException for : " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
            }
            catch (RuntimeException runtimeException) {
                AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener: " + this.m_el + ": Exception thrown by onException().JDBC INFO: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date(), runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener:" + this.m_el + ": Exception thrown by onException() : " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date(), error);
                throw error;
            }
        }
        AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener:: Exception Listener obj is NULL :" + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date(), jMSException);
    }

    void setPingPeriod(long l) {
        if (l <= 0L) {
            return;
        }
        this.m_period = l;
    }

    long getPingPeriod() {
        return this.m_period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ":START: " + this.jdbcInfo + "Queue List" + this.queueSet + "Time Now " + new Date());
        while (!this.m_stop) {
            try {
                if (this.parentJmsConn != null && !this.parentJmsConn.isOpen()) {
                    AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ":ParentClosed: " + this.jdbcInfo + "Queue List" + this.queueSet + "Time Now " + new Date());
                    this.m_stop = true;
                }
                Object object = this;
                synchronized (object) {
                    this.wait(this.m_period);
                }
                try {
                    if (this.parentJmsConn != null && this.parentJmsConn.queueSet != null) {
                        this.queueSet.clear();
                        object = this.parentJmsConn.queueSet;
                        synchronized (object) {
                            this.queueSet.addAll(this.parentJmsConn.queueSet);
                        }
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", this.m_el + ":HeartBeat: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.m_registered || this.m_suspended) continue;
                ++n;
                if (this.checkNotifiedJMSException()) break;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", this.m_el + "executing query: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                this.m_pstmt.executeQuery();
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", this.m_el + "done executing query: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                if (!this.checkNotifiedJMSException()) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                if (!this.m_stop) continue;
                AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "run stopped " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                return;
            }
            catch (SQLException sQLException) {
                JMSException jMSException = new JMSException(sQLException.toString());
                this.onException(jMSException);
                this.m_stop = true;
            }
        }
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "CLOSED: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
    }

    synchronized void resumeExceptionListener() {
        if (this.m_suspended) {
            this.m_suspended = false;
        }
    }

    synchronized void suspendExceptionListener() {
        this.m_suspended = true;
    }

    void close() {
        try {
            Object object;
            try {
                AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "CLOSING: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                if (AQjmsOracleDebug.getTraceLevel() >= 1) {
                    object = "";
                    boolean bl = true;
                    String string = "";
                    for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        string = stackTraceElement.toString();
                        if (string.contains("oracle.jms")) continue;
                        object = (String)object + string + "\n";
                    }
                    AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "CLOSE INVOKED FROM " + (String)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.m_stop) {
                this.m_stop = true;
                if (this.isAlive()) {
                    object = this;
                    AccessController.doPrivileged(new PrivilegedAction((Thread)object){
                        final /* synthetic */ Thread val$expThread;
                        {
                            this.val$expThread = thread;
                        }

                        public Object run() {
                            this.val$expThread.interrupt();
                            return null;
                        }
                    });
                    try {
                        this.join(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "in close, InterruptedException caught");
                    }
                }
            }
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.m_pstmt = null;
            }
            try {
                this.m_genConn.close();
            }
            catch (JMSException jMSException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void feedJMSException(JMSException jMSException) {
        Object object = this.expLock;
        synchronized (object) {
            this.expFromMessageListener = jMSException;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNotifiedJMSException() {
        Object object = this.expLock;
        synchronized (object) {
            if (this.expFromMessageListener != null) {
                JMSException jMSException = this.expFromMessageListener;
                this.expFromMessageListener = null;
                this.onException(jMSException);
            }
        }
        return this.m_stop;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

