/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.AQ.AQException;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsDestinationFactory
implements ObjectFactory {
    private int type = 10;
    private String owner;
    private String qname;
    private String table;
    private int payload_type;
    private String p_data_type = null;
    private AQjmsDestinationProperty property = null;
    private String tabledn;
    static final String QTYPE_ATTR = "queuetype";
    static final String RETRY_ATTR = "maxretries";
    static final String INTVL_ATTR = "retryinterval";
    static final String RETEN_ATTR = "rentention";
    static final String PLTYP_ATTR = "payloadtype";
    static final String MUCSM_ATTR = "multiconsumers";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws JMSException {
        Reference reference = (Reference)object;
        AQjmsOracleDebug.trace(4, "AQjmsDestinationFactory.getObjectInstance", "entry");
        if (reference == null) {
            AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!reference.getClassName().equals("oracle.jms.AQjmsDestination")) {
            AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "unable to manufacture object of class: " + reference.getClassName());
            return null;
        }
        try {
            Object object2;
            String[] stringArray;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = ((DirContext)context).search(name, "(objectclass=*)", searchControls);
            if (namingEnumeration == null) {
                AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "failed to search attributes of queue " + name.get(0));
                return null;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            this.owner = (String)attributes.get("orclDBAQObjOwner").get();
            this.qname = (String)attributes.get("orclDBAQObjName").get();
            this.tabledn = (String)attributes.get("orclDBAQPointerAttr").get();
            this.property = new AQjmsDestinationProperty();
            Attribute attribute = attributes.get("orclDBAQGeneric");
            for (int i = 0; i < attribute.size(); ++i) {
                Integer n;
                stringArray = (String[])attribute.get(i);
                if (stringArray.toLowerCase().startsWith(QTYPE_ATTR)) {
                    n = Integer.valueOf(stringArray.substring(QTYPE_ATTR.length() + 1));
                    try {
                        this.property.setQueueType(n);
                    }
                    catch (AQException aQException) {
                        AQjmsError.throwEx(155, (Throwable)aQException);
                    }
                    continue;
                }
                if (stringArray.toLowerCase().startsWith(RETRY_ATTR)) {
                    n = Integer.valueOf(stringArray.substring(RETRY_ATTR.length() + 1));
                    this.property.setMaxRetries((int)n);
                    continue;
                }
                if (stringArray.toLowerCase().startsWith(INTVL_ATTR)) {
                    object2 = Double.valueOf(stringArray.substring(INTVL_ATTR.length() + 1));
                    this.property.setRetryInterval(((Double)object2).doubleValue());
                    continue;
                }
                if (!stringArray.toLowerCase().startsWith(RETEN_ATTR)) continue;
                object2 = Double.valueOf(stringArray.substring(RETEN_ATTR.length() + 1));
                this.property.setRetentionTime(((Double)object2).doubleValue());
            }
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            stringArray = new String[]{"orclDBAQObjOwner", "orclDBAQObjName", "orclDBAQGeneric"};
            searchControls.setReturningAttributes(stringArray);
            namingEnumeration = initialDirContext.search(this.tabledn, "(objectclass=*)", searchControls);
            if (namingEnumeration == null) {
                AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "failed to search attributes of queue table " + this.tabledn);
                return null;
            }
            searchResult = namingEnumeration.next();
            attributes = searchResult.getAttributes();
            attribute = attributes.get("orclDBAQGeneric");
            this.table = (String)attributes.get("orclDBAQObjName").get();
            for (int i = 0; i < attribute.size(); ++i) {
                String string;
                object2 = (String)attribute.get(i);
                if (((String)object2).toLowerCase().startsWith(PLTYP_ATTR)) {
                    string = ((String)object2).substring(PLTYP_ATTR.length() + 1);
                    if (string.toLowerCase().equals("raw")) {
                        this.p_data_type = null;
                        this.payload_type = 2;
                        continue;
                    }
                    this.p_data_type = new String(string);
                    this.payload_type = 1;
                    continue;
                }
                if (!((String)object2).toLowerCase().startsWith(MUCSM_ATTR)) continue;
                string = ((String)object2).substring(MUCSM_ATTR.length() + 1);
                this.type = string.toLowerCase().equals("true") ? 20 : 10;
            }
            AQjmsDestination aQjmsDestination = new AQjmsDestination(this.owner, this.qname, this.type, this.payload_type, this.p_data_type, this.property, this.table, false);
            AQjmsOracleDebug.trace(4, "AQjmsDestinationFactory.getObjectInstance", "exit");
            return aQjmsDestination;
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDestinationFactory.getObjectInstance", namingException);
            AQjmsError.throwEx(205, (Throwable)namingException);
            return null;
        }
    }
}

