/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.ArrayList;
import javax.jms.JMSException;
import oracle.jdbc.internal.JMSConsumerExceptionEvent;
import oracle.jdbc.internal.JMSConsumerExceptionListener;
import oracle.jms.AQjmsConsumerClosedException;
import oracle.jms.AQjmsDestinationClosedException;
import oracle.jms.AQjmsNtfRegistration;
import oracle.jms.AQjmsServerNotReachableException;
import oracle.jms.AQjmsSession;

public class AQjmsConsumerExceptionListener
implements JMSConsumerExceptionListener {
    int state;
    AQjmsNtfRegistration ntfReg;
    AQjmsSession session;

    public AQjmsConsumerExceptionListener(AQjmsNtfRegistration aQjmsNtfRegistration, AQjmsSession aQjmsSession) {
        this.ntfReg = aQjmsNtfRegistration;
        this.session = aQjmsSession;
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConsumerException(JMSConsumerExceptionEvent jMSConsumerExceptionEvent) {
        if (this.state == 0) {
            return;
        }
        switch (jMSConsumerExceptionEvent.getType()) {
            case 1: {
                AQjmsSession aQjmsSession = this.session;
                synchronized (aQjmsSession) {
                    this.raiseServerNotReachableException(this.session, jMSConsumerExceptionEvent);
                    break;
                }
            }
            case 2: {
                this.raiseConsumerClosedException(this.session, jMSConsumerExceptionEvent.getCause());
                break;
            }
            case 3: {
                this.raiseDestinationClosedException(this.session, jMSConsumerExceptionEvent.getCause());
            }
        }
    }

    boolean isActive() {
        return this.state != 0;
    }

    void disable() {
        this.state = 1;
    }

    void raiseConsumerClosedException(AQjmsSession aQjmsSession, String string) {
        if (this.state != 2) {
            return;
        }
        this.disable();
        AQjmsConsumerClosedException aQjmsConsumerClosedException = new AQjmsConsumerClosedException(string, 24035);
        aQjmsSession.getExceptionListener().onException((JMSException)aQjmsConsumerClosedException);
    }

    void raiseDestinationClosedException(AQjmsSession aQjmsSession, String string) {
        if (this.state != 2) {
            return;
        }
        this.disable();
        AQjmsDestinationClosedException aQjmsDestinationClosedException = new AQjmsDestinationClosedException(string, 24010);
        aQjmsSession.getExceptionListener().onException((JMSException)aQjmsDestinationClosedException);
    }

    private void raiseServerNotReachableException(AQjmsSession aQjmsSession, JMSConsumerExceptionEvent jMSConsumerExceptionEvent) {
        this.state = 0;
        ArrayList<AQjmsConsumerExceptionListener> arrayList = aQjmsSession.getConsumerExcpLsnrList();
        for (AQjmsConsumerExceptionListener aQjmsConsumerExceptionListener : arrayList) {
            if (!aQjmsConsumerExceptionListener.isActive()) continue;
            return;
        }
        AQjmsServerNotReachableException aQjmsServerNotReachableException = new AQjmsServerNotReachableException(jMSConsumerExceptionEvent.getCause(), 1034);
        aQjmsSession.getConsumerExcpLsnrList().clear();
        aQjmsSession.getExceptionListener().onException((JMSException)aQjmsServerNotReachableException);
    }
}

