/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.transaction.TransactionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;
import oracle.jakarta.jms.AQjmsOracleDebug;

public class WebLogicHelper {
    private static boolean s_runningInsideWLServer;
    private static XAResource s_ignoreXAResource;
    private static TransactionManager s_wlsTransactionManager;
    private static final String CLASS_NAME_ForeignAQIntegration = "weblogic.jms.foreign.ForeignAQIntegration";
    private static final String METHOD_NAME_createIgnoredXAResource = "createIgnoredXAResource";
    private static final String METHOD_NAME_isServer = "isServer";
    private static final String METHOD_NAME_getTransactionManager = "getTransactionManager";

    public static boolean runningInWLServer() {
        return s_runningInsideWLServer;
    }

    public static XAResource createIgnoredXAResource() {
        return s_ignoreXAResource;
    }

    public static TransactionManager getTranactionManager() {
        return s_wlsTransactionManager;
    }

    static {
        AQjmsOracleDebug.trace(3, "WeblogicHelper static initializer", "enter");
        try {
            Class<?> aqIntegrationClass = Class.forName(CLASS_NAME_ForeignAQIntegration);
            Method createIgnorXARMethod = aqIntegrationClass.getDeclaredMethod(METHOD_NAME_createIgnoredXAResource, new Class[0]);
            Method isServerMethod = aqIntegrationClass.getDeclaredMethod(METHOD_NAME_isServer, new Class[0]);
            Method getTransactionManager = aqIntegrationClass.getDeclaredMethod(METHOD_NAME_getTransactionManager, new Class[0]);
            s_runningInsideWLServer = (Boolean)isServerMethod.invoke(null, new Object[0]);
            s_ignoreXAResource = (XAResource)createIgnorXARMethod.invoke(null, new Object[0]);
            if (s_runningInsideWLServer) {
                s_wlsTransactionManager = (TransactionManager)getTransactionManager.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException cnfe) {
            s_runningInsideWLServer = false;
            s_ignoreXAResource = null;
        }
        catch (NoSuchMethodException nsme) {
            AQjmsOracleDebug.traceEx(5, "WeblogicHelper static initializer", nsme);
            throw new RuntimeException("Internal Error: the desired method is not found on the class weblogic.jms.foreign.ForeignAQIntegration", nsme);
        }
        catch (IllegalAccessException iae) {
            AQjmsOracleDebug.traceEx(5, "WeblogicHelper static initializer", iae);
            throw new RuntimeException("Internal Error: cannot invoke the desired method on the classweblogic.jms.foreign.ForeignAQIntegration", iae);
        }
        catch (InvocationTargetException ite) {
            AQjmsOracleDebug.traceEx(5, "WeblogicHelper static initializer", ite);
            throw new RuntimeException("Internal Error: cannot invoke the desired method on the classweblogic.jms.foreign.ForeignAQIntegration", ite);
        }
        AQjmsOracleDebug.trace(3, "WeblogicHelper static initializer", "exit. runningInsideWLServer:" + s_runningInsideWLServer);
    }
}

