/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import oracle.jakarta.AQ.AQDriverManager;
import oracle.jakarta.AQ.AQException;
import oracle.jakarta.AQ.AQOracleAdmin;
import oracle.jakarta.AQ.AQOracleAgent;
import oracle.jakarta.AQ.AQOracleQueue;
import oracle.jakarta.AQ.AQOracleQueueTable;
import oracle.jakarta.AQ.AQOracleSession;
import oracle.jakarta.AQ.AQQueueProperty;
import oracle.jakarta.AQ.AQQueueTable;
import oracle.jakarta.AQ.AQQueueTableProperty;
import oracle.jakarta.jms.AQjmsAdtMessage;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsBytesMessage;
import oracle.jakarta.jms.AQjmsCliSubMapEntry;
import oracle.jakarta.jms.AQjmsClientSubscriberMap;
import oracle.jakarta.jms.AQjmsConnection;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsConsumer;
import oracle.jakarta.jms.AQjmsConsumerExceptionListener;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsDestinationProperty;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGeneralDBConnection;
import oracle.jakarta.jms.AQjmsInterOp;
import oracle.jakarta.jms.AQjmsJDBCConnInfo;
import oracle.jakarta.jms.AQjmsJsonMessage;
import oracle.jakarta.jms.AQjmsMapMessage;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsNtfRegistration;
import oracle.jakarta.jms.AQjmsObject;
import oracle.jakarta.jms.AQjmsObjectMessage;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsProducer;
import oracle.jakarta.jms.AQjmsQueueBrowser;
import oracle.jakarta.jms.AQjmsQueueSenderImpl;
import oracle.jakarta.jms.AQjmsSelector;
import oracle.jakarta.jms.AQjmsStreamMessage;
import oracle.jakarta.jms.AQjmsTextMessage;
import oracle.jakarta.jms.AQjmsTopicBrowser;
import oracle.jakarta.jms.AQjmsTopicPublisherImpl;
import oracle.jakarta.jms.AQjmsTopicReceiver;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jakarta.jms.AdtMessage;
import oracle.jakarta.jms.EmulatedXAHandler;
import oracle.jakarta.jms.JsonMessage;
import oracle.jakarta.jms.TopicBrowser;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CustomDatum;
import oracle.sql.ORAData;
import oracle.sql.converter.CharacterSetMetaData;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonValue;

public class AQjmsSession
extends AQjmsObject
implements QueueSession,
TopicSession,
AutoCloseable {
    int cl_check_interval = AQjmsConstants.getCloseCheckInterval();
    AQjmsConnection jms_conn;
    int ack_mode;
    boolean transacted;
    int sess_type;
    private CallableStatement rems_stmt;
    private CallableStatement alts_stmt;
    private CallableStatement bind_stmt;
    private CallableStatement ubnd_stmt;
    private CallableStatement chks_stmt;
    private Hashtable cons_list;
    private QueueBrowser queue_browser;
    private MessageListener privileged_listener;
    long[] oci_handles = new long[3];
    long oci_aq_cntxt = 0L;
    short dbversion;
    int dbMaxIdenLength;
    int dbCompatMajorVer;
    int dbCompatMinorVer;
    OracleCallableStatement st_text = null;
    OracleCallableStatement st_bytes = null;
    OracleCallableStatement st_map = null;
    OracleCallableStatement st_stream = null;
    OracleCallableStatement st_object = null;
    OracleCallableStatement st_adt = null;
    OracleCallableStatement st_adt_rep = null;
    OracleCallableStatement deq_stmt = null;
    OracleCallableStatement st_array_enqueue = null;
    OracleCallableStatement st_array_text_enqueue = null;
    OracleCallableStatement st_array_bytes_enqueue = null;
    OracleCallableStatement st_array_stream_enqueue = null;
    OracleCallableStatement st_array_map_enqueue = null;
    OracleCallableStatement st_array_object_enqueue = null;
    OracleCallableStatement st_array_dequeue = null;
    OracleCallableStatement st_array_text_dequeue = null;
    OracleCallableStatement st_array_bytes_dequeue = null;
    OracleCallableStatement st_array_stream_dequeue = null;
    OracleCallableStatement st_array_map_dequeue = null;
    OracleCallableStatement st_array_object_dequeue = null;
    OracleJsonFactory jsonFactory = null;
    Connection db_conn = null;
    boolean cache_deq_stmt = false;
    static boolean loaded_library = false;
    private String clientSessionGUID = null;
    private static final Map<String, Map<String, Map<String, Topic>>> s_subt = new HashMap<String, Map<String, Map<String, Topic>>>();
    private static Hashtable<String, Integer> clientUseCntMap = new Hashtable();
    private final Object m_consync = new Object();
    private boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private Thread closingThread = null;
    AQjmsGeneralDBConnection genConn = null;
    AQjmsJDBCConnInfo jdbcConnInfo = null;
    private String prevSubName = null;
    private EmulatedXAHandler xaHandler;
    private int db_max_bytes;
    private boolean sendConsistent = true;
    boolean wlsXaTopicNextDisabled;
    OracleBlob cachedTempBlob = null;
    OracleClob cachedTempClob = null;
    volatile boolean usedJMSRegistration;
    ExceptionListener excpLsnr = null;
    ArrayList<AQjmsConsumerExceptionListener> consExcpListenerList = new ArrayList();
    private boolean thisSessionClosed = false;
    durableSubCreationMode durSubCreationMode = durableSubCreationMode.COMPLAINT_BASED;
    private Object m_lsync = new Object();
    private boolean m_inlis = false;
    private static final int MAX_SUBSCRIBER_LEN = 30;
    private static final int MAX_SUBSCRIBER_LEN_122_COMPATIBLE = 128;
    private static final int MAX_QUEUE_NAME_LEN = 24;
    private static final int MAX_QUEUETABLE_NAME_LEN = 24;

    AQjmsSession(AQjmsConnection jms_conn, int ack_mode, boolean transacted, int type, AQjmsGeneralDBConnection genConn) throws JMSException {
        super("Session", jms_conn);
        this.jms_conn = jms_conn;
        this.ack_mode = ack_mode;
        this.transacted = transacted;
        this.compliant = jms_conn.getCompliant();
        this.genConn = genConn;
        this.db_conn = genConn.getDBConnection();
        this.dbversion = jms_conn.getDBVersion();
        this.dbMaxIdenLength = jms_conn.getDBMaxIdenLength();
        this.dbCompatMajorVer = jms_conn.getDBCompatMajorVersion();
        this.dbCompatMinorVer = jms_conn.getDBCompatMinorVersion();
        if (this.getDriver().equalsIgnoreCase("thin")) {
            this.jdbcConnInfo = AQjmsUtil.getJDBCConnInfo((oracle.jdbc.OracleConnection)((OracleConnection)this.db_conn));
        }
        AQjmsOracleDebug.trace(1, "AQjmsSession.constructor", "JDBC Connection Info: " + String.valueOf(this.jdbcConnInfo));
        AQjmsOracleDebug.trace(5, "AQjmsSession.constructor", "dbversion = " + this.dbversion + ", dbCompatibleVersion = " + this.dbCompatMajorVer + "." + this.dbCompatMinorVer + ", dbMaxIdenLength = " + this.dbMaxIdenLength);
        this.setDBRatio();
        this.rems_stmt = null;
        this.alts_stmt = null;
        this.bind_stmt = null;
        this.ubnd_stmt = null;
        this.chks_stmt = null;
        if (type == 10 || type == 20 || type == 30) {
            this.sess_type = type;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Invalid type - not a Queue or Topic");
            AQjmsError.throwEx(122, "invalid type");
        }
        this.xaHandler = AQjmsConstants.useEmulatedXA() ? new EmulatedXAHandler(this.db_conn, this) : null;
        if (!this.isInTransactionRechecked() && ack_mode != 1 && ack_mode != 2 && ack_mode != 3) {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Wrong ACKOWLEDGE MODE: ack_mode, setting it to AUTO_ACKNOWLEDGE");
            ack_mode = 1;
        }
        this.cons_list = new Hashtable();
        this.queue_browser = null;
        this.privileged_listener = null;
        this.cache_deq_stmt = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.constructor1", "oci enabled = " + AQDriverManager.isOciAQEnabled());
        this.getOCIHandles();
        if (!AQjmsConstants.TEQ_SESSION_ONLY) {
            if (this.hasOciAQContext() || this.getDriver().equalsIgnoreCase("thin") && AQjmsConstants.useJdbcAQ() && AQjmsConstants.GET_RETRY_COUNT_FLAG) {
                this.setMultiRetry();
            }
            if (AQjmsConstants.ORDER_WITH_SELECTOR) {
                this.enableEventForMsgOrder();
            }
        }
        if (!((oracle.jdbc.OracleConnection)this.db_conn).getUsingXAFlag()) {
            try {
                this.db_conn.setAutoCommit(false);
            }
            catch (SQLException sqe) {
                AQjmsError.throwEx("can not set autocommit for the db connection", (Throwable)sqe);
            }
        }
        try {
            Class<?> jsonFactoryClass = Class.forName("oracle.sql.json.OracleJsonFactory");
            this.jsonFactory = new OracleJsonFactory();
        }
        catch (ClassNotFoundException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.constructor1 oracle.sql.json.OracleJsonFactory not found", e);
        }
        jms_conn.attach(this);
    }

    private boolean isSharedDurableSub() {
        switch (this.durSubCreationMode) {
            case COMPLAINT_BASED: {
                return !this.getCompliant();
            }
            case FORCE_SHARED: {
                return true;
            }
            case FORCE_UNSHARED: {
                return false;
            }
        }
        return true;
    }

    boolean isKprb() {
        String protocol = ((OracleConnection)this.db_conn).getProtocolType();
        AQjmsOracleDebug.trace(3, "AQjmsSession.isKbrp", "protocol:" + protocol);
        return "kprb".equals(protocol);
    }

    private boolean isKnownSingleCharset(int csid) {
        return csid == 1 || csid == 2 || csid == 31;
    }

    private int getClientRatio() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "enter");
        short jdbcCsId = 0;
        try {
            jdbcCsId = ((OracleConnection)this.db_conn).getJdbcCsId();
        }
        catch (SQLException sqe) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getClientRatio get the csid from jdbc", sqe);
            AQjmsError.throwEx("Failed to obtain the Client CSID from JDBC connection", (Throwable)sqe);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "The Client csid = " + jdbcCsId);
        int client_max_bytes = 0;
        if (this.isKnownSingleCharset(jdbcCsId)) {
            client_max_bytes = 1;
        } else {
            int ratio = CharacterSetMetaData.getRatio((int)jdbcCsId, (int)2002);
            if (ratio == 0) {
                AQjmsError.throwEx("The Client CSID obtained from JDBC is bad", null);
            } else {
                client_max_bytes = ratio * 2;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "exit");
        return client_max_bytes;
    }

    private void setDBRatio() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.setDBRatio", "enter");
        short dbCsId = 0;
        try {
            dbCsId = ((OracleConnection)this.db_conn).getDbCsId();
        }
        catch (SQLException sqe) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.setRatio get the csid from db", sqe);
            AQjmsError.throwEx("Failed to obtain the DB CSID from JDBC connection", (Throwable)sqe);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.setRatio", "The DB csid = " + dbCsId);
        if (this.isKnownSingleCharset(dbCsId)) {
            this.db_max_bytes = 1;
        } else {
            int db_ratio = CharacterSetMetaData.getRatio((int)dbCsId, (int)2002);
            if (db_ratio == 0) {
                AQjmsError.throwEx("The DB CSID obtained from JDBC is bad", null);
            } else {
                this.db_max_bytes = db_ratio * 2;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.setRatio", "exit");
    }

    int maxBytes(int strlenUTF16) {
        return this.db_max_bytes * strlenUTF16;
    }

    boolean getCompliant() {
        AQjmsOracleDebug.trace(4, "AQjmsSession.getCompliant", "Session <compliant>:" + this.compliant);
        return this.compliant;
    }

    private native long ociinit(long[] var1, int var2, int var3, boolean var4, short var5, int var6, int var7) throws Exception;

    private native void ocifrctx(long[] var1, long var2, int var4) throws Exception;

    private native void ocibreak(long var1, long var3, long var5) throws Exception;

    public BytesMessage createBytesMessage() throws JMSException {
        AQjmsBytesMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsBytesMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createBytesMesage", "returning bytes message");
        return message;
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        AQjmsMapMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsMapMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMapMessage", "returning map message");
        return message;
    }

    public synchronized Message createMessage() throws JMSException {
        AQjmsMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsMessage(this, true);
        message.setHeaderOnly();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMessage", "return message");
        return message;
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        AQjmsObjectMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsObjectMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return object message");
        return message;
    }

    public synchronized ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        AQjmsObjectMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsObjectMessage(this);
        message.setObject(object);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return initialized object message");
        return message;
    }

    public synchronized AdtMessage createAdtMessage() throws JMSException {
        AQjmsAdtMessage message = null;
        message = this.createAdtMessage(null);
        return message;
    }

    public synchronized AQjmsAdtMessage createAdtMessage(CustomDatum payload) throws JMSException {
        AQjmsAdtMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsAdtMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return message;
    }

    public synchronized AdtMessage createORAMessage() throws JMSException {
        AQjmsAdtMessage message = null;
        ORAData data = null;
        message = this.createORAMessage(data);
        return message;
    }

    public synchronized AQjmsAdtMessage createORAMessage(OracleData payload) throws JMSException {
        AQjmsAdtMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsAdtMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return message;
    }

    public synchronized AQjmsAdtMessage createORAMessage(ORAData payload) throws JMSException {
        AQjmsAdtMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsAdtMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return message;
    }

    public synchronized JsonMessage createJsonMessage() throws JMSException {
        AQjmsJsonMessage message = null;
        OracleJsonValue payload = null;
        message = this.createJsonMessage(payload);
        return message;
    }

    public synchronized AQjmsJsonMessage createJsonMessage(OracleJsonValue payload) throws JMSException {
        AQjmsJsonMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsJsonMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createJsonMessage", "return json message");
        return message;
    }

    public synchronized AQjmsJsonMessage createJsonMessage(OracleJsonDatum payload) throws JMSException {
        AQjmsJsonMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsJsonMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createJsonMessage", "return json message");
        return message;
    }

    public synchronized AQjmsJsonMessage createJsonMessage(String payload) throws JMSException {
        AQjmsJsonMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsJsonMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createJsonMessage", "return json message");
        return message;
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        AQjmsStreamMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsStreamMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createStreamMessage", "return stream message");
        return message;
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        AQjmsTextMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return text message");
        return message;
    }

    public synchronized TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        AQjmsTextMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage(this);
        message.setText(stringBuffer.toString());
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return message;
    }

    public synchronized TextMessage createTextMessage(String text) throws JMSException {
        AQjmsTextMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage(this);
        message.setText(text);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return message;
    }

    public synchronized boolean getTransacted() throws JMSException {
        this.checkSessionStarted();
        return this.transacted;
    }

    public synchronized OracleJsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public synchronized int getAckMode() throws JMSException {
        this.checkSessionStarted();
        return this.ack_mode;
    }

    void checkConsistency() throws JMSException {
        if (!this.sendConsistent) {
            JMSException e = new JMSException("Cannot not commit in an inconsistent state, must rollback");
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkConsistency", e);
            throw e;
        }
    }

    void setConsistency(boolean state) {
        this.sendConsistent = state;
        if (!state && this.xaHandler != null) {
            this.xaHandler.setRollbackOnlyIfInGlobalTxn();
        }
    }

    public void commit() throws JMSException {
        this.checkSessionStarted();
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(227, null);
        }
        if (this.usedJMSRegistration) {
            this.ackJmsNtfsAndCommit();
            return;
        }
        if (!this.lock("commit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.commitNoCheck();
        }
        finally {
            this.unlock("commit");
        }
    }

    void ackJmsNtfsAndCommit() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.ackJmsNtfsAndCommit", "entry");
        if (!this.lock("ackJmsNtfsAndCommit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.ackMultiJmsNtfs(JMSNotificationRegistration.Directive.COMMIT);
            AQjmsOracleDebug.trace(5, "AQjmsSession.ackJmsNtfsAndCommit", "ready to commit");
            this.commitNoCheck();
        }
        finally {
            this.unlock("ackJmsNtfsAndCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackMultiJmsNtfs(JMSNotificationRegistration.Directive action) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "entry Operation= " + (action == JMSNotificationRegistration.Directive.COMMIT ? "Commit" : "Rollback"));
        try {
            AQjmsNtfRegistration ntfReg;
            ArrayList<AQjmsNtfRegistration> ntfRegList = new ArrayList<AQjmsNtfRegistration>();
            Enumeration e = this.cons_list.elements();
            while (e.hasMoreElements()) {
                AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
                ntfReg = cons.getNtfReg();
                if (ntfReg == null || ntfReg.getLastMessageId() == null) continue;
                ntfRegList.add(ntfReg);
            }
            if (ntfRegList.size() == 0) {
                AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "All messages are Acknowledged, No Ack to be sent.");
                return;
            }
            byte[][] messageIds = new byte[ntfRegList.size()][];
            ArrayList<JMSNotificationRegistration> jmsRegList = new ArrayList<JMSNotificationRegistration>(ntfRegList.size());
            Iterator ntfRegIter = ntfRegList.iterator();
            int index = 0;
            while (ntfRegIter.hasNext()) {
                ntfReg = (AQjmsNtfRegistration)ntfRegIter.next();
                messageIds[index++] = ntfReg.getLastMessageId();
                jmsRegList.add(ntfReg.getJDBCRegistration());
                AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "Ack for registration= " + String.valueOf(ntfReg) + " lastMessageID=" + RepConversion.bArray2String((byte[])ntfReg.getLastMessageId()));
            }
            AQjmsSession aQjmsSession = this;
            synchronized (aQjmsSession) {
                OracleConnection db_conn = (OracleConnection)this.getDBConnection();
                db_conn.ackJMSNotification(jmsRegList, (byte[][])messageIds, action);
            }
            AQjmsOracleDebug.trace(4, "AQjmsSession.ackMultiJmsNtfs", "after called db conn.ackJMSNotification");
            ntfRegIter = ntfRegList.iterator();
            while (ntfRegIter.hasNext()) {
                ((AQjmsNtfRegistration)ntfRegIter.next()).setLastMessageId(null);
            }
        }
        catch (SQLException sqlEx) {
            AQjmsError.throwEx("failed to ack last notified message", (Throwable)sqlEx);
        }
    }

    @Override
    void startJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.startJMSNotification", "entry");
        if (this.usedJMSRegistration) {
            if (!this.lock("startJMSNotification", -1L)) {
                AQjmsError.throwEx(122);
            }
            try {
                Enumeration e = this.cons_list.elements();
                while (e.hasMoreElements()) {
                    this.checkSessionStarted();
                    AQjmsConsumer consumer = (AQjmsConsumer)e.nextElement();
                    consumer.startJMSNotification();
                }
            }
            finally {
                this.unlock("startJMSNotification");
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.startJMSNotification", "exit");
    }

    @Override
    void stopJMSNotification() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.stopJMSNotification", "entry");
        if (this.usedJMSRegistration) {
            if (!this.lock("stopJMSNotification", -1L)) {
                AQjmsError.throwEx(122);
            }
            try {
                Enumeration e = this.cons_list.elements();
                while (e.hasMoreElements()) {
                    this.checkSessionStarted();
                    AQjmsConsumer consumer = (AQjmsConsumer)e.nextElement();
                    consumer.stopJMSNotification();
                }
            }
            finally {
                this.unlock("stopJMSNotification");
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.stopJMSNotification", "exit");
    }

    @Override
    void handleJMSNotification() throws JMSException, TimeoutException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.handleJMSNotification", "entry");
        if (this.usedJMSRegistration) {
            long pingInterval;
            long timeoutInMillis = AQjmsConstants.getJmsNotificationTimeout();
            if (timeoutInMillis < (pingInterval = 1000L)) {
                pingInterval = timeoutInMillis;
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.handleJMSNotification", "timeoutInMillis " + timeoutInMillis);
            AQjmsOracleDebug.trace(5, "AQjmsSession.handleJMSNotification", "check the state of the registration");
            boolean timedOut = true;
            long maxTimeInMillis = System.currentTimeMillis() + timeoutInMillis;
            Enumeration e = this.cons_list.elements();
            while (e.hasMoreElements()) {
                AQjmsConsumer consumer = (AQjmsConsumer)e.nextElement();
                while (!(timedOut = System.currentTimeMillis() > maxTimeInMillis)) {
                    this.checkSessionStarted();
                    if (consumer.isRegistrationDisabled()) break;
                    try {
                        AQjmsOracleDebug.trace(5, "AQjmsSession.handleJMSNotification", "state of the registration is not DISABLED");
                        Thread.sleep(pingInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (pingInterval >= 30000L || pingInterval == timeoutInMillis) continue;
                    pingInterval += 1000L;
                }
                if (!timedOut) continue;
                throw new TimeoutException("The timeout value specified, " + timeoutInMillis + " ms exceeded, stop() on Connection timed out !");
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.handleJMSNotification", "exit");
    }

    void forceCommit() throws JMSException {
        if (!this.lock("forceCommit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.commitNoCheck();
        }
        finally {
            this.unlock("forceCommit");
        }
    }

    synchronized void commitNoCheck() throws JMSException {
        this.checkConsistency();
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            db_conn.commit();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        if (!AQjmsConstants.ignorePriority()) {
            this.restartConsumers();
        }
    }

    public synchronized void rollback() throws JMSException {
        this.checkSessionStarted();
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(228, null);
        }
        if (this.usedJMSRegistration) {
            this.ackJmsNtfsAndRollback();
            return;
        }
        this.forceRollback();
    }

    private void ackJmsNtfsAndRollback() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.ackJmsNtfsAndRollback", "entry");
        if (!this.lock("ackJmsNtfsAndRollback", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.ackMultiJmsNtfs(JMSNotificationRegistration.Directive.ROLLBACK);
            AQjmsOracleDebug.trace(5, "AQjmsSession.ackJmsNtfsAndRollback", "ready to rollback");
            this.forceRollback();
        }
        finally {
            this.unlock("ackJmsNtfsAndRollback");
        }
    }

    synchronized void forceRollback() throws JMSException {
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            db_conn.rollback();
            this.setConsistency(true);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.restartConsumers();
    }

    @Override
    void markClosed() {
        super.markClosed();
        if (this.lockedByReceive()) {
            this.cancelBlockingReceive();
        }
    }

    void cancelBlockingReceive() {
        try {
            if (this.oci_aq_cntxt != 0L) {
                String osName = AQjmsUtil.getSystemProperty("os.name");
                if (osName == null || !osName.toUpperCase().startsWith("WINDOWS")) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.cancelBlockingReceive", System.currentTimeMillis() + ": Calling OCIBreak");
                    this.ocibreak(this.getOCIServiceHandle(), this.getOCIErrorHandle(), this.oci_aq_cntxt);
                }
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.cancelBlockingReceive", System.currentTimeMillis() + ": Calling OracleConnection.cancel");
                if (this.db_conn != null) {
                    ((oracle.jdbc.OracleConnection)this.db_conn).cancel();
                }
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.trace(4, "AQjmsSession.cancelBlockingReceive", "Got exception: " + String.valueOf(t));
        }
    }

    @Override
    protected synchronized void preClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "ENTRY");
        Connection our_conn = this.getOurDBConnection();
        try {
            if (our_conn != null && !our_conn.isClosed()) {
                if (!this.isInGlobalTransactionRechecked() && !this.genConn.isExternal()) {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "abort txn");
                    our_conn.rollback();
                } else {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "not aborting txn");
                }
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsSession.preClose: failed to rollback the transaction before close", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "EXIT");
    }

    @Override
    public void close() throws JMSException {
        try {
            this.closingThread = Thread.currentThread();
            super.close();
        }
        finally {
            this.closingThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void localClose() throws JMSException {
        Connection our_conn = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.localClose", "entry ...");
        if (this.clientSessionGUID != null) {
            try {
                this.removeAQNondurableSubscribers(this.clientSessionGUID);
            }
            catch (Throwable t) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: removeAQNondurableSubscribers(" + this.clientSessionGUID + ")", t);
            }
        }
        if (this.cachedTempBlob != null) {
            try {
                AQjmsOracleDebug.trace(5, "AQjmsSession.localClose", "to free cached temporary Blob");
                this.cachedTempBlob.free();
            }
            catch (Throwable t) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: free cached temporary Blob", t);
            }
            this.cachedTempBlob = null;
        }
        if (this.cachedTempClob != null) {
            try {
                AQjmsOracleDebug.trace(5, "AQjmsSession.localClose", "to free cached temporary Clob");
                this.cachedTempClob.free();
            }
            catch (Throwable t) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: free cached temporary Clob", t);
            }
            this.cachedTempClob = null;
        }
        our_conn = this.getOurDBConnection();
        try {
            if (this.oci_aq_cntxt != 0L && !our_conn.isClosed()) {
                this.freeOCIHandles();
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.localClose: freeing oci handles", t);
        }
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
                this.alts_stmt = null;
            }
            if (this.bind_stmt != null) {
                this.bind_stmt.close();
                this.bind_stmt = null;
            }
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.close();
                this.ubnd_stmt = null;
            }
            if (this.chks_stmt != null) {
                this.chks_stmt.close();
                this.chks_stmt = null;
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(2, "AQjmsSession.localClose: close cached statements", t);
        }
        this.destroyStmt(this.st_text);
        this.destroyStmt(this.st_bytes);
        this.destroyStmt(this.st_map);
        this.destroyStmt(this.st_object);
        this.destroyStmt(this.st_stream);
        this.destroyStmt(this.st_adt);
        this.destroyStmt(this.st_adt_rep);
        this.destroyStmt(this.deq_stmt);
        this.destroyStmt(this.st_array_enqueue);
        this.destroyStmt(this.st_array_text_enqueue);
        this.destroyStmt(this.st_array_bytes_enqueue);
        this.destroyStmt(this.st_array_stream_enqueue);
        this.destroyStmt(this.st_array_map_enqueue);
        this.destroyStmt(this.st_array_object_enqueue);
        this.destroyStmt(this.st_array_dequeue);
        this.destroyStmt(this.st_array_text_dequeue);
        this.destroyStmt(this.st_array_bytes_dequeue);
        this.destroyStmt(this.st_array_stream_dequeue);
        this.destroyStmt(this.st_array_map_dequeue);
        this.destroyStmt(this.st_array_object_dequeue);
        try {
            AQjmsOracleDebug.trace(4, "AQjmsSession.localClose", "Closing general Connection");
            this.genConn.close();
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(2, "AQjmsSession.localClose: close db connection", t);
        }
        String clientId = this.jms_conn.getClientIDForce();
        Hashtable<String, Integer> hashtable = clientUseCntMap;
        synchronized (hashtable) {
            if (clientUseCntMap.containsKey(clientId)) {
                int useCnt = clientUseCntMap.get(clientId);
                if (--useCnt == 0) {
                    clientUseCntMap.remove(clientId);
                    if (AQjmsConstants.FREE_CLOSED_SUB) {
                        Map<String, Map<String, Map<String, Topic>>> map = s_subt;
                        synchronized (map) {
                            Map<String, Map<String, Topic>> cid2subs = s_subt.get(this.genConn.providerKey);
                            if (cid2subs != null) {
                                Map<String, Topic> name2topic = cid2subs.get(clientId);
                                if (name2topic != null) {
                                    cid2subs.remove(clientId);
                                }
                                if (cid2subs.isEmpty()) {
                                    s_subt.remove(this.genConn.providerKey);
                                }
                            }
                        }
                    }
                } else {
                    clientUseCntMap.put(clientId, useCnt);
                }
            }
        }
        this.jms_conn = null;
        this.db_conn = null;
        this.genConn = null;
        this.thisSessionClosed = true;
        if (this.jdbcConnInfo != null) {
            AQjmsOracleDebug.trace(1, "AQjmsSession.localClose", "Closing JMS Session: " + this.jdbcConnInfo.toString() + " Time Now:" + String.valueOf(new Date()));
        }
    }

    void acknowledge() throws JMSException {
        Connection db_conn = null;
        if (this.getAcknowledgeMode() == 2) {
            if (this.usedJMSRegistration) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.acknowledge", "before calling session.ackJmsNtfsAndCommit");
                this.ackJmsNtfsAndCommit();
                return;
            }
            db_conn = this.getDBConnection();
            try {
                db_conn.commit();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startListener() {
        Object object = this.m_lsync;
        synchronized (object) {
            this.m_inlis = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopListener() {
        Object object = this.m_lsync;
        synchronized (object) {
            this.m_inlis = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inListener() {
        boolean ret = false;
        Object object = this.m_lsync;
        synchronized (object) {
            ret = this.m_inlis;
        }
        return ret;
    }

    public synchronized void recover() throws JMSException {
        this.checkSessionStarted();
        int ackMode = this.getAcknowledgeMode();
        if (ackMode == 0) {
            AQjmsError.throwIllegalStateEx(238, null);
        }
        Connection db_conn = null;
        if (ackMode == 2 || this.inListener()) {
            if (this.usedJMSRegistration) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.recover", "before calling session.ackJmsNtfsAndRollback");
                this.ackJmsNtfsAndRollback();
                return;
            }
            try {
                db_conn = this.getDBConnection();
                db_conn.rollback();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
            this.restartConsumers();
        }
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        return this.privileged_listener;
    }

    public synchronized void setMessageListener(MessageListener listener) throws JMSException {
        this.privileged_listener = listener;
        Enumeration e = this.cons_list.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
            cons.setPrivilegedMessageListener(listener);
        }
    }

    public synchronized void setExceptionListener(ExceptionListener eListener) {
        this.excpLsnr = eListener;
    }

    public synchronized ExceptionListener getExceptionListener() {
        return this.excpLsnr;
    }

    synchronized ArrayList<AQjmsConsumerExceptionListener> getConsumerExcpLsnrList() {
        return this.consExcpListenerList;
    }

    synchronized void addConsumerExcpLsnr(AQjmsConsumerExceptionListener exLsnr) {
        this.consExcpListenerList.add(exLsnr);
    }

    synchronized void removeConsumerExcpLsnr(AQjmsConsumerExceptionListener exLsnr) {
        this.consExcpListenerList.remove(exLsnr);
    }

    public synchronized Queue createQueue(String queueName) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.createQueue IN", "queuename: " + queueName);
        this.checkClosed("createQueue");
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        String owner = this.getAQOwner(queueName);
        String name = this.getAQName(queueName);
        Queue q = null;
        try {
            q = this.getQueue(owner, name);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createQueue: getQueue failed: ", e);
            AQjmsError.throwEx(190, queueName, e);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createQueue EXIT ", "");
        return q;
    }

    public synchronized QueueReceiver createReceiver(Queue queue) throws JMSException {
        AQjmsConsumer receiver = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public synchronized QueueReceiver createReceiver(Queue queue, Object payloadFactory) throws JMSException {
        AQjmsConsumer receiver = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, payloadFactory);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return this.createReceiver(queue, messageSelector, null);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String messageSelector, Object payloadFactory) throws JMSException {
        AQjmsConsumer receiver = null;
        AQjmsSelector jms_sel = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            AQjmsDestination aqjmsQueue = (AQjmsDestination)queue;
            jms_sel = aqjmsQueue.isSharded() ? new AQjmsSelector(messageSelector, 10, 4, this.dbversion, aqjmsQueue) : (payloadFactory != null ? new AQjmsSelector(messageSelector, 10, 2, this.dbversion, this.getCompliant()) : ((p_data_type = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 10, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(messageSelector, 10, 1, this.dbversion, this.getCompliant())));
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.createReceiver", "Selector: " + String.valueOf(jms_sel));
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, payloadFactory, jms_sel, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        AQjmsQueueSenderImpl sender = null;
        this.checkSessionStarted();
        if (!(queue == null || queue instanceof AQjmsDestination && ((AQjmsDestination)queue).isQueue())) {
            AQjmsError.throwInvalidDestEx(125);
        }
        sender = new AQjmsQueueSenderImpl(this, (AQjmsDestination)queue);
        return sender;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, Object payloadFactory) throws JMSException {
        return this.createBrowser(queue, null, payloadFactory, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.createBrowser(queue, messageSelector, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, boolean locked) throws JMSException {
        return this.createBrowser(queue, messageSelector, null, locked);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, Object payloadFactory) throws JMSException {
        return this.createBrowser(queue, messageSelector, payloadFactory, false);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String messageSelector, Object payloadFactory, boolean locked) throws JMSException {
        AQjmsQueueBrowser browser = null;
        int deq_mode = 1;
        AQjmsSelector jms_sel = null;
        String qname = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        qname = ((AQjmsDestination)queue).getCompleteName();
        if (locked) {
            deq_mode = 2;
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            AQjmsDestination aqjmsQueue = (AQjmsDestination)queue;
            jms_sel = aqjmsQueue.isSharded() ? new AQjmsSelector(messageSelector, 10, 4, this.dbversion, aqjmsQueue) : (payloadFactory != null ? new AQjmsSelector(messageSelector, 10, 2, this.dbversion, this.getCompliant()) : ((p_data_type = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 10, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(messageSelector, 10, 1, this.dbversion, this.getCompliant())));
        }
        browser = new AQjmsQueueBrowser((Session)this, (Destination)queue, 10, deq_mode, null, jms_sel, payloadFactory);
        return browser;
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName) throws JMSException {
        return this.createBrowser(topic, consumerName, null, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName, boolean locked) throws JMSException {
        return this.createBrowser(topic, consumerName, null, null, locked);
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName, Object payloadFactory) throws JMSException {
        return this.createBrowser(topic, consumerName, null, payloadFactory, false);
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName, Object payloadFactory, boolean locked) throws JMSException {
        return this.createBrowser(topic, consumerName, null, payloadFactory, locked);
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName, String messageSelector) throws JMSException {
        return this.createBrowser(topic, consumerName, messageSelector, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName, String messageSelector, boolean locked) throws JMSException {
        return this.createBrowser(topic, consumerName, messageSelector, null, locked);
    }

    public TopicBrowser createBrowser(Topic topic, String consumerName, String messageSelector, Object payloadFactory) throws JMSException {
        return this.createBrowser(topic, consumerName, messageSelector, payloadFactory, false);
    }

    public synchronized TopicBrowser createBrowser(Topic topic, String consumerName, String messageSelector, Object payloadFactory, boolean locked) throws JMSException {
        AQjmsTopicBrowser browser = null;
        int deq_mode = 1;
        AQjmsSelector jms_sel = null;
        String tname = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (this.dbversion < 9000) {
            AQjmsError.throwEx(102);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        tname = ((AQjmsDestination)topic).getCompleteName();
        if (locked) {
            deq_mode = 2;
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            AQjmsDestination aqjmsTopic = (AQjmsDestination)topic;
            jms_sel = aqjmsTopic.isSharded() ? new AQjmsSelector(messageSelector, 20, 4, this.dbversion, aqjmsTopic) : (payloadFactory != null ? new AQjmsSelector(messageSelector, 20, 2, this.dbversion, this.getCompliant()) : ((p_data_type = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 20, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(messageSelector, 20, 1, this.dbversion, this.getCompliant())));
        }
        browser = new AQjmsTopicBrowser((Session)this, (Destination)topic, 20, deq_mode, consumerName, jms_sel, payloadFactory);
        return browser;
    }

    public synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        return this.makeTemporaryQueue(false);
    }

    public synchronized Destination createJMSShardedQueue(String queueName, boolean isMultipleConsumer) throws JMSException {
        return this.createJMSShardedQueue(queueName, isMultipleConsumer, null, 0, null);
    }

    public synchronized Destination createJMSShardedQueue(String queueName, boolean isMultipleConsumer, String storageClause, int maxRetries, String comment) throws JMSException {
        AQjmsDestination jmsDestination = null;
        Connection dbConnection = null;
        CallableStatement callableStatement = null;
        if (queueName == null || queueName.trim().equals("")) {
            AQjmsError.throwEx(134);
        }
        String queueOwner = this.getAQOwner(queueName);
        String simpleQueueName = this.getAQName(queueName);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createJMSShardedQueue", "Queue Owner: " + queueOwner + " and Queue Name: " + simpleQueueName);
        Object createShardedQueueString = "begin dbms_aqadm.create_sharded_queue(queue_name => ?, storage_clause => ?, max_retries => ?, comment => ?, ";
        createShardedQueueString = isMultipleConsumer ? (String)createShardedQueueString + "multiple_consumers => true); end;" : (String)createShardedQueueString + "multiple_consumers => false); end;";
        try {
            dbConnection = this.getDBConnection();
            callableStatement = dbConnection.prepareCall((String)createShardedQueueString);
            callableStatement.setString(1, queueName);
            callableStatement.setString(2, storageClause);
            if (maxRetries != 0) {
                ((OracleCallableStatement)callableStatement).setObject(3, (Object)maxRetries, 4);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(3, 4);
            }
            callableStatement.setString(4, comment);
            callableStatement.execute();
        }
        catch (SQLException sqlException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createJMSShardedQueue", sqlException);
            throw new AQjmsException(sqlException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        AQQueueProperty queueProperty = new AQQueueProperty();
        queueProperty.setSharded(true);
        queueProperty.setComment(comment);
        queueProperty.setMaxRetries(maxRetries);
        try (AQOracleQueue aqOracleQueue = null;){
            aqOracleQueue = new AQOracleQueue(this, queueOwner, simpleQueueName, null, queueProperty, 3, null, false);
            AQjmsDestinationProperty destinationProperty = new AQjmsDestinationProperty(aqOracleQueue.getProperty(true));
            jmsDestination = isMultipleConsumer ? new AQjmsDestination(queueOwner, simpleQueueName, 20, aqOracleQueue.getPayloadType(), aqOracleQueue.getObjectPayloadType(), destinationProperty, null, false) : new AQjmsDestination(queueOwner, simpleQueueName, 10, aqOracleQueue.getPayloadType(), aqOracleQueue.getObjectPayloadType(), destinationProperty, null, false);
        }
        return jmsDestination;
    }

    public synchronized Destination createJMSTransactionalEventQueue(String queueName, boolean isMultipleConsumer) throws JMSException {
        return this.createJMSTransactionalEventQueue(queueName, isMultipleConsumer, null, 0, null);
    }

    public synchronized Destination createJMSTransactionalEventQueue(String queueName, boolean isMultipleConsumer, String storageClause, int maxRetries, String comment) throws JMSException {
        AQjmsDestination jmsDestination = null;
        Connection dbConnection = null;
        CallableStatement callableStatement = null;
        if (queueName == null || queueName.trim().equals("")) {
            AQjmsError.throwEx(134);
        }
        String queueOwner = this.getAQOwner(queueName);
        String simpleQueueName = this.getAQName(queueName);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createJMSTransactionalEventQueue", "Queue Owner: " + queueOwner + " and Queue Name: " + simpleQueueName);
        Object createTransactionalQueueString = "begin dbms_aqadm.create_transactional_event_queue(queue_name => ?, storage_clause => ?, max_retries => ?, comment => ?, ";
        createTransactionalQueueString = isMultipleConsumer ? (String)createTransactionalQueueString + "multiple_consumers => true); end;" : (String)createTransactionalQueueString + "multiple_consumers => false); end;";
        try {
            dbConnection = this.getDBConnection();
            callableStatement = dbConnection.prepareCall((String)createTransactionalQueueString);
            callableStatement.setString(1, queueName);
            callableStatement.setString(2, storageClause);
            if (maxRetries != 0) {
                ((OracleCallableStatement)callableStatement).setObject(3, (Object)maxRetries, 4);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(3, 4);
            }
            callableStatement.setString(4, comment);
            callableStatement.execute();
        }
        catch (SQLException sqlException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createJMSTransactionalEventQueue", sqlException);
            throw new AQjmsException(sqlException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        AQQueueProperty queueProperty = new AQQueueProperty();
        queueProperty.setSharded(true);
        queueProperty.setComment(comment);
        queueProperty.setMaxRetries(maxRetries);
        try (AQOracleQueue aqOracleQueue = null;){
            aqOracleQueue = new AQOracleQueue(this, queueOwner, simpleQueueName, null, queueProperty, 3, null, false);
            AQjmsDestinationProperty destinationProperty = new AQjmsDestinationProperty(aqOracleQueue.getProperty(true));
            jmsDestination = isMultipleConsumer ? new AQjmsDestination(queueOwner, simpleQueueName, 20, aqOracleQueue.getPayloadType(), aqOracleQueue.getObjectPayloadType(), destinationProperty, null, false) : new AQjmsDestination(queueOwner, simpleQueueName, 10, aqOracleQueue.getPayloadType(), aqOracleQueue.getObjectPayloadType(), destinationProperty, null, false);
        }
        return jmsDestination;
    }

    public synchronized Topic createTopic(String topicName) throws JMSException {
        this.checkClosed("createQueue");
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        String owner = this.getAQOwner(topicName);
        String name = this.getAQName(topicName);
        Topic t = null;
        try {
            t = this.getTopic(owner, name);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic: getTopic failed: ", e);
            AQjmsError.throwEx(243, topicName, e);
        }
        return t;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionStarted();
        TopicSubscriber sub = this.createNondurableSub(topic, null, false, null, null);
        return sub;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkSessionStarted();
        TopicSubscriber sub = this.createNondurableSub(topic, messageSelector, noLocal, null, null);
        return sub;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriberName) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, null, false, null, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriberName, Object payloadFactory) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, null, false, payloadFactory, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriberName, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, messageSelector, noLocal, null, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subscriberName, String messageSelector, boolean noLocal, Object payloadFactory) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, messageSelector, noLocal, payloadFactory, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subscriberName, String messageSelector, boolean noLocal, Object payloadFactory, String transformation) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, messageSelector, noLocal, payloadFactory, transformation, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subscriberName, String messageSelector, boolean noLocal, Object payloadFactory, String transformation, boolean forceOldMode, boolean emulateNondurable) throws JMSException {
        AQjmsAgent agent = null;
        TopicSubscriber subscriber = null;
        AQjmsSelector jms_sel = null;
        Connection db_conn = null;
        String topicName = null;
        int nameBehav = 0;
        String revisedSubName = null;
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        db_conn = this.getDBConnection();
        if (subscriberName == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createDurableSubscriber after MessageListener of Session is set");
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createDurableSubscriber", "origSubName: " + subscriberName);
        if (!((AQjmsDestination)topic).isSharded()) {
            topicName = ((AQjmsDestination)topic).getCompleteName();
            if (AQjmsUtil.isGrantOnAQADMPriv(db_conn)) {
                nameBehav = AQjmsUtil.getQueueParameter(db_conn, topicName, "AQJMS_NAME_BEHAVIOR");
            }
            AQjmsOracleDebug.trace(3, "AQjmsSession.createDurableSubscriber", "nameBehavior: " + nameBehav);
            revisedSubName = this.getRevisedSubName(subscriberName, nameBehav);
        } else {
            revisedSubName = AQjmsSession.chopit(subscriberName, this.getMaxSubscriberNameLen());
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createDurableSubscriber", "revisedSubName: " + revisedSubName);
        if (this.jms_conn != null) {
            this.jms_conn.addQueueToSet(((AQjmsDestination)topic).getName());
        }
        try {
            agent = new AQjmsAgent();
            agent.setName(revisedSubName);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createDurableSubscriber - error createing agent", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        boolean retry = false;
        do {
            jms_sel = this.getAQJmsSelector((AQjmsDestination)topic, messageSelector, noLocal, payloadFactory);
            try {
                subscriber = !forceOldMode && !this.isSharedDurableSub() ? this.createSubInCompliantMode(topic, revisedSubName, messageSelector, jms_sel, noLocal, payloadFactory, transformation, agent) : this.createSubInOldMode(topic, revisedSubName, jms_sel, noLocal, payloadFactory, transformation, agent);
                retry = false;
            }
            catch (AQjmsException e) {
                if (e.getErrorNumber() == 25448) {
                    AQjmsOracleDebug.traceEx(5, "AQjmsSession.createDurableSubscriber - ", (Throwable)((Object)e));
                    String owner = this.getAQOwner(topicName);
                    String name = this.getAQName(topicName);
                    try {
                        topic = this.getTopic(owner, name);
                    }
                    catch (Exception ex) {
                        AQjmsOracleDebug.traceEx(5, "AQjmsSession.createDurableSubscriber - ", ex);
                        AQjmsError.throwEx(243, topicName, ex);
                    }
                    retry = true;
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createDurableSubscriber", "retry parsing the rule based on queue: ");
                    continue;
                }
                throw e;
            }
        } while (retry);
        this.cons_list.put(subscriber, subscriber);
        AQjmsConsumer aqConsumer = (AQjmsConsumer)subscriber;
        aqConsumer.setDurable(!emulateNondurable);
        if (aqConsumer.isDurable()) {
            String clientId = this.jms_conn.getClientIDForce();
            Hashtable<String, Integer> hashtable = clientUseCntMap;
            synchronized (hashtable) {
                Map<String, Map<String, Map<String, Topic>>> map = s_subt;
                synchronized (map) {
                    Map<String, Topic> name2topic;
                    Map<String, Map<String, Topic>> cid2subs = s_subt.get(this.genConn.providerKey);
                    if (cid2subs == null) {
                        cid2subs = new HashMap<String, Map<String, Topic>>();
                        s_subt.put(this.genConn.providerKey, cid2subs);
                    }
                    if ((name2topic = cid2subs.get(clientId)) == null) {
                        name2topic = new HashMap<String, Topic>();
                        cid2subs.put(clientId, name2topic);
                    }
                    if (clientUseCntMap.containsKey(clientId)) {
                        int useCnt = clientUseCntMap.get(clientId);
                        clientUseCntMap.put(clientId, ++useCnt);
                    } else {
                        clientUseCntMap.put(clientId, 1);
                    }
                    name2topic.put(subscriberName, topic);
                }
            }
        }
        this.durSubCreationMode = durableSubCreationMode.COMPLAINT_BASED;
        return subscriber;
    }

    private AQjmsSelector getAQJmsSelector(AQjmsDestination topic, String messageSelector, boolean noLocal, Object payloadFactory) throws JMSException {
        String ptype = null;
        AQjmsSelector jms_sel = null;
        boolean isSharded = topic.isSharded();
        boolean isPre12gJMSType = false;
        int payload_obj_type = topic.getPloadType();
        ptype = topic.getAdtType();
        if (!isSharded) {
            isPre12gJMSType = ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE");
        }
        Object fixedSelector = messageSelector;
        if (noLocal && (isSharded || isPre12gJMSType)) {
            fixedSelector = messageSelector == null || messageSelector.trim().equals("") ? "JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "'" : "(" + messageSelector + ") and (JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "')";
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAQJmsSelector", "The fixed selector for noLocal option is: " + (String)fixedSelector);
        }
        if (fixedSelector != null && !((String)fixedSelector).equals("")) {
            if (isSharded && payload_obj_type != 1) {
                jms_sel = new AQjmsSelector((String)fixedSelector, 20, 4, this.dbversion, topic);
            } else if (isPre12gJMSType) {
                jms_sel = new AQjmsSelector((String)fixedSelector, 20, 1, this.dbversion, this.getCompliant());
            } else if (ptype.equalsIgnoreCase("SYS.ANYDATA")) {
                jms_sel = new AQjmsSelector((String)fixedSelector, 20, 3, this.dbversion, this.getCompliant());
            } else {
                if (payloadFactory == null) {
                    AQjmsError.throwEx(137);
                }
                jms_sel = new AQjmsSelector((String)fixedSelector, 20, 2, this.dbversion, this.getCompliant());
            }
        }
        return jms_sel;
    }

    private TopicSubscriber createSubInCompliantMode(Topic topic, String subscriberName, String messageSelector, AQjmsSelector jms_sel, boolean noLocal, Object payloadFactory, String transformation, AQjmsAgent agent) throws JMSException {
        AQjmsConsumer subscriber = null;
        String clientID = this.jms_conn.getClientIDForce();
        AQjmsCliSubMapEntry entry = AQjmsClientSubscriberMap.createClientSubscriber(clientID, subscriberName, topic, messageSelector, noLocal, this.jms_conn.getConnectionID(), transformation);
        if (entry == null) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subscriberName + " is NOT in subscriber map.");
        } else {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subscriberName + " is in subscriber map.");
        }
        subcriberStatus status = AQjmsConstants.NO_SUB_CHECK ? subcriberStatus.SAME_SELECTOR : this.checkSubscriberExists(topic, agent, jms_sel);
        switch (status) {
            case SUBSCRIBER_EXISTS: {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subscriberName + " is in database.");
                if (entry == null) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subscriberName + " is not in subscribers map in memory.");
                    try {
                        subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation);
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "alterDurableSubscriber is called.");
                        break;
                    }
                    catch (AQjmsException aq_ex) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
                        if (aq_ex.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jms_sel, transformation);
                            break;
                        }
                        AQjmsClientSubscriberMap.removeClientSubscriber(clientID, subscriberName);
                        throw aq_ex;
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subscriberName + " is in subscribers map in memory.");
                boolean nochange = false;
                try {
                    nochange = AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)entry.m_topic) && AQjmsUtil.selectorEquals(messageSelector, entry.m_selector);
                }
                catch (JMSException aq_ex) {
                    AQjmsClientSubscriberMap.recoverClientSubscriber(clientID, subscriberName, entry);
                    throw aq_ex;
                }
                if (nochange) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are the same for old and new subscribers");
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Always alter the subscriber.");
                    try {
                        subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation);
                        break;
                    }
                    catch (AQjmsException aq_ex) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode-2 - aq_ex", "error number: " + aq_ex.getErrorNumber());
                        if (aq_ex.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jms_sel, transformation);
                            break;
                        }
                        AQjmsClientSubscriberMap.recoverClientSubscriber(clientID, subscriberName, entry);
                        throw aq_ex;
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are different for old and new subscribers");
                try {
                    this.removeSubscriber(entry.m_topic, agent);
                    subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation, false);
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                    break;
                }
                catch (AQjmsException aq_ex) {
                    AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
                    AQjmsClientSubscriberMap.removeClientSubscriber(clientID, subscriberName);
                    throw aq_ex;
                }
            }
            case NO_SUBSCRIBER: {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subscriberName + " is not in database.");
                try {
                    if (entry != null && !AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)entry.m_topic)) {
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Recreate the subscriber with same name but different topic.");
                        try {
                            this.removeSubscriber(entry.m_topic, agent);
                        }
                        catch (AQjmsException aq_jex) {
                            if (aq_jex.getErrorNumber() == 24035) {
                                AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_jex", "error number: " + aq_jex.getErrorNumber());
                            }
                            throw aq_jex;
                        }
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                    }
                    subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation, false);
                    break;
                }
                catch (AQjmsException aq_ex) {
                    AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
                    AQjmsClientSubscriberMap.removeClientSubscriber(clientID, subscriberName);
                    throw aq_ex;
                }
            }
            case SAME_SELECTOR: {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Subscriber " + subscriberName + " already exists with same selector.");
                subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jms_sel, transformation);
            }
        }
        return subscriber;
    }

    private TopicSubscriber createSubInOldMode(Topic topic, String subscriberName, AQjmsSelector jms_sel, boolean noLocal, Object payloadFactory, String transformation, AQjmsAgent agent) throws JMSException {
        TopicSubscriber subscriber = null;
        subcriberStatus status = AQjmsConstants.NO_SUB_CHECK ? subcriberStatus.SAME_SELECTOR : this.checkSubscriberExists(topic, agent, jms_sel);
        switch (status) {
            case SAME_SELECTOR: {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInOldMode", subscriberName + " already exists with same selector");
                subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jms_sel, transformation);
                break;
            }
            case SUBSCRIBER_EXISTS: {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInOldMode", subscriberName + " already exists with different selector");
                subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation);
                break;
            }
            case NO_SUBSCRIBER: {
                try {
                    subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation, false);
                    break;
                }
                catch (AQjmsException aqex) {
                    if (aqex.getErrorNumber() == 24034) {
                        subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payloadFactory, false, transformation);
                        break;
                    }
                    throw aqex;
                }
            }
        }
        return subscriber;
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subscriberName) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, null, false, null, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subscriberName, Object payloadFactory) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, null, false, payloadFactory, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subscriberName, String selector, Object payloadFactory) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, selector, false, payloadFactory, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subscriberName, String selector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, selector, noLocal, null, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subscriberName, String selector, boolean noLocal, Object payloadFactory, String transformation) throws JMSException {
        return this.createDurableSubscriber(topic, subscriberName, selector, noLocal, payloadFactory, transformation, true, false);
    }

    public TopicSubscriber getDurableSubscriber(Topic topic, String subscriberName) throws JMSException, InvalidDestinationException {
        return this.getDurableSubscriber(topic, subscriberName, null);
    }

    public synchronized TopicSubscriber getDurableSubscriber(Topic topic, String subscriberName, Object payloadFactory) throws JMSException, InvalidDestinationException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.getDurableSubscriber", "entry");
        AQjmsConsumer subscriber = null;
        this.checkSessionStarted();
        if (subscriberName == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "getDurableSubscriber after MessageListener of Session is set");
        }
        subscriberName = AQjmsSession.chopit(subscriberName, this.getMaxSubscriberNameLen());
        AQjmsAgent agent = null;
        try {
            agent = new AQjmsAgent();
            agent.setName(subscriberName);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getDurableSubscriber - error createing agent", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (this.checkSubscriberExists(topic, agent, null) == subcriberStatus.NO_SUBSCRIBER) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "subscriber is not in database, return null!!!");
            return null;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "found the subscriber in the database");
        String clientID = this.jms_conn.getClientIDForce();
        AQjmsCliSubMapEntry entry = AQjmsClientSubscriberMap.addClientSubscriber(clientID, subscriberName, topic);
        if (entry != null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "found the subscriber in the map");
            AQjmsSelector jms_sel = this.getAQJmsSelector((AQjmsDestination)topic, entry.m_selector, entry.m_noLocal, payloadFactory);
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jms_sel, entry.m_transformation, entry.m_noLocal, true);
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "Did not found the subscriber in the map");
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, null, null, false, false);
        }
        this.cons_list.put(subscriber, subscriber);
        AQjmsOracleDebug.trace(5, "AQjmsSession.getDurableSubscriber", "exit");
        return subscriber;
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remoteSubscriber, String messageSelector) throws JMSException {
        this.createRemoteSubscriber(topic, remoteSubscriber, messageSelector, null, null, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remoteSubscriber, String messageSelector, Object payloadFactory) throws JMSException {
        this.createRemoteSubscriber(topic, remoteSubscriber, messageSelector, payloadFactory, null, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remoteSubscriber, String messageSelector, Object payloadFactory, String transformation) throws JMSException {
        this.createRemoteSubscriber(topic, remoteSubscriber, messageSelector, payloadFactory, transformation, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remoteSubscriber, String messageSelector, Object payloadFactory, String transformation, boolean queueToQueue) throws JMSException {
        AQjmsSelector jms_sel = null;
        Connection db_conn = null;
        String ptype = null;
        String remote_dest = null;
        db_conn = this.getDBConnection();
        if (remoteSubscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            remote_dest = remoteSubscriber.getAddress();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createRemoteSubscriber1 - get address of remote subscriber", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (remote_dest == null || remote_dest.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            ptype = ((AQjmsDestination)topic).getAdtType();
            AQjmsDestination aqjmsTopic = (AQjmsDestination)topic;
            if (aqjmsTopic.isSharded()) {
                jms_sel = new AQjmsSelector(messageSelector, 20, 4, this.dbversion, aqjmsTopic);
            } else if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                jms_sel = new AQjmsSelector(messageSelector, 20, 1, this.dbversion, this.getCompliant());
            } else if (ptype.equalsIgnoreCase("SYS.ANYDATA")) {
                jms_sel = new AQjmsSelector(messageSelector, 20, 3, this.dbversion, this.getCompliant());
            } else {
                if (payloadFactory == null) {
                    AQjmsError.throwEx(137);
                }
                jms_sel = new AQjmsSelector(messageSelector, 20, 2, this.dbversion, this.getCompliant());
            }
        }
        try {
            this.addDurableSubscriber(topic, remoteSubscriber, jms_sel, false, null, true, transformation, queueToQueue);
        }
        catch (AQjmsException aq_ex) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createRemoteSubscriber - aq_ex", "error number: " + aq_ex.getErrorNumber());
            if (aq_ex.getErrorNumber() == 24034) {
                this.alterDurableSubscriber(topic, remoteSubscriber, jms_sel, false, null, true, transformation);
            }
            throw aq_ex;
        }
    }

    synchronized void removeRemoteSubscriber(Topic topic, AQjmsAgent remoteSubscriber) throws JMSException {
        String remote_dest = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (remoteSubscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            remote_dest = remoteSubscriber.getAddress();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeRemoteSubscriber2 - get address of remote subscriber", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (remote_dest == null || remote_dest.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        this.removeSubscriber(topic, remoteSubscriber);
    }

    synchronized subcriberStatus checkSubscriberExists(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel) {
        boolean subRuleCheck = AQjmsConstants.FORCE_SUB_RULE_CHECK;
        subcriberStatus status = subcriberStatus.NO_SUBSCRIBER;
        boolean retry = false;
        int attempts = 0;
        do {
            try {
                ++attempts;
                status = this.checkSubscriberExistsWithRule(topic, agent, jms_sel, subRuleCheck);
            }
            catch (SQLException e) {
                if (!subRuleCheck || e.getErrorCode() != 6550) continue;
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists retry to check if subscriber exists", e);
                subRuleCheck = false;
                retry = true;
            }
        } while (retry && attempts < 2);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized subcriberStatus checkSubscriberExistsWithRule(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, boolean subRuleCheck) throws SQLException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        Connection db_conn = null;
        int s_exists = 0;
        String rule = null;
        int is_rule_same = 0;
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "entry");
        try {
            if (agent == null) {
                AQjmsError.throwEx(105);
            }
            db_conn = this.getDBConnection();
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                }
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subs_name: " + subs_name + " subs_addr: " + subs_addr + " subs_prot: " + subs_prot);
            if (this.chks_stmt != null) {
                this.chks_stmt.clearParameters();
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "before subs_exists t_name: " + t_name);
                String checkStmtStr = AQjmsInterOp.getCheckStmtByVersion(this.dbversion, subRuleCheck);
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subscriber_exists statement: " + checkStmtStr);
                this.chks_stmt = db_conn.prepareCall(checkStmtStr);
            }
            this.chks_stmt.setString(1, t_name);
            this.chks_stmt.setObject(2, (Object)agt, 2002);
            this.chks_stmt.setObject(3, (Object)1);
            this.chks_stmt.registerOutParameter(4, 2);
            this.chks_stmt.registerOutParameter(5, 12);
            this.chks_stmt.registerOutParameter(6, 12);
            this.chks_stmt.registerOutParameter(7, 12);
            if (subRuleCheck || this.is21compatible()) {
                this.chks_stmt.registerOutParameter(8, 12);
                this.chks_stmt.registerOutParameter(9, 2);
                this.chks_stmt.registerOutParameter(10, 2);
                this.chks_stmt.setString(11, rule);
                this.chks_stmt.execute();
                s_exists = this.chks_stmt.getInt(9);
                is_rule_same = this.chks_stmt.getInt(10);
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "is_rule_same: " + is_rule_same);
            } else if (this.is10compatible()) {
                this.chks_stmt.registerOutParameter(8, 12);
                this.chks_stmt.registerOutParameter(9, 2);
                this.chks_stmt.execute();
                s_exists = this.chks_stmt.getInt(9);
            } else {
                this.chks_stmt.registerOutParameter(8, 2);
                this.chks_stmt.execute();
                s_exists = this.chks_stmt.getInt(8);
            }
        }
        catch (SQLException sqlex) {
            try {
                this.chks_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.chks_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-sqlex", sqlex);
            if (subRuleCheck && sqlex.getErrorCode() == 6550) {
                throw sqlex;
            }
            s_exists = 0;
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-ex", ex);
            s_exists = 0;
        }
        finally {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkSubscriberExists", "always close the check stmt");
            if (this.chks_stmt != null) {
                try {
                    this.chks_stmt.close();
                }
                catch (Exception sqlex) {}
                this.chks_stmt = null;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "exit s_exists=" + s_exists);
        if (s_exists == 1) {
            if (is_rule_same == 1) {
                return subcriberStatus.SAME_SELECTOR;
            }
            return subcriberStatus.SUBSCRIBER_EXISTS;
        }
        return subcriberStatus.NO_SUBSCRIBER;
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String receiverName, String messageSelector) throws JMSException {
        return this.createTopicReceiver(topic, receiverName, messageSelector, null);
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String receiverName, String messageSelector, Object payloadFactory) throws JMSException {
        AQjmsConsumer receiver = null;
        AQjmsSelector jms_sel = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createTopicReceiver after MessageListener is set");
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            AQjmsDestination aqjmsTopic = (AQjmsDestination)topic;
            jms_sel = aqjmsTopic.isSharded() ? new AQjmsSelector(messageSelector, 20, 4, this.dbversion, aqjmsTopic) : (payloadFactory != null ? new AQjmsSelector(messageSelector, 10, 2, this.dbversion, this.getCompliant()) : ((p_data_type = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 10, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(messageSelector, 10, 1, this.dbversion, this.getCompliant())));
        }
        receiver = new AQjmsConsumer(this, (Destination)topic, 20, 3, receiverName, payloadFactory, jms_sel, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    private synchronized TopicSubscriber addDurableSubscriber(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, boolean noLocal, Object payloadFactory, boolean remote, String transformation, boolean queueToQueue) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        String rule = null;
        AQjmsConsumer subscriber = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        Statement adds_stmt = null;
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                }
            }
            String addStmtStr = AQjmsInterOp.getAddSubStmtByVersion(this.dbversion, queueToQueue);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "add_subscriber statement:" + addStmtStr);
            adds_stmt = db_conn.prepareCall(addStmtStr);
            adds_stmt.setString(1, t_name);
            adds_stmt.setObject(2, agt, 2002);
            adds_stmt.setString(3, rule);
            if (this.is82compatible()) {
                adds_stmt.setString(4, transformation);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        adds_stmt.setInt(5, 1);
                    } else {
                        adds_stmt.setInt(5, 0);
                    }
                }
            }
            adds_stmt.execute();
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addDurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (adds_stmt != null) {
                    adds_stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!remote) {
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payloadFactory, jms_sel, transformation, noLocal);
            this.cons_list.put(subscriber, subscriber);
            return subscriber;
        }
        return null;
    }

    private synchronized TopicSubscriber addAQNondurableSubscriber(Topic topic, String messageSelector, boolean noLocal, Object payloadFactory, String transformation) throws JMSException {
        Connection dbConn = this.getDBConnection();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "create subscriber after MessageListener of Session is set");
        }
        AQjmsSelector jmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, messageSelector, noLocal, payloadFactory);
        String addSubStmtStr = AQjmsInterOp.getAddAQNondurableSubStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "add nondurable subscriber statement: " + addSubStmtStr);
        String topicName = ((AQjmsDestination)topic).getCompleteName();
        String rule = null;
        if (jmsSelector != null) {
            if (jmsSelector.getSelectorType() == 10) {
                rule = jmsSelector.getRule();
            } else if (jmsSelector.getSelectorType() == 40) {
                rule = jmsSelector.getAdtRule();
            }
        }
        CallableStatement addSubStmt = null;
        String subscriberName = null;
        try {
            addSubStmt = dbConn.prepareCall(addSubStmtStr);
            addSubStmt.setString(1, topicName);
            addSubStmt.setString(2, rule);
            addSubStmt.setString(3, transformation);
            if (this.clientSessionGUID == null) {
                addSubStmt.setString(4, null);
                addSubStmt.registerOutParameter(4, 12);
            } else {
                addSubStmt.setString(4, this.clientSessionGUID);
            }
            addSubStmt.registerOutParameter(5, 12);
            addSubStmt.execute();
            subscriberName = addSubStmt.getString(5);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "subscriber name: " + subscriberName);
            if (this.clientSessionGUID == null) {
                this.clientSessionGUID = addSubStmt.getString(4);
                AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "session GUID: " + this.clientSessionGUID);
            }
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addAQNondurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (addSubStmt != null) {
                    addSubStmt.close();
                }
            }
            catch (Exception exception) {}
        }
        AQjmsConsumer subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jmsSelector, transformation, noLocal);
        subscriber.setDurable(false);
        this.cons_list.put(subscriber, subscriber);
        return subscriber;
    }

    private TopicSubscriber addAQNondurableSubscriberSQ(Topic topic, String messageSelector, boolean noLocal, Object payloadFactory, String transformation) throws JMSException {
        Connection dbConn = this.getDBConnection();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "create subscriber after MessageListener of Session is set");
        }
        AQjmsSelector jmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, messageSelector, noLocal, payloadFactory);
        String addSubStmtStr = AQjmsInterOp.getAddAQNondurableSubSQStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriberSQ", "add nondurable subscribe sql statement: " + addSubStmtStr);
        String topicName = ((AQjmsDestination)topic).getCompleteName();
        String rule = null;
        if (jmsSelector != null) {
            if (jmsSelector.getSelectorType() == 10) {
                rule = jmsSelector.getRule();
            } else if (jmsSelector.getSelectorType() == 40) {
                rule = jmsSelector.getAdtRule();
            }
        }
        CallableStatement addSubStmt = null;
        String subscriberName = null;
        try {
            addSubStmt = dbConn.prepareCall(addSubStmtStr);
            addSubStmt.setString(1, topicName);
            addSubStmt.setString(2, rule);
            addSubStmt.setString(3, transformation);
            addSubStmt.registerOutParameter(4, 12);
            addSubStmt.execute();
            subscriberName = addSubStmt.getString(4);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriberSQ", "nondurable subscriber is added: topic=" + topicName + ", subscriber name=" + subscriberName);
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addAQNondurableSubscriberSQ", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (addSubStmt != null) {
                    addSubStmt.close();
                }
            }
            catch (Exception exception) {}
        }
        AQjmsConsumer subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jmsSelector, transformation, noLocal);
        subscriber.setDurable(false);
        this.cons_list.put(subscriber, subscriber);
        return subscriber;
    }

    private void removeAQNondurableSubscriberSQ(AQjmsDestination topic, String subName) throws JMSException {
        Connection dbConn = this.getOurDBConnection();
        if (!topic.isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        String removeSubStmtStr = AQjmsInterOp.getRemoveAQNondurableSubSQStmtByVersion(this.dbversion);
        String topicName = topic.getCompleteName();
        CallableStatement stmt = null;
        try {
            stmt = dbConn.prepareCall(removeSubStmtStr);
            stmt.setString(1, topicName);
            stmt.setString(2, subName);
            stmt.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscriberSQ", "nondurable subscriber is removed: topic=" + topicName + ", subscriber name=" + subName);
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeAQNondurableSubscriberSQ", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void removeAQNondurableSubscribers(String sessGUID) throws JMSException {
        Connection dbConn = this.getOurDBConnection();
        String removeSubsStmtStr = AQjmsInterOp.getRemoveAQNondurableSubsStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscribers", "remove nondurable subscribers by session GUID statement: " + removeSubsStmtStr);
        CallableStatement stmt = null;
        try {
            stmt = dbConn.prepareCall(removeSubsStmtStr);
            AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscribers", "session GUID : " + sessGUID);
            stmt.setString(1, sessGUID);
            stmt.execute();
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeAQNondurableSubscribers", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private synchronized TopicSubscriber alterDurableSubscriber(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, boolean noLocal, Object payloadFactory, boolean remote, String transformation) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        String rule = null;
        AQjmsConsumer subscriber = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Rule: " + rule);
                }
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                String alterStmtStr = AQjmsInterOp.getAlterSubStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "alter_subscriber statement : " + alterStmtStr);
                this.alts_stmt = db_conn.prepareCall(alterStmtStr);
            }
            this.alts_stmt.setString(1, t_name);
            this.alts_stmt.setObject(2, (Object)agt, 2002);
            this.alts_stmt.setString(3, rule);
            if (this.is82compatible()) {
                this.alts_stmt.setString(4, transformation);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        this.alts_stmt.setInt(5, 1);
                    } else {
                        this.alts_stmt.setInt(5, 0);
                    }
                }
            }
            this.alts_stmt.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Subscriber");
        }
        catch (SQLException sqlex) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alts_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.alterDurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        if (!remote) {
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payloadFactory, jms_sel, transformation, noLocal);
            this.cons_list.put(subscriber, subscriber);
            return subscriber;
        }
        return null;
    }

    boolean diffSubName(String consumerName) {
        if (this.prevSubName == null || !this.prevSubName.equalsIgnoreCase(consumerName)) {
            this.prevSubName = consumerName;
            return true;
        }
        return false;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        AQjmsTopicPublisherImpl publisher = null;
        this.checkSessionStarted();
        if (!(topic == null || topic instanceof AQjmsDestination && ((AQjmsDestination)topic).isTopic())) {
            AQjmsError.throwInvalidDestEx(126);
        }
        publisher = new AQjmsTopicPublisherImpl(this, (AQjmsDestination)topic);
        return publisher;
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        return this.makeTemporaryQueue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(String subscriberName) throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (subscriberName == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(235));
        }
        String clientId = this.jms_conn.getClientIDForce();
        Map<String, Map<String, Map<String, Topic>>> map = s_subt;
        synchronized (map) {
            Map<String, Map<String, Topic>> cid2subs = s_subt.get(this.genConn.providerKey);
            if (cid2subs == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            Map<String, Topic> name2topic = cid2subs.get(clientId);
            if (name2topic == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            Topic topic = name2topic.get(subscriberName);
            if (topic == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            this.unsubscribe(topic, subscriberName);
            name2topic.remove(subscriberName);
            if (name2topic.isEmpty()) {
                cid2subs.remove(clientId);
            }
            if (cid2subs.isEmpty()) {
                s_subt.remove(this.genConn.providerKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(Topic topic, String subscriberName) throws JMSException {
        AQjmsAgent agent = null;
        Connection db_conn = null;
        String topicName = null;
        int nameBehav = 0;
        String revisedSubName = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "entry");
        this.checkSessionStarted();
        db_conn = this.getDBConnection();
        if (subscriberName == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "origSubName: " + subscriberName);
        if (!((AQjmsDestination)topic).isSharded()) {
            topicName = ((AQjmsDestination)topic).getCompleteName();
            if (AQjmsUtil.isGrantOnAQADMPriv(db_conn)) {
                nameBehav = AQjmsUtil.getQueueParameter(db_conn, topicName, "AQJMS_NAME_BEHAVIOR");
            }
            AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "nameBehavior: " + nameBehav);
            revisedSubName = this.getRevisedSubName(subscriberName, nameBehav);
        } else {
            revisedSubName = AQjmsSession.chopit(subscriberName, this.getMaxSubscriberNameLen());
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "revisedSubName: " + revisedSubName);
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "subs name:" + subscriberName + ", topic name:" + ((AQjmsDestination)topic).getTopicName());
        if (this.getCompliant()) {
            Object mapLock;
            AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "unsubscribe in compliant mode, consult in memeory map before remove AQ subscriber.");
            Object object = mapLock = AQjmsClientSubscriberMap.getMapLock();
            synchronized (object) {
                AQjmsClientSubscriberMap.unsubscribeClientSubscriber(this.jms_conn.getClientIDForce(), revisedSubName);
                try {
                    agent = new AQjmsAgent();
                    agent.setName(revisedSubName);
                    this.removeSubscriber(topic, agent);
                }
                catch (SQLException sql_ex) {
                    throw new AQjmsException(sql_ex);
                }
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "unsubscribe in old mode, just remove the AQ subscriber.");
        try {
            agent = new AQjmsAgent();
            agent.setName(revisedSubName);
            this.removeSubscriber(topic, agent);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "exit");
    }

    public synchronized void unsubscribe(Topic topic, AQjmsAgent remoteSubscriber) throws JMSException {
        this.checkSessionStarted();
        this.removeRemoteSubscriber(topic, remoteSubscriber);
    }

    private synchronized void removeSubscriber(Topic topic, AQjmsAgent subscriber) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.removeSubscriber", "enter");
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            t_name = ((AQjmsDestination)topic).getCompleteName();
            subs_name = subscriber.getName();
            subs_addr = subscriber.getAddress();
            subs_prot = subscriber.getProtocol();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                String removeStmtStr = AQjmsInterOp.getRemoveSubStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.removeSubscriber", "remove_subscriber statement: " + removeStmtStr);
                this.rems_stmt = db_conn.prepareCall(removeStmtStr);
            }
            this.rems_stmt.setString(1, t_name);
            this.rems_stmt.setObject(2, (Object)agt, 2002);
            if (this.is92compatible()) {
                if (((AQjmsDestination)topic).isSecure()) {
                    this.rems_stmt.setInt(3, 1);
                } else {
                    this.rems_stmt.setInt(3, 0);
                }
            }
            this.rems_stmt.execute();
            try {
                Enumeration e = this.cons_list.elements();
                while (e.hasMoreElements()) {
                    AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
                    if (cons.cons_name == null || !cons.cons_name.equals(subs_name) || !cons.cons_dest.getCompleteName().equals(t_name)) continue;
                    cons.disableConsumerExceptionListener();
                }
            }
            catch (Exception cex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", cex);
            }
        }
        catch (SQLException sqlex) {
            try {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.removeSubscriber", "exit");
    }

    synchronized Map<String, JMSNotificationRegistration> registerJMSNotification(String[] names, Map<String, Properties> opts, String selectorRule) throws SQLException, JMSException {
        OracleConnection conn = (OracleConnection)this.getDBConnection();
        return conn.registerJMSNotification(names, opts, selectorRule);
    }

    synchronized void unregisterJMSNotification(JMSNotificationRegistration registration) throws JMSException, SQLException {
        OracleConnection conn = (OracleConnection)this.getDBConnection();
        conn.unregisterJMSNotification(registration);
    }

    synchronized void startJMSNotification(JMSNotificationRegistration registration) throws JMSException, SQLException {
        OracleConnection conn = (OracleConnection)this.getDBConnection();
        conn.startJMSNotification(registration);
    }

    synchronized void ackJMSNotification(JMSNotificationRegistration registration, byte[] lastMessageID, JMSNotificationRegistration.Directive hint) throws SQLException, JMSException {
        OracleConnection conn = (OracleConnection)this.getDBConnection();
        conn.ackJMSNotification(registration, lastMessageID, hint);
    }

    public void run() {
    }

    public Connection getDBConnection() throws JMSException {
        this.checkSessionStarted();
        return this.db_conn;
    }

    private Connection getOurDBConnection() {
        return this.db_conn;
    }

    public Map getTypeMap() throws JMSException {
        Map type_map = null;
        oracle.jdbc.OracleConnection db_conn = null;
        try {
            db_conn = (oracle.jdbc.OracleConnection)this.getDBConnection();
            type_map = db_conn.getTypeMap();
            if (type_map != null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap found");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap NULL");
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getTypeMap", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        return type_map;
    }

    private void checkSessionStarted() throws JMSException {
        if (this.isSessionClosed() && Thread.currentThread() != this.closingThread) {
            String arg1 = null;
            if (this.jdbcConnInfo != null) {
                arg1 = "JMS Session with JDBC Conn:" + this.jdbcConnInfo.toString();
                arg1 = arg1 + "Time Now: " + String.valueOf(new Date());
            }
            AQjmsError.throwIllegalStateEx(131, arg1);
        }
    }

    public AQjmsConnection getJmsConnection() throws JMSException {
        return this.jms_conn;
    }

    public AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property) throws JMSException {
        return this.createQueueTable(owner, name, property, false);
    }

    public synchronized AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property, boolean autonomous) throws JMSException {
        AQOracleSession sess = null;
        AQQueueTable q_table = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            q_table = sess.createQueueTable(owner, name, property, autonomous);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueueTable", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return q_table;
    }

    public synchronized AQQueueTable getQueueTable(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQQueueTable q_table = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            q_table = sess.getQueueTable(owner, name);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getQueueTable", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return q_table;
    }

    public synchronized Queue createQueue(AQQueueTable queueTable, String queueName, AQjmsDestinationProperty destinationProperty) throws JMSException {
        return this.createQueue(queueTable, queueName, destinationProperty, false);
    }

    public synchronized Queue createQueue(AQQueueTable queueTable, String queueName, AQjmsDestinationProperty destinationProperty, boolean autonomous) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_queue = null;
        Connection db_conn = null;
        AQjmsDestinationProperty curr_dest_property = null;
        db_conn = this.getDBConnection();
        if (destinationProperty == null) {
            AQjmsError.throwEx(121);
        }
        if (queueTable == null) {
            AQjmsError.throwEx(187);
        }
        try {
            if (((AQOracleQueueTable)queueTable).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(144);
            }
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.createQueue(queueTable, queueName, destinationProperty, autonomous);
            curr_dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_queue = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), curr_dest_property, aq_queue.getQueueTableName(), queueTable.isSecure());
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueue", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return jms_queue;
    }

    public Topic createTopic(AQQueueTable queueTable, String topicName, AQjmsDestinationProperty destinationProperty) throws JMSException {
        return this.createTopic(queueTable, topicName, destinationProperty, false);
    }

    public synchronized Topic createTopic(AQQueueTable queueTable, String topicName, AQjmsDestinationProperty destinationProperty, boolean autonomous) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_topic = null;
        Connection db_conn = null;
        AQjmsDestinationProperty curr_dest_property = null;
        db_conn = this.getDBConnection();
        if (queueTable == null) {
            AQjmsError.throwEx(187);
        }
        if (destinationProperty == null) {
            AQjmsError.throwEx(121);
        }
        try {
            if (destinationProperty.getQueueType() == 1) {
                AQjmsError.throwEx(151);
            }
            if (!((AQOracleQueueTable)queueTable).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.createQueue(queueTable, topicName, destinationProperty, autonomous);
            AQjmsOracleDebug.trace(5, "AQjmsSession.createTopic", "Queue table: " + aq_queue.getQueueTableName());
            curr_dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_topic = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), curr_dest_property, aq_queue.getQueueTableName(), queueTable.isSecure());
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return jms_topic;
    }

    public synchronized Queue getQueue(String owner, String name) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.getQueue IN", " owner: " + owner + ", name: " + name);
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_queue = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        AQOracleQueueTable q_table = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getQueue", "created AQOracleSession");
            aq_queue = (AQOracleQueue)sess.getQueue(owner, name);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getQueue", "finish AQOracleSession.getQueue()");
            dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_queue = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure());
            q_table = (AQOracleQueueTable)this.getQueueTable(aq_queue.getOwner(), aq_queue.getQueueTableName());
            if (q_table.isMulticonsumerEnabled() && dest_property.getQueueType() != 1) {
                AQjmsError.throwEx(130);
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getQueue", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (q_table != null) {
                    q_table.getAQSession().close();
                }
            }
            catch (Throwable throwable) {}
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.getQueue EXIT", "");
        return jms_queue;
    }

    public Destination getJmsDestination(AQOracleQueue aq_queue) throws JMSException {
        AQjmsDestination jms_dest = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        String ptype = null;
        db_conn = this.getDBConnection();
        try {
            ptype = aq_queue.getObjectPayloadType();
            if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getJmsDestination", "before newAQjmsDestProp");
                dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
                jms_dest = !aq_queue.isMultiConsumer() || dest_property.getQueueType() == 1 ? new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure()) : new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure());
            } else {
                jms_dest = null;
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.geJmsDestination", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return jms_dest;
    }

    public synchronized Topic getTopic(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_topic = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        AQOracleQueueTable q_table = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.getQueue(owner, name);
            dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_topic = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure());
            q_table = (AQOracleQueueTable)this.getQueueTable(aq_queue.getOwner(), aq_queue.getQueueTableName());
            if (!q_table.isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getTopic", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (q_table != null) {
                    q_table.getAQSession().close();
                }
            }
            catch (Throwable throwable) {}
        }
        return jms_topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSessionClosed() throws JMSException {
        boolean closed = false;
        if (this.isClosed()) {
            return true;
        }
        Object object = this.m_consync;
        synchronized (object) {
            if (this.jms_conn == null) {
                closed = true;
            } else {
                block13: {
                    if (this.db_conn != null) {
                        try {
                            if (!this.db_conn.isClosed()) {
                                closed = false;
                                break block13;
                            }
                            closed = true;
                        }
                        catch (Exception ex) {
                            closed = true;
                        }
                    } else {
                        closed = false;
                    }
                }
                if (closed) {
                    this.thisSessionClosed = true;
                    if (this.jdbcConnInfo != null) {
                        this.jdbcConnInfo.setInValid(true);
                        AQjmsOracleDebug.trace(1, "AQjmsSession.isSessionClosed", "JDBC Connection found Closed: " + this.jdbcConnInfo.toString() + " Time Now:" + String.valueOf(new Date()));
                    }
                }
            }
        }
        return closed;
    }

    int getCloseCheckInterval() {
        return this.cl_check_interval;
    }

    public synchronized void setCloseCheckInterval(int interval) throws JMSException {
        if (interval >= 1) {
            this.cl_check_interval = interval;
        } else {
            AQjmsError.throwEx(123, Integer.toString(1));
        }
    }

    public void grantSystemPrivilege(String privilege, String grantee, boolean adminOption) throws JMSException {
        AQOracleSession sess = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQOracleAdmin.grantSystemPrivilege(sess, privilege, grantee, adminOption);
            sess.close();
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.grantSystemPrivilege", aq_ex);
            throw new AQjmsException(aq_ex);
        }
    }

    public void revokeSystemPrivilege(String privilege, String grantee) throws JMSException {
        AQOracleSession sess = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQOracleAdmin.revokeSystemPrivilege(sess, privilege, grantee);
            sess.close();
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.revokeSystemPrivilege", aq_ex);
            throw new AQjmsException(aq_ex);
        }
    }

    public void createAQAgent(String agentName) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "entry");
        this.createAQAgent(agentName, false, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "exit");
    }

    public void createAQAgent(String agentName, boolean enableHTTP, boolean enableSMTP, String certLocation) throws JMSException {
        Statement ag_stmt = null;
        Connection db_conn = null;
        String http_flag = "false";
        String smtp_flag = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "entry");
        if (agentName == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (enableHTTP) {
            http_flag = "true";
        }
        if (enableSMTP) {
            smtp_flag = "true";
        }
        try {
            db_conn = this.getDBConnection();
            ag_stmt = db_conn.prepareCall("begin dbms_aqadm.create_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + http_flag + ", enable_smtp => " + smtp_flag + "); end;");
            ag_stmt.setString(1, agentName);
            ag_stmt.setString(2, certLocation);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "exit");
    }

    public void alterAQAgent(String agentName, boolean enableHTTP, boolean enableSMTP, String certLocation) throws JMSException {
        Statement ag_stmt = null;
        Connection db_conn = null;
        String http_flag = "false";
        String smtp_flag = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "entry");
        if (agentName == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (enableHTTP) {
            http_flag = "true";
        }
        if (enableSMTP) {
            smtp_flag = "true";
        }
        try {
            db_conn = this.getDBConnection();
            ag_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + http_flag + ", enable_smtp => " + smtp_flag + "); end;");
            ag_stmt.setString(1, agentName);
            ag_stmt.setString(2, certLocation);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "exit");
    }

    public void dropAQAgent(String agentName) throws JMSException {
        Statement ag_stmt = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "entry");
        if (agentName == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        try {
            db_conn = this.getDBConnection();
            ag_stmt = db_conn.prepareCall("begin dbms_aqadm.drop_aq_agent(agent_name=> ? ); end;");
            ag_stmt.setString(1, agentName);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "exit");
    }

    public void enableDBAccess(String agentName, String dbUserName) throws JMSException {
        Statement ed_stmt = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "entry");
        if (agentName == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (dbUserName == null) {
            AQjmsError.throwEx(229, "dbUserName");
        }
        try {
            db_conn = this.getDBConnection();
            ed_stmt = db_conn.prepareCall("begin dbms_aqadm.enable_db_access(agent_name=> ?, db_username => ? ); end;");
            ed_stmt.setString(1, agentName);
            ed_stmt.setString(2, dbUserName);
            ed_stmt.execute();
            try {
                ed_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                ed_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "exit");
    }

    public void disableDBAccess(String agentName, String dbUserName) throws JMSException {
        Statement ed_stmt = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "entry");
        if (agentName == null) {
            AQjmsError.throwEx(229, "agentName");
        }
        if (dbUserName == null) {
            AQjmsError.throwEx(229, "dbUserName");
        }
        try {
            db_conn = this.getDBConnection();
            ed_stmt = db_conn.prepareCall("begin dbms_aqadm.disable_db_access(agent_name=> ?, db_username => ? ); end;");
            ed_stmt.setString(1, agentName);
            ed_stmt.setString(2, dbUserName);
            ed_stmt.execute();
            try {
                ed_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                ed_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "exit");
    }

    public boolean isDeqStmtCachingEnabled() {
        return this.cache_deq_stmt;
    }

    public void setDeqStmtCachingFlag(boolean value) {
        this.cache_deq_stmt = value;
    }

    public void bindAgent(AQjmsAgent agent, String certificate) throws JMSException {
        Connection db_conn = null;
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        db_conn = this.getDBConnection();
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.bind_stmt != null) {
                this.bind_stmt.clearParameters();
            } else {
                this.bind_stmt = db_conn.prepareCall("begin dbms_aq.bind_agent(agent=>?, certificate_location=>?); end;");
            }
            this.bind_stmt.setObject(1, (Object)agt, 2002);
            this.bind_stmt.setString(2, certificate);
            this.bind_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.bind_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bind_stmt = null;
            throw new AQjmsException(sqlex);
        }
    }

    public void unbindAgent(AQjmsAgent agent) throws JMSException {
        Connection db_conn = null;
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        db_conn = this.getDBConnection();
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.clearParameters();
            } else {
                this.ubnd_stmt = db_conn.prepareCall("begin dbms_aq.unbind_agent(agent=>?); end;");
            }
            this.ubnd_stmt.setObject(1, (Object)agt, 2002);
            this.ubnd_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.ubnd_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ubnd_stmt = null;
            throw new AQjmsException(sqlex);
        }
    }

    OracleCallableStatement getTextStmt() throws SQLException {
        if (this.st_text == null) {
            String textStmtStr = AQjmsInterOp.getEnquTextMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getTextStmt", "enqueue_text statement: " + textStmtStr);
            this.st_text = (OracleCallableStatement)this.db_conn.prepareCall(textStmtStr);
        } else {
            this.st_text.clearParameters();
        }
        return this.st_text;
    }

    OracleCallableStatement getMapStmt() throws SQLException {
        if (this.st_map == null) {
            String mapStmtStr = AQjmsInterOp.getEnquMapMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getMapStmt", "enqueue_map statement: " + mapStmtStr);
            this.st_map = (OracleCallableStatement)this.db_conn.prepareCall(mapStmtStr);
        } else {
            this.st_map.clearParameters();
        }
        return this.st_map;
    }

    OracleCallableStatement getStreamStmt() throws SQLException {
        if (this.st_stream == null) {
            String streamStmtStr = AQjmsInterOp.getEnquStreamMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getStreamStmt", "enqueue_stream statement: " + streamStmtStr);
            this.st_stream = (OracleCallableStatement)this.db_conn.prepareCall(streamStmtStr);
        } else {
            this.st_stream.clearParameters();
        }
        return this.st_stream;
    }

    OracleCallableStatement getBytesStmt() throws SQLException {
        if (this.st_bytes == null) {
            String bytesStmtStr = AQjmsInterOp.getEnquBytesMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getBytesStmt", "enqueue_bytes statement: " + bytesStmtStr);
            this.st_bytes = (OracleCallableStatement)this.db_conn.prepareCall(bytesStmtStr);
        } else {
            this.st_bytes.clearParameters();
        }
        return this.st_bytes;
    }

    OracleCallableStatement getObjectStmt() throws SQLException {
        if (this.st_object == null) {
            String objectStmtStr = AQjmsInterOp.getEnquObjectMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getObjectStmt", "enqueue_object statement: " + objectStmtStr);
            this.st_object = (OracleCallableStatement)this.db_conn.prepareCall(objectStmtStr);
        } else {
            this.st_object.clearParameters();
        }
        return this.st_object;
    }

    OracleCallableStatement getAdtStmt() throws SQLException {
        if (this.st_adt == null) {
            String adtStmtStr = AQjmsInterOp.getEnquAdtStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtStmt", "enqueue_adt statement: " + adtStmtStr);
            this.st_adt = (OracleCallableStatement)this.db_conn.prepareCall(adtStmtStr);
        } else {
            this.st_adt.clearParameters();
        }
        return this.st_adt;
    }

    OracleCallableStatement getAdtNoRecplStmt() throws SQLException {
        if (this.st_adt_rep == null) {
            String adtRepStmtStr = AQjmsInterOp.getEnquAdtNoRecplStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtNoRecplStmt", "enqueue_adt_norecpl statement: " + adtRepStmtStr);
            this.st_adt_rep = (OracleCallableStatement)this.db_conn.prepareCall(adtRepStmtStr);
        } else {
            this.st_adt_rep.clearParameters();
        }
        return this.st_adt_rep;
    }

    OracleCallableStatement getEnqueueStmt(Message message) throws SQLException {
        if (message instanceof AQjmsTextMessage) {
            return this.getTextStmt();
        }
        if (message instanceof AQjmsBytesMessage) {
            return this.getBytesStmt();
        }
        if (message instanceof AQjmsStreamMessage) {
            return this.getStreamStmt();
        }
        if (message instanceof AQjmsMapMessage) {
            return this.getMapStmt();
        }
        if (message instanceof AQjmsObjectMessage) {
            return this.getObjectStmt();
        }
        return null;
    }

    OracleCallableStatement getDequeueStmt() throws SQLException {
        if (this.deq_stmt == null) {
            String dequStmtStr = AQjmsInterOp.getDequeueStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getDequeueStmt", "dequeue statement: " + dequStmtStr);
            this.deq_stmt = (OracleCallableStatement)this.db_conn.prepareCall(dequStmtStr);
        } else {
            this.deq_stmt.clearParameters();
        }
        return this.deq_stmt;
    }

    OracleCallableStatement getArrayEnqueueStmt(String qtabletype) throws SQLException {
        String pkgName = this.is19compatible() ? "dbms_aqjms." : "dbms_aqjms_internal.";
        AQjmsOracleDebug.trace(5, "AQjmsSession.getArrayEnqueueStmt: pkgName: ", pkgName);
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            if (this.st_array_enqueue == null) {
                this.st_array_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_enqueue_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_enqueue.clearParameters();
            }
            return this.st_array_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            if (this.st_array_text_enqueue == null) {
                this.st_array_text_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_enqueue_text_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_text_enqueue.clearParameters();
            }
            return this.st_array_text_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            if (this.st_array_bytes_enqueue == null) {
                this.st_array_bytes_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_enqueue_bytes_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_bytes_enqueue.clearParameters();
            }
            return this.st_array_bytes_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (this.st_array_stream_enqueue == null) {
                this.st_array_stream_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_enqueue_str_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_stream_enqueue.clearParameters();
            }
            return this.st_array_stream_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            if (this.st_array_map_enqueue == null) {
                this.st_array_map_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_enqueue_map_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_map_enqueue.clearParameters();
            }
            return this.st_array_map_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            if (this.st_array_object_enqueue == null) {
                this.st_array_object_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_enqueue_obj_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_object_enqueue.clearParameters();
            }
            return this.st_array_object_enqueue;
        }
        return null;
    }

    OracleCallableStatement getArrayDequeueStmt(String qtabletype) throws SQLException {
        String pkgName = this.is19compatible() ? "dbms_aqjms." : "dbms_aqjms_internal.";
        AQjmsOracleDebug.trace(5, "AQjmsSession.getArrayDequeueStmt: pkgName: ", pkgName);
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            if (this.st_array_dequeue == null) {
                this.st_array_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_dequeue_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_dequeue.clearParameters();
            }
            return this.st_array_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            if (this.st_array_text_dequeue == null) {
                this.st_array_text_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_dequeue_text_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_text_dequeue.clearParameters();
            }
            return this.st_array_text_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            if (this.st_array_bytes_dequeue == null) {
                this.st_array_bytes_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_dequeue_bytes_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_bytes_dequeue.clearParameters();
            }
            return this.st_array_bytes_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (this.st_array_stream_dequeue == null) {
                this.st_array_stream_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_dequeue_stream_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_stream_dequeue.clearParameters();
            }
            return this.st_array_stream_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            if (this.st_array_map_dequeue == null) {
                this.st_array_map_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_dequeue_map_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_map_dequeue.clearParameters();
            }
            return this.st_array_map_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            if (this.st_array_object_dequeue == null) {
                this.st_array_object_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin " + pkgName + "aq$_jms_dequeue_object_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_object_dequeue.clearParameters();
            }
            return this.st_array_object_dequeue;
        }
        return null;
    }

    void destroyStmt(OracleCallableStatement stmt) {
        if (stmt == null) {
            return;
        }
        boolean del = false;
        if (stmt == this.st_text) {
            this.st_text = null;
            del = true;
        } else if (stmt == this.st_map) {
            this.st_map = null;
            del = true;
        } else if (stmt == this.st_bytes) {
            this.st_bytes = null;
            del = true;
        } else if (stmt == this.st_stream) {
            this.st_stream = null;
            del = true;
        } else if (stmt == this.st_object) {
            this.st_object = null;
            del = true;
        } else if (stmt == this.st_adt) {
            this.st_adt = null;
            del = true;
        } else if (stmt == this.st_adt_rep) {
            this.st_adt_rep = null;
            del = true;
        } else if (stmt == this.deq_stmt) {
            this.deq_stmt = null;
            del = true;
        } else if (stmt == this.st_array_enqueue) {
            this.st_array_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_text_enqueue) {
            this.st_array_text_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_bytes_enqueue) {
            this.st_array_bytes_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_stream_enqueue) {
            this.st_array_stream_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_map_enqueue) {
            this.st_array_map_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_object_enqueue) {
            this.st_array_object_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_dequeue) {
            this.st_array_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_text_dequeue) {
            this.st_array_text_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_bytes_dequeue) {
            this.st_array_bytes_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_stream_dequeue) {
            this.st_array_stream_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_map_dequeue) {
            this.st_array_map_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_object_dequeue) {
            this.st_array_object_dequeue = null;
            del = true;
        }
        if (del) {
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected long[] getOCIHandles() throws JMSException {
        String drv = this.getDriver();
        if ((drv.equalsIgnoreCase("oci8") || drv.equalsIgnoreCase("oci")) && AQDriverManager.isOciAQEnabled() && AQjmsConstants.OCI_NATIVE_PATH) {
            Properties prop = new Properties();
            Connection db_conn = this.getOurDBConnection();
            try {
                if (!loaded_library) {
                    String osName = AQjmsUtil.getSystemProperty("os.name");
                    String libName = null;
                    if (osName.toUpperCase().startsWith("WINDOWS")) {
                        libName = "oci";
                    } else if (osName.equalsIgnoreCase("OpenVMS")) {
                        libName = "libclntsh";
                    } else if (osName.toUpperCase().startsWith("MAC OS")) {
                        libName = "clntsh";
                    }
                    if (libName != null) {
                        final String finalLibName = libName;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                System.loadLibrary(finalLibName);
                                return null;
                            }
                        });
                        loaded_library = true;
                    }
                }
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.loadLibrary excp:", ex);
            }
            catch (Error err) {
                AQjmsOracleDebug.traceErr(3, "AQjmsSession.loadLibrary error:", err);
            }
            try {
                prop = ((OracleConnection)db_conn).getOCIHandles();
            }
            catch (Exception e) {
                AQjmsError.throwEx(122, "Properties Not Found", e);
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.getOCIHandles():", "Got DBAccess properties ");
            long h0 = Long.parseLong(prop.getProperty("OCIEnvHandle"));
            long h1 = Long.parseLong(prop.getProperty("OCIErrHandle"));
            long h2 = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
            if (h0 == this.oci_handles[0] && h1 == this.oci_handles[1] && h2 == this.oci_handles[2]) {
                return this.oci_handles;
            }
            this.freeOCIHandles();
            this.oci_handles[0] = h0;
            this.oci_handles[1] = h1;
            this.oci_handles[2] = h2;
            AQjmsOracleDebug.trace(3, "AQjmsSession.getOCIHandles():", "(Re)got oci handles ");
            String tname = Thread.currentThread().getName();
            int tid = 0;
            try {
                AQjmsOracleDebug.println("Tname.substring:" + tname.substring(7) + "::");
                tid = Integer.parseInt(tname.substring(7));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.oci_aq_cntxt = this.ociinit(this.oci_handles, AQjmsOracleDebug.getTraceLevel(), tid, this.toUseTempLobs(), this.dbversion, this.db_max_bytes, this.getClientRatio());
            }
            catch (Exception e) {
                AQjmsError.throwEx(122, "OCI Init failed!", e);
            }
            AQjmsOracleDebug.trace(3, "AQjmsSession.getOCIHandles():", "(Re)initialized AQ context");
            return this.oci_handles;
        }
        return null;
    }

    public void setMultiRetry() throws JMSException {
        if ((this.sess_type == 20 || this.sess_type == 30) && this.hasGenMsgSupport()) {
            CallableStatement stmt = null;
            try {
                String text = "{call dbms_aqin.set_multi_retry(TRUE)}";
                stmt = this.db_conn.prepareCall(text);
                stmt.execute(text);
                AQjmsOracleDebug.trace(3, "AQjmsSession.setMultiRetry", "setting the multi_retry flag to true");
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.setMultiRetry", sql_ex);
                throw new AQjmsException(sql_ex);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void enableEventForMsgOrder() throws JMSException {
        if (this.is11compatible()) {
            CallableStatement stmt = null;
            try {
                String text = "{call dbms_aqin.set_deq_sort(TRUE)}";
                stmt = this.db_conn.prepareCall(text);
                stmt.execute(text);
                AQjmsOracleDebug.trace(3, "AQjmsSession.enableEventForMsgOrder", "setting the multi_retry flag to true");
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.enableEventForMsgOrder", sql_ex);
                throw new AQjmsException(sql_ex);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private long getOCIServiceHandle() {
        return this.oci_handles[2];
    }

    private long getOCIErrorHandle() {
        return this.oci_handles[1];
    }

    void freeOCIHandles() throws JMSException {
        if (this.oci_aq_cntxt != 0L) {
            Properties prop = null;
            try {
                Connection db_conn = this.getOurDBConnection();
                if (db_conn.isClosed()) {
                    return;
                }
                prop = ((OracleConnection)db_conn).getDBAccessProperties();
            }
            catch (Exception e) {
                AQjmsError.throwEx(122, "Properties Not Found", e);
            }
            if (prop != null) {
                try {
                    this.ocifrctx(this.oci_handles, this.oci_aq_cntxt, AQjmsOracleDebug.getTraceLevel());
                }
                catch (Exception ex) {
                    AQjmsOracleDebug.traceEx(3, "freeOCIHandles excp:", ex);
                    AQjmsError.throwEx(122, "Freeing OCI handles", ex);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSession.freeOCIHandles():", "Freed AQ context");
            }
        }
        this.oci_aq_cntxt = 0L;
    }

    boolean is82compatible() {
        return AQjmsInterOp.is82compatible(this.dbversion);
    }

    boolean is92compatible() {
        return AQjmsInterOp.is92compatible(this.dbversion);
    }

    boolean is10compatible() {
        return AQjmsInterOp.is10compatible(this.dbversion);
    }

    boolean is102compatible() {
        return AQjmsInterOp.is102compatible(this.dbversion);
    }

    boolean is11compatible() {
        return AQjmsInterOp.is11compatible(this.dbversion);
    }

    boolean is112compatible() {
        return AQjmsInterOp.is112compatible(this.dbversion);
    }

    boolean is121compatible() {
        return AQjmsInterOp.is121compatible(this.dbversion);
    }

    boolean is122compatible() {
        return AQjmsInterOp.is122compatible(this.dbversion);
    }

    boolean is19compatible() {
        return AQjmsInterOp.is19compatible(this.dbversion);
    }

    boolean is21compatible() {
        return AQjmsInterOp.is21compatible(this.dbversion);
    }

    boolean is23compatible() {
        return AQjmsInterOp.is23compatible(this.dbversion);
    }

    boolean toUseTempLobs() {
        return this.is10compatible() && this.jms_conn.isUseTempLobs();
    }

    short getDBVersion() {
        return this.dbversion;
    }

    boolean hasGenMsgSupport() {
        return AQjmsInterOp.hasGenMsgSupport(this.dbversion);
    }

    public boolean hasOciAQContext() {
        return this.oci_aq_cntxt != 0L;
    }

    String getDriver() {
        return this.jms_conn.getDriver();
    }

    public synchronized void removeConsumer(AQjmsConsumer que_con) {
        if (que_con.dest_type == 20 && !que_con.isDurable()) {
            try {
                AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "Before removing nondurable subscriber " + que_con.cons_name);
                if (this.is112compatible()) {
                    if (que_con.cons_dest.isSharded()) {
                        this.removeAQNondurableSubscriberSQ(que_con.cons_dest, que_con.cons_name);
                    } else if (this.clientSessionGUID != null && this.isClosing()) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "Delay removing nondurable subscriber " + que_con.cons_name + " on server ");
                    }
                } else {
                    AQjmsAgent agent = new AQjmsAgent();
                    agent.setName(que_con.cons_name);
                    this.removeSubscriber(que_con.cons_dest, agent);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "End removing nondurable subscriber " + que_con.cons_name);
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeConsumer", ex);
            }
        }
        que_con.disableConsumerExceptionListener();
        this.cons_list.remove(que_con);
    }

    void disableConsumerExceptionListenerForQ(String qName) {
        Enumeration e = this.cons_list.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
            if (!cons.cons_dest.getCompleteName().equals(qName)) continue;
            cons.disableConsumerExceptionListener();
        }
    }

    @Override
    public void finalize() {
        AQjmsOracleDebug.println("AQjmsSession.finalize");
    }

    private String getAQOwner(String name) throws JMSException {
        if (name.indexOf(46) == -1) {
            try {
                return this.getDBConnection().getMetaData().getUserName();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
        return name.substring(0, name.indexOf(46));
    }

    private String getAQName(String name) {
        if (name.indexOf(46) == -1) {
            return name;
        }
        return name.substring(1 + name.indexOf(46));
    }

    private int getMaxSubscriberNameLen() {
        if (this.dbMaxIdenLength > 0) {
            return this.dbMaxIdenLength;
        }
        return this.is122compatible() ? 128 : 30;
    }

    private String getTempName() throws JMSException {
        String id = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        return "TMPQ_" + n + "_" + id;
    }

    private String getSubsName() throws JMSException {
        String id = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        String subs_name = AQjmsSession.chopit("TSUB_" + n + "_" + id, 30);
        return subs_name;
    }

    private static String chopit(String n, int max_len) {
        boolean dQuoteIt = false;
        AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", "original name: " + (String)n);
        if (n != null && AQjmsUtil.doubleQuoted((String)n)) {
            n = ((String)n).substring(1, ((String)n).length() - 1);
            dQuoteIt = true;
            AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", "quote stripped off, name: " + (String)n);
        }
        if (n != null && ((String)n).length() > max_len) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", (String)n + " -> " + ((String)n).substring(0, max_len));
            n = ((String)n).substring(0, max_len);
        }
        if (dQuoteIt) {
            n = "\"" + (String)n + "\"";
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", "final name: " + (String)n);
        return n;
    }

    private String getRevisedSubName(String subName, int nameBehaviour) {
        String revisedName = subName;
        switch (nameBehaviour) {
            case 1: {
                revisedName = AQjmsSession.chopit(subName, 30);
                break;
            }
            case 2: {
                if (this.dbversion >= 12200) {
                    revisedName = AQjmsSession.chopit(subName, 128);
                    break;
                }
                revisedName = AQjmsSession.chopit(subName, 30);
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                if (this.dbCompatMajorVer >= 23) break;
                if (this.dbCompatMajorVer == 0) {
                    if (this.dbversion >= 12200) {
                        revisedName = AQjmsSession.chopit(subName, 128);
                        break;
                    }
                    revisedName = AQjmsSession.chopit(subName, 30);
                    break;
                }
                if (this.dbCompatMajorVer > 12 || this.dbCompatMajorVer == 12 && this.dbCompatMinorVer >= 2) {
                    revisedName = AQjmsSession.chopit(subName, 128);
                    break;
                }
                revisedName = AQjmsSession.chopit(subName, 30);
                break;
            }
            default: {
                AQjmsOracleDebug.trace(3, "AQjmsSession.getRevisedSubName", "Error: Bad case, not expected!");
            }
        }
        if (revisedName.contains(".") && !AQjmsUtil.doubleQuoted(revisedName)) {
            revisedName = revisedName.toUpperCase();
            revisedName = AQjmsUtil.encloseInDoubleQuotes(revisedName);
        }
        return revisedName;
    }

    private AQjmsDestination makeTemporaryQueue(boolean isMulti) throws JMSException {
        String owner = this.getAQOwner("");
        String qName = AQjmsSession.chopit(this.getTempName(), 24);
        String qtName = AQjmsSession.chopit(qName, 24);
        AQjmsDestination q = null;
        if (!this.is121compatible() || AQjmsConstants.usePre12TempDestination()) {
            AQQueueTableProperty qtProp = null;
            try {
                qtProp = new AQQueueTableProperty("SYS.AQ$_JMS_MESSAGE");
                qtProp.setSortOrder("priority,enq_time");
                qtProp.setMultiConsumer(isMulti);
            }
            catch (AQException e) {
                throw new AQjmsException(e);
            }
            AQQueueTable qt = this.createQueueTable(owner, qtName, qtProp, true);
            q = isMulti ? (AQjmsDestination)this.createTopic(qt, qName, new AQjmsDestinationProperty(), true) : (AQjmsDestination)this.createQueue(qt, qName, new AQjmsDestinationProperty(), true);
        } else {
            q = (AQjmsDestination)this.createJMSShardedQueue(qName, isMulti);
        }
        q.start((Session)this, true, true, true);
        this.jms_conn.registerTemp(q);
        return q;
    }

    private TopicSubscriber createNondurableSub(Topic topic, String messageSelector, boolean noLocal, Object payloadFactory, String transformation) throws JMSException {
        TopicSubscriber sub = null;
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!this.is112compatible()) {
            String subName = this.getSubsName();
            sub = this.createDurableSubscriber(topic, subName, messageSelector, noLocal, payloadFactory, transformation, true, true);
            AQjmsOracleDebug.trace(3, "AQjmsSession.createNondurableSub", "Created nondurable subscriber using durable subscriber: " + subName);
            return sub;
        }
        if (this.is121compatible() && ((AQjmsDestination)topic).isSharded()) {
            sub = this.addAQNondurableSubscriberSQ(topic, messageSelector, noLocal, payloadFactory, transformation);
            AQjmsOracleDebug.trace(3, "AQjmsSession.createNondurableSub", "Created nondurable subscriber using 12g APIs");
            return sub;
        }
        sub = this.addAQNondurableSubscriber(topic, messageSelector, noLocal, payloadFactory, transformation);
        AQjmsOracleDebug.trace(3, "AQjmsSession.createNondurableSub", "Created nondurable subscriber using 11.2 APIs");
        return sub;
    }

    public synchronized void restartConsumers() {
        AQjmsOracleDebug.trace(5, "AQjmsSession.restartConsumers", "entry");
        Enumeration e = this.cons_list.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
            cons.restart();
        }
    }

    void checkForGlobalTxn() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "oracle.jakarta.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "oracle.jakarta.jms.useEmulatedXA is on");
            this.xaHandler.checkForGlobalTxn();
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "exit");
    }

    boolean isInGlobalTransactionRechecked() throws JMSException {
        boolean inGT = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "oracle.jakarta.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "oracle.jakarta.jms.useEmulatedXA is on");
            inGT = this.xaHandler.inGlobalTrans(true);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "exit");
        return inGT;
    }

    boolean isInGlobalTransaction() {
        boolean inGT = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "oracle.jakarta.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "oracle.jakarta.jms.useEmulatedXA is on");
            inGT = this.xaHandler.globalTxnFlag;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "exit");
        return inGT;
    }

    boolean isInTransactionRechecked() throws JMSException {
        return this.transacted || this.isInGlobalTransactionRechecked();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionStarted();
        if (this.isInTransactionRechecked()) {
            return 0;
        }
        return this.ack_mode;
    }

    public synchronized MessageProducer createProducer(Destination destination) throws JMSException {
        AQjmsProducer producer = null;
        this.checkSessionStarted();
        if (destination != null && !(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        producer = new AQjmsProducer(this, (AQjmsDestination)destination, 30);
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, null, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, null, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        return this.createConsumer(destination, messageSelector, null, null, NoLocal);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String messageSelector, Object payloadFactory, String transformation, boolean noLocal) throws JMSException {
        int dest_type;
        TopicSubscriber consumer = null;
        this.checkSessionStarted();
        if (destination == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(200));
        }
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createConsumer after MessageListener of Session is set");
        }
        if (this.jms_conn != null) {
            this.jms_conn.addQueueToSet(((AQjmsDestination)destination).getName());
        }
        if ((dest_type = ((AQjmsDestination)destination).isQueue() ? 10 : 20) == 10) {
            AQjmsSelector jms_sel = null;
            String p_data_type = null;
            if (messageSelector != null && !messageSelector.equals("")) {
                AQjmsDestination aqjmsDest = (AQjmsDestination)destination;
                jms_sel = aqjmsDest.isSharded() ? new AQjmsSelector(messageSelector, dest_type, 4, this.dbversion, aqjmsDest) : (payloadFactory != null ? new AQjmsSelector(messageSelector, dest_type, 2, this.dbversion, this.getCompliant()) : ((p_data_type = ((AQjmsDestination)destination).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, dest_type, 3, this.dbversion, this.getCompliant()) : new AQjmsSelector(messageSelector, dest_type, 1, this.dbversion, this.getCompliant())));
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.createConsumer", "Selector for Queue: " + String.valueOf(jms_sel));
            consumer = new AQjmsConsumer(this, destination, dest_type, 3, null, payloadFactory, jms_sel, transformation);
        } else {
            consumer = this.createNondurableSub((Topic)destination, messageSelector, noLocal, payloadFactory, transformation);
        }
        this.cons_list.put(consumer, consumer);
        return consumer;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        this.durSubCreationMode = durableSubCreationMode.FORCE_UNSHARED;
        TopicSubscriber consumer = this.createDurableSubscriber(topic, name);
        return consumer;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        this.durSubCreationMode = durableSubCreationMode.FORCE_UNSHARED;
        TopicSubscriber consumer = this.createDurableSubscriber(topic, name, selector, noLocal);
        return consumer;
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name, String selector) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        this.durSubCreationMode = durableSubCreationMode.FORCE_SHARED;
        TopicSubscriber consumer = this.createDurableSubscriber(topic, name, null, false, null, null);
        return consumer;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String selector) throws JMSException {
        this.durSubCreationMode = durableSubCreationMode.FORCE_SHARED;
        TopicSubscriber consumer = this.createDurableSubscriber(topic, name, selector, false, null, null);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionClosed() {
        boolean isClosed = false;
        Object object = this.m_consync;
        synchronized (object) {
            if (this.jms_conn == null) {
                isClosed = true;
            }
        }
        return isClosed;
    }

    void checkConnectionClosed() throws JMSException {
        if (this.isConnectionClosed()) {
            String arg1 = null;
            if (this.jdbcConnInfo != null) {
                arg1 = "JMS Session with JDBC Conn:" + this.jdbcConnInfo.toString();
                arg1 = arg1 + "Time Now: " + String.valueOf(new Date());
            }
            AQjmsError.throwIllegalStateEx(131, arg1);
        }
    }

    boolean isNetworkTimeoutRequired() {
        return AQjmsConstants.SET_NETWORK_TIMEOUT;
    }

    public AQjmsJDBCConnInfo getJDBCConnInfo() {
        return this.jdbcConnInfo;
    }

    private static enum durableSubCreationMode {
        COMPLAINT_BASED("COMPLAINT_BASED"),
        FORCE_SHARED("FORCE_SHARED"),
        FORCE_UNSHARED("FORCE_UNSHARED");

        private String mode;

        private durableSubCreationMode(String mode) {
            this.mode = mode;
        }
    }

    private static enum subcriberStatus {
        NO_SUBSCRIBER("NO_SUBSCRIBER"),
        SAME_SELECTOR("SAME_SELECTOR"),
        SUBSCRIBER_EXISTS("SUBSCRIBER_EXISTS");

        private final String status;

        private subcriberStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

