/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsFactory;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsQueueConnectionFactory;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsTopicConnectionFactory;

public class AQjmsContext
implements Context {
    public static final String Q_PREFIX = "Queues/";
    public static final String T_PREFIX = "Topics/";
    public static final String CF_PREFIX = "ConnectionFactory";
    public static final String XACF_PREFIX = "XAConnectionFactory";
    public static final String QCF_PREFIX = "QueueConnectionFactory";
    public static final String XAQCF_PREFIX = "XAQueueConnectionFactory";
    public static final String TCF_PREFIX = "TopicConnectionFactory";
    public static final String XATCF_PREFIX = "XATopicConnectionFactory";
    public static final String DB_URL = "db_url";
    public static final String DB_USERNAME = "java.naming.security.principal";
    public static final String DB_PASSWORD = "java.naming.security.credentials";
    public static final String DATASOURCE_LOCATION = "datasource";
    private String url = null;
    private String username = null;
    private String password = null;
    private String dsLocation = null;
    private DataSource ds = null;

    public AQjmsContext(Hashtable env) throws NamingException {
        this.dsLocation = (String)env.get(DATASOURCE_LOCATION);
        this.url = (String)env.get(DB_URL);
        this.username = (String)env.get(DB_USERNAME);
        this.password = (String)env.get(DB_PASSWORD);
        if (this.url != null) {
            if (this.username == null || this.password == null) {
                this.incompleteConfiguration();
            }
        } else {
            if (this.dsLocation == null) {
                this.incompleteConfiguration();
            }
            if (this.username != null || this.password != null) {
                this.incompleteConfiguration();
            }
        }
        if (this.dsLocation != null && AQjmsConstants.CACHE_DS_IN_CONTEXT) {
            this.getDataSource();
        }
    }

    private void incompleteConfiguration() throws NamingException {
        throw new NamingException("The configuration of the AQjmsInitialContext is not complete. The configuration must contain datasource or (db_url,java.naming.security.principal,java.naming.security.credentials) or both");
    }

    private synchronized DataSource getDataSource() throws NamingException {
        if (this.dsLocation == null) {
            return null;
        }
        if (this.ds == null) {
            InitialContext ctx = new InitialContext();
            DataSource currentDS = (DataSource)ctx.lookup(this.dsLocation);
            if (AQjmsConstants.CACHE_DS_IN_CONTEXT) {
                this.ds = currentDS;
            }
            return currentDS;
        }
        return this.ds;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object lookup(String name) throws NamingException {
        AQjmsOracleDebug.trace(3, "AQjmsContext.lookup", "enter");
        Object result = null;
        if (name != null) {
            try {
                String resType = AQjmsContext.getResourceType(name);
                String resName = AQjmsContext.getResourceName(name);
                if (resType == null) {
                    throw new NamingException("Unrecognized prefix in: " + name);
                }
                if (resType.equals(Q_PREFIX)) {
                    if (resName == null) {
                        throw new NamingException("Empty destination name in: " + name);
                    }
                    result = this.initQ(resName);
                } else if (resType.equals(T_PREFIX)) {
                    if (resName == null) {
                        throw new NamingException("Empty destination name in: " + name);
                    }
                    result = this.initT(resName);
                } else if (resType.equals(CF_PREFIX)) {
                    result = this.initCF();
                } else if (resType.equals(QCF_PREFIX)) {
                    result = this.initQCF();
                } else if (resType.equals(TCF_PREFIX)) {
                    result = this.initTCF();
                } else if (resType.equals(XACF_PREFIX)) {
                    result = this.initXACF();
                } else if (resType.equals(XAQCF_PREFIX)) {
                    result = this.initXAQCF();
                } else if (resType.equals(XATCF_PREFIX)) {
                    result = this.initXATCF();
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Cannot resolve name:" + name);
                ne.initCause(e);
                AQjmsOracleDebug.traceEx(1, "AQjmsContext.lookup failed for " + name, e);
                throw ne;
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsContext.lookup", "lookup return:" + String.valueOf(result));
        if (result == null) {
            throw new NameNotFoundException("Cannot resolve name:" + name);
        }
        return result;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, String> myEnv = new Hashtable<String, String>();
        if (this.url != null) {
            myEnv.put(DB_URL, this.url);
            myEnv.put(DB_USERNAME, this.username);
            myEnv.put(DB_PASSWORD, this.password);
        }
        if (this.dsLocation != null) {
            myEnv.put(DATASOURCE_LOCATION, this.dsLocation);
        }
        return myEnv;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new NamingException("Not supported");
    }

    private static String getResourceType(String n) throws JMSException {
        if (n.startsWith(Q_PREFIX)) {
            return Q_PREFIX;
        }
        if (n.equals(CF_PREFIX)) {
            return CF_PREFIX;
        }
        if (n.equals(XACF_PREFIX)) {
            return XACF_PREFIX;
        }
        if (n.equals(QCF_PREFIX)) {
            return QCF_PREFIX;
        }
        if (n.equals(XAQCF_PREFIX)) {
            return XAQCF_PREFIX;
        }
        if (n.startsWith(T_PREFIX)) {
            return T_PREFIX;
        }
        if (n.equals(TCF_PREFIX)) {
            return TCF_PREFIX;
        }
        if (n.equals(XATCF_PREFIX)) {
            return XATCF_PREFIX;
        }
        return null;
    }

    private static String getResourceName(String n) {
        if (n.startsWith(Q_PREFIX)) {
            return n.substring(Q_PREFIX.length());
        }
        if (n.startsWith(T_PREFIX)) {
            return n.substring(T_PREFIX.length());
        }
        return null;
    }

    private Object initQ(String name) throws Exception {
        Queue q = null;
        QueueConnection qc = null;
        QueueSession qs = null;
        try {
            AQjmsQueueConnectionFactory qcf = (AQjmsQueueConnectionFactory)this.initQCF();
            qc = qcf.createQueueConnectionInternal();
            qs = qc.createQueueSession(true, 1);
            q = ((AQjmsSession)qs).createQueue(name);
        }
        catch (Exception exc) {
            AQjmsOracleDebug.traceEx(1, "AQjmsContext.initQ failed for queue " + name, exc);
            throw exc;
        }
        finally {
            try {
                qs.close();
            }
            catch (Exception exception) {}
            try {
                qc.close();
            }
            catch (Exception exception) {}
        }
        return q;
    }

    private Object initCF() throws Exception {
        return AQjmsFactory.getConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initQCF() throws Exception {
        return AQjmsFactory.getQueueConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initXACF() throws Exception {
        return AQjmsFactory.getXAConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initXAQCF() throws Exception {
        return AQjmsFactory.getXAQueueConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initT(String name) throws Exception {
        Topic t = null;
        TopicConnection tc = null;
        TopicSession ts = null;
        try {
            AQjmsTopicConnectionFactory tcf = (AQjmsTopicConnectionFactory)this.initTCF();
            tc = tcf.createTopicConnectionInternal();
            ts = tc.createTopicSession(true, 1);
            t = ((AQjmsSession)ts).createTopic(name);
        }
        catch (Exception exc) {
            AQjmsOracleDebug.traceEx(1, "AQjmsContext.initT failed for topic " + name, exc);
            throw exc;
        }
        finally {
            try {
                ts.close();
            }
            catch (Exception exception) {}
            try {
                tc.close();
            }
            catch (Exception exception) {}
        }
        return t;
    }

    private Object initTCF() throws Exception {
        return AQjmsFactory.getTopicConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initXATCF() throws Exception {
        return AQjmsFactory.getXATopicConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Properties getProperties() {
        Properties prop = new Properties();
        if (this.username != null) {
            prop.put("user", this.username);
        }
        if (this.password != null) {
            prop.put("password", this.password);
        }
        return prop;
    }
}

