/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms.plsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.jakarta.jms.plsql.MsgEntity;
import oracle.jakarta.jms.plsql.TypeConversion;
import oracle.jakarta.jms.plsql.TypeConversionException;
import oracle.jakarta.jms.plsql.WrongAccessModeException;

class StreamMsgEntity
extends MsgEntity {
    private int accessMode;
    private byte[] data;
    private ObjectInputStream objectInput;
    private ByteArrayOutputStream byteOutput;
    private ObjectOutputStream objectOutput;

    StreamMsgEntity() throws IOException {
        this.byteOutput = new ByteArrayOutputStream();
        this.objectOutput = new ObjectOutputStream(this.byteOutput);
        this.accessMode = 1;
    }

    StreamMsgEntity(byte[] data) throws IOException {
        this.data = data;
        this.objectInput = new ObjectInputStream(new ByteArrayInputStream(data));
        this.accessMode = 0;
    }

    @Override
    void clean() throws IOException {
        if (this.accessMode == 0) {
            if (this.objectInput != null) {
                this.objectInput.close();
                this.objectInput = null;
            }
            this.data = null;
        } else {
            if (this.objectOutput != null) {
                this.objectOutput.close();
                this.objectOutput = null;
            }
            if (this.byteOutput != null) {
                this.byteOutput.close();
                this.byteOutput = null;
            }
            this.data = null;
        }
    }

    int getMode() {
        return this.accessMode;
    }

    void reset() throws IOException {
        if (this.accessMode == 0) {
            this.objectInput.close();
            this.objectInput = new ObjectInputStream(new ByteArrayInputStream(this.data));
        } else {
            this.objectOutput.close();
            this.data = this.byteOutput.toByteArray();
            this.objectOutput = null;
            this.byteOutput = null;
            this.objectInput = new ObjectInputStream(new ByteArrayInputStream(this.data));
            this.accessMode = 0;
        }
    }

    byte[] flush() throws IOException {
        if (this.accessMode == 1) {
            this.data = this.byteOutput.toByteArray();
        }
        return this.data;
    }

    Object readObject(int type) throws WrongAccessModeException, TypeConversionException, ClassNotFoundException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        try {
            Object objData = this.objectInput.readObject();
            if (objData == null) {
                return null;
            }
            return TypeConversion.jmsConvert(objData, type);
        }
        catch (EOFException eofe) {
            return null;
        }
    }

    Object readObject() throws WrongAccessModeException, ClassNotFoundException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        try {
            return this.objectInput.readObject();
        }
        catch (EOFException eofe) {
            return null;
        }
    }

    void writeObject(Object obj) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.objectOutput.writeObject(obj);
    }
}

