/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGeneralDBConnection;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsUcp;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolXADataSource;

class AQjmsDBConnMgr {
    private String oracle_sid;
    private String hostname;
    private int portno;
    private String user;
    private String password;
    private String driver = "";
    private String jdbc_url;
    private Properties jdbc_info;
    private short dbversion;
    private int dbMaxIdenLength;
    private int dbCompatMajorVer;
    private int dbCompatMinorVer;
    private AQjmsGeneralDBConnection firstConn;
    private Connection externalConn;
    private boolean externalConnFree;
    private XADataSource xaDS;
    private DataSource data_source;
    private OracleOCIConnectionPool cpool;
    private PoolDataSource ucpPool;
    private boolean isXA = false;

    AQjmsDBConnMgr(String hostname, String oracle_sid, int portno, String user, String password, String driver, boolean isXA) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (host,sid,port,user,pass,driver)", "enter: isXA is " + isXA);
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        this.driver = driver;
        this.user = user;
        this.password = password;
        this.isXA = isXA;
        boolean pass = false;
        try {
            String url;
            boolean useUcp = System.getProperty("oracle.jakarta.jms.ucp", "false").equalsIgnoreCase("true");
            if (useUcp) {
                try {
                    url = AQjmsDBConnMgr.createUrl(hostname, oracle_sid, portno, driver);
                    PoolDataSource pds = AQjmsUcp.getPool(url, user, password, isXA);
                    if (pds != null) {
                        this.setUcpPool(pds);
                        pass = true;
                        return;
                    }
                }
                catch (Exception e) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr:  UCP Create, ctor (host,sid,port,user,pass,driver)", e);
                }
            }
            if (isXA) {
                url = AQjmsDBConnMgr.createUrl(hostname, oracle_sid, portno, driver);
                this.xaDS = new OracleXADataSource();
                ((OracleXADataSource)this.xaDS).setURL(url);
                ((OracleXADataSource)this.xaDS).setUser(user);
                ((OracleXADataSource)this.xaDS).setPassword(password);
                this.setNativeXA((OracleXADataSource)this.xaDS);
                this.firstConn = this.getConnection(false);
            } else if (driver.equalsIgnoreCase("oci8") || driver.equalsIgnoreCase("oci")) {
                url = AQjmsDBConnMgr.createUrl(hostname, oracle_sid, portno, "oci8");
                this.cpool = AQjmsDBConnMgr.createPool(user, password, url, null);
                this.driver = "oci8";
            } else {
                this.firstConn = this.getConnection(false);
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: ctor (host,sid,port,user,pass,driver)", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (host,sid,port,user,pass,driver)", "exit");
    }

    AQjmsDBConnMgr(String url, Properties info, boolean isXA) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,info)", "enter: isXA is " + isXA);
        this.jdbc_url = url;
        this.jdbc_info = info;
        this.isXA = isXA;
        if (info != null) {
            this.user = info.getProperty("user");
        }
        boolean pass = false;
        boolean useUcp = System.getProperty("oracle.jakarta.jms.ucp", "false").equalsIgnoreCase("true");
        if (useUcp) {
            try {
                PoolDataSource pds = AQjmsUcp.getPool(this.jdbc_url, this.jdbc_info, isXA);
                if (pds != null) {
                    this.setUcpPool(pds);
                    pass = true;
                    return;
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr:  UCP Create, ctor (host,sid,port,user,pass,driver)", e);
            }
        }
        try {
            if (isXA) {
                this.xaDS = new OracleXADataSource();
                ((OracleXADataSource)this.xaDS).setURL(url);
                ((OracleXADataSource)this.xaDS).setConnectionProperties(info);
                this.setNativeXA((OracleXADataSource)this.xaDS);
                this.firstConn = this.getConnection(false);
            } else {
                this.driver = this.getDriverFromUrl(url);
                if (this.driver.equals("oci8") || this.driver.equals("oci")) {
                    this.cpool = AQjmsDBConnMgr.createPool(url, info);
                } else {
                    this.firstConn = this.getConnection(false);
                }
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: ctor (url, info)", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,info)", "exit");
    }

    AQjmsDBConnMgr(String url, String username, String password, boolean isXA) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,username,password)", "enter: isXA is " + isXA);
        this.jdbc_url = url;
        this.user = username;
        this.password = password;
        this.isXA = isXA;
        this.jdbc_info = new Properties();
        this.jdbc_info.put("user", username);
        this.jdbc_info.put("password", password);
        boolean pass = false;
        boolean useUcp = System.getProperty("oracle.jakarta.jms.ucp", "false").equalsIgnoreCase("true");
        if (useUcp) {
            try {
                PoolDataSource pds = AQjmsUcp.getPool(this.jdbc_url, this.jdbc_info, isXA);
                if (pds != null) {
                    this.setUcpPool(pds);
                    pass = true;
                    return;
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr:  UCP Create, ctor (host,sid,port,user,pass,driver)", e);
            }
        }
        try {
            if (isXA) {
                this.xaDS = new OracleXADataSource();
                ((OracleXADataSource)this.xaDS).setURL(url);
                ((OracleXADataSource)this.xaDS).setUser(this.user);
                ((OracleXADataSource)this.xaDS).setPassword(password);
                this.setNativeXA((OracleXADataSource)this.xaDS);
                this.firstConn = this.getConnection(false);
            } else {
                this.driver = this.getDriverFromUrl(url);
                if (this.driver.equals("oci8") || this.driver.equals("oci")) {
                    this.cpool = AQjmsDBConnMgr.createPool(username, password, url, null);
                } else {
                    this.firstConn = this.getConnection(false);
                }
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: ctor (url,username,password)", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (url,username,password)", "exit");
    }

    AQjmsDBConnMgr(Connection db_connection) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (user jdbc conn)", "connection: " + db_connection);
        this.externalConn = db_connection;
        this.externalConnFree = true;
        try {
            this.extraInit(db_connection);
        }
        catch (JMSException je) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: constructor (user jdbc conn) ", je);
            throw je;
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (user jdbc conn)", "exit");
    }

    AQjmsDBConnMgr(DataSource ds, String user, String password) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (datasource)", "enter");
        this.data_source = ds;
        this.user = user;
        this.password = password;
        try {
            this.firstConn = this.getConnection(false);
        }
        catch (JMSException je) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: constructor (datasource) " + ds, je);
            throw je;
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (datasource)", "exit");
    }

    AQjmsDBConnMgr(OracleOCIConnectionPool cpool) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (oci connection pool)", "enter");
        if (cpool == null) {
            AQjmsError.throwEx(111);
        }
        this.user = cpool.getUser();
        this.driver = "oci8";
        this.firstConn = this.getConnection(false);
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (oci connection pool)", "exit");
    }

    AQjmsDBConnMgr(XADataSource xaDS, String user, String password) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (XADataSource) " + xaDS, "enter");
        this.xaDS = xaDS;
        this.user = user;
        this.password = password;
        try {
            this.firstConn = this.getConnection(false);
        }
        catch (JMSException je) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: constructor (XADataSource) " + xaDS, je);
            throw je;
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr ctor (XADataSource) " + xaDS, "exit");
    }

    synchronized void setUcpPool(PoolDataSource pds) {
        this.ucpPool = pds;
    }

    synchronized AQjmsGeneralDBConnection getConnection(boolean force) throws JMSException {
        AQjmsGeneralDBConnection genConn = null;
        try {
            if (this.externalConn != null) {
                if (force) {
                    AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "use the external connection without usage check");
                    return new AQjmsGeneralDBConnection(this, this.externalConn, true, force);
                }
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "use the external connection with usage check");
                if (this.externalConnFree) {
                    AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "passed usage check, creating from exteranl connection ");
                    this.externalConnFree = false;
                    return new AQjmsGeneralDBConnection(this, this.externalConn, true, force);
                }
                AQjmsError.throwEx(106);
            }
            if (this.firstConn != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "get the firstConn created during the authentication");
                genConn = this.firstConn;
                this.firstConn = null;
                return genConn;
            }
            if (this.xaDS != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from XADataSource");
                genConn = this.user != null && this.password != null ? new AQjmsGeneralDBConnection(this, this.xaDS.getXAConnection(this.user, this.password), false, force) : new AQjmsGeneralDBConnection(this, this.xaDS.getXAConnection(), false, force);
            } else if (this.cpool != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from connection pool");
                genConn = new AQjmsGeneralDBConnection(this, this.cpool.getConnection(), false, force);
            } else if (this.data_source != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from datasource");
                genConn = this.user != null && this.password != null ? new AQjmsGeneralDBConnection(this, this.data_source.getConnection(this.user, this.password), false, force) : new AQjmsGeneralDBConnection(this, this.data_source.getConnection(), false, force);
            } else if (this.ucpPool != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from connection ucp pool");
                genConn = this.isXA ? new AQjmsGeneralDBConnection(this, ((PoolXADataSource)this.ucpPool).getXAConnection(), false, force) : new AQjmsGeneralDBConnection(this, this.ucpPool.getConnection(), false, force);
            } else if (this.jdbc_url != null) {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating using url");
                DriverManager.registerDriver((Driver)new OracleDriver());
                genConn = this.jdbc_info != null ? new AQjmsGeneralDBConnection(this, DriverManager.getConnection(this.jdbc_url, this.jdbc_info), false, force) : new AQjmsGeneralDBConnection(this, DriverManager.getConnection(this.jdbc_url), false, force);
            } else {
                AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getConnection", "Creating from host:" + this.hostname + " sid:" + this.oracle_sid + " port:" + this.portno + " driver: " + this.driver);
                DriverManager.registerDriver((Driver)new OracleDriver());
                String url = AQjmsDBConnMgr.createUrl(this.hostname, this.oracle_sid, this.portno, this.driver);
                genConn = new AQjmsGeneralDBConnection(this, DriverManager.getConnection(url, this.user, this.password), false, force);
            }
            this.extraInit(genConn.getDBConnection());
            AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.getConnection", "generic->DB connection: " + genConn.getDBConnection());
            AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.getConnection", "generic->XA connection: " + genConn.getXAConnection());
        }
        catch (SQLException se) {
            if (genConn != null) {
                try {
                    genConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AQjmsDBConnMgr.checkForSecurityException(se);
        }
        catch (Exception e) {
            if (genConn != null) {
                try {
                    genConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AQjmsException("Error creating the db_connection", e);
        }
        return genConn;
    }

    synchronized void releaseExternalConnection() {
        this.externalConnFree = true;
        AQjmsOracleDebug.trace(3, "releaseExternalConnection", "free the external connection");
    }

    void close() throws JMSException {
        Exception se;
        block11: {
            block10: {
                se = null;
                try {
                    if (this.firstConn != null) {
                        this.firstConn.close();
                    }
                }
                catch (Exception e) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: close", e);
                    se = e;
                }
                try {
                    if (this.cpool != null) {
                        this.cpool.close();
                    }
                }
                catch (Exception e) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: close", e);
                    if (se == null) break block10;
                    se = e;
                }
            }
            try {
                if (this.ucpPool != null) {
                    AQjmsUcp.closePool(this.ucpPool);
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsDBConnMgr: close", e);
                if (se == null) break block11;
                se = e;
            }
        }
        this.firstConn = null;
        this.cpool = null;
        if (se != null) {
            throw new AQjmsException("Error in close", se);
        }
    }

    String getUserName() {
        return this.user;
    }

    String getDriver() {
        return this.driver;
    }

    short getDBVersion() {
        return this.dbversion;
    }

    int getDBMaxIdenLength() {
        return this.dbMaxIdenLength;
    }

    int getDBCompatMajorVersion() {
        return this.dbCompatMajorVer;
    }

    int getDBCompatMinorVersion() {
        return this.dbCompatMinorVer;
    }

    String getDBCompatVersion() {
        return this.dbCompatMajorVer + "." + this.dbCompatMinorVer;
    }

    public OracleOCIConnectionPool getOCIConnectionPool() {
        return this.cpool;
    }

    private String getDriverFromUrl(String url) {
        if (url != null) {
            if ((url = url.toLowerCase().trim()).startsWith("jdbc:oracle:oci") || url.startsWith("jdbc:oracle:oci8")) {
                return "oci8";
            }
            if (url.startsWith("jdbc:oracle:thin")) {
                return "thin";
            }
            return "kprb";
        }
        return "kprb";
    }

    private static String createUrl(String host, String sid, int port, String driver) throws JMSException {
        String url;
        if (driver.equals("oci8") || driver.equals("oci")) {
            url = "jdbc:oracle:oci8:@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(PORT=" + port + ")(HOST=" + host + "))(CONNECT_DATA=(SID=" + sid + ")))";
        } else if (driver.equals("thin")) {
            url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
        } else {
            AQjmsError.throwEx(135);
            throw new AQjmsException("unsupported driver", 0);
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.createUrl", "The connection URL: " + url);
        return url;
    }

    private void extraInit(Connection conn) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.extraInit", "enter");
        if (conn == null) {
            AQjmsError.throwEx(111);
        }
        try {
            AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.extraInit", "The connection class: " + conn.getClass().getName());
            if (!(conn instanceof OracleConnection)) {
                AQjmsError.throwEx(112, "db connection is not oracle internal db connection");
            }
            if (this.dbversion == 0) {
                this.dbversion = ((OracleConnection)conn).getVersionNumber();
            }
            if (this.dbMaxIdenLength == 0) {
                this.dbMaxIdenLength = this.getDBMaxIdenLength(conn);
            }
            if (this.dbCompatMajorVer == 0) {
                this.initDBCompatVersion(conn);
            }
            if (this.user == null) {
                this.user = ((oracle.jdbc.OracleConnection)conn).getUserName();
            }
            if (this.driver == null || this.driver.equals("")) {
                this.driver = this.getDriverName(conn);
            }
        }
        catch (SQLException se) {
            AQjmsDBConnMgr.checkForSecurityException(se);
        }
        AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.extraInit", "exit");
    }

    private String getDriverName(Connection c) throws SQLException {
        if (c instanceof OracleConnection) {
            String connUrl = ((OracleConnection)c).getURL();
            return this.getDriverFromUrl(connUrl);
        }
        return "";
    }

    private static OracleOCIConnectionPool createPool(String url, Properties prop) throws JMSException {
        String user = null;
        String password = null;
        if (prop != null) {
            user = prop.getProperty("user");
            password = prop.getProperty("password");
        }
        return AQjmsDBConnMgr.createPool(user, password, url, prop);
    }

    private static OracleOCIConnectionPool createPool(String user, String password, String url, Properties prop) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.createPool", "enter");
        OracleOCIConnectionPool pool = null;
        if (prop == null) {
            prop = new Properties();
        }
        if (!prop.containsKey("connpool_min_limit")) {
            prop.put("connpool_min_limit", Integer.toString(1));
        }
        if (!prop.containsKey("connpool_increment")) {
            prop.put("connpool_increment", Integer.toString(1));
        }
        if (!prop.containsKey("connpool_max_limit")) {
            prop.put("connpool_max_limit", Integer.toString(50));
        }
        try {
            pool = new OracleOCIConnectionPool(user, password, url, prop);
            if (pool != null) {
                pool.setPoolConfig(prop);
            }
        }
        catch (SQLException se) {
            if (pool != null) {
                try {
                    pool.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AQjmsDBConnMgr.checkForSecurityException(se);
        }
        AQjmsOracleDebug.trace(5, "AQjmsDBConnMgr.createPool", "exit");
        return pool;
    }

    private static void checkForSecurityException(SQLException sql_ex) throws JMSException {
        if (sql_ex.getErrorCode() == 1017 || sql_ex.getErrorCode() == 17079) {
            throw new JMSSecurityException(AQjmsError.getMessage(232));
        }
        throw new AQjmsException(sql_ex);
    }

    private void setNativeXA(OracleXADataSource xads) {
        String nativeXAFlag = AQjmsUtil.getSystemProperty("oracle.jakarta.jms.useNativeXA");
        if (nativeXAFlag == null) {
            return;
        }
        xads.setNativeXA(Boolean.valueOf(nativeXAFlag).booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDBMaxIdenLength(Connection conn) throws JMSException {
        int maxIdenLen = 0;
        CallableStatement stmt = null;
        try {
            stmt = conn.prepareCall("BEGIN ? := sys.dbms_aqjms.getMaxIdentifierLength; END;");
            stmt.registerOutParameter(1, 2);
            stmt.execute();
            maxIdenLen = stmt.getInt(1);
            AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getDBMaxIdenLength", "maxIdenLen: " + maxIdenLen);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.getDBMaxIdenLength", "Error: " + sql_ex.getErrorCode());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return maxIdenLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBCompatVersion(Connection conn) throws JMSException {
        int majVer = 0;
        int minVer = 0;
        CallableStatement stmt = null;
        try {
            stmt = conn.prepareCall("BEGIN  ? := sys.dbms_aqjms.getDBCompatMajorVersion;  ? := sys.dbms_aqjms.getDBCompatMinorVersion;  END;");
            stmt.registerOutParameter(1, 2);
            stmt.registerOutParameter(2, 2);
            stmt.execute();
            majVer = stmt.getInt(1);
            minVer = stmt.getInt(2);
            AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.initDBCompatVersion", "DBCompatibleVersion: " + majVer + "." + minVer);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.trace(3, "AQjmsDBConnMgr.initDBCompatVersion", "Error: " + sql_ex.getErrorCode());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.dbCompatMajorVer = majVer;
        this.dbCompatMinorVer = minVer;
    }
}

