/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import oracle.jakarta.AQ.xml.AQxmlAuthContext;
import oracle.jakarta.AQ.xml.AQxmlCallback;
import oracle.jakarta.AQ.xml.AQxmlDataSource;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlProcessor;
import oracle.jakarta.AQ.xml.AQxmlServContext;
import oracle.jakarta.AQ.xml.AQxmlSessionContext;

public class AQxmlServlet
extends HttpServlet
implements Runnable {
    AQxmlServContext serv_ctx = null;
    AQxmlCallback user_cbk = null;
    boolean auth_user = true;
    AQxmlDataSource[] data_src = null;
    String[] data_src_names = null;
    String schema_loc = null;
    String email_server_addr = null;
    String email_server_host = null;
    int max_inactive_time = 120;
    String xsl_proc_instr = null;
    HttpSessionContext hses_ctx = null;
    Thread hses_thd = null;
    boolean hses_miv = false;
    DirContext ldapCtx = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String title = "Sample AQ Servlet";
        AQxmlDataSource dbdrv = null;
        Connection db_conn = null;
        SimpleDateFormat formatter = null;
        Date tstamp = null;
        String timestamp = null;
        response.setContentType("text/html");
        AQxmlDebug.trace(4, "AQxmlServlet.doGet", "entry");
        PrintWriter out = response.getWriter();
        String req_uri = request.getRequestURI();
        AQxmlDebug.trace(4, "AQxmlServlet.doGet", "req_uri " + req_uri);
        out.println("<HTML><HEAD><TITLE>");
        out.println(title);
        out.println("</TITLE></HEAD><BODY bgcolor=\"#FFFFFF\">");
        out.println("<H1>" + title + "</H1>");
        formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        tstamp = new Date();
        timestamp = formatter.format(tstamp);
        try {
            dbdrv = this.getAQDataSource();
            AQxmlDebug.trace(4, "AQxmlServlet.doGet", "sid: " + dbdrv.getSid() + " host: " + dbdrv.getHost() + " port: " + dbdrv.getPort() + " cachesize: " + dbdrv.getCacheSize());
            if (dbdrv == null) {
                AQxmlDebug.trace(4, "AQxmlServlet.doGet", "dbdrv=null");
            } else {
                AQxmlDebug.trace(4, "AQxmlServlet.doGet", "dbdrv valid");
            }
            db_conn = dbdrv.getDBConnectionFromPool(null);
            if (db_conn == null) {
                AQxmlDebug.trace(4, "AQxmlServlet.doGet", "db_conn=null");
            } else {
                AQxmlDebug.trace(4, "AQxmlServlet.doGet", "db_conn valid");
            }
            db_conn.close();
            out.println("<H2> AQxmlServlet is working!  " + timestamp + "<br>");
        }
        catch (Exception ex) {
            out.println("AQxmlServlet.doGet - Exception: " + ex);
            ex.printStackTrace();
        }
        out.println("</BODY></HTML>");
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contType = null;
        AQxmlProcessor aq_proc = null;
        AQxmlDataSource dbdrv = null;
        PrintWriter out = response.getWriter();
        try {
            String title = "AQ Servlet - POST";
            contType = request.getContentType();
            AQxmlDebug.println("content-type: " + contType);
            response.setContentType("text/plain");
            AQxmlDebug.println("AQxmlServlet: before AQxmlProcessor");
            try {
                dbdrv = this.getAQDataSource();
                if (dbdrv == null) {
                    AQxmlDebug.println("AQxmlServlet: before getAQProcessor:dbdrv=null");
                    Thread.sleep(3000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            aq_proc = this.getAQProcessor(request);
            AQxmlDebug.println("AQxmlServlet: before processMessage");
            aq_proc.processMessage(request, response, this.user_cbk, this.xsl_proc_instr);
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(3, "AQxmlServlet.doPost-ex", ex);
            AQxmlProcessor.writeErrorMessagetoStream(out, ex, this.serv_ctx, aq_proc.getXmlDriver(), 100, this.xsl_proc_instr);
        }
        finally {
            if (aq_proc != null && aq_proc.getXmlDriver() != null) {
                aq_proc.setXmlDriver(null);
            }
            out.close();
            AQxmlDebug.getLogStream().flush();
        }
    }

    synchronized AQxmlProcessor getAQProcessor(HttpServletRequest request) throws AQxmlException {
        HttpSession http_sess = null;
        AQxmlAuthContext auth_ctx = null;
        String user = null;
        AQxmlProcessor aq_proc = null;
        AQxmlSessionContext sess_ctx = null;
        AQxmlDataSource[] dbdrv = null;
        String[] dbnames = null;
        AQxmlDebug.trace(3, "AQxmlServlet.getAQProcessor", "entry");
        if (this.serv_ctx == null) {
            AQxmlDebug.println("AQxmlServlet: getting db driver");
            dbdrv = this.getAQDataSources();
            dbnames = this.getAQDataSourceNames();
            if (dbdrv == null) {
                AQxmlDebug.println("AQxmlServlet: db driver=null - 1");
                AQxmlError.throwAQEx(434);
            }
            this.data_src = dbdrv;
            this.serv_ctx = new AQxmlServContext(this.data_src, dbnames, this.schema_loc);
            this.serv_ctx.setMaxInactiveTime(this.max_inactive_time);
            if (this.ldapCtx != null) {
                this.serv_ctx.setLdapContext(this.ldapCtx);
            }
        }
        if ((http_sess = request.getSession(false)) == null) {
            AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "http_sess=null");
            user = this.getAgentName(request);
            auth_ctx = new AQxmlAuthContext(user);
            aq_proc = new AQxmlProcessor(this.serv_ctx);
            sess_ctx = new AQxmlSessionContext(auth_ctx, aq_proc);
            http_sess = request.getSession(true);
            if (http_sess == null) {
                AQxmlDebug.trace(3, "AQxmlServlet.getAQProcessor", "ERROR: http_sess=null");
                AQxmlError.throwAQEx(401, "http_sess=null");
            }
            if (this.hses_ctx == null && this.hses_thd == null && this.hses_miv) {
                this.hses_ctx = http_sess.getSessionContext();
                this.hses_thd = new Thread(this);
                this.hses_thd.start();
                AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "started session invalidation thread");
            } else {
                AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "use the built in session invalidation method");
                http_sess.setMaxInactiveInterval(this.max_inactive_time);
            }
            http_sess.putValue("AQxmlSessionContext", (Object)sess_ctx);
        } else {
            AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "http_sess-not null");
            sess_ctx = (AQxmlSessionContext)http_sess.getValue("AQxmlSessionContext");
            if (sess_ctx == null) {
                AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "sess_ctx = null");
                user = this.getAgentName(request);
                auth_ctx = new AQxmlAuthContext(user);
                aq_proc = new AQxmlProcessor(this.serv_ctx);
                sess_ctx = new AQxmlSessionContext(auth_ctx, aq_proc);
                http_sess.putValue("AQxmlSessionContext", (Object)sess_ctx);
            } else {
                AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "sess_ctx != null");
                aq_proc = sess_ctx.getProcessor();
                user = this.getAgentName(request);
                if (!user.equalsIgnoreCase(sess_ctx.getAuthContext().getAgentName())) {
                    auth_ctx = new AQxmlAuthContext(user);
                    sess_ctx.setAuthContext(auth_ctx);
                }
                aq_proc.setServletContext(this.serv_ctx);
            }
        }
        return aq_proc;
    }

    public synchronized AQxmlDataSource getAQDataSource() throws AQxmlException {
        return this.data_src[0];
    }

    public synchronized String getAQDataSourceName() throws AQxmlException {
        return this.data_src_names[0];
    }

    public synchronized AQxmlDataSource[] getAQDataSources() throws AQxmlException {
        return this.data_src;
    }

    public synchronized String[] getAQDataSourceNames() throws AQxmlException {
        return this.data_src_names;
    }

    public final synchronized void setAQDataSource(AQxmlDataSource data_source) throws AQxmlException {
        if (data_source == null) {
            AQxmlError.throwAQEx(434);
        }
        this.data_src = new AQxmlDataSource[1];
        this.data_src[0] = data_source;
        this.data_src_names = new String[1];
        this.data_src_names[0] = "default";
    }

    public final synchronized void setAQDataSources(AQxmlDataSource[] data_source, String[] names) throws AQxmlException {
        if (data_source == null) {
            AQxmlError.throwAQEx(434);
        }
        this.data_src = data_source;
        this.data_src_names = names;
    }

    public final AQxmlCallback getUserCallback() {
        return this.user_cbk;
    }

    public final void setUserCallback(AQxmlCallback callback) {
        this.user_cbk = callback;
    }

    public synchronized void setAQSchemaLocation(String schema_location) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlServlet.setAQxmlSchemaLocation", "schema " + schema_location);
        if (schema_location == null) {
            AQxmlError.throwAQEx(435);
        }
        this.schema_loc = schema_location;
    }

    protected synchronized void setSessionMaxInactiveTime(int secs) {
        this.max_inactive_time = secs > 30 ? secs : 30;
    }

    public synchronized void setEmailServerAddr(String ip_address) {
        this.email_server_addr = ip_address;
    }

    public String getEmailServerAddr() {
        return this.email_server_addr;
    }

    private synchronized void setEmailServerHost(String host_name) {
        this.email_server_host = host_name;
    }

    public String getEmailServerHost() {
        return this.email_server_host;
    }

    public final synchronized void setLdapContext(DirContext ctx) {
        this.ldapCtx = ctx;
    }

    synchronized String getAgentName(HttpServletRequest request) throws AQxmlException {
        String agent_name = null;
        String remote_host = null;
        String remote_addr = null;
        String smtp_user = null;
        AQxmlDebug.trace(4, "AQxmlServlet.getAgentName", "entry");
        remote_host = request.getRemoteHost();
        remote_addr = request.getRemoteAddr();
        agent_name = request.getRemoteUser();
        AQxmlDebug.trace(5, "AQxmlServlet.getAgentName", "remote host: " + remote_host + "remote addr: " + remote_addr);
        AQxmlDebug.trace(5, "AQxmlServlet.getAgentName", "remote auth user: " + agent_name);
        if (this.email_server_addr != null || this.email_server_host != null) {
            AQxmlDebug.trace(5, "AQxmlServlet.getAgentName", "email host: " + this.email_server_host + "\nemail addr: " + this.email_server_addr);
            if ((remote_host.equalsIgnoreCase(this.email_server_host) || remote_addr.equals(this.email_server_addr)) && agent_name.equalsIgnoreCase("oracle_smtp_agent")) {
                smtp_user = request.getHeader("ORACLE_AQ_SMTP_USER");
                AQxmlDebug.trace(5, "AQxmlServlet.getAgentName", "smtp_user: " + smtp_user);
                if (smtp_user != null) {
                    agent_name = smtp_user;
                }
            }
        }
        if (agent_name == null) {
            if (this.auth_user) {
                AQxmlError.throwAQEx(433);
            } else {
                agent_name = "aq_default";
                AQxmlDebug.trace(4, "AQxmlServlet.getAQProcessor", "user not authenticated: " + agent_name);
            }
        }
        return agent_name;
    }

    protected synchronized void setManualInvalidation(boolean flag) {
        this.hses_miv = flag;
        if (!flag) {
            if (this.hses_thd != null) {
                if (this.hses_thd.isAlive()) {
                    this.hses_thd.stop();
                }
                this.hses_thd = null;
            }
            if (this.hses_ctx != null) {
                this.hses_ctx = null;
            }
        }
    }

    public synchronized void setStyleSheet(String type, String href) throws AQxmlException {
        String proc_instr;
        if (type == null) {
            AQxmlError.throwAQEx(441, "type");
        }
        if (href == null) {
            AQxmlError.throwAQEx(441, "href");
        }
        AQxmlDebug.trace(5, "AQxmlServlet.setStyleSheet", "type: " + type + " href: " + href);
        this.xsl_proc_instr = proc_instr = "type=\"" + type + "\" href=\"" + href + "\"";
        AQxmlDebug.trace(5, "AQxmlServlet.setStyleSheet", "proc_instr: " + proc_instr);
    }

    public void setStyleSheetProcessingInstr(String proc_instr) throws AQxmlException {
        if (proc_instr == null) {
            AQxmlError.throwAQEx(441, "Processing_instruction");
        }
        this.xsl_proc_instr = proc_instr;
        AQxmlDebug.trace(5, "AQxmlServlet.setStyleSheetProcessingInstr", "proc_instr: " + proc_instr);
    }

    protected final void setUserAuthentication(boolean flag) {
        this.auth_user = flag;
    }

    public void destroy() {
        AQxmlDebug.trace(4, "AQxmlServlet.destroy", "entry");
        if (this.data_src != null) {
            AQxmlDebug.trace(4, "AQxmlServlet.destroy", "before data_src.close");
            for (int i = 0; i < this.data_src.length; ++i) {
                this.data_src[i].close();
            }
        }
        if (this.hses_thd != null && this.hses_thd.isAlive()) {
            this.hses_thd.stop();
        }
        AQxmlDebug.trace(4, "AQxmlServlet.destroy", "exit");
    }

    @Override
    public void run() {
        AQxmlDebug.trace(4, "AQxmlServlet.sessionInvalidationThread", "run");
        while (true) {
            if (this.hses_ctx != null) {
                try {
                    Enumeration ids = this.hses_ctx.getIds();
                    AQxmlDebug.trace(5, "AQxmlServlet.sessionInvalidationThread", "get session ids" + ids);
                    while (ids.hasMoreElements()) {
                        Date curtime;
                        String id = (String)ids.nextElement();
                        AQxmlDebug.trace(5, "AQxmlServlet.sessionInvalidationThread", "session id" + id);
                        HttpSession session = this.hses_ctx.getSession(id);
                        Date accessed = new Date(session.getLastAccessedTime());
                        if (!accessed.before(curtime = new Date(System.currentTimeMillis() - (long)(this.max_inactive_time * 1000)))) continue;
                        AQxmlDebug.trace(5, "AQxmlServlet.invalidateSession", "id: " + id);
                        session.invalidate();
                    }
                    try {
                        AQxmlDebug.trace(5, "AQxmlServlet.invalidateSession", "inactive time " + this.max_inactive_time);
                        Thread.sleep(this.max_inactive_time * 1000);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    AQxmlDebug.trace(5, "AQxmlServlet.invalidateSession", "wake up");
                }
                catch (Exception e) {
                    AQxmlDebug.traceEx(5, "AQxmlServlet.invalidation-ex", e);
                }
                continue;
            }
            AQxmlDebug.trace(5, "AQxmlServlet.sessionInvalidationThread", "session context is null");
        }
    }
}

