/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;

public class AQxmlProducerOption {
    public static final int DEVIATION_BEFORE = 2;
    public static final int DEVIATION_TOP = 3;
    public static final int VISIBILITY_IMMEDIATE = 1;
    public static final int VISIBILITY_ONCOMMIT = 2;
    static final int DEFAULT_VISIBILITY = 2;
    protected int m_visibility;
    String dest_owner = null;
    String dest_name = null;
    String dest_alias = null;
    int sequence_number;
    String db_link;
    int source_qid;
    boolean al_unresolved = false;
    String prod_txfm = null;

    public AQxmlProducerOption(String destination_owner, String destination_name, int visibility) throws AQxmlException {
        if (visibility == 1 || visibility == 2) {
            this.m_visibility = visibility;
        } else {
            AQxmlError.throwAQEx(415);
        }
        if (destination_owner == null || destination_owner.equals("")) {
            AQxmlError.throwAQEx(414);
        }
        if (destination_name == null) {
            AQxmlError.throwAQEx(400);
        }
        this.dest_owner = destination_owner;
        this.dest_name = destination_name;
    }

    public AQxmlProducerOption(String destination_owner, String destination_name) throws AQxmlException {
        this(destination_owner, destination_name, 2);
    }

    public AQxmlProducerOption(String destination_alias, int visibility) throws AQxmlException {
        if (visibility == 1 || visibility == 2) {
            this.m_visibility = visibility;
        } else {
            AQxmlError.throwAQEx(415);
        }
        if (destination_alias == null || destination_alias.equals("")) {
            AQxmlError.throwAQEx(445);
        }
        this.dest_alias = destination_alias;
        this.al_unresolved = true;
    }

    public AQxmlProducerOption(String destination_alias) throws AQxmlException {
        this(destination_alias, 2);
    }

    public int getVisibility() {
        return this.m_visibility;
    }

    public void setVisibility(int visibility) throws AQxmlException {
        if (visibility == 1 || visibility == 2) {
            this.m_visibility = visibility;
        } else {
            AQxmlError.throwAQEx(415);
        }
    }

    public String getCompleteDestName() {
        String ret = null;
        ret = this.dest_owner != null && !this.dest_owner.equals("") ? this.dest_owner + "." + this.dest_name : this.dest_name;
        return ret;
    }

    public void setDestinationOwner(String owner) {
        this.dest_owner = owner;
    }

    public String getDestinationOwner() {
        return this.dest_owner;
    }

    public void setDestinationName(String name) {
        this.dest_name = name;
    }

    public String getDestinationName() {
        return this.dest_name;
    }

    public void setDestinationAlias(String d_alias) {
        this.dest_alias = d_alias;
        this.al_unresolved = true;
    }

    public String getDestinationAlias() {
        return this.dest_alias;
    }

    void setAliasUnresolved(boolean au) {
        this.al_unresolved = au;
    }

    boolean aliasUnresolved() {
        return this.al_unresolved;
    }

    void setSequenceNumber(int seq) {
        this.sequence_number = seq;
    }

    int getSequenceNumber() {
        return this.sequence_number;
    }

    void setDbLink(String dblink) {
        this.db_link = dblink;
    }

    String getDbLink() {
        return this.db_link;
    }

    void setSourceQid(int sqid) {
        this.source_qid = sqid;
    }

    int getSourceQid() {
        return this.source_qid;
    }

    public String getTransformation() {
        return this.prod_txfm;
    }

    public void setTransformation(String transformation) {
        this.prod_txfm = transformation;
    }
}

