/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlJmsMessage;
import oracle.jakarta.AQ.xml.AQxmlMessageHeader;
import oracle.jakarta.AQ.xml.AQxmlMessagePropertyList;

public class AQxmlJmsMapMessage
extends AQxmlJmsMessage {
    Object jms_message;
    Hashtable mapItemHash;

    public AQxmlJmsMapMessage(AQxmlMessageHeader header, AQxmlMessagePropertyList props) throws AQxmlException {
        super(header, props);
        this.mapItemHash = new Hashtable();
    }

    AQxmlJmsMapMessage(Object jms_map_message) throws AQxmlException {
        if (jms_map_message == null) {
            AQxmlError.throwAQEx(401, "jms_map_message cannot be null");
        }
        this.header = new AQxmlMessageHeader();
        this.jms_message = jms_map_message;
    }

    @Override
    Object getJmsMessage() {
        return this.jms_message;
    }

    public void setBoolean(String name, boolean value) {
        this.mapItemHash.put(name, new Boolean(value));
    }

    public void setByte(String name, byte value) {
        this.mapItemHash.put(name, new Byte(value));
    }

    public void setShort(String name, short value) {
        this.mapItemHash.put(name, new Short(value));
    }

    void setChar(String name, char value) {
        this.mapItemHash.put(name, new Character(value));
    }

    public void setDouble(String name, double value) {
        this.mapItemHash.put(name, new Double(value));
    }

    public void setFloat(String name, float value) {
        this.mapItemHash.put(name, new Float(value));
    }

    public void setInt(String name, int value) {
        this.mapItemHash.put(name, new Integer(value));
    }

    public void setLong(String name, long value) {
        this.mapItemHash.put(name, new Long(value));
    }

    public void setString(String name, String value) {
        this.mapItemHash.put(name, value);
    }

    void setBytes(String name, byte[] value) {
        this.mapItemHash.put(name, value);
    }

    public boolean getBoolean(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    return new Boolean((String)obj);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return false;
        }
        AQxmlError.throwAQEx(409);
        return false;
    }

    public byte getByte(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return (Byte)obj;
                }
                if (obj instanceof String) {
                    return Byte.parseByte((String)obj);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return 0;
        }
        AQxmlError.throwAQEx(409);
        return 0;
    }

    byte[] getBytes(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                return (byte[])obj;
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
                AQxmlError.throwAQEx(408);
                return null;
            }
        }
        AQxmlError.throwAQEx(409);
        return null;
    }

    char getChar(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Character) {
                    return ((Character)obj).charValue();
                }
                if (obj instanceof String) {
                    return ((String)obj).charAt(0);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return '\u0000';
        }
        AQxmlError.throwAQEx(409);
        return '\u0000';
    }

    public double getDouble(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Float) {
                    return ((Float)obj).floatValue();
                }
                if (obj instanceof Double) {
                    return (Double)obj;
                }
                if (obj instanceof String) {
                    return new Double((String)obj);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return 0.0;
        }
        AQxmlError.throwAQEx(409);
        return 0.0;
    }

    public float getFloat(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Float) {
                    return ((Float)obj).floatValue();
                }
                if (obj instanceof String) {
                    return new Float((String)obj).floatValue();
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return 0.0f;
        }
        AQxmlError.throwAQEx(409);
        return 0.0f;
    }

    public int getInt(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return ((Byte)obj).byteValue();
                }
                if (obj instanceof Short) {
                    return ((Short)obj).shortValue();
                }
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
                if (obj instanceof String) {
                    return new Integer((String)obj);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return 0;
        }
        AQxmlError.throwAQEx(409);
        return 0;
    }

    public long getLong(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return ((Byte)obj).byteValue();
                }
                if (obj instanceof Short) {
                    return ((Short)obj).shortValue();
                }
                if (obj instanceof Integer) {
                    return ((Integer)obj).intValue();
                }
                if (obj instanceof Long) {
                    return (Long)obj;
                }
                if (obj instanceof String) {
                    return new Long((String)obj);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return 0L;
        }
        AQxmlError.throwAQEx(409);
        return 0L;
    }

    public short getShort(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return ((Byte)obj).byteValue();
                }
                if (obj instanceof Short) {
                    return (Short)obj;
                }
                if (obj instanceof String) {
                    return new Short((String)obj);
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return 0;
        }
        AQxmlError.throwAQEx(409);
        return 0;
    }

    public String getString(String name) throws AQxmlException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Integer || obj instanceof Character || obj instanceof Long || obj instanceof Float || obj instanceof Short || obj instanceof Byte || obj instanceof Double || obj instanceof String || obj instanceof Boolean) {
                    return obj.toString();
                }
            }
            catch (Exception e) {
                AQxmlError.throwAQEx(408, e.getMessage());
            }
            AQxmlError.throwAQEx(408);
            return null;
        }
        AQxmlError.throwAQEx(409);
        return null;
    }

    public Enumeration getMapNames() throws AQxmlException {
        return this.mapItemHash.keys();
    }

    public boolean itemExists(String name) throws AQxmlException {
        return this.mapItemHash.containsKey(name);
    }
}

