/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlSignature;

public class AQxmlConsumerOption {
    static final int NAVIGATION_FIRST_MESSAGE = 1;
    static final int NAVIGATION_NEXT_TRANSACTION = 2;
    static final int NAVIGATION_NEXT_MESSAGE = 3;
    static final int DEQUEUE_BROWSE = 1;
    static final int DEQUEUE_LOCKED = 2;
    static final int DEQUEUE_REMOVE = 3;
    static final int DEQUEUE_REMOVE_NODATA = 4;
    static final int DEQUEUE_GET_SIGNATURE = 5;
    static final int WAIT_FOREVER = -1;
    static final int WAIT_NONE = 0;
    static final int VISIBILITY_IMMEDIATE = 1;
    static final int VISIBILITY_ONCOMMIT = 2;
    static final int DEFAULT_DEQUEUE_MODE = 3;
    static final int DEFAULT_NAVIGATION_MODE = 3;
    static final int DEFAULT_WAIT_TIME = -1;
    static final int DEFAULT_VISIBILITY = 2;
    private String consumer = null;
    private int deq_mode = 3;
    private int navig_mode = 3;
    private int visib = 2;
    private int wait = -1;
    private byte[] msgid = null;
    private String corr = null;
    String condition = null;
    String dest_owner = null;
    String dest_name = null;
    String dest_alias = null;
    boolean al_unresolved;
    int batch_size = 1;
    String cnsmr_txfm = null;
    AQxmlSignature signature = null;

    public AQxmlConsumerOption(String destination_owner, String destination_name, int dequeue_mode, int navigation, int wait_time, int visibility) throws AQxmlException {
        if (destination_name == null) {
            AQxmlError.throwAQEx(400);
        }
        if (destination_owner == null || destination_owner.equals("")) {
            AQxmlError.throwAQEx(414);
        }
        this.dest_owner = destination_owner;
        this.dest_name = destination_name;
        this.al_unresolved = false;
        this.setVisibility(visibility);
        this.setDequeueMode(dequeue_mode);
        this.setNavigationMode(navigation);
        this.setWaitTime(wait_time);
    }

    public AQxmlConsumerOption(String destination_owner, String destination_name) throws AQxmlException {
        this(destination_owner, destination_name, 3, 3, 0, 2);
    }

    public AQxmlConsumerOption(String destination_alias, int dequeue_mode, int navigation, int wait_time, int visibility) throws AQxmlException {
        if (destination_alias == null || destination_alias.equals("")) {
            AQxmlError.throwAQEx(445);
        }
        this.dest_alias = destination_alias;
        this.al_unresolved = true;
        this.setVisibility(visibility);
        this.setDequeueMode(dequeue_mode);
        this.setNavigationMode(navigation);
        this.setWaitTime(wait_time);
    }

    public AQxmlConsumerOption(String destination_alias) throws AQxmlException {
        this(destination_alias, 3, 3, 0, 2);
    }

    public String getConsumerName() {
        return this.consumer;
    }

    public void setConsumerName(String consumer_name) throws AQxmlException {
        this.consumer = consumer_name;
    }

    public int getDequeueMode() {
        return this.deq_mode;
    }

    public void setDequeueMode(int dequeue_mode) throws AQxmlException {
        if (dequeue_mode == 1 || dequeue_mode == 2 || dequeue_mode == 3 || dequeue_mode == 4 || dequeue_mode == 5) {
            this.deq_mode = dequeue_mode;
        } else {
            AQxmlError.throwAQEx(416);
        }
    }

    public AQxmlSignature getSignature() throws AQxmlException {
        return this.signature;
    }

    public void setSignature(AQxmlSignature m_sign) throws AQxmlException {
        this.signature = m_sign;
    }

    public int getNavigationMode() {
        return this.navig_mode;
    }

    public void setNavigationMode(int navigation) throws AQxmlException {
        if (navigation == 1 || navigation == 3 || navigation == 2) {
            this.navig_mode = navigation;
        } else {
            AQxmlError.throwAQEx(417);
        }
    }

    public int getVisibility() {
        return this.visib;
    }

    public void setVisibility(int visibility) throws AQxmlException {
        if (visibility == 1 || visibility == 2) {
            this.visib = visibility;
        } else {
            AQxmlError.throwAQEx(415);
        }
    }

    public int getWaitTime() {
        return this.wait;
    }

    public void setWaitTime(int wait_time) throws AQxmlException {
        if (wait_time == -1 || wait_time == 0) {
            this.wait = wait_time;
        } else if (wait_time > 0) {
            this.wait = wait_time;
        } else {
            AQxmlError.throwAQEx(418);
        }
    }

    public byte[] getMessageId() {
        return this.msgid;
    }

    public void setMessageId(byte[] message_id) throws AQxmlException {
        this.msgid = message_id;
    }

    public String getCorrelation() {
        return this.corr;
    }

    public void setCorrelation(String correlation) throws AQxmlException {
        this.corr = correlation;
    }

    String getCompleteName() {
        String ret = null;
        ret = this.dest_owner != null && !this.dest_owner.equals("") ? this.dest_owner + "." + this.dest_name : this.dest_name;
        return ret;
    }

    public void setDestinationOwner(String owner) {
        this.dest_owner = owner;
    }

    public String getDestinationOwner() {
        return this.dest_owner;
    }

    public void setCondition(String cond) {
        this.condition = cond;
    }

    public void setBatchSize(int size) {
        this.batch_size = size;
    }

    public void setDestinationName(String name) {
        this.dest_name = name;
    }

    public String getDestinationName() {
        return this.dest_name;
    }

    public void setDestinationAlias(String d_alias) {
        this.dest_alias = d_alias;
        this.al_unresolved = true;
    }

    public String getDestinationAlias() {
        return this.dest_alias;
    }

    void setAliasUnresolved(boolean au) {
        this.al_unresolved = au;
    }

    boolean aliasUnresolved() {
        return this.al_unresolved;
    }

    public String getCondition() {
        return this.condition;
    }

    public int getBatchSize() {
        return this.batch_size;
    }

    public String getTransformation() {
        return this.cnsmr_txfm;
    }

    public void setTransformation(String transformation) {
        this.cnsmr_txfm = transformation;
    }
}

