/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import oracle.jakarta.AQ.AQException;
import oracle.jakarta.AQ.AQOracleDebug;

public class AQUtil {
    private SimpleDateFormat printdateformat;
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static ResourceBundle bundle;

    public AQUtil() {
        this.printdateformat = new SimpleDateFormat("EE MMM dd HH:mm:ss.SSS zz yyyy  ");
    }

    static String ByteArraytoString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        if (b == null) {
            buf.append("<Null byte array!>");
        } else {
            int n = b.length;
            for (int i = 0; i < n; ++i) {
                int v = b[i] & 0xFF;
                if (v < 16) {
                    buf.append("0" + Integer.toHexString(v));
                    continue;
                }
                buf.append(Integer.toHexString(v));
            }
        }
        return buf.toString();
    }

    String convertDateObjToPrintStr(Date sdate) {
        String string_date = "";
        string_date = this.printdateformat.format(sdate);
        return string_date;
    }

    Date convertPrintStrToDateObj(String str_date) {
        Date sdate = null;
        try {
            sdate = this.printdateformat.parse("1998-07-07 00:00:00");
        }
        catch (Exception ex) {
            AQOracleDebug.traceEx(4, "AQUtil.converttoDateObj", ex);
        }
        return sdate;
    }

    static String getMessage(String key, Object[] args) {
        String ret_str = null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("oracle.jakarta.jms.AQjmsMessages");
        }
        try {
            ret_str = MessageFormat.format(bundle.getString(key), args);
            ret_str = "JMS-" + key + ": " + ret_str;
        }
        catch (Exception ex) {
            ret_str = "Message [" + key + "] not found in 'AQjmsMessages'.";
        }
        return ret_str;
    }

    public static void throwAQEx(int aq_error_code) throws AQException {
        String msg = null;
        msg = AQUtil.getMessage(Integer.toString(aq_error_code), null);
        throw new AQException(aq_error_code, msg);
    }

    public static void throwAQEx(int aq_error_code, Exception linked_ex) throws AQException {
        String msg = null;
        msg = AQUtil.getMessage(Integer.toString(aq_error_code), null);
        throw new AQException(aq_error_code, msg, linked_ex);
    }

    public static void throwAQEx(int aq_error_code, String arg1) throws AQException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1};
        msg = AQUtil.getMessage(Integer.toString(aq_error_code), args);
        throw new AQException(aq_error_code, msg);
    }

    public static void throwAQEx(int aq_error_code, String arg1, Exception linked_ex) throws AQException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1};
        msg = AQUtil.getMessage(Integer.toString(aq_error_code), args);
        throw new AQException(aq_error_code, msg, linked_ex);
    }
}

