/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;

public abstract class OracleJDBCConnectionPool
extends JDBCConnectionPool
implements RACManagerImpl.RACCallbackExtended {
    static final String CLASS_NAME = OracleJDBCConnectionPool.class.getName();
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    RACManager m_racManager = null;
    Boolean isDRCPEnabled = null;
    Boolean isDRCPMultiTagEnabled = null;
    String drcpPLSQLCallbackName = null;
    private final ReentrantLock connectionPoolLock = new ReentrantLock();
    private Boolean isStrictWSAffinity = false;
    private Boolean isStrictXAAffinity = false;

    public OracleJDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
    }

    public OracleJDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            String instanceName;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "createOnePooledConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            assert (cri != null);
            OracleJDBCConnectionRetrievalInfo criToCreate = null;
            if (cri instanceof OracleJDBCConnectionRetrievalInfo) {
                OracleJDBCConnectionRetrievalInfo ocri = (OracleJDBCConnectionRetrievalInfo)cri;
                instanceName = ocri.getInstanceName();
                Object object = criToCreate = null == instanceName || "".equals(instanceName) ? null : cri;
            }
            if (null == criToCreate) {
                RACInstance racInstance = null != this.m_racManager ? this.m_racManager.getMostDesirableInstanceToGrow() : null;
                String string = instanceName = null == racInstance ? null : racInstance.getInstance();
                if (null != instanceName && !"".equals(instanceName)) {
                    this.trace(Level.FINEST, CLASS_NAME, "createOnePooledConnection", "about to set most desired instance {0}", null, null, instanceName);
                    boolean usePreferredInstance = false;
                    criToCreate = new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)cri, instanceName, usePreferredInstance);
                } else {
                    criToCreate = cri;
                }
            }
            UniversalPooledConnection universalPooledConnection = super.createOnePooledConnection(criToCreate);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "createOnePooledConnection", "returning {0}", null, null, universalPooledConnection);
            return universalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "createOnePooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void start(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl) throws UniversalConnectionPoolException {
        try {
            JDBCUniversalPooledConnection conn;
            void keepMetadataConn;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "start", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, bl);
            super.start((ConnectionRetrievalInfo)cri, (boolean)keepMetadataConn);
            String sqlStr = this.getSQLForValidateConnection();
            if (this.getValidateConnectionOnBorrow() && null != sqlStr && !"".equals(sqlStr) && null != (conn = (JDBCUniversalPooledConnection)this.createOnePooledConnection((ConnectionRetrievalInfo)cri))) {
                boolean invalidSQL = false;
                Statement stmt = null;
                try {
                    stmt = conn.getSQLConnection(conn.getPhysicalConnection()).createStatement();
                    stmt.execute(sqlStr);
                }
                catch (SQLRecoverableException sQLRecoverableException) {
                }
                catch (SQLException e) {
                    this.setValidateConnectionOnBorrow(false);
                    invalidSQL = true;
                }
                finally {
                    if (null != stmt) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    this.closePhysicalConnection(conn.getPhysicalConnection());
                }
                if (invalidSQL) {
                    this.purge();
                    throw UCPErrorHandler.newUniversalConnectionPoolException(151);
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "start", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        if (this.m_racManager != null) {
            return this.m_racManager.isRuntimeLoadBalancingEnabled();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo, int n) {
        try {
            void numConnectionsToTearDown;
            void dbInstance;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "tearDownConnectionsForInstance", "entering args ({0}, {1})", null, null, oracleDatabaseInstanceInfo, n);
            String instanceName = dbInstance.getInstanceName();
            String dbName = dbInstance.getDatabaseName();
            AtomicInteger tearDownCount = new AtomicInteger((int)numConnectionsToTearDown);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "tearDownConnectionsForInstance", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "tearDownConnectionsForInstance", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback connectionAffinityCallback) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "registerConnectionAffinityCallback", "entering args ({0})", null, null, connectionAffinityCallback);
            this.connectionPoolLock.lock();
            try {
                void affCbk;
                super.registerConnectionAffinityCallback((ConnectionAffinityCallback)affCbk);
                if (this.m_racManager != null) {
                    this.m_racManager.registerConnectionAffinityCallback((ConnectionAffinityCallback)affCbk);
                }
            }
            finally {
                this.connectionPoolLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "registerConnectionAffinityCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "registerConnectionAffinityCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "removeConnectionAffinityCallback", "entering args ()", null, null, new Object[0]);
            this.connectionPoolLock.lock();
            try {
                super.removeConnectionAffinityCallback();
                if (this.m_racManager != null) {
                    this.m_racManager.unregisterConnectionAffinityCallback(this.getConnectionAffinityCallback());
                }
            }
            finally {
                this.connectionPoolLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "removeConnectionAffinityCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool", "removeConnectionAffinityCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    UniversalPooledConnection getConnectionToNamedInstance() {
        return this.createOnePooledConnection();
    }

    @Override
    public OracleJDBCConnectionPoolStatistics getStatistics() {
        return new OracleJDBCConnectionPoolStatisticsImpl(this);
    }

    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).affBorrows.successful.total().longValue();
    }

    public long getSuccessfulAffinityBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).affBorrows.successful.total().longValue();
    }

    public long getFailedAffinityBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).affBorrows.failed.total().longValue();
    }

    public long getFailedAffinityBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).affBorrows.failed.total().longValue();
    }

    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).lbBorrows.successful.total().longValue();
    }

    public long getSuccessfulRCLBBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).lbBorrows.successful.total().longValue();
    }

    public long getFailedRCLBBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).lbBorrows.failed.total().longValue();
    }

    public long getFailedRCLBBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).lbBorrows.failed.total().longValue();
    }

    public String getFCFProcessingInfo() {
        return this.core.connectionSource().failoverDriverStats(null).toString();
    }

    public String getFCFProcessingInfo(String serviceName) {
        return this.core.connectionSource().failoverDriverStats(serviceName).toString();
    }

    public String getFCFProcessingInfoProcessedOnly() {
        return this.core.connectionSource().failoverDriverStats(null).toStringProcessedOnly();
    }

    public String getFCFProcessingInfoProcessedOnly(String serviceName) {
        return this.core.connectionSource().failoverDriverStats(serviceName).toStringProcessedOnly();
    }

    public long getConnectionRepurposeCount() {
        return this.core.repurposeCount();
    }

    public String getColocationStats(String serviceName) {
        return this.core.connectionSource().getColocationStats(null);
    }

    @Override
    public void closePhysicalConnection(final Object physicalConnection) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

            @Override
            public void run() {
                OracleJDBCConnectionPool.this.superClosePhysicalConnection(physicalConnection);
            }
        });
    }

    public void superClosePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    public void initiateDownEventProcessing(OracleFailoverEvent event) {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public int initiateUpEventProcessing(OracleFailoverEvent event) {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public FailoverablePooledConnection openNewConnection(String url, RACInstance racInstance) {
        throw new IllegalStateException("this method is obsolete");
    }

    @Override
    public String getUrl() {
        JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
        return cfa.getUrl();
    }

    @Override
    public String getPoolName() {
        return this.getName();
    }

    @Override
    public int getRoomToGrowPool() {
        return 0;
    }

    @Override
    public boolean isValid(FailoverablePooledConnection fpc) {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)fpc;
        return oupc.isValid();
    }

    @Override
    public FailoverablePooledConnection getAvailableConnectionToInstance(ConnectionRetrievalInfo cri, RACInstance racInstance) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public Collection<FailoverablePooledConnection> getAvailableConnections(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public void lbaEventOccurred(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
    }

    void setRACManager(RACManager racMngr) {
        this.m_racManager = racMngr;
    }

    @Override
    public CompletionStage<UniversalPooledConnection> borrowConnectionAsync(ConnectionRetrievalInfo cri, Executor executor) {
        return super.borrowConnectionAsync(this.updateCri(cri), executor);
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        return super.borrowConnection(this.updateCri(cri));
    }

    private ConnectionRetrievalInfo updateCri(ConnectionRetrievalInfo cri) {
        JDBCConnectionRetrievalInfo jdbcCri;
        String serviceName;
        if (cri instanceof JDBCConnectionRetrievalInfo && null != (serviceName = (jdbcCri = (JDBCConnectionRetrievalInfo)cri).getServiceNameFromUser())) {
            jdbcCri.getBorrowContextUpdater().userRequestedServiceName(serviceName);
        }
        return cri;
    }

    protected void onAddingConnectionToPool(UniversalPooledConnection pooledConnection) {
    }

    protected void onRemovingConnectionFromPool(UniversalPooledConnection pooledConnection) {
    }

    public void useStrictWebSessionAffinity(boolean strict) {
        this.isStrictWSAffinity = strict;
    }

    public void useStrictXAAffinity(boolean strict) {
        this.isStrictXAAffinity = strict;
    }

    protected boolean isDRCPEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        return false;
    }

    protected boolean isDRCPMultiTagEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        return false;
    }

    protected String getDRCPPLSQLCallbackName(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        return null;
    }

    @Override
    protected void validateConnectionRetrievalInfo(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            if (this.core.connectionSource().isShardedDatabase()) {
                if (jdbcCri.getShardingKey() == null) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(277);
                }
            } else if (!(this.core.connectionSource().isRacDataAffinityEnabled() || jdbcCri.getShardingKey() == null && jdbcCri.getSuperShardingKey() == null)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(278);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
    }
}

