/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.UCPConnectionBuilder;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CONN_CONSTRUCTION})
public class JDBCConnectionRetrievalInfo
implements ConnectionRetrievalInfo {
    private final String user;
    private final OpaqueString password;
    private final int hashcode;
    private final CRIProperties labels = new CRIProperties(){
        private static final long serialVersionUID = 4112578634029874842L;
        private static final String EXCEPTION_MESSAGE = "immutable properties";
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object putIfAbsent(Object key, Object value) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public boolean remove(Object key, Object val) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object replace(Object key, Object val) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public boolean replace(Object key, Object oldval, Object newval) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        @Override
        public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        static {
            try {
                $$$methodRef$$$9 = 1.class.getDeclaredConstructor(JDBCConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = 1.class.getDeclaredMethod("merge", Object.class, Object.class, BiFunction.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = 1.class.getDeclaredMethod("replaceAll", BiFunction.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = 1.class.getDeclaredMethod("replace", Object.class, Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = 1.class.getDeclaredMethod("replace", Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = 1.class.getDeclaredMethod("remove", Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 1.class.getDeclaredMethod("remove", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredMethod("clear", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("putIfAbsent", Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("put", Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    private final int proxyType;
    private final Properties proxyProperties;
    private final String serviceName;
    private final String userRequestedServiceName;
    private OracleShardingKey shardingKey;
    private OracleShardingKey superShardingKey;
    private SSLContext sslContext;
    private boolean readOnlyInstanceAllowed;
    private Properties pdbRoles;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;

    @Deprecated
    public JDBCConnectionRetrievalInfo(String user, String password) {
        this(user, OpaqueString.newOpaqueString(password), null);
    }

    @Deprecated
    public JDBCConnectionRetrievalInfo(String user, String password, Properties labels) {
        this(user, OpaqueString.newOpaqueString(password), labels);
    }

    public JDBCConnectionRetrievalInfo(String user, OpaqueString password) {
        this(user, password, null);
    }

    public JDBCConnectionRetrievalInfo(String user, OpaqueString password, Properties labels) {
        this.user = user;
        this.password = password;
        if (labels != null) {
            this.labels.putAllLabels(labels);
        }
        String tuser = user == null ? "" : user;
        this.hashcode = tuser.hashCode();
        this.serviceName = null;
        this.userRequestedServiceName = null;
        this.proxyType = -1;
        this.proxyProperties = null;
    }

    JDBCConnectionRetrievalInfo(UCPConnectionBuilder connBldr) {
        this(JDBCConnectionRetrievalInfo.createBuilder(connBldr));
    }

    JDBCConnectionRetrievalInfo(UCPXAConnectionBuilder xaConnBldr) {
        this(JDBCConnectionRetrievalInfo.createBuilder(xaConnBldr));
    }

    public JDBCConnectionRetrievalInfo(JDBCConnectionRetrievalInfo copyCri) {
        this(copyCri.copyBuilder());
    }

    @Override
    public boolean equals(Object obj) {
        String ouser;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo other = (JDBCConnectionRetrievalInfo)obj;
        String luser = this.user == null ? "" : this.user;
        boolean isEqual = luser.equals(ouser = other.user == null ? "" : other.user);
        if (isEqual) {
            isEqual = this.serviceName == null && other.serviceName == null ? true : (this.serviceName != null && other.serviceName != null ? this.serviceName.equals(other.serviceName) : false);
        }
        return isEqual;
    }

    @Override
    public boolean equalsIncludingPassword(ConnectionRetrievalInfo cri) {
        return this.equals(cri) && this.password.equals(((JDBCConnectionRetrievalInfo)cri).password);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    public String getUser() {
        return this.user;
    }

    public OpaqueString getPassword() {
        return this.password;
    }

    @Override
    public void addLabel(String key, String value) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(201);
        }
        String val = value == null ? "" : value;
        this.labels.addLabel(key, val);
    }

    @Override
    public void removeLabel(String key) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(201);
        }
        this.labels.removeLabel(key);
        ClioSupport.ilogFinest(null, null, null, null, "label removed successfully: key=" + key);
    }

    @Override
    public ConnectionRetrievalInfo getCopyWithNoLabels() {
        return this.copyBuilder().labels(null).build();
    }

    public ConnectionRetrievalInfo getCopyWithNewProxyProperties(int type, Properties newProxyProps) {
        return this.copyBuilder().proxyProperties(type, newProxyProps).build();
    }

    public ConnectionRetrievalInfo getCopyWithService(String newService) {
        return this.copyBuilder().serviceName(newService).build();
    }

    public ConnectionRetrievalInfo getCopyWithUserRequestedService(String newService) {
        return this.copyBuilder().userRequestedServiceName(newService).build();
    }

    @Override
    public Properties getLabels() {
        if (this.labels.isEmpty()) {
            return null;
        }
        return this.labels;
    }

    public Properties getProxyProperties() {
        if (this.proxyProperties == null) {
            return null;
        }
        Properties proxyProps = new Properties();
        proxyProps.putAll((Map<?, ?>)this.proxyProperties);
        return proxyProps;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUserRequestedServiceName() {
        return this.userRequestedServiceName;
    }

    public OracleShardingKey getShardingKey() {
        return this.shardingKey;
    }

    public OracleShardingKey getSuperShardingKey() {
        return this.superShardingKey;
    }

    public Properties getPdbRoles() {
        return this.pdbRoles;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    @DisableTrace
    public String toString() {
        return "user=" + this.user + ", password=********" + ", labels=" + this.labels + (String)(this.proxyType != -1 ? ", Proxy Type =" + this.proxyType : "") + (String)(this.proxyProperties != null ? ", Proxy Properties =" + this.proxyProperties : "") + (String)(this.serviceName != null ? ", Service Name =" + this.serviceName : "") + (String)(this.shardingKey != null ? ", Sharding Key =" + this.shardingKey : "") + (String)(this.superShardingKey != null ? ", Super Sharding Key =" + this.superShardingKey : "") + (String)(this.pdbRoles != null ? ", PDB Roles =" + this.pdbRoles : "");
    }

    public String stringValue() {
        return "user=" + this.user + ", password=" + this.password + ", labels=" + this.labels + (String)(this.proxyType != -1 ? ", Proxy Type =" + this.proxyType : "") + (String)(this.proxyProperties != null ? ", Proxy Properties =" + this.proxyProperties : "") + (String)(this.serviceName != null ? ", Service Name =" + this.serviceName : "") + (String)(this.shardingKey != null ? ", Sharding Key =" + this.shardingKey : "") + (String)(this.superShardingKey != null ? ", Super Sharding Key =" + this.superShardingKey : "") + (String)(this.pdbRoles != null ? ", PDB Roles =" + this.pdbRoles : "");
    }

    private JDBCConnectionRetrievalInfo(Builder builder) {
        this.user = builder.user;
        this.password = builder.password;
        if (builder.labels != null) {
            this.labels.putAllLabels(builder.labels);
        }
        this.proxyType = builder.proxyType;
        if (builder.proxyProperties == null) {
            this.proxyProperties = null;
        } else {
            this.proxyProperties = new Properties();
            this.proxyProperties.putAll((Map<?, ?>)builder.proxyProperties);
        }
        this.serviceName = builder.serviceName != null ? builder.serviceName.toLowerCase() : null;
        this.userRequestedServiceName = builder.userRequestedServiceName != null ? builder.userRequestedServiceName.toLowerCase() : null;
        int tempHashCode = 0;
        String tuser = this.user == null ? "" : this.user;
        tempHashCode = tuser.hashCode();
        if (this.serviceName != null) {
            tempHashCode = tempHashCode * 31 + this.serviceName.hashCode();
        }
        this.hashcode = tempHashCode;
        this.shardingKey = builder.shardingKey;
        this.superShardingKey = builder.superShardingKey;
        if (builder.pdbRoles == null) {
            this.pdbRoles = null;
        } else {
            this.pdbRoles = new Properties();
            this.pdbRoles.putAll((Map<?, ?>)builder.pdbRoles);
        }
        this.sslContext = builder.sslContext;
        this.readOnlyInstanceAllowed = builder.readOnlyInstanceAllowed;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    static Builder createBuilder(UCPConnectionBuilder builder) {
        UCPConnectionBuilderImpl connBldr = (UCPConnectionBuilderImpl)builder;
        return new Builder().user(connBldr.user).password(connBldr.password).labels(connBldr.labels).proxyProperties(connBldr.proxyType, connBldr.proxyProperties).serviceName(connBldr.serviceName).shardingKey(connBldr.shardingKey).superShardingKey(connBldr.superShardingKey).pdbRoles(connBldr.pdbRoles).sslContext(connBldr.sslContext).readOnlyInstanceAllowed(connBldr.readOnlyInstanceAllowed);
    }

    static Builder createBuilder(UCPXAConnectionBuilder builder) {
        UCPXAConnectionBuilderImpl xaConnBldr = (UCPXAConnectionBuilderImpl)builder;
        return new Builder().user(xaConnBldr.user).password(xaConnBldr.password).labels(xaConnBldr.labels).proxyProperties(xaConnBldr.proxyType, xaConnBldr.proxyProperties).serviceName(xaConnBldr.serviceName).shardingKey(xaConnBldr.shardingKey).superShardingKey(xaConnBldr.superShardingKey).pdbRoles(xaConnBldr.pdbRoles).sslContext(xaConnBldr.sslContext).readOnlyInstanceAllowed(xaConnBldr.readOnlyInstanceAllowed);
    }

    private Builder copyBuilder() {
        return JDBCConnectionRetrievalInfo.createBuilder().user(this.user).password(this.password).labels(this.labels).proxyProperties(this.proxyType, this.proxyProperties).serviceName(this.serviceName).userRequestedServiceName(this.userRequestedServiceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey).pdbRoles(this.pdbRoles).sslContext(this.sslContext).readOnlyInstanceAllowed(this.readOnlyInstanceAllowed);
    }

    static {
        try {
            $$$methodRef$$$34 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(Builder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(UCPXAConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(UCPConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(String.class, OpaqueString.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = JDBCConnectionRetrievalInfo.class.getDeclaredConstructor(String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("copyBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("createBuilder", UCPXAConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("createBuilder", UCPConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("createBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("isReadOnlyInstanceAllowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getSSLContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getPdbRoles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getSuperShardingKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getShardingKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getUserRequestedServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getProxyType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getProxyProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getLabels", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getCopyWithUserRequestedService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getCopyWithService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getCopyWithNewProxyProperties", Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getCopyWithNoLabels", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("removeLabel", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("addLabel", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("equalsIncludingPassword", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = JDBCConnectionRetrievalInfo.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public static class Builder {
        private String user = null;
        private OpaqueString password = OpaqueString.NULL;
        private Properties labels = null;
        private int proxyType = -1;
        private Properties proxyProperties = null;
        private String serviceName = null;
        private String userRequestedServiceName = null;
        private OracleShardingKey shardingKey = null;
        private OracleShardingKey superShardingKey = null;
        private Properties pdbRoles = null;
        private SSLContext sslContext = null;
        private boolean readOnlyInstanceAllowed = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(OpaqueString password) {
            this.password = password;
            return this;
        }

        public Builder labels(Properties labels) {
            this.labels = labels;
            return this;
        }

        public Builder proxyProperties(int type, Properties proxyProperties) {
            this.proxyType = type;
            this.proxyProperties = proxyProperties;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder userRequestedServiceName(String userRequestedServiceName) {
            this.userRequestedServiceName = userRequestedServiceName;
            return this;
        }

        public Builder shardingKey(OracleShardingKey shardingKey) {
            this.shardingKey = shardingKey;
            return this;
        }

        public Builder superShardingKey(OracleShardingKey superKey) {
            this.superShardingKey = superKey;
            return this;
        }

        public Builder pdbRoles(Properties pdbRoles) {
            this.pdbRoles = pdbRoles;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
            this.readOnlyInstanceAllowed = readOnlyInstanceAllowed;
            return this;
        }

        public JDBCConnectionRetrievalInfo build() {
            return new JDBCConnectionRetrievalInfo(this);
        }

        static {
            try {
                $$$methodRef$$$12 = Builder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$11 = Builder.class.getDeclaredMethod("build", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = Builder.class.getDeclaredMethod("readOnlyInstanceAllowed", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = Builder.class.getDeclaredMethod("sslContext", SSLContext.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = Builder.class.getDeclaredMethod("pdbRoles", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = Builder.class.getDeclaredMethod("superShardingKey", OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = Builder.class.getDeclaredMethod("shardingKey", OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Builder.class.getDeclaredMethod("userRequestedServiceName", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Builder.class.getDeclaredMethod("serviceName", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Builder.class.getDeclaredMethod("proxyProperties", Integer.TYPE, Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Builder.class.getDeclaredMethod("labels", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Builder.class.getDeclaredMethod("password", OpaqueString.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Builder.class.getDeclaredMethod("user", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    private static class CRIProperties
    extends Properties {
        private static final long serialVersionUID = 4112578634029874841L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        private CRIProperties() {
        }

        private void addLabel(Object key, Object val) {
            super.put(key, val);
        }

        private void putAllLabels(Properties props) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.addLabel(k, v)));
        }

        private void removeLabel(String key) {
            super.remove(key);
        }

        static {
            try {
                $$$methodRef$$$4 = CRIProperties.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = CRIProperties.class.getDeclaredMethod("lambda$putAllLabels$0", Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = CRIProperties.class.getDeclaredMethod("removeLabel", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = CRIProperties.class.getDeclaredMethod("putAllLabels", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = CRIProperties.class.getDeclaredMethod("addLabel", Object.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

