/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardingRangeMap;
import oracle.ucp.util.Pair;

abstract class ShardRoutingCacheBase {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final NavigableMap<RoutingKey, Chunk> keysToChunks = new TreeMap<RoutingKey, Chunk>();
    private volatile NavigableMap<RoutingKey, Chunk> keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
    private volatile ShardingRangeMap shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
    private volatile int routingTableSize = 0;
    private final Map<String, Set<RoutingKey>> chunkNamesToKeys = new HashMap<String, Set<RoutingKey>>();
    private final Map<Chunk, Set<RoutingKey>> chunksToKeys = new HashMap<Chunk, Set<RoutingKey>>();
    private final Map<ServiceMember, Map<Chunk, AtomicInteger>> instsToChunks = new HashMap<ServiceMember, Map<Chunk, AtomicInteger>>();
    protected final Map<String, Map<Chunk, AtomicInteger>> chunkAbsNamesToChunks = new HashMap<String, Map<Chunk, AtomicInteger>>();
    protected final Map<Pair<ServiceMember, String>, Map<Chunk, AtomicInteger>> instsAndChunkAbsNamesToChunks = new HashMap<Pair<ServiceMember, String>, Map<Chunk, AtomicInteger>>();
    private volatile Map<Integer, List<Chunk>> chunkIdsToChunks = Collections.unmodifiableMap(new HashMap());
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;

    ShardRoutingCacheBase() {
    }

    protected abstract long getShardkeyOraHash(OracleShardingKey var1);

    protected final Set<RoutingKey> keyForChunk(String chunkName) {
        if (null == chunkName) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<RoutingKey> set = this.chunkNamesToKeys.getOrDefault(chunkName, Collections.emptySet());
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final List<Chunk> chunks(OracleShardingKey superKey, OracleShardingKey key) {
        return Objects.requireNonNull(this.shardingRangeMap.get(superKey, key));
    }

    protected final int getRoutingTableSize() {
        return this.routingTableSize;
    }

    protected final NavigableMap<RoutingKey, Chunk> keyToChunkMap() {
        return this.keysToChunksSnapshot;
    }

    protected final Chunk get(RoutingKey key) {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        return (Chunk)this.keysToChunksSnapshot.get(key);
    }

    protected final Set<Chunk> chunks(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.instsToChunks.getOrDefault(inst, Collections.emptyMap()).keySet();
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<Chunk> chunks(ServiceMember inst, String chunkAbsName) {
        if (null == inst) {
            return this.chunks(chunkAbsName);
        }
        if (null == chunkAbsName) {
            return new HashSet<Chunk>();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>(inst, chunkAbsName), Collections.emptyMap()).keySet();
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final Set<Chunk> chunks(String chunkAbsName) {
        if (null == chunkAbsName) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.chunkAbsNamesToChunks.getOrDefault(chunkAbsName, Collections.emptyMap()).keySet();
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected List<Chunk> chunks(int id) {
        return this.chunkIdsToChunks.get(id);
    }

    protected final int chunksCount() {
        this.rLock.lock();
        try {
            int n = this.chunksToKeys.keySet().size();
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void remove(Chunk chunk) {
        if (null == chunk) {
            throw new IllegalArgumentException();
        }
        String name = chunk.name();
        String absName = chunk.absoluteName();
        this.wLock.lock();
        try {
            Set<RoutingKey> keys = this.chunksToKeys.getOrDefault(chunk, Collections.emptySet());
            keys.forEach(p -> {
                if (chunk.equals(this.keysToChunks.get(p))) {
                    this.keysToChunks.remove(p);
                }
            });
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.chunkIdsToChunks = Collections.unmodifiableMap(this.keysToChunks.values().stream().collect(Collectors.groupingBy(c -> c.Id().get())));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunkNamesToKeys.getOrDefault(name, Collections.emptySet()).removeAll(keys);
            this.chunksToKeys.getOrDefault(chunk, Collections.emptySet()).removeAll(keys);
            chunk.instances().forEach(p -> {
                Map chunkMap = this.instsToChunks.getOrDefault(p, Collections.emptyMap());
                AtomicInteger count = (AtomicInteger)chunkMap.get(chunk);
                if (null != count && count.decrementAndGet() <= 0) {
                    chunkMap.remove(chunk);
                }
            });
            Map chunkMap = this.chunkAbsNamesToChunks.getOrDefault(absName, Collections.emptyMap());
            AtomicInteger count = (AtomicInteger)chunkMap.get(chunk);
            if (null != count && count.decrementAndGet() <= 0) {
                chunkMap.remove(chunk);
            }
            chunk.instances().forEach(p -> {
                Map chunkMap = this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>((ServiceMember)p, absName), Collections.emptyMap());
                AtomicInteger count = (AtomicInteger)chunkMap.get(chunk);
                if (null != count && count.decrementAndGet() <= 0) {
                    chunkMap.remove(chunk);
                }
            });
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected final void remove(ServiceMember instance) {
        if (null == instance) {
            throw new IllegalArgumentException();
        }
        Set<Chunk> chunks = this.chunks(instance);
        chunks.forEach(p -> p.removeInstance(instance));
        this.wLock.lock();
        try {
            chunks.forEach(p -> this.instsAndChunkAbsNamesToChunks.remove(new Pair<ServiceMember, String>(instance, p.absoluteName())));
            this.instsToChunks.remove(instance);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void replace(RoutingKey key, Chunk oldChunk, Chunk newChunk) {
        if (null == key || null == oldChunk || null == newChunk) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.remove(oldChunk);
            this.putIfAbsent(key, newChunk);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Chunk putIfAbsent(RoutingKey key, Chunk chunk) {
        Chunk chunkToReturn;
        if (null == key || null == chunk) {
            throw new IllegalArgumentException();
        }
        String name = chunk.name();
        String absName = chunk.absoluteName();
        this.wLock.lock();
        try {
            chunkToReturn = this.keysToChunks.putIfAbsent(key, chunk);
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunkNamesToKeys.computeIfAbsent(name, p -> new HashSet()).add(key);
            this.chunksToKeys.computeIfAbsent(chunk, p -> new HashSet()).add(key);
            chunk.instances().forEach(p -> this.instsToChunks.computeIfAbsent((ServiceMember)p, q -> new HashMap()).computeIfAbsent(chunk, q -> new AtomicInteger(0)).getAndIncrement());
            this.chunkAbsNamesToChunks.computeIfAbsent(absName, q -> new HashMap()).computeIfAbsent(chunk, q -> new AtomicInteger(0)).getAndIncrement();
            chunk.instances().forEach(p -> this.instsAndChunkAbsNamesToChunks.computeIfAbsent(new Pair<ServiceMember, String>((ServiceMember)p, absName), q -> new HashMap()).computeIfAbsent(chunk, q -> new AtomicInteger(0)).getAndIncrement());
        }
        finally {
            this.wLock.unlock();
        }
        return chunkToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstanceRelatedCaches(Chunk chunk, ServiceMember instance) {
        this.wLock.lock();
        try {
            this.instsToChunks.computeIfAbsent(instance, q -> new HashMap()).computeIfAbsent(chunk, q -> new AtomicInteger(0)).getAndIncrement();
            String chunkAbsName = chunk.absoluteName();
            this.chunkAbsNamesToChunks.computeIfAbsent(chunkAbsName, q -> new HashMap()).computeIfAbsent(chunk, q -> new AtomicInteger(0)).getAndIncrement();
            this.instsAndChunkAbsNamesToChunks.computeIfAbsent(new Pair<ServiceMember, String>(instance, chunkAbsName), q -> new HashMap()).computeIfAbsent(chunk, q -> new AtomicInteger(0)).getAndIncrement();
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected void populateChunkIdToChunkCache() {
        this.wLock.lock();
        try {
            this.chunkIdsToChunks = Collections.unmodifiableMap(this.keysToChunks.values().stream().collect(Collectors.groupingBy(c -> c.Id().get())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromInstanceRelatedCaches(Chunk chunk, ServiceMember instance) {
        this.wLock.lock();
        try {
            String chunkAbsName;
            Map chunkMap;
            AtomicInteger count;
            Map chunkMap2 = this.instsToChunks.getOrDefault(instance, Collections.emptyMap());
            AtomicInteger count2 = (AtomicInteger)chunkMap2.get(chunk);
            if (null != count2 && count2.decrementAndGet() <= 0) {
                chunkMap2.remove(chunk);
            }
            if (null != (count = (AtomicInteger)(chunkMap = this.chunkAbsNamesToChunks.getOrDefault(chunkAbsName = chunk.absoluteName(), Collections.emptyMap())).get(chunk)) && count.decrementAndGet() <= 0) {
                chunkMap.remove(chunk);
            }
            if (null != (count = (AtomicInteger)(chunkMap = this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>(instance, chunkAbsName), Collections.emptyMap())).get(chunk)) && count.decrementAndGet() <= 0) {
                chunkMap.remove(chunk);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected final void clear() {
        this.wLock.lock();
        try {
            this.keysToChunks.clear();
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.chunkIdsToChunks = Collections.unmodifiableMap(this.keysToChunks.values().stream().collect(Collectors.groupingBy(c -> c.Id().get())));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunksToKeys.clear();
            this.chunkNamesToKeys.clear();
            this.instsToChunks.clear();
            this.chunkAbsNamesToChunks.clear();
            this.instsAndChunkAbsNamesToChunks.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    @DisableTrace
    protected final String routingTableToString() {
        this.rLock.lock();
        try {
            String string = this.keysToChunks.toString();
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @DisableTrace
    protected final String routingTableToHumanReadableString() {
        this.rLock.lock();
        try {
            String string = "\n\t\t SHARD ROUTING CACHE \n\n " + "\nSUPER SHARDING KEY\t\t SHARDING KEY\t\t\t\t\tCHUNK NAME \t\tINSTANCES\n\n" + this.keysToChunks.entrySet().stream().map(entry -> String.format("%-70s", entry.getKey()) + "\t\t" + ((Chunk)entry.getValue()).toString()).collect(Collectors.joining("\n"));
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @DisableTrace
    public String toString() {
        return this.routingTableToString();
    }

    static {
        try {
            $$$methodRef$$$50 = ShardRoutingCacheBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$new$0", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$1", Chunk.class, RoutingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$2", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$3", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$4", Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$5", String.class, Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$6", ServiceMember.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$7", ServiceMember.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$8", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$9", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$10", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$11", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$12", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$13", Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$14", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$15", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$16", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$17", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$18", String.class, Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$addToInstanceRelatedCaches$19", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$addToInstanceRelatedCaches$20", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$addToInstanceRelatedCaches$21", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$addToInstanceRelatedCaches$22", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$addToInstanceRelatedCaches$23", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$addToInstanceRelatedCaches$24", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$populateChunkIdToChunkCache$25", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$clear$26", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$clear$27", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$routingTableToHumanReadableString$28", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = ShardRoutingCacheBase.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ShardRoutingCacheBase.class.getDeclaredMethod("routingTableToHumanReadableString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ShardRoutingCacheBase.class.getDeclaredMethod("routingTableToString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ShardRoutingCacheBase.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ShardRoutingCacheBase.class.getDeclaredMethod("removeFromInstanceRelatedCaches", Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ShardRoutingCacheBase.class.getDeclaredMethod("populateChunkIdToChunkCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ShardRoutingCacheBase.class.getDeclaredMethod("addToInstanceRelatedCaches", Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ShardRoutingCacheBase.class.getDeclaredMethod("putIfAbsent", RoutingKey.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ShardRoutingCacheBase.class.getDeclaredMethod("replace", RoutingKey.class, Chunk.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ShardRoutingCacheBase.class.getDeclaredMethod("remove", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ShardRoutingCacheBase.class.getDeclaredMethod("remove", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ShardRoutingCacheBase.class.getDeclaredMethod("chunksCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", ServiceMember.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ShardRoutingCacheBase.class.getDeclaredMethod("get", RoutingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ShardRoutingCacheBase.class.getDeclaredMethod("keyToChunkMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ShardRoutingCacheBase.class.getDeclaredMethod("getRoutingTableSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ShardRoutingCacheBase.class.getDeclaredMethod("keyForChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

