/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

public class CoreConnectionImpl
implements CoreConnection,
Diagnosable {
    static final String CLASS_NAME = CoreConnectionImpl.class.getName();
    private static final long CLOSE_TIMEOUT = 5000L;
    private static final short DB_VERSION_122 = 12200;
    private volatile Service service;
    private final UniversalPooledConnectionImpl upc;
    private final Properties props;
    private volatile ServiceMember serviceMember;
    private boolean replayable = false;
    private AtomicBoolean pendingClose = new AtomicBoolean(false);
    private final Topology connectionSource;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private final Semaphore acSemaphore = new Semaphore(1);

    static CoreConnection create(Service service, Object delegate, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        return new CoreConnectionImpl(service, delegate, diagnosticsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnectionImpl(final Service service, Object delegate, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        this.service = Objects.requireNonNull(service);
        this.connectionSource = Objects.requireNonNull(this.service.connectionSource());
        this.upc = (UniversalPooledConnectionImpl)Objects.requireNonNull(delegate);
        this.props = this.upc.getDatabaseConnectionProperties();
        this.serviceMember = new ServiceMember(this.props, service);
        this.diagnosticsCollector = diagnosticsCollector;
        this.trace(Level.FINE, CLASS_NAME, "<init>", "about to create a new connection, connStats={0}", null, null, this.connStats());
        try {
            String smServiceName = this.serviceMember.service();
            assert ("".equals(this.service.toString()) || this.service.isThisServiceName(smServiceName)) : "service mismatch: this.service=" + this.service + ", smServiceName=" + smServiceName;
            service.setContainerName(this.fetchContainerName());
            service.placement.addAll(this.fetchServicePlacement());
            final String[] onsConfig = new String[]{this.connectionSource.getONSConfig()};
            if (null == onsConfig[0] || "".equals(onsConfig[0])) {
                onsConfig[0] = this.props.getProperty("AUTH_ONS_CONFIG");
            }
            if (this.connectionSource.failoverEnabled() && service.onsStarted.compareAndSet(false, true)) {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                    @Override
                    public void run() {
                        block5: {
                            CoreConnectionImpl.this.trace(Level.FINE, CLASS_NAME, "<init>", "failover enabled - about to start ONS", null, null, new Object[0]);
                            try {
                                ONSDriver onsDriver = CoreConnectionImpl.this.connectionSource.onsDriver(onsConfig[0]);
                                if (onsDriver != null) {
                                    service.failoverDriver.start(onsDriver);
                                    String serviceName = CoreConnectionImpl.this.serviceMember.service();
                                    if (!CoreConnectionImpl.this.connectionSource.isColocation() && null != serviceName) {
                                        CoreConnectionImpl.this.trace(Level.FINE, CLASS_NAME, "<init>", "NOT using COLOCATION, about to start RLB", null, null, new Object[0]);
                                        service.loadBalancer.start(onsDriver, serviceName);
                                    } else {
                                        CoreConnectionImpl.this.trace(Level.FINE, CLASS_NAME, "<init>", "Using COLOCATION, disabled RLB", null, null, new Object[0]);
                                        service.setRLBEnabled(false);
                                    }
                                }
                                CoreConnectionImpl.this.trace(Level.FINE, CLASS_NAME, "<init>", "ONS started", null, null, new Object[0]);
                            }
                            catch (Throwable e) {
                                UniversalPooledConnectionImpl upc;
                                UniversalConnectionPoolBase ucp;
                                CoreConnectionImpl.this.trace(Level.WARNING, CLASS_NAME, "<init>", "", null, e, new Object[0]);
                                CoreConnectionImpl.this.trace(Level.SEVERE, CLASS_NAME, ":<init>", "ONS registration failed, disabling FAN/FCF: all applicable subsystems, like Fast Failover, Runtime Load Balancing and Sharding Configuration Updates will not work properly", null, null, new Object[0]);
                                Object delegate = CoreConnectionImpl.this.getDelegate();
                                if (!Objects.nonNull(delegate) || !(delegate instanceof UniversalPooledConnectionImpl) || !Objects.nonNull(ucp = (upc = (UniversalPooledConnectionImpl)delegate).getPool())) break block5;
                                ucp.setFailoverEnabled(false);
                            }
                        }
                    }

                    @Override
                    public boolean isCritical() {
                        return true;
                    }
                });
            }
            this.serviceMember = service.insertMember(this.serviceMember);
            this.serviceMember.activeCount.incrementAndGet();
            this.serviceMember.serviceRef.lbStats.onOpened();
            this.serviceMember.lbStats.onOpened();
            this.connectionSource.totalCount().incrementAndGet();
            this.serviceMember.serviceRef.activeCount.incrementAndGet();
            this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).incrementAndGet();
            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                ONSDriver onsDrvr = this.connectionSource.onsDriver(onsConfig[0]);
                service.routingCache().startEventHandler(onsDrvr);
                service.routingCache().onConnectionCreation((Connection)this.getPhysicalConnection(), this.cri());
            }
            service.onRegister();
        }
        catch (Throwable throwable) {
            this.trace(Level.FINE, CLASS_NAME, "<init>", "created: connStats={0}", null, null, this.connStats());
            throw throwable;
        }
        this.trace(Level.FINE, CLASS_NAME, "<init>", "created: connStats={0}", null, null, this.connStats());
    }

    void setRepurposedService(Service repurposedService) {
        assert (Objects.nonNull(this.service));
        this.service = Objects.requireNonNull(repurposedService);
    }

    @Override
    public void makeAvailable() {
        this.upc.heartbeat();
        this.upc.setAvailableStartTime();
        this.upc.removeConnectionHarvestingCallback();
        if (this.upc.setAvailable()) {
            long delta = Clock.clock() - this.upc.getBorrowedStartTime();
            if (this.upc.isOracle()) {
                if (this.connectionSource.failoverEnabled()) {
                    this.serviceMember.serviceRef.lbStats.onReturned(delta);
                    this.serviceMember.lbStats.onReturned(delta);
                }
                this.serviceMember.borrowedCount.decrementAndGet();
                this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
            }
            this.connectionSource.borrowedCount().decrementAndGet();
            this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
            this.connectionSource.cumulativeConnectionUseTime().add(delta);
        }
    }

    @Override
    public void makeUnavailable() {
        this.upc.heartbeat();
        this.upc.setBorrowedStartTime();
        if (this.upc.setBorrowed()) {
            int bc = this.connectionSource.borrowedCount().incrementAndGet();
            this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).incrementAndGet();
            if (this.upc.isOracle()) {
                int smbc = this.serviceMember.borrowedCount.incrementAndGet();
                this.serviceMember.serviceRef.borrowedCount.incrementAndGet();
                if (this.connectionSource.failoverEnabled()) {
                    this.serviceMember.lbStats.onBorrowed(smbc);
                    this.serviceMember.serviceRef.lbStats.onBorrowed(bc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markReconnecting() {
        try {
            block13: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markReconnecting", "entering args ()", null, null, new Object[0]);
                if (this.normal()) {
                    String origInst = this.serviceMember().name();
                    try {
                        this.acSemaphore.acquire();
                        if (origInst == null || !origInst.equals(this.serviceMember().name())) break block13;
                        try {
                            this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        }
                        catch (UniversalConnectionPoolException e) {
                            this.trace(Level.WARNING, CLASS_NAME, "markReconnecting", "", null, e, new Object[0]);
                        }
                        finally {
                            this.abort();
                            this.close();
                        }
                    }
                    catch (InterruptedException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "markReconnecting", "", null, e, new Object[0]);
                    }
                    finally {
                        this.acSemaphore.release();
                    }
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markReconnecting", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markReconnecting", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void reinitialize() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reinitialize", "entering args ()", null, null, new Object[0]);
            try {
                this.acSemaphore.acquire();
                boolean avail = this.available();
                ServiceMember oldInst = this.serviceMember();
                Properties props = this.upc.getDatabaseConnectionProperties();
                this.serviceMember = new ServiceMember(props, this.service);
                this.serviceMember = this.service.insertMember(this.serviceMember);
                this.serviceMember.activeCount.incrementAndGet();
                if (!avail) {
                    this.serviceMember.borrowedCount.incrementAndGet();
                }
                this.serviceMember.lbStats.onOpened();
                this.serviceMember.serviceRef.lbStats.onOpened();
                oldInst.activeCount.decrementAndGet();
                oldInst.lbStats.onClosed();
                oldInst.serviceRef.lbStats.onClosed();
                if (!avail) {
                    oldInst.borrowedCount.decrementAndGet();
                }
                try {
                    this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "reinitialize", "", null, e, new Object[0]);
                }
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "reinitialize", "", null, e, new Object[0]);
            }
            finally {
                this.acSemaphore.release();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reinitialize", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reinitialize", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean repurpose(ConnectionRetrievalInfo var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String connStats() {
        String totalStats = "(borrowed=" + this.connectionSource.borrowedCount().get() + ", total=" + this.connectionSource.totalCount().get() + ")";
        String serviceStats = "(service=" + this.service.getFullServiceName() + ", borrowed=" + this.service.borrowedCount.get() + ", total=" + this.service.activeCount.get() + ")";
        String serviceMemberStats = "(serviceMember:" + this.service.getAllMembers().toString() + ")";
        return totalStats + ", " + serviceStats + ", " + serviceMemberStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void close() {
        try {
            block23: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "entering args ()", null, null, new Object[0]);
                try {
                    this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "about to close conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
                    while (true) {
                        current = this.upc.m_status.get();
                        if (UniversalPooledConnectionStatus.STATUS_CLOSED.equals(current) && this.upc.m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                        }
                        ** GOTO lbl-1000
                        break;
                    }
                }
                catch (Throwable var5_7) {
                    this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "closed conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
                    throw var5_7;
                }
                this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "closed conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "returning void", null, null, new Object[0]);
                return;
lbl-1000:
                // 1 sources

                {
                    if (UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(current) && this.upc.m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_RECONNECTING)) {
                        reconnecting = true;
                    } else {
                        if (!this.upc.m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) ** continue;
                        reconnecting = false;
                    }
                    if (!this.available() && !reconnecting) {
                        delta = Clock.clock() - this.upc.getBorrowedStartTime();
                        this.serviceMember.serviceRef.lbStats.onReturned(delta);
                        this.serviceMember.lbStats.onReturned(delta);
                        this.serviceMember.borrowedCount.decrementAndGet();
                        this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                        this.connectionSource.borrowedCount().decrementAndGet();
                        this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                        this.connectionSource.cumulativeConnectionUseTime().add(delta);
                        try {
                            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                                this.service.routingCache().onConnectionReturn((Connection)this.getPhysicalConnection());
                            }
                        }
                        catch (SQLException e) {
                            this.trace(Level.WARNING, CoreConnectionImpl.CLASS_NAME, "close", "", null, e, new Object[0]);
                        }
                    }
                    if (this.connectionSource.isDataDependentRoutingEnabled()) {
                        this.service.routingCache().onConnectionClosure((Connection)this.getPhysicalConnection());
                    }
                    if (!reconnecting) {
                        this.serviceMember.activeCount.decrementAndGet();
                        this.serviceMember.serviceRef.activeCount.decrementAndGet();
                        this.serviceMember.serviceRef.lbStats.onClosed();
                        this.serviceMember.lbStats.onClosed();
                        this.connectionSource.totalCount().decrementAndGet();
                        this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                        this.connectionSource.connectionsClosed().incrementAndGet();
                    }
                    if (this.pendingClose.compareAndSet(true, false)) {
                        this.serviceMember.pendingCloseCount.decrementAndGet();
                        this.serviceMember.serviceRef.pendingCloseCount.decrementAndGet();
                    }
                    if (this.bad() || this.reconnecting()) {
                        this.abort();
                        break block23;
                    }
                    try {
                        submittedTask = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                            @Override
                            public void run() {
                                CoreConnectionImpl.this.upc.closeNoStatsUpdate();
                            }
                        });
                        if (submittedTask != null) {
                            submittedTask.get(5000L);
                            submittedTask.getTask().release();
                        } else {
                            this.trace(Level.WARNING, CoreConnectionImpl.CLASS_NAME, "close", "task submission failed", null, null, new Object[0]);
                        }
                        if (!this.closed()) {
                            this.upc.m_status.set(UniversalPooledConnectionStatus.STATUS_BAD);
                            this.abort();
                        } else {
                            this.upc.m_status.set(UniversalPooledConnectionStatus.STATUS_CLOSED);
                        }
                    }
                    catch (TaskManagerException e) {
                        this.trace(Level.WARNING, CoreConnectionImpl.CLASS_NAME, "close", "", null, e, new Object[0]);
                    }
                }
            }
            this.trace(Level.FINE, CoreConnectionImpl.CLASS_NAME, "close", "closed conn={0}, connStats={1}", null, null, new Object[]{this, this.connStats()});
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable var6_8) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "close", "throwing", null, var6_8, new Object[0]);
            throw var6_8;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void cleanupToHarvest() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cleanupToHarvest", "entering args ()", null, null, new Object[0]);
            ConnectionHarvestingCallback callback = this.upc.getConnectionHarvestingCallback();
            if (callback != null) {
                callback.cleanup();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cleanupToHarvest", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "cleanupToHarvest", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean reconnecting() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reconnecting", "entering args ()", null, null, new Object[0]);
            boolean bl = UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.upc.getStatus());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reconnecting", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "reconnecting", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markCloseOnReturn() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markCloseOnReturn", "entering args ()", null, null, new Object[0]);
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "markCloseOnReturn", "", null, null, new Object[0]);
            }
            if (this.pendingClose.compareAndSet(false, true)) {
                this.serviceMember.pendingCloseCount.incrementAndGet();
                this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markCloseOnReturn", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markCloseOnReturn", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markToReplace() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markToReplace", "entering args ()", null, null, new Object[0]);
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "markToReplace", "", null, null, new Object[0]);
            }
            if (this.pendingClose.compareAndSet(false, true)) {
                this.serviceMember.pendingCloseCount.incrementAndGet();
                this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markToReplace", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markToReplace", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public ConnectionRetrievalInfo cri() {
        return this.upc.getConnectionRetrievalInfo();
    }

    @Override
    public Object getDelegate() {
        return this.upc;
    }

    @Override
    public boolean available() {
        return this.upc.isAvailable();
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void abort() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "abort", "entering args ()", null, null, new Object[0]);
            this.trace(Level.INFO, CLASS_NAME, "abort", "about to abort conn={0}, connStats={1}", null, null, this, this.connStats());
            this.upc.abort();
            this.serviceMember.serviceRef.lbStats.onAborted();
            this.serviceMember.lbStats.onAborted();
            this.trace(Level.INFO, CLASS_NAME, "abort", "aborted conn={0}, connStats={1}", null, null, this, this.connStats());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "abort", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "abort", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public long lastAccessedTime() {
        return this.upc.getLastAccessedTime();
    }

    @Override
    public boolean reusable() {
        return this.upc.isReusable();
    }

    @Override
    public boolean valid() {
        return this.upc.isValid();
    }

    @Override
    public boolean closed() {
        return UniversalPooledConnectionStatus.STATUS_CLOSED.equals(this.upc.getStatus());
    }

    @Override
    public boolean bad() {
        return UniversalPooledConnectionStatus.STATUS_BAD.equals(this.upc.getStatus());
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void markBad() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markBad", "entering args ()", null, null, new Object[0]);
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "markBad", "", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markBad", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "markBad", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean normal() {
        return UniversalPooledConnectionStatus.STATUS_NORMAL.equals(this.upc.getStatus());
    }

    @Override
    public boolean markedToReplace() {
        return UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN.equals(this.upc.getStatus());
    }

    @Override
    public boolean markedCloseOnReturn() {
        return UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN.equals(this.upc.getStatus());
    }

    @Override
    public ServiceMember serviceMember() {
        if (null == this.serviceMember || null == this.serviceMember.name()) {
            throw new IllegalStateException();
        }
        return this.serviceMember;
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void handleTimeout() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "handleTimeout", "entering args ()", null, null, new Object[0]);
            this.upc.handleTimeout();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "handleTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "handleTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public int labelingCost(Properties properties) {
        try {
            void reqLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "labelingCost", "entering args ({0})", null, null, properties);
            int n = this.upc.labelingCost((Properties)reqLabels);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "labelingCost", "returning {0}", null, null, n);
            return n;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "labelingCost", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setReplayable(boolean bl) {
        try {
            void replayable;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "setReplayable", "entering args ({0})", null, null, bl);
            this.replayable = replayable;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "setReplayable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "setReplayable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String serviceName() {
        return this.serviceMember.service();
    }

    @Override
    public Service service() {
        return this.service;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void onError(int n) {
        try {
            void oraErrorNumber;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onError", "entering args ({0})", null, null, n);
            this.service.routingCache().onError((int)oraErrorNumber, this.upc.getBorrowCRI(), this.serviceMember());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onError", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "onError", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void onInsert() {
        ((UniversalPooledConnectionImpl)this.getDelegate()).onInsert();
    }

    @Override
    public void onRetrieve() {
        ((UniversalPooledConnectionImpl)this.getDelegate()).onRetrieve();
    }

    @Override
    public void onBorrow(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        try {
            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                this.service.routingCache().onConnectionBorrow((Connection)this.getPhysicalConnection(), cri);
            }
            if (this.connectionSource.isMultitenantDatabase() && this.upc instanceof OracleUniversalPooledConnection) {
                ((OracleUniversalPooledConnection)this.upc).initPdbSession(cri);
            }
            this.openProxySession(cri);
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e.getMessage(), e);
        }
    }

    @Override
    public void onReturn() throws UniversalConnectionPoolException {
        try {
            if (this.service.connectionSource().isDataDependentRoutingEnabled()) {
                this.service.routingCache().onConnectionReturn((Connection)this.getPhysicalConnection());
            }
            this.closeProxySession();
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e.getMessage(), e);
        }
    }

    @Override
    public void commit() {
        this.commitRollbackHelper(false);
    }

    @Override
    public void rollback() {
        this.commitRollbackHelper(true);
    }

    private void commitRollbackHelper(boolean rollback) {
        if (this.upc.isOracle()) {
            OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
            if (oConn == null) {
                return;
            }
            EnumSet tstate = null;
            try {
                tstate = oConn.getTransactionState();
            }
            catch (SQLException e) {
                this.trace(Level.FINEST, CLASS_NAME, "commitRollbackHelper", "failed to determine transaction state", null, e, new Object[0]);
            }
            if (tstate == null) {
                try {
                    if (!oConn.getAutoCommit()) {
                        this.doCommitRollback(oConn, rollback);
                    }
                }
                catch (SQLException e) {
                    this.trace(Level.FINEST, CLASS_NAME, "commitRollbackHelper", "failed to determine auto commit mode", null, e, new Object[0]);
                }
            } else if (tstate.contains(OracleConnection.TransactionState.LOCAL_TRANSACTION_STARTED) || tstate.contains(OracleConnection.TransactionState.SESSIONLESS_TRANSACTION_STARTED)) {
                this.doCommitRollback(oConn, rollback);
            }
        }
    }

    private void doCommitRollback(OracleConnection oConn, boolean rollback) {
        try {
            if (rollback) {
                oConn.rollback();
                this.trace(Level.FINEST, CLASS_NAME, "doCommitRollback", "successfully rolled back", null, null, new Object[0]);
            } else {
                oConn.commit();
                this.trace(Level.FINEST, CLASS_NAME, "doCommitRollback", "successfully committed", null, null, new Object[0]);
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "doCommitRollback", "failed to {0} unfinished transaction", null, e, rollback ? "rollback" : "commit");
        }
    }

    @Override
    public Object getPhysicalConnection() {
        block7: {
            Object delegate = Objects.requireNonNull(this.getDelegate());
            if (!(delegate instanceof UniversalPooledConnection)) {
                return null;
            }
            try {
                UniversalPooledConnection upc = (UniversalPooledConnection)delegate;
                Object conn = upc.getPhysicalConnection();
                if (upc.isOracle()) {
                    if (conn instanceof OracleConnection) {
                        return conn;
                    }
                    if (conn instanceof OracleXAConnection) {
                        return ((OracleXAConnection)conn).getPhysicalHandle();
                    }
                    if (conn instanceof OraclePooledConnection) {
                        return ((OraclePooledConnection)conn).getConnection();
                    }
                    break block7;
                }
                return conn;
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "getPhysicalConnection", "", null, null, new Object[0]);
            }
        }
        return null;
    }

    private void openProxySession(ConnectionRetrievalInfo borrowCri) throws SQLException {
        if (!(borrowCri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)borrowCri;
        Properties newProxyProps = jdbcCri.getProxyProperties();
        if (newProxyProps == null) {
            return;
        }
        int proxyType = jdbcCri.getProxyType();
        if (!this.upc.isOracle()) {
            return;
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        if (oConn == null) {
            return;
        }
        if (oConn.isProxySession()) {
            return;
        }
        oConn.openProxySession(proxyType, newProxyProps);
        JDBCConnectionRetrievalInfo newConnCri = jdbcCri.getCopyWithNewProxyProperties(proxyType, newProxyProps);
        this.upc.setConnectionRetrievalInfo(newConnCri);
    }

    private void closeProxySession() throws SQLException {
        ConnectionRetrievalInfo cri = this.upc.getConnectionRetrievalInfo();
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (jdbcCri.getProxyProperties() == null) {
            return;
        }
        if (!this.upc.isOracle()) {
            return;
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        if (oConn == null) {
            return;
        }
        oConn.close(1);
        this.upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Debug(level=Debug.Level.FINEST)
    private String fetchContainerName() {
        try {
            block19: {
                String string;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "entering args ()", null, null, new Object[0]);
                if (!this.connectionSource.isMultitenantDatabase() || !this.connectionSource.isShareable()) {
                    String string2 = "";
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string2);
                    return string2;
                }
                OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
                if (oConn == null) {
                    String string3 = "";
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string3);
                    return string3;
                }
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = oConn.createStatement();
                    String updateStr = "select sys_context('userenv','con_name') from dual";
                    rs = stmt.executeQuery("select sys_context('userenv','con_name') from dual");
                    if (!rs.next()) break block19;
                    String string4 = rs.getString(1);
                    string = string4;
                }
                catch (SQLException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "fetchContainerName", "", null, null, new Object[0]);
                    break block19;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "fetchContainerName", "", null, null, new Object[0]);
                    }
                }
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string);
                return string;
            }
            String string = "";
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "returning {0}", null, null, string);
            return string;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchContainerName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private Set<String> fetchServicePlacement() {
        try {
            HashSet<String> instances;
            OracleConnection oConn;
            block35: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "entering args ()", null, null, new Object[0]);
                if (!this.upc.isOracle()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                    return hashSet;
                }
                oConn = (OracleConnection)this.getPhysicalConnection();
                instances = new HashSet<String>();
                instances.add(this.serviceMember().name());
                if (!this.connectionSource.isMultitenantDatabase()) {
                    HashSet<String> hashSet = instances;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                    return hashSet;
                }
                if (oConn == null) {
                    HashSet<String> hashSet = instances;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                    return hashSet;
                }
                if (oConn.getVersionNumber() >= 12200 && this.connectionSource.isShareable()) break block35;
                HashSet<String> hashSet = instances;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
                return hashSet;
            }
            try {
                String sql = "select dbms_service_prvt.get_topology('" + this.serviceName() + "') from dual";
                try (Statement stmt = oConn.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    String instancesStr = "";
                    if (rs.next()) {
                        instancesStr = rs.getString(1);
                    }
                    if (instancesStr != null && instancesStr.length() > 0) {
                        for (String instName : instancesStr.split(",")) {
                            instances.add(instName);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "fetchServicePlacement", "", null, null, new Object[0]);
            }
            HashSet<String> hashSet = instances;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "returning {0}", null, null, hashSet);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.CoreConnectionImpl", "fetchServicePlacement", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

