/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.events.api;

import java.util.Collections;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.events.api.UCPInstalledProviders;
import oracle.ucp.events.api.UCPResourceType;
import oracle.ucp.events.core.UCPEventListener;
import oracle.ucp.events.core.UCPEventListenerProvider;

public final class UCPEventListenerSelector {
    private static final String DEFAULT_PROVIDER_KEY = "UCPEventListenerProvider";

    public static UCPEventListener loadUcpEventListenerFromConfiguredProvider(Object poolProperty) throws UniversalConnectionPoolException {
        UCPEventListenerProvider selectedProvider;
        UCPInstalledProviders<UCPEventListenerProvider> installedProviders = UCPInstalledProviders.load(UCPResourceType.UCP_EVENT_LISTENER);
        String poolPropertyName = null;
        if (poolProperty != null) {
            poolPropertyName = poolProperty.toString().trim();
            if (poolPropertyName.isEmpty()) {
                throw new UniversalConnectionPoolException("Invalid UCP Event Listener Provider: provider name cannot be empty or contain only whitespace");
            }
        } else {
            String systemProperty = System.getProperty(DEFAULT_PROVIDER_KEY);
            if (systemProperty != null && (poolPropertyName = systemProperty.trim()).isEmpty()) {
                throw new UniversalConnectionPoolException("Invalid UCP Event Listener Provider from system property 'UCPEventListenerProvider': provider name cannot be empty or contain only whitespace");
            }
        }
        if (poolPropertyName == null) {
            try {
                selectedProvider = UCPResourceType.UCP_EVENT_LISTENER.getDefaultProvider();
            }
            catch (Exception e) {
                throw new UniversalConnectionPoolException("Failed to load default UCPEventListenerProvider", e);
            }
        } else {
            selectedProvider = installedProviders.get(poolPropertyName);
            if (selectedProvider == null) {
                throw new UniversalConnectionPoolException("Invalid or non-existent UCPEventListenerProvider: \"" + poolPropertyName + "\". Check your configuration or ensure the provider is on the classpath.");
            }
        }
        UCPEventListener eventListener = UCPResourceType.UCP_EVENT_LISTENER.getResource(selectedProvider, Collections.emptyMap());
        return eventListener;
    }
}

